/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.io.Serializable;
import javax.cache.configuration.Factory;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public class TransactionConfiguration
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final boolean DFLT_TX_SERIALIZABLE_ENABLED = false;
    public static final TransactionConcurrency DFLT_TX_CONCURRENCY = TransactionConcurrency.PESSIMISTIC;
    public static final TransactionIsolation DFLT_TX_ISOLATION = TransactionIsolation.REPEATABLE_READ;
    public static final long DFLT_TRANSACTION_TIMEOUT = 0L;
    public static final int DFLT_PESSIMISTIC_TX_LOG_LINGER = 10000;
    private boolean txSerEnabled = false;
    private TransactionIsolation dfltIsolation = DFLT_TX_ISOLATION;
    private TransactionConcurrency dfltConcurrency = DFLT_TX_CONCURRENCY;
    private long dfltTxTimeout = 0L;
    private int pessimisticTxLogSize;
    private int pessimisticTxLogLinger = 10000;
    private String tmLookupClsName;
    private Factory txManagerFactory;
    private boolean useJtaSync;

    public TransactionConfiguration() {
    }

    public TransactionConfiguration(TransactionConfiguration cfg) {
        this.dfltConcurrency = cfg.getDefaultTxConcurrency();
        this.dfltIsolation = cfg.getDefaultTxIsolation();
        this.dfltTxTimeout = cfg.getDefaultTxTimeout();
        this.pessimisticTxLogLinger = cfg.getPessimisticTxLogLinger();
        this.pessimisticTxLogSize = cfg.getPessimisticTxLogSize();
        this.txSerEnabled = cfg.isTxSerializableEnabled();
        this.tmLookupClsName = cfg.getTxManagerLookupClassName();
        this.txManagerFactory = cfg.getTxManagerFactory();
        this.useJtaSync = cfg.isUseJtaSynchronization();
    }

    @Deprecated
    public boolean isTxSerializableEnabled() {
        return this.txSerEnabled;
    }

    @Deprecated
    public void setTxSerializableEnabled(boolean txSerEnabled) {
        this.txSerEnabled = txSerEnabled;
    }

    public TransactionConcurrency getDefaultTxConcurrency() {
        return this.dfltConcurrency;
    }

    public void setDefaultTxConcurrency(TransactionConcurrency dfltConcurrency) {
        this.dfltConcurrency = dfltConcurrency;
    }

    public TransactionIsolation getDefaultTxIsolation() {
        return this.dfltIsolation;
    }

    public void setDefaultTxIsolation(TransactionIsolation dfltIsolation) {
        this.dfltIsolation = dfltIsolation;
    }

    public long getDefaultTxTimeout() {
        return this.dfltTxTimeout;
    }

    public void setDefaultTxTimeout(long dfltTxTimeout) {
        this.dfltTxTimeout = dfltTxTimeout;
    }

    public int getPessimisticTxLogSize() {
        return this.pessimisticTxLogSize;
    }

    public void setPessimisticTxLogSize(int pessimisticTxLogSize) {
        this.pessimisticTxLogSize = pessimisticTxLogSize;
    }

    public int getPessimisticTxLogLinger() {
        return this.pessimisticTxLogLinger;
    }

    public void setPessimisticTxLogLinger(int pessimisticTxLogLinger) {
        this.pessimisticTxLogLinger = pessimisticTxLogLinger;
    }

    @Deprecated
    public String getTxManagerLookupClassName() {
        return this.tmLookupClsName;
    }

    @Deprecated
    public void setTxManagerLookupClassName(String tmLookupClsName) {
        this.tmLookupClsName = tmLookupClsName;
    }

    public <T> Factory<T> getTxManagerFactory() {
        return this.txManagerFactory;
    }

    public <T> void setTxManagerFactory(Factory<T> factory) {
        this.txManagerFactory = factory;
    }

    public boolean isUseJtaSynchronization() {
        return this.useJtaSync;
    }

    public void setUseJtaSynchronization(boolean useJtaSync) {
        this.useJtaSync = useJtaSync;
    }
}

