/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.igfs;

import org.apache.ignite.internal.processors.cache.GridCacheDefaultAffinityKeyMapper;
import org.apache.ignite.internal.processors.igfs.IgfsBlockKey;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;

public class IgfsGroupDataBlocksKeyMapper
extends GridCacheDefaultAffinityKeyMapper {
    private static final long serialVersionUID = 0L;
    public static final int DFLT_GRP_SIZE = 1024;
    private int grpSize = 1024;

    public IgfsGroupDataBlocksKeyMapper() {
    }

    public IgfsGroupDataBlocksKeyMapper(int grpSize) {
        A.ensure(grpSize >= 1, "grpSize >= 1");
        this.grpSize = grpSize;
    }

    @Override
    public Object affinityKey(Object key) {
        if (key != null && IgfsBlockKey.class.equals(key.getClass())) {
            IgfsBlockKey blockKey = (IgfsBlockKey)key;
            if (blockKey.affinityKey() != null) {
                return blockKey.affinityKey();
            }
            long grpId = blockKey.getBlockId() / (long)this.grpSize;
            return blockKey.getFileId().hashCode() + (int)(grpId ^ grpId >>> 32);
        }
        return super.affinityKey(key);
    }

    public int getGroupSize() {
        return this.grpSize;
    }

    public void setGroupSize(int grpSize) {
        this.grpSize = grpSize;
    }

    public String toString() {
        return S.toString(IgfsGroupDataBlocksKeyMapper.class, this);
    }
}

