/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.igfs.mapreduce;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteFileSystem;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.igfs.IgfsBlockLocation;
import org.apache.ignite.igfs.IgfsFile;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.igfs.mapreduce.IgfsFileRange;
import org.apache.ignite.igfs.mapreduce.IgfsJob;
import org.apache.ignite.igfs.mapreduce.IgfsTaskArgs;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.igfs.IgfsProcessorAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.jetbrains.annotations.Nullable;

public abstract class IgfsTask<T, R>
extends ComputeTaskAdapter<IgfsTaskArgs<T>, R> {
    private static final long serialVersionUID = 0L;
    @IgniteInstanceResource
    private Ignite ignite;

    @Override
    @Nullable
    public final Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable IgfsTaskArgs<T> args) {
        assert (this.ignite != null);
        assert (args != null);
        IgniteFileSystem fs = this.ignite.fileSystem(args.igfsName());
        IgfsProcessorAdapter igfsProc = ((IgniteKernal)this.ignite).context().igfs();
        HashMap<ComputeJob, ClusterNode> splitMap = new HashMap<ComputeJob, ClusterNode>();
        Map<UUID, ClusterNode> nodes = this.mapSubgrid(subgrid);
        for (IgfsPath path : args.paths()) {
            IgfsFile file = fs.info(path);
            if (file == null) {
                if (args.skipNonExistentFiles()) continue;
                throw new IgniteException("Failed to process IGFS file because it doesn't exist: " + path);
            }
            Collection<IgfsBlockLocation> aff = fs.affinity(path, 0L, file.length(), args.maxRangeLength());
            long totalLen = 0L;
            for (IgfsBlockLocation loc : aff) {
                UUID nodeId;
                ClusterNode node = null;
                Iterator<UUID> i$ = loc.nodeIds().iterator();
                while (i$.hasNext() && (node = nodes.get(nodeId = i$.next())) == null) {
                }
                if (node == null) {
                    throw new IgniteException("Failed to find any of block affinity nodes in subgrid [loc=" + loc + ", subgrid=" + subgrid + ']');
                }
                IgfsJob job = this.createJob(path, new IgfsFileRange(file.path(), loc.start(), loc.length()), args);
                if (job != null) {
                    ComputeJob jobImpl = igfsProc.createJob(job, fs.name(), file.path(), loc.start(), loc.length(), args.recordResolver());
                    splitMap.put(jobImpl, node);
                }
                totalLen += loc.length();
            }
            assert (totalLen == file.length());
        }
        return splitMap;
    }

    @Nullable
    public abstract IgfsJob createJob(IgfsPath var1, IgfsFileRange var2, IgfsTaskArgs<T> var3) throws IgniteException;

    private Map<UUID, ClusterNode> mapSubgrid(Collection<ClusterNode> subgrid) {
        HashMap<UUID, ClusterNode> res = U.newHashMap(subgrid.size());
        for (ClusterNode node : subgrid) {
            res.put(node.id(), node);
        }
        return res;
    }
}

