/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class ClusterMetricsSnapshot
implements ClusterMetrics {
    public static final int METRICS_SIZE = 320;
    private long lastUpdateTime = -1L;
    private int maxActiveJobs = -1;
    private int curActiveJobs = -1;
    private float avgActiveJobs = -1.0f;
    private int maxWaitingJobs = -1;
    private int curWaitingJobs = -1;
    private float avgWaitingJobs = -1.0f;
    private int maxRejectedJobs = -1;
    private int curRejectedJobs = -1;
    private float avgRejectedJobs = -1.0f;
    private int maxCancelledJobs = -1;
    private int curCancelledJobs = -1;
    private float avgCancelledJobs = -1.0f;
    private int totalRejectedJobs = -1;
    private int totalCancelledJobs = -1;
    private int totalExecutedJobs = -1;
    private long maxJobWaitTime = -1L;
    private long curJobWaitTime = -1L;
    private double avgJobWaitTime = -1.0;
    private long maxJobExecTime = -1L;
    private long curJobExecTime = -1L;
    private double avgJobExecTime = -1.0;
    private int totalExecTasks = -1;
    private long totalIdleTime = -1L;
    private long curIdleTime = -1L;
    private int availProcs = -1;
    private double load = -1.0;
    private double avgLoad = -1.0;
    private double gcLoad = -1.0;
    private long heapInit = -1L;
    private long heapUsed = -1L;
    private long heapCommitted = -1L;
    private long heapMax = -1L;
    private long heapTotal = -1L;
    private long nonHeapInit = -1L;
    private long nonHeapUsed = -1L;
    private long nonHeapCommitted = -1L;
    private long nonHeapMax = -1L;
    private long nonHeapTotal = -1L;
    private long upTime = -1L;
    private long startTime = -1L;
    private long nodeStartTime = -1L;
    private int threadCnt = -1;
    private int peakThreadCnt = -1;
    private long startedThreadCnt = -1L;
    private int daemonThreadCnt = -1;
    private long lastDataVer = -1L;
    private int sentMsgsCnt = -1;
    private long sentBytesCnt = -1L;
    private int rcvdMsgsCnt = -1;
    private long rcvdBytesCnt = -1L;
    private int outMesQueueSize = -1;
    private int totalNodes = -1;

    public ClusterMetricsSnapshot() {
    }

    public ClusterMetricsSnapshot(ClusterGroup p) {
        assert (p != null);
        Collection<ClusterNode> nodes = p.nodes();
        int size = nodes.size();
        this.curJobWaitTime = Long.MAX_VALUE;
        this.lastUpdateTime = 0L;
        this.maxActiveJobs = 0;
        this.curActiveJobs = 0;
        this.avgActiveJobs = 0.0f;
        this.maxWaitingJobs = 0;
        this.curWaitingJobs = 0;
        this.avgWaitingJobs = 0.0f;
        this.maxRejectedJobs = 0;
        this.curRejectedJobs = 0;
        this.avgRejectedJobs = 0.0f;
        this.maxCancelledJobs = 0;
        this.curCancelledJobs = 0;
        this.avgCancelledJobs = 0.0f;
        this.totalRejectedJobs = 0;
        this.totalCancelledJobs = 0;
        this.totalExecutedJobs = 0;
        this.maxJobWaitTime = 0L;
        this.avgJobWaitTime = 0.0;
        this.maxJobExecTime = 0L;
        this.curJobExecTime = 0L;
        this.avgJobExecTime = 0.0;
        this.totalExecTasks = 0;
        this.totalIdleTime = 0L;
        this.curIdleTime = 0L;
        this.availProcs = 0;
        this.load = 0.0;
        this.avgLoad = 0.0;
        this.gcLoad = 0.0;
        this.heapInit = 0L;
        this.heapUsed = 0L;
        this.heapCommitted = 0L;
        this.heapMax = 0L;
        this.nonHeapInit = 0L;
        this.nonHeapUsed = 0L;
        this.nonHeapCommitted = 0L;
        this.nonHeapMax = 0L;
        this.nonHeapTotal = 0L;
        this.upTime = 0L;
        this.startTime = 0L;
        this.nodeStartTime = 0L;
        this.threadCnt = 0;
        this.peakThreadCnt = 0;
        this.startedThreadCnt = 0L;
        this.daemonThreadCnt = 0;
        this.lastDataVer = 0L;
        this.sentMsgsCnt = 0;
        this.sentBytesCnt = 0L;
        this.rcvdMsgsCnt = 0;
        this.rcvdBytesCnt = 0L;
        this.outMesQueueSize = 0;
        this.heapTotal = 0L;
        this.totalNodes = nodes.size();
        for (ClusterNode node : nodes) {
            ClusterMetrics m = node.metrics();
            this.lastUpdateTime = Math.max(this.lastUpdateTime, node.metrics().getLastUpdateTime());
            this.curActiveJobs += m.getCurrentActiveJobs();
            this.maxActiveJobs = Math.max(this.maxActiveJobs, m.getCurrentActiveJobs());
            this.avgActiveJobs += (float)m.getCurrentActiveJobs();
            this.totalExecutedJobs += m.getTotalExecutedJobs();
            this.totalExecTasks += m.getTotalExecutedTasks();
            this.totalCancelledJobs += m.getTotalCancelledJobs();
            this.curCancelledJobs += m.getCurrentCancelledJobs();
            this.maxCancelledJobs = Math.max(this.maxCancelledJobs, m.getCurrentCancelledJobs());
            this.avgCancelledJobs += (float)m.getCurrentCancelledJobs();
            this.totalRejectedJobs += m.getTotalRejectedJobs();
            this.curRejectedJobs += m.getCurrentRejectedJobs();
            this.maxRejectedJobs = Math.max(this.maxRejectedJobs, m.getCurrentRejectedJobs());
            this.avgRejectedJobs += (float)m.getCurrentRejectedJobs();
            this.curWaitingJobs = (int)((long)this.curWaitingJobs + m.getCurrentJobWaitTime());
            this.maxWaitingJobs = Math.max(this.maxWaitingJobs, m.getCurrentWaitingJobs());
            this.avgWaitingJobs += (float)m.getCurrentWaitingJobs();
            this.maxJobExecTime = Math.max(this.maxJobExecTime, m.getMaximumJobExecuteTime());
            this.avgJobExecTime += m.getAverageJobExecuteTime();
            this.curJobExecTime += m.getCurrentJobExecuteTime();
            this.curJobWaitTime = Math.min(this.curJobWaitTime, m.getCurrentJobWaitTime());
            this.maxJobWaitTime = Math.max(this.maxJobWaitTime, m.getCurrentJobWaitTime());
            this.avgJobWaitTime += (double)m.getCurrentJobWaitTime();
            this.daemonThreadCnt += m.getCurrentDaemonThreadCount();
            this.peakThreadCnt = Math.max(this.peakThreadCnt, m.getCurrentThreadCount());
            this.threadCnt += m.getCurrentThreadCount();
            this.startedThreadCnt += m.getTotalStartedThreadCount();
            this.curIdleTime += m.getCurrentIdleTime();
            this.totalIdleTime += m.getTotalIdleTime();
            this.heapCommitted += m.getHeapMemoryCommitted();
            this.heapUsed += m.getHeapMemoryUsed();
            this.heapMax = Math.max(this.heapMax, m.getHeapMemoryMaximum());
            this.heapTotal += m.getHeapMemoryTotal();
            this.heapInit += m.getHeapMemoryInitialized();
            this.nonHeapCommitted += m.getNonHeapMemoryCommitted();
            this.nonHeapUsed += m.getNonHeapMemoryUsed();
            this.nonHeapMax = Math.max(this.nonHeapMax, m.getNonHeapMemoryMaximum());
            this.nonHeapTotal += m.getNonHeapMemoryTotal();
            this.nonHeapInit += m.getNonHeapMemoryInitialized();
            this.upTime = Math.max(this.upTime, m.getUpTime());
            this.lastDataVer = Math.max(this.lastDataVer, m.getLastDataVersion());
            this.sentMsgsCnt += m.getSentMessagesCount();
            this.sentBytesCnt += m.getSentBytesCount();
            this.rcvdMsgsCnt += m.getReceivedMessagesCount();
            this.rcvdBytesCnt += m.getReceivedBytesCount();
            this.outMesQueueSize += m.getOutboundMessagesQueueSize();
            this.avgLoad += m.getCurrentCpuLoad();
        }
        this.curJobExecTime /= (long)size;
        this.avgActiveJobs /= (float)size;
        this.avgCancelledJobs /= (float)size;
        this.avgRejectedJobs /= (float)size;
        this.avgWaitingJobs /= (float)size;
        this.avgJobExecTime /= (double)size;
        this.avgJobWaitTime /= (double)size;
        this.avgLoad /= (double)size;
        if (!F.isEmpty(nodes)) {
            ClusterMetrics oldestNodeMetrics = ClusterMetricsSnapshot.oldest(nodes).metrics();
            this.nodeStartTime = oldestNodeMetrics.getNodeStartTime();
            this.startTime = oldestNodeMetrics.getStartTime();
        }
        Map<String, Collection<ClusterNode>> neighborhood = U.neighborhood(nodes);
        this.gcLoad = ClusterMetricsSnapshot.gcCpus(neighborhood);
        this.load = ClusterMetricsSnapshot.cpus(neighborhood);
        this.availProcs = ClusterMetricsSnapshot.cpuCnt(neighborhood);
    }

    @Override
    public long getHeapMemoryTotal() {
        return this.heapTotal;
    }

    public void setHeapMemoryTotal(long heapTotal) {
        this.heapTotal = heapTotal;
    }

    public void setNonHeapMemoryTotal(long nonHeapTotal) {
        this.nonHeapTotal = nonHeapTotal;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Override
    public int getMaximumActiveJobs() {
        return this.maxActiveJobs;
    }

    public void setMaximumActiveJobs(int maxActiveJobs) {
        this.maxActiveJobs = maxActiveJobs;
    }

    @Override
    public int getCurrentActiveJobs() {
        return this.curActiveJobs;
    }

    public void setCurrentActiveJobs(int curActiveJobs) {
        this.curActiveJobs = curActiveJobs;
    }

    @Override
    public float getAverageActiveJobs() {
        return this.avgActiveJobs;
    }

    public void setAverageActiveJobs(float avgActiveJobs) {
        this.avgActiveJobs = avgActiveJobs;
    }

    @Override
    public int getMaximumWaitingJobs() {
        return this.maxWaitingJobs;
    }

    public void setMaximumWaitingJobs(int maxWaitingJobs) {
        this.maxWaitingJobs = maxWaitingJobs;
    }

    @Override
    public int getCurrentWaitingJobs() {
        return this.curWaitingJobs;
    }

    public void setCurrentWaitingJobs(int curWaitingJobs) {
        this.curWaitingJobs = curWaitingJobs;
    }

    @Override
    public float getAverageWaitingJobs() {
        return this.avgWaitingJobs;
    }

    public void setAverageWaitingJobs(float avgWaitingJobs) {
        this.avgWaitingJobs = avgWaitingJobs;
    }

    @Override
    public int getMaximumRejectedJobs() {
        return this.maxRejectedJobs;
    }

    public void setMaximumRejectedJobs(int maxRejectedJobs) {
        this.maxRejectedJobs = maxRejectedJobs;
    }

    @Override
    public int getCurrentRejectedJobs() {
        return this.curRejectedJobs;
    }

    public void setCurrentRejectedJobs(int curRejectedJobs) {
        this.curRejectedJobs = curRejectedJobs;
    }

    @Override
    public float getAverageRejectedJobs() {
        return this.avgRejectedJobs;
    }

    public void setAverageRejectedJobs(float avgRejectedJobs) {
        this.avgRejectedJobs = avgRejectedJobs;
    }

    @Override
    public int getTotalRejectedJobs() {
        return this.totalRejectedJobs;
    }

    public void setTotalRejectedJobs(int totalRejectedJobs) {
        this.totalRejectedJobs = totalRejectedJobs;
    }

    @Override
    public int getMaximumCancelledJobs() {
        return this.maxCancelledJobs;
    }

    public void setMaximumCancelledJobs(int maxCancelledJobs) {
        this.maxCancelledJobs = maxCancelledJobs;
    }

    @Override
    public int getCurrentCancelledJobs() {
        return this.curCancelledJobs;
    }

    public void setCurrentCancelledJobs(int curCancelledJobs) {
        this.curCancelledJobs = curCancelledJobs;
    }

    @Override
    public float getAverageCancelledJobs() {
        return this.avgCancelledJobs;
    }

    public void setAverageCancelledJobs(float avgCancelledJobs) {
        this.avgCancelledJobs = avgCancelledJobs;
    }

    @Override
    public int getTotalExecutedJobs() {
        return this.totalExecutedJobs;
    }

    public void setTotalExecutedJobs(int totalExecutedJobs) {
        this.totalExecutedJobs = totalExecutedJobs;
    }

    @Override
    public int getTotalCancelledJobs() {
        return this.totalCancelledJobs;
    }

    public void setTotalCancelledJobs(int totalCancelledJobs) {
        this.totalCancelledJobs = totalCancelledJobs;
    }

    @Override
    public long getMaximumJobWaitTime() {
        return this.maxJobWaitTime;
    }

    public void setMaximumJobWaitTime(long maxJobWaitTime) {
        this.maxJobWaitTime = maxJobWaitTime;
    }

    @Override
    public long getCurrentJobWaitTime() {
        return this.curJobWaitTime;
    }

    public void setCurrentJobWaitTime(long curJobWaitTime) {
        this.curJobWaitTime = curJobWaitTime;
    }

    @Override
    public double getAverageJobWaitTime() {
        return this.avgJobWaitTime;
    }

    public void setAverageJobWaitTime(double avgJobWaitTime) {
        this.avgJobWaitTime = avgJobWaitTime;
    }

    @Override
    public long getMaximumJobExecuteTime() {
        return this.maxJobExecTime;
    }

    public void setMaximumJobExecuteTime(long maxJobExecTime) {
        this.maxJobExecTime = maxJobExecTime;
    }

    @Override
    public long getCurrentJobExecuteTime() {
        return this.curJobExecTime;
    }

    public void setCurrentJobExecuteTime(long curJobExecTime) {
        this.curJobExecTime = curJobExecTime;
    }

    @Override
    public double getAverageJobExecuteTime() {
        return this.avgJobExecTime;
    }

    public void setAverageJobExecuteTime(double avgJobExecTime) {
        this.avgJobExecTime = avgJobExecTime;
    }

    @Override
    public int getTotalExecutedTasks() {
        return this.totalExecTasks;
    }

    public void setTotalExecutedTasks(int totalExecTasks) {
        this.totalExecTasks = totalExecTasks;
    }

    @Override
    public long getTotalBusyTime() {
        return this.getUpTime() - this.getTotalIdleTime();
    }

    @Override
    public long getTotalIdleTime() {
        return this.totalIdleTime;
    }

    public void setTotalIdleTime(long totalIdleTime) {
        this.totalIdleTime = totalIdleTime;
    }

    @Override
    public long getCurrentIdleTime() {
        return this.curIdleTime;
    }

    public void setCurrentIdleTime(long curIdleTime) {
        this.curIdleTime = curIdleTime;
    }

    @Override
    public float getBusyTimePercentage() {
        return 1.0f - this.getIdleTimePercentage();
    }

    @Override
    public float getIdleTimePercentage() {
        return (float)this.getTotalIdleTime() / (float)this.getUpTime();
    }

    @Override
    public int getTotalCpus() {
        return this.availProcs;
    }

    @Override
    public double getCurrentCpuLoad() {
        return this.load;
    }

    @Override
    public double getAverageCpuLoad() {
        return this.avgLoad;
    }

    @Override
    public double getCurrentGcCpuLoad() {
        return this.gcLoad;
    }

    @Override
    public long getHeapMemoryInitialized() {
        return this.heapInit;
    }

    @Override
    public long getHeapMemoryUsed() {
        return this.heapUsed;
    }

    @Override
    public long getHeapMemoryCommitted() {
        return this.heapCommitted;
    }

    @Override
    public long getHeapMemoryMaximum() {
        return this.heapMax;
    }

    @Override
    public long getNonHeapMemoryInitialized() {
        return this.nonHeapInit;
    }

    @Override
    public long getNonHeapMemoryUsed() {
        return this.nonHeapUsed;
    }

    @Override
    public long getNonHeapMemoryCommitted() {
        return this.nonHeapCommitted;
    }

    @Override
    public long getNonHeapMemoryMaximum() {
        return this.nonHeapMax;
    }

    @Override
    public long getNonHeapMemoryTotal() {
        return this.nonHeapTotal;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getNodeStartTime() {
        return this.nodeStartTime;
    }

    @Override
    public int getCurrentThreadCount() {
        return this.threadCnt;
    }

    @Override
    public int getMaximumThreadCount() {
        return this.peakThreadCnt;
    }

    @Override
    public long getTotalStartedThreadCount() {
        return this.startedThreadCnt;
    }

    @Override
    public int getCurrentDaemonThreadCount() {
        return this.daemonThreadCnt;
    }

    @Override
    public long getLastDataVersion() {
        return this.lastDataVer;
    }

    @Override
    public int getSentMessagesCount() {
        return this.sentMsgsCnt;
    }

    @Override
    public long getSentBytesCount() {
        return this.sentBytesCnt;
    }

    @Override
    public int getReceivedMessagesCount() {
        return this.rcvdMsgsCnt;
    }

    @Override
    public long getReceivedBytesCount() {
        return this.rcvdBytesCnt;
    }

    @Override
    public int getOutboundMessagesQueueSize() {
        return this.outMesQueueSize;
    }

    @Override
    public int getTotalNodes() {
        return this.totalNodes;
    }

    public void setAvailableProcessors(int availProcs) {
        this.availProcs = availProcs;
    }

    public void setCurrentCpuLoad(double load) {
        this.load = load;
    }

    public void setAverageCpuLoad(double avgLoad) {
        this.avgLoad = avgLoad;
    }

    public void setCurrentGcCpuLoad(double gcLoad) {
        this.gcLoad = gcLoad;
    }

    public void setHeapMemoryInitialized(long heapInit) {
        this.heapInit = heapInit;
    }

    public void setHeapMemoryUsed(long heapUsed) {
        this.heapUsed = heapUsed;
    }

    public void setHeapMemoryCommitted(long heapCommitted) {
        this.heapCommitted = heapCommitted;
    }

    public void setHeapMemoryMaximum(long heapMax) {
        this.heapMax = heapMax;
    }

    public void setNonHeapMemoryInitialized(long nonHeapInit) {
        this.nonHeapInit = nonHeapInit;
    }

    public void setNonHeapMemoryUsed(long nonHeapUsed) {
        this.nonHeapUsed = nonHeapUsed;
    }

    public void setNonHeapMemoryCommitted(long nonHeapCommitted) {
        this.nonHeapCommitted = nonHeapCommitted;
    }

    public void setNonHeapMemoryMaximum(long nonHeapMax) {
        this.nonHeapMax = nonHeapMax;
    }

    public void setUpTime(long upTime) {
        this.upTime = upTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setNodeStartTime(long nodeStartTime) {
        this.nodeStartTime = nodeStartTime;
    }

    public void setCurrentThreadCount(int threadCnt) {
        this.threadCnt = threadCnt;
    }

    public void setMaximumThreadCount(int peakThreadCnt) {
        this.peakThreadCnt = peakThreadCnt;
    }

    public void setTotalStartedThreadCount(long startedThreadCnt) {
        this.startedThreadCnt = startedThreadCnt;
    }

    public void setCurrentDaemonThreadCount(int daemonThreadCnt) {
        this.daemonThreadCnt = daemonThreadCnt;
    }

    public void setLastDataVersion(long lastDataVer) {
        this.lastDataVer = lastDataVer;
    }

    public void setSentMessagesCount(int sentMsgsCnt) {
        this.sentMsgsCnt = sentMsgsCnt;
    }

    public void setSentBytesCount(long sentBytesCnt) {
        this.sentBytesCnt = sentBytesCnt;
    }

    public void setReceivedMessagesCount(int rcvdMsgsCnt) {
        this.rcvdMsgsCnt = rcvdMsgsCnt;
    }

    public void setReceivedBytesCount(long rcvdBytesCnt) {
        this.rcvdBytesCnt = rcvdBytesCnt;
    }

    public void setOutboundMessagesQueueSize(int outMesQueueSize) {
        this.outMesQueueSize = outMesQueueSize;
    }

    public void setTotalNodes(int totalNodes) {
        this.totalNodes = totalNodes;
    }

    private static int cpuCnt(Map<String, Collection<ClusterNode>> neighborhood) {
        int cpus = 0;
        for (Collection<ClusterNode> nodes : neighborhood.values()) {
            ClusterNode first = F.first(nodes);
            if (first == null) continue;
            cpus += first.metrics().getTotalCpus();
        }
        return cpus;
    }

    private static int cpus(Map<String, Collection<ClusterNode>> neighborhood) {
        int cpus = 0;
        for (Collection<ClusterNode> nodes : neighborhood.values()) {
            ClusterNode first = F.first(nodes);
            if (first == null) continue;
            cpus = (int)((double)cpus + first.metrics().getCurrentCpuLoad());
        }
        return cpus;
    }

    private static int gcCpus(Map<String, Collection<ClusterNode>> neighborhood) {
        int cpus = 0;
        for (Collection<ClusterNode> nodes : neighborhood.values()) {
            ClusterNode first = F.first(nodes);
            if (first == null) continue;
            cpus = (int)((double)cpus + first.metrics().getCurrentGcCpuLoad());
        }
        return cpus;
    }

    @Nullable
    private static ClusterNode oldest(Collection<ClusterNode> nodes) {
        long min = Long.MAX_VALUE;
        ClusterNode oldest = null;
        for (ClusterNode n : nodes) {
            if (n.order() >= min) continue;
            min = n.order();
            oldest = n;
        }
        return oldest;
    }

    public static byte[] serialize(ClusterMetrics metrics) {
        byte[] buf = new byte[320];
        ClusterMetricsSnapshot.serialize(buf, 0, metrics);
        return buf;
    }

    public static int serialize(byte[] data, int off, ClusterMetrics metrics) {
        ByteBuffer buf = ByteBuffer.wrap(data, off, 320);
        buf.putInt(metrics.getMaximumActiveJobs());
        buf.putInt(metrics.getCurrentActiveJobs());
        buf.putFloat(metrics.getAverageActiveJobs());
        buf.putInt(metrics.getMaximumWaitingJobs());
        buf.putInt(metrics.getCurrentWaitingJobs());
        buf.putFloat(metrics.getAverageWaitingJobs());
        buf.putInt(metrics.getMaximumRejectedJobs());
        buf.putInt(metrics.getCurrentRejectedJobs());
        buf.putFloat(metrics.getAverageRejectedJobs());
        buf.putInt(metrics.getMaximumCancelledJobs());
        buf.putInt(metrics.getCurrentCancelledJobs());
        buf.putFloat(metrics.getAverageCancelledJobs());
        buf.putInt(metrics.getTotalRejectedJobs());
        buf.putInt(metrics.getTotalCancelledJobs());
        buf.putInt(metrics.getTotalExecutedJobs());
        buf.putLong(metrics.getMaximumJobWaitTime());
        buf.putLong(metrics.getCurrentJobWaitTime());
        buf.putDouble(metrics.getAverageJobWaitTime());
        buf.putLong(metrics.getMaximumJobExecuteTime());
        buf.putLong(metrics.getCurrentJobExecuteTime());
        buf.putDouble(metrics.getAverageJobExecuteTime());
        buf.putInt(metrics.getTotalExecutedTasks());
        buf.putLong(metrics.getCurrentIdleTime());
        buf.putLong(metrics.getTotalIdleTime());
        buf.putInt(metrics.getTotalCpus());
        buf.putDouble(metrics.getCurrentCpuLoad());
        buf.putDouble(metrics.getAverageCpuLoad());
        buf.putDouble(metrics.getCurrentGcCpuLoad());
        buf.putLong(metrics.getHeapMemoryInitialized());
        buf.putLong(metrics.getHeapMemoryUsed());
        buf.putLong(metrics.getHeapMemoryCommitted());
        buf.putLong(metrics.getHeapMemoryMaximum());
        buf.putLong(metrics.getHeapMemoryTotal());
        buf.putLong(metrics.getNonHeapMemoryInitialized());
        buf.putLong(metrics.getNonHeapMemoryUsed());
        buf.putLong(metrics.getNonHeapMemoryCommitted());
        buf.putLong(metrics.getNonHeapMemoryMaximum());
        buf.putLong(metrics.getNonHeapMemoryTotal());
        buf.putLong(metrics.getStartTime());
        buf.putLong(metrics.getNodeStartTime());
        buf.putLong(metrics.getUpTime());
        buf.putInt(metrics.getCurrentThreadCount());
        buf.putInt(metrics.getMaximumThreadCount());
        buf.putLong(metrics.getTotalStartedThreadCount());
        buf.putInt(metrics.getCurrentDaemonThreadCount());
        buf.putLong(metrics.getLastDataVersion());
        buf.putInt(metrics.getSentMessagesCount());
        buf.putLong(metrics.getSentBytesCount());
        buf.putInt(metrics.getReceivedMessagesCount());
        buf.putLong(metrics.getReceivedBytesCount());
        buf.putInt(metrics.getOutboundMessagesQueueSize());
        buf.putInt(metrics.getTotalNodes());
        assert (!buf.hasRemaining()) : "Invalid metrics size [expected=320, actual=" + (buf.position() - off) + ']';
        return buf.position();
    }

    public static ClusterMetrics deserialize(byte[] data, int off) {
        ClusterMetricsSnapshot metrics = new ClusterMetricsSnapshot();
        ByteBuffer buf = ByteBuffer.wrap(data, off, 320);
        metrics.setLastUpdateTime(U.currentTimeMillis());
        metrics.setMaximumActiveJobs(buf.getInt());
        metrics.setCurrentActiveJobs(buf.getInt());
        metrics.setAverageActiveJobs(buf.getFloat());
        metrics.setMaximumWaitingJobs(buf.getInt());
        metrics.setCurrentWaitingJobs(buf.getInt());
        metrics.setAverageWaitingJobs(buf.getFloat());
        metrics.setMaximumRejectedJobs(buf.getInt());
        metrics.setCurrentRejectedJobs(buf.getInt());
        metrics.setAverageRejectedJobs(buf.getFloat());
        metrics.setMaximumCancelledJobs(buf.getInt());
        metrics.setCurrentCancelledJobs(buf.getInt());
        metrics.setAverageCancelledJobs(buf.getFloat());
        metrics.setTotalRejectedJobs(buf.getInt());
        metrics.setTotalCancelledJobs(buf.getInt());
        metrics.setTotalExecutedJobs(buf.getInt());
        metrics.setMaximumJobWaitTime(buf.getLong());
        metrics.setCurrentJobWaitTime(buf.getLong());
        metrics.setAverageJobWaitTime(buf.getDouble());
        metrics.setMaximumJobExecuteTime(buf.getLong());
        metrics.setCurrentJobExecuteTime(buf.getLong());
        metrics.setAverageJobExecuteTime(buf.getDouble());
        metrics.setTotalExecutedTasks(buf.getInt());
        metrics.setCurrentIdleTime(buf.getLong());
        metrics.setTotalIdleTime(buf.getLong());
        metrics.setAvailableProcessors(buf.getInt());
        metrics.setCurrentCpuLoad(buf.getDouble());
        metrics.setAverageCpuLoad(buf.getDouble());
        metrics.setCurrentGcCpuLoad(buf.getDouble());
        metrics.setHeapMemoryInitialized(buf.getLong());
        metrics.setHeapMemoryUsed(buf.getLong());
        metrics.setHeapMemoryCommitted(buf.getLong());
        metrics.setHeapMemoryMaximum(buf.getLong());
        metrics.setHeapMemoryTotal(buf.getLong());
        metrics.setNonHeapMemoryInitialized(buf.getLong());
        metrics.setNonHeapMemoryUsed(buf.getLong());
        metrics.setNonHeapMemoryCommitted(buf.getLong());
        metrics.setNonHeapMemoryMaximum(buf.getLong());
        metrics.setNonHeapMemoryTotal(buf.getLong());
        metrics.setStartTime(buf.getLong());
        metrics.setNodeStartTime(buf.getLong());
        metrics.setUpTime(buf.getLong());
        metrics.setCurrentThreadCount(buf.getInt());
        metrics.setMaximumThreadCount(buf.getInt());
        metrics.setTotalStartedThreadCount(buf.getLong());
        metrics.setCurrentDaemonThreadCount(buf.getInt());
        metrics.setLastDataVersion(buf.getLong());
        metrics.setSentMessagesCount(buf.getInt());
        metrics.setSentBytesCount(buf.getLong());
        metrics.setReceivedMessagesCount(buf.getInt());
        metrics.setReceivedBytesCount(buf.getLong());
        metrics.setOutboundMessagesQueueSize(buf.getInt());
        metrics.setTotalNodes(buf.getInt());
        return metrics;
    }

    public String toString() {
        return S.toString(ClusterMetricsSnapshot.class, this);
    }
}

