/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.plugin.CachePluginConfiguration;
import org.apache.ignite.plugin.CachePluginContext;

public class GridCachePluginContext<C extends CachePluginConfiguration>
implements CachePluginContext<C> {
    private final GridKernalContext ctx;
    private final CacheConfiguration igniteCacheCfg;
    private final CachePluginConfiguration cachePluginCfg;

    public GridCachePluginContext(GridKernalContext ctx, CacheConfiguration igniteCacheCfg, CachePluginConfiguration cachePluginCfg) {
        this.ctx = ctx;
        this.cachePluginCfg = cachePluginCfg;
        this.igniteCacheCfg = igniteCacheCfg;
    }

    @Override
    public IgniteConfiguration igniteConfiguration() {
        return this.ctx.config();
    }

    @Override
    public C cacheConfiguration() {
        return (C)this.cachePluginCfg;
    }

    @Override
    public CacheConfiguration igniteCacheConfiguration() {
        return this.igniteCacheCfg;
    }

    @Override
    public Ignite grid() {
        return this.ctx.grid();
    }

    @Override
    public ClusterNode localNode() {
        return this.ctx.discovery().localNode();
    }

    @Override
    public IgniteLogger log(Class<?> cls) {
        return this.ctx.log(cls);
    }
}

