/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;

final class GridDiagnostic {
    private static final int REACH_TIMEOUT = 2000;

    private GridDiagnostic() {
    }

    static void runBackgroundCheck(String gridName, Executor exec, IgniteLogger parentLog) {
        assert (exec != null);
        assert (parentLog != null);
        IgniteLogger log = parentLog.getLogger(GridDiagnostic.class);
        try {
            exec.execute(new GridWorker(gridName, "grid-diagnostic-1", log){

                @Override
                public void body() {
                    try {
                        InetAddress locHost = U.getLocalHost();
                        if (!locHost.isReachable(2000)) {
                            U.warn(this.log, "Default local host is unreachable. This may lead to delays on grid network operations. Check your OS network setting to correct it.", "Default local host is unreachable.");
                        }
                    }
                    catch (IOException ignore) {
                        U.warn(this.log, "Failed to perform network diagnostics. It is usually caused by serious network configuration problem. Check your OS network setting to correct it.", "Failed to perform network diagnostics.");
                    }
                }
            });
            exec.execute(new GridWorker(gridName, "grid-diagnostic-2", log){

                @Override
                public void body() {
                    try {
                        InetAddress locHost = U.getLocalHost();
                        if (locHost.isLoopbackAddress()) {
                            U.warn(this.log, "Default local host is a loopback address. This can be a sign of potential network configuration problem.", "Default local host is a loopback address.");
                        }
                    }
                    catch (IOException ignore) {
                        U.warn(this.log, "Failed to perform network diagnostics. It is usually caused by serious network configuration problem. Check your OS network setting to correct it.", "Failed to perform network diagnostics.");
                    }
                }
            });
            exec.execute(new GridWorker(gridName, "grid-diagnostic-4", log){

                @Override
                public void body() {
                    if (!U.isSufficientlyTestedOs()) {
                        U.warn(this.log, "This operating system has been tested less rigorously: " + U.osString() + ". Our team will appreciate the feedback if you experience any problems running " + "ignite in this environment.", "This OS is tested less rigorously: " + U.osString());
                    }
                }
            });
            exec.execute(new GridWorker(gridName, "grid-diagnostic-5", log){

                @Override
                public void body() {
                    if (F.isEmpty(U.allLocalMACs())) {
                        U.warn(this.log, "No live network interfaces detected. If IP-multicast discovery is used - make sure to add 127.0.0.1 as a local address.", "No live network interfaces. Add 127.0.0.1 as a local address.");
                    }
                }
            });
            exec.execute(new GridWorker(gridName, "grid-diagnostic-6", log){

                @Override
                public void body() {
                    if (System.getProperty("com.sun.management.jmxremote") != null) {
                        String portStr = System.getProperty("com.sun.management.jmxremote.port");
                        if (portStr != null) {
                            try {
                                Integer.parseInt(portStr);
                                return;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        U.warn(this.log, "JMX remote management is enabled but JMX port is either not set or invalid. Check system property 'com.sun.management.jmxremote.port' to make sure it specifies valid TCP/IP port.", "JMX remote port is invalid - JMX management is off.");
                    }
                }
            });
            long HALF_GB = 0x20000000L;
            exec.execute(new GridWorker(gridName, "grid-diagnostic-7", log){

                @Override
                public void body() {
                    long initBytes = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getInit();
                    long initMb = initBytes / 1024L / 1024L;
                    if (initBytes < 0x20000000L) {
                        U.quietAndWarn(this.log, String.format("Initial heap size is %dMB (should be no less than 512MB, use -Xms512m -Xmx512m).", initMb));
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            U.error(log, "Failed to start background network diagnostics check due to thread pool execution rejection. In most cases it indicates a severe configuration problem with Ignite.", "Failed to start background network diagnostics.", e);
        }
    }
}

