/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobSibling;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridJobExecuteRequest
implements Message {
    private static final long serialVersionUID = 0L;
    private UUID subjId;
    private IgniteUuid sesId;
    private IgniteUuid jobId;
    @GridToStringExclude
    private byte[] jobBytes;
    @GridToStringExclude
    @GridDirectTransient
    private ComputeJob job;
    private long startTaskTime;
    private long timeout;
    private String taskName;
    private String userVer;
    private String taskClsName;
    @GridToStringInclude
    @GridDirectMap(keyType=UUID.class, valueType=IgniteUuid.class)
    private Map<UUID, IgniteUuid> ldrParticipants;
    @GridToStringExclude
    private byte[] sesAttrsBytes;
    @GridToStringExclude
    @GridDirectTransient
    private Map<Object, Object> sesAttrs;
    @GridToStringExclude
    private byte[] jobAttrsBytes;
    @GridToStringExclude
    @GridDirectTransient
    private Map<? extends Serializable, ? extends Serializable> jobAttrs;
    private String cpSpi;
    @GridDirectTransient
    private Collection<ComputeJobSibling> siblings;
    private byte[] siblingsBytes;
    @GridDirectTransient
    private long createTime = U.currentTimeMillis();
    private IgniteUuid clsLdrId;
    private DeploymentMode depMode;
    private boolean dynamicSiblings;
    private boolean forceLocDep;
    private boolean sesFullSup;
    private boolean internal;
    @GridDirectCollection(value=UUID.class)
    private Collection<UUID> top;
    private int[] idsOfCaches;
    private int part;
    private AffinityTopologyVersion topVer;

    public GridJobExecuteRequest() {
    }

    public GridJobExecuteRequest(IgniteUuid sesId, IgniteUuid jobId, String taskName, String userVer, String taskClsName, byte[] jobBytes, ComputeJob job, long startTaskTime, long timeout, @Nullable Collection<UUID> top, byte[] siblingsBytes, Collection<ComputeJobSibling> siblings, byte[] sesAttrsBytes, Map<Object, Object> sesAttrs, byte[] jobAttrsBytes, Map<? extends Serializable, ? extends Serializable> jobAttrs, String cpSpi, IgniteUuid clsLdrId, DeploymentMode depMode, boolean dynamicSiblings, Map<UUID, IgniteUuid> ldrParticipants, boolean forceLocDep, boolean sesFullSup, boolean internal, UUID subjId, @Nullable int[] cacheIds, int part, @Nullable AffinityTopologyVersion topVer) {
        this.top = top;
        assert (sesId != null);
        assert (jobId != null);
        assert (taskName != null);
        assert (taskClsName != null);
        assert (job != null || jobBytes != null);
        assert (sesAttrs != null || sesAttrsBytes != null || !sesFullSup);
        assert (jobAttrs != null || jobAttrsBytes != null);
        assert (clsLdrId != null);
        assert (userVer != null);
        assert (depMode != null);
        this.sesId = sesId;
        this.jobId = jobId;
        this.taskName = taskName;
        this.userVer = userVer;
        this.taskClsName = taskClsName;
        this.jobBytes = jobBytes;
        this.job = job;
        this.startTaskTime = startTaskTime;
        this.timeout = timeout;
        this.top = top;
        this.siblingsBytes = siblingsBytes;
        this.siblings = siblings;
        this.sesAttrsBytes = sesAttrsBytes;
        this.sesAttrs = sesAttrs;
        this.jobAttrsBytes = jobAttrsBytes;
        this.jobAttrs = jobAttrs;
        this.clsLdrId = clsLdrId;
        this.depMode = depMode;
        this.dynamicSiblings = dynamicSiblings;
        this.ldrParticipants = ldrParticipants;
        this.forceLocDep = forceLocDep;
        this.sesFullSup = sesFullSup;
        this.internal = internal;
        this.subjId = subjId;
        this.idsOfCaches = cacheIds;
        this.part = part;
        this.topVer = topVer;
        this.cpSpi = cpSpi == null || cpSpi.isEmpty() ? null : cpSpi;
    }

    public IgniteUuid getSessionId() {
        return this.sesId;
    }

    public IgniteUuid getJobId() {
        return this.jobId;
    }

    public String getTaskClassName() {
        return this.taskClsName;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getUserVersion() {
        return this.userVer;
    }

    public byte[] getJobBytes() {
        return this.jobBytes;
    }

    public ComputeJob getJob() {
        return this.job;
    }

    public long getStartTaskTime() {
        return this.startTaskTime;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public byte[] getSiblingsBytes() {
        return this.siblingsBytes;
    }

    public Collection<ComputeJobSibling> getSiblings() {
        return this.siblings;
    }

    public byte[] getSessionAttributesBytes() {
        return this.sesAttrsBytes;
    }

    public Map<Object, Object> getSessionAttributes() {
        return this.sesAttrs;
    }

    public byte[] getJobAttributesBytes() {
        return this.jobAttrsBytes;
    }

    public Map<? extends Serializable, ? extends Serializable> getJobAttributes() {
        return this.jobAttrs;
    }

    public String getCheckpointSpi() {
        return this.cpSpi;
    }

    public IgniteUuid getClassLoaderId() {
        return this.clsLdrId;
    }

    public DeploymentMode getDeploymentMode() {
        return this.depMode;
    }

    public boolean isDynamicSiblings() {
        return this.dynamicSiblings;
    }

    public Map<UUID, IgniteUuid> getLoaderParticipants() {
        return this.ldrParticipants;
    }

    public boolean isForceLocalDeployment() {
        return this.forceLocDep;
    }

    @Nullable
    public Collection<UUID> topology() {
        return this.top;
    }

    public boolean isSessionFullSupport() {
        return this.sesFullSup;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public UUID getSubjectId() {
        return this.subjId;
    }

    public int[] getCacheIds() {
        return this.idsOfCaches;
    }

    public int getPartition() {
        return this.part;
    }

    public AffinityTopologyVersion getTopVer() {
        return this.topVer;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeIgniteUuid("clsLdrId", this.clsLdrId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeString("cpSpi", this.cpSpi)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeByte("depMode", this.depMode != null ? (byte)this.depMode.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeBoolean("dynamicSiblings", this.dynamicSiblings)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeBoolean("forceLocDep", this.forceLocDep)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeIntArray("idsOfCaches", this.idsOfCaches)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeBoolean("internal", this.internal)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeByteArray("jobAttrsBytes", this.jobAttrsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeByteArray("jobBytes", this.jobBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeIgniteUuid("jobId", this.jobId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeMap("ldrParticipants", this.ldrParticipants, MessageCollectionItemType.UUID, MessageCollectionItemType.IGNITE_UUID)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeInt("part", this.part)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeByteArray("sesAttrsBytes", this.sesAttrsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeBoolean("sesFullSup", this.sesFullSup)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeIgniteUuid("sesId", this.sesId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeByteArray("siblingsBytes", this.siblingsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 16: {
                if (!writer.writeLong("startTaskTime", this.startTaskTime)) {
                    return false;
                }
                writer.incrementState();
            }
            case 17: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 18: {
                if (!writer.writeString("taskClsName", this.taskClsName)) {
                    return false;
                }
                writer.incrementState();
            }
            case 19: {
                if (!writer.writeString("taskName", this.taskName)) {
                    return false;
                }
                writer.incrementState();
            }
            case 20: {
                if (!writer.writeLong("timeout", this.timeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 21: {
                if (!writer.writeCollection("top", this.top, MessageCollectionItemType.UUID)) {
                    return false;
                }
                writer.incrementState();
            }
            case 22: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 23: {
                if (!writer.writeString("userVer", this.userVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.clsLdrId = reader.readIgniteUuid("clsLdrId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.cpSpi = reader.readString("cpSpi");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                byte depModeOrd = reader.readByte("depMode");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.depMode = DeploymentMode.fromOrdinal(depModeOrd);
                reader.incrementState();
            }
            case 3: {
                this.dynamicSiblings = reader.readBoolean("dynamicSiblings");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.forceLocDep = reader.readBoolean("forceLocDep");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.idsOfCaches = reader.readIntArray("idsOfCaches");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.internal = reader.readBoolean("internal");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.jobAttrsBytes = reader.readByteArray("jobAttrsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.jobBytes = reader.readByteArray("jobBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.jobId = reader.readIgniteUuid("jobId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.ldrParticipants = reader.readMap("ldrParticipants", MessageCollectionItemType.UUID, MessageCollectionItemType.IGNITE_UUID, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.part = reader.readInt("part");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.sesAttrsBytes = reader.readByteArray("sesAttrsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.sesFullSup = reader.readBoolean("sesFullSup");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.sesId = reader.readIgniteUuid("sesId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.siblingsBytes = reader.readByteArray("siblingsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 16: {
                this.startTaskTime = reader.readLong("startTaskTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 17: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 18: {
                this.taskClsName = reader.readString("taskClsName");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 19: {
                this.taskName = reader.readString("taskName");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 20: {
                this.timeout = reader.readLong("timeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 21: {
                this.top = reader.readCollection("top", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 22: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 23: {
                this.userVer = reader.readString("userVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridJobExecuteRequest.class);
    }

    @Override
    public byte directType() {
        return 1;
    }

    @Override
    public byte fieldsCount() {
        return 24;
    }

    public String toString() {
        return S.toString(GridJobExecuteRequest.class, this);
    }
}

