/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridJobSiblingsRequest
implements Message {
    private static final long serialVersionUID = 0L;
    private IgniteUuid sesId;
    @GridDirectTransient
    private Object topic;
    private byte[] topicBytes;

    public GridJobSiblingsRequest() {
    }

    public GridJobSiblingsRequest(IgniteUuid sesId, Object topic, byte[] topicBytes) {
        assert (sesId != null);
        assert (topic != null || topicBytes != null);
        this.sesId = sesId;
        this.topic = topic;
        this.topicBytes = topicBytes;
    }

    public IgniteUuid sessionId() {
        return this.sesId;
    }

    public Object topic() {
        return this.topic;
    }

    public byte[] topicBytes() {
        return this.topicBytes;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeIgniteUuid("sesId", this.sesId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByteArray("topicBytes", this.topicBytes)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.sesId = reader.readIgniteUuid("sesId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.topicBytes = reader.readByteArray("topicBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridJobSiblingsRequest.class);
    }

    @Override
    public byte directType() {
        return 3;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    public String toString() {
        return S.toString(GridJobSiblingsRequest.class, this);
    }
}

