/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.internal.GridKernalGateway;
import org.apache.ignite.internal.GridKernalState;
import org.apache.ignite.internal.util.GridSpinReadWriteLock;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

@GridToStringExclude
public class GridKernalGatewayImpl
implements GridKernalGateway,
Serializable {
    private static final long serialVersionUID = 0L;
    @GridToStringExclude
    private final GridSpinReadWriteLock rwLock = new GridSpinReadWriteLock();
    @GridToStringExclude
    private IgniteFutureImpl<?> reconnectFut;
    private final AtomicReference<GridKernalState> state = new AtomicReference<GridKernalState>(GridKernalState.STOPPED);
    @GridToStringExclude
    private final String gridName;
    private String stackTrace;

    public GridKernalGatewayImpl(String gridName) {
        this.gridName = gridName;
    }

    @Override
    public void readLock() throws IllegalStateException {
        if (this.stackTrace == null) {
            this.stackTrace = GridKernalGatewayImpl.stackTrace();
        }
        this.rwLock.readLock();
        GridKernalState state = this.state.get();
        if (state != GridKernalState.STARTED) {
            this.rwLock.readUnlock();
            if (state == GridKernalState.DISCONNECTED) {
                assert (this.reconnectFut != null);
                throw new IgniteClientDisconnectedException(this.reconnectFut, "Client node disconnected: " + this.gridName);
            }
            throw this.illegalState();
        }
    }

    @Override
    public void readLockAnyway() {
        if (this.stackTrace == null) {
            this.stackTrace = GridKernalGatewayImpl.stackTrace();
        }
        this.rwLock.readLock();
        if (this.state.get() == GridKernalState.DISCONNECTED) {
            throw new IgniteClientDisconnectedException(this.reconnectFut, "Client node disconnected: " + this.gridName);
        }
    }

    @Override
    public void readUnlock() {
        this.rwLock.readUnlock();
    }

    @Override
    public void writeLock() {
        if (this.stackTrace == null) {
            this.stackTrace = GridKernalGatewayImpl.stackTrace();
        }
        boolean interrupted = false;
        while (true) {
            try {
                while (!this.rwLock.tryWriteLock(200L, TimeUnit.MILLISECONDS)) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException ignore) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean tryWriteLock(long timeout) throws InterruptedException {
        boolean acquired = this.rwLock.tryWriteLock(timeout, TimeUnit.MILLISECONDS);
        if (acquired) {
            if (this.stackTrace == null) {
                this.stackTrace = GridKernalGatewayImpl.stackTrace();
            }
            return true;
        }
        return false;
    }

    @Override
    public GridFutureAdapter<?> onDisconnected() {
        GridFutureAdapter fut = new GridFutureAdapter();
        this.reconnectFut = new IgniteFutureImpl(fut);
        if (!this.state.compareAndSet(GridKernalState.STARTED, GridKernalState.DISCONNECTED)) {
            ((GridFutureAdapter)this.reconnectFut.internalFuture()).onDone(new IgniteCheckedException("Node stopped."));
            return null;
        }
        return fut;
    }

    @Override
    public void onReconnected() {
        if (this.state.compareAndSet(GridKernalState.DISCONNECTED, GridKernalState.STARTED)) {
            ((GridFutureAdapter)this.reconnectFut.internalFuture()).onDone();
        }
    }

    private static String stackTrace() {
        StringWriter sw = new StringWriter();
        new Throwable().printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private IllegalStateException illegalState() {
        return new IllegalStateException("Grid is in invalid state to perform this operation. It either not started yet or has already being or have stopped [gridName=" + this.gridName + ", state=" + this.state + ']');
    }

    @Override
    public void writeUnlock() {
        this.rwLock.writeUnlock();
    }

    @Override
    public void setState(GridKernalState state) {
        assert (state != null);
        this.state.set(state);
        if (this.reconnectFut != null) {
            ((GridFutureAdapter)this.reconnectFut.internalFuture()).onDone(new IgniteCheckedException("Node stopped."));
        }
    }

    @Override
    public GridKernalState getState() {
        return this.state.get();
    }

    @Override
    public String userStackTrace() {
        return this.stackTrace;
    }

    public String toString() {
        return S.toString(GridKernalGatewayImpl.class, this);
    }
}

