/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collections;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.jetbrains.annotations.Nullable;

public class GridLoggerProxy
implements IgniteLogger,
LifecycleAware,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static ThreadLocal<IgniteBiTuple<String, Object>> stash = new ThreadLocal<IgniteBiTuple<String, Object>>(){

        @Override
        protected IgniteBiTuple<String, Object> initialValue() {
            return new IgniteBiTuple<String, Object>();
        }
    };
    private IgniteLogger impl;
    private String gridName;
    private String id8;
    @GridToStringExclude
    private Object ctgr;
    private static final boolean logGridName = System.getProperty("IGNITE_LOG_GRID_NAME") != null;

    public GridLoggerProxy() {
    }

    public GridLoggerProxy(IgniteLogger impl2, @Nullable Object ctgr, @Nullable String gridName, String id8) {
        assert (impl2 != null);
        this.impl = impl2;
        this.ctgr = ctgr;
        this.gridName = gridName;
        this.id8 = id8;
    }

    @Override
    public void start() {
        if (this.impl instanceof LifecycleAware) {
            ((LifecycleAware)((Object)this.impl)).start();
        }
    }

    @Override
    public void stop() {
        U.stopLifecycleAware(this, Collections.singleton(this.impl));
    }

    @Override
    public IgniteLogger getLogger(Object ctgr) {
        assert (ctgr != null);
        return new GridLoggerProxy(this.impl.getLogger(ctgr), ctgr, this.gridName, this.id8);
    }

    @Override
    @Nullable
    public String fileName() {
        return this.impl.fileName();
    }

    @Override
    public void trace(String msg) {
        this.impl.trace(this.enrich(msg));
    }

    @Override
    public void debug(String msg) {
        this.impl.debug(this.enrich(msg));
    }

    @Override
    public void info(String msg) {
        this.impl.info(this.enrich(msg));
    }

    @Override
    public void warning(String msg) {
        this.impl.warning(this.enrich(msg));
    }

    @Override
    public void warning(String msg, Throwable e) {
        this.impl.warning(this.enrich(msg), e);
    }

    @Override
    public void error(String msg) {
        this.impl.error(this.enrich(msg));
    }

    @Override
    public void error(String msg, Throwable e) {
        this.impl.error(this.enrich(msg), e);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.impl.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.impl.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.impl.isInfoEnabled();
    }

    @Override
    public boolean isQuiet() {
        return this.impl.isQuiet();
    }

    private String enrich(@Nullable String m) {
        return logGridName && m != null ? "<" + this.gridName + '-' + this.id8 + "> " + m : m;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.gridName);
        out.writeObject(this.ctgr);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IgniteBiTuple<String, Object> t = stash.get();
        t.set1(U.readString(in));
        t.set2(in.readObject());
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            IgniteBiTuple<String, Object> t = stash.get();
            Object ctgrR = t.get2();
            IgniteLogger log = IgnitionEx.localIgnite().log();
            IgniteLogger igniteLogger = ctgrR != null ? log.getLogger(ctgrR) : log;
            return igniteLogger;
        }
        catch (IllegalStateException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    public String toString() {
        return S.toString(GridLoggerProxy.class, this);
    }
}

