/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Serializable;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.plugin.PluginValidationException;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.jetbrains.annotations.Nullable;

public class GridPluginComponent
implements GridComponent {
    private final PluginProvider plugin;

    public GridPluginComponent(PluginProvider plugin) {
        this.plugin = plugin;
    }

    public PluginProvider plugin() {
        return this.plugin;
    }

    @Override
    public void start() throws IgniteCheckedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.plugin.stop(cancel);
    }

    @Override
    public void onKernalStart() throws IgniteCheckedException {
        this.plugin.onIgniteStart();
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) {
    }

    @Override
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) {
        return null;
    }

    @Override
    public void onKernalStop(boolean cancel) {
        this.plugin.onIgniteStop(cancel);
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return null;
    }

    @Override
    @Nullable
    public Serializable collectDiscoveryData(UUID nodeId) {
        return null;
    }

    @Override
    public void onDiscoveryDataReceived(UUID joiningNodeId, UUID rmtNodeId, Serializable data) {
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node) {
        try {
            this.plugin.validateNewNode(node);
            return null;
        }
        catch (PluginValidationException e) {
            return new IgniteNodeValidationResult(e.nodeId(), e.getMessage(), e.remoteMessage());
        }
    }

    @Override
    public void printMemoryStats() {
    }
}

