/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteDeploymentException;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.compute.ComputeTaskFuture;
import org.apache.ignite.internal.AsyncSupportAdapter;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterGroupAdapter;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.processors.task.GridTaskThreadContextKey;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgniteComputeImpl
extends AsyncSupportAdapter<IgniteCompute>
implements IgniteCompute,
Externalizable {
    private static final long serialVersionUID = 0L;
    private GridKernalContext ctx;
    private ClusterGroupAdapter prj;
    private UUID subjId;

    public IgniteComputeImpl() {
    }

    public IgniteComputeImpl(GridKernalContext ctx, ClusterGroupAdapter prj, UUID subjId, boolean async) {
        super(async);
        this.ctx = ctx;
        this.prj = prj;
        this.subjId = subjId;
    }

    @Override
    protected IgniteCompute createAsyncInstance() {
        return new IgniteComputeImpl(this.ctx, this.prj, this.subjId, true);
    }

    @Override
    public ClusterGroup clusterGroup() {
        return this.prj;
    }

    @Override
    public void affinityRun(@Nullable String cacheName, Object affKey, IgniteRunnable job) {
        A.notNull(affKey, "affKey");
        A.notNull(job, "job");
        this.guard();
        try {
            Object affKey0 = this.ctx.affinity().affinityKey(cacheName, affKey);
            int partId = this.ctx.affinity().partition(cacheName, affKey0);
            if (partId < 0) {
                throw new IgniteCheckedException("Failed map key to partition: [cache=" + cacheName + " key=" + affKey + ']');
            }
            this.saveOrGet(this.ctx.closure().affinityRun(Collections.singletonList(cacheName), partId, affKey, job, this.prj.nodes()));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void affinityRun(@NotNull Collection<String> cacheNames, Object affKey, IgniteRunnable job) {
        A.notNull(affKey, "affKey");
        A.notNull(job, "job");
        A.ensure(!cacheNames.isEmpty(), "cachesNames mustn't be empty");
        this.guard();
        try {
            String cacheName = F.first(cacheNames);
            Object affKey0 = this.ctx.affinity().affinityKey(cacheName, affKey);
            int partId = this.ctx.affinity().partition(cacheName, affKey0);
            if (partId < 0) {
                throw new IgniteCheckedException("Failed map key to partition: [cache=" + cacheName + " key=" + affKey + ']');
            }
            this.saveOrGet(this.ctx.closure().affinityRun(cacheNames, partId, affKey, job, this.prj.nodes()));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void affinityRun(@NotNull Collection<String> cacheNames, int partId, IgniteRunnable job) {
        A.ensure(partId >= 0, "partId = " + partId);
        A.notNull(job, "job");
        A.ensure(!cacheNames.isEmpty(), "cachesNames mustn't be empty");
        this.guard();
        try {
            this.saveOrGet(this.ctx.closure().affinityRun(cacheNames, partId, null, job, this.prj.nodes()));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R> R affinityCall(@Nullable String cacheName, Object affKey, IgniteCallable<R> job) {
        A.notNull(affKey, "affKey");
        A.notNull(job, "job");
        this.guard();
        try {
            Object affKey0 = this.ctx.affinity().affinityKey(cacheName, affKey);
            int partId = this.ctx.affinity().partition(cacheName, affKey0);
            if (partId < 0) {
                throw new IgniteCheckedException("Failed map key to partition: [cache=" + cacheName + " key=" + affKey + ']');
            }
            R r = this.saveOrGet(this.ctx.closure().affinityCall(Collections.singletonList(cacheName), partId, affKey, job, this.prj.nodes()));
            return r;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R> R affinityCall(@NotNull Collection<String> cacheNames, Object affKey, IgniteCallable<R> job) {
        A.notNull(affKey, "affKey");
        A.notNull(job, "job");
        A.ensure(!cacheNames.isEmpty(), "cachesNames mustn't be empty");
        this.guard();
        try {
            String cacheName = F.first(cacheNames);
            Object affKey0 = this.ctx.affinity().affinityKey(cacheName, affKey);
            int partId = this.ctx.affinity().partition(cacheName, affKey0);
            if (partId < 0) {
                throw new IgniteCheckedException("Failed map key to partition: [cache=" + cacheName + " key=" + affKey + ']');
            }
            R r = this.saveOrGet(this.ctx.closure().affinityCall(cacheNames, partId, affKey, job, this.prj.nodes()));
            return r;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R> R affinityCall(@NotNull Collection<String> cacheNames, int partId, IgniteCallable<R> job) {
        A.ensure(partId >= 0, "partId = " + partId);
        A.notNull(job, "job");
        A.ensure(!cacheNames.isEmpty(), "cachesNames mustn't be empty");
        this.guard();
        try {
            R r = this.saveOrGet(this.ctx.closure().affinityCall(cacheNames, partId, null, job, this.prj.nodes()));
            return r;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T, R> R execute(String taskName, @Nullable T arg) {
        A.notNull(taskName, "taskName");
        this.guard();
        try {
            this.ctx.task().setThreadContextIfNotNull(GridTaskThreadContextKey.TC_SUBGRID, this.prj.nodes());
            this.ctx.task().setThreadContextIfNotNull(GridTaskThreadContextKey.TC_SUBJ_ID, this.subjId);
            Object r = this.saveOrGet(this.ctx.task().execute(taskName, arg));
            return r;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T, R> R execute(Class<? extends ComputeTask<T, R>> taskCls, @Nullable T arg) {
        A.notNull(taskCls, "taskCls");
        this.guard();
        try {
            this.ctx.task().setThreadContextIfNotNull(GridTaskThreadContextKey.TC_SUBGRID, this.prj.nodes());
            this.ctx.task().setThreadContextIfNotNull(GridTaskThreadContextKey.TC_SUBJ_ID, this.subjId);
            Object r = this.saveOrGet(this.ctx.task().execute(taskCls, arg));
            return r;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T, R> R execute(ComputeTask<T, R> task, @Nullable T arg) {
        A.notNull(task, "task");
        this.guard();
        try {
            this.ctx.task().setThreadContextIfNotNull(GridTaskThreadContextKey.TC_SUBGRID, this.prj.nodes());
            this.ctx.task().setThreadContextIfNotNull(GridTaskThreadContextKey.TC_SUBJ_ID, this.subjId);
            R r = this.saveOrGet(this.ctx.task().execute(task, arg));
            return r;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> ComputeTaskInternalFuture<R> executeAsync(ComputeTask<T, R> task, @Nullable T arg) {
        A.notNull(task, "task");
        this.guard();
        try {
            this.ctx.task().setThreadContextIfNotNull(GridTaskThreadContextKey.TC_SUBGRID, this.prj.nodes());
            this.ctx.task().setThreadContextIfNotNull(GridTaskThreadContextKey.TC_SUBJ_ID, this.subjId);
            ComputeTaskInternalFuture<R> computeTaskInternalFuture = this.ctx.task().execute(task, arg);
            return computeTaskInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> ComputeTaskInternalFuture<R> executeAsync(String taskName, @Nullable T arg) {
        A.notNull(taskName, "taskName");
        this.guard();
        try {
            this.ctx.task().setThreadContextIfNotNull(GridTaskThreadContextKey.TC_SUBGRID, this.prj.nodes());
            this.ctx.task().setThreadContextIfNotNull(GridTaskThreadContextKey.TC_SUBJ_ID, this.subjId);
            ComputeTaskInternalFuture computeTaskInternalFuture = this.ctx.task().execute(taskName, arg);
            return computeTaskInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void broadcast(IgniteRunnable job) {
        A.notNull(job, "job");
        this.guard();
        try {
            this.saveOrGet(this.ctx.closure().runAsync(GridClosureCallMode.BROADCAST, job, this.prj.nodes()));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R> Collection<R> broadcast(IgniteCallable<R> job) {
        A.notNull(job, "job");
        this.guard();
        try {
            Collection<R> collection = this.saveOrGet(this.ctx.closure().callAsync(GridClosureCallMode.BROADCAST, Collections.singletonList(job), this.prj.nodes()));
            return collection;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R, T> Collection<R> broadcast(IgniteClosure<T, R> job, @Nullable T arg) {
        A.notNull(job, "job");
        this.guard();
        try {
            Collection<R> collection = this.saveOrGet(this.ctx.closure().broadcast(job, arg, this.prj.nodes()));
            return collection;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void run(IgniteRunnable job) {
        A.notNull(job, "job");
        this.guard();
        try {
            this.saveOrGet(this.ctx.closure().runAsync(GridClosureCallMode.BALANCE, job, this.prj.nodes()));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void run(Collection<? extends IgniteRunnable> jobs) {
        A.notEmpty(jobs, "jobs");
        this.guard();
        try {
            this.saveOrGet(this.ctx.closure().runAsync(GridClosureCallMode.BALANCE, jobs, this.prj.nodes()));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R, T> R apply(IgniteClosure<T, R> job, @Nullable T arg) {
        A.notNull(job, "job");
        this.guard();
        try {
            R r = this.saveOrGet(this.ctx.closure().callAsync(job, arg, this.prj.nodes()));
            return r;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R> R call(IgniteCallable<R> job) {
        A.notNull(job, "job");
        this.guard();
        try {
            R r = this.saveOrGet(this.ctx.closure().callAsync(GridClosureCallMode.BALANCE, job, this.prj.nodes()));
            return r;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R> Collection<R> call(Collection<? extends IgniteCallable<R>> jobs) {
        A.notEmpty(jobs, "jobs");
        this.guard();
        try {
            Collection collection = this.saveOrGet(this.ctx.closure().callAsync(GridClosureCallMode.BALANCE, jobs, this.prj.nodes()));
            return collection;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T, R> Collection<R> apply(IgniteClosure<T, R> job, @Nullable Collection<? extends T> args) {
        A.notNull(job, "job");
        A.notNull(args, "args");
        this.guard();
        try {
            Collection<R> collection = this.saveOrGet(this.ctx.closure().callAsync(job, args, this.prj.nodes()));
            return collection;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R1, R2> R2 call(Collection<? extends IgniteCallable<R1>> jobs, IgniteReducer<R1, R2> rdc) {
        A.notEmpty(jobs, "jobs");
        A.notNull(rdc, "rdc");
        this.guard();
        try {
            R2 R22 = this.saveOrGet(this.ctx.closure().forkjoinAsync(GridClosureCallMode.BALANCE, jobs, rdc, this.prj.nodes()));
            return R22;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R1, R2, T> R2 apply(IgniteClosure<T, R1> job, Collection<? extends T> args, IgniteReducer<R1, R2> rdc) {
        A.notNull(job, "job");
        A.notNull(rdc, "rdc");
        A.notNull(args, "args");
        this.guard();
        try {
            R2 R22 = this.saveOrGet(this.ctx.closure().callAsync(job, args, rdc, this.prj.nodes()));
            return R22;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> Map<IgniteUuid, ComputeTaskFuture<R>> activeTaskFutures() {
        this.guard();
        try {
            Map map = this.ctx.task().taskFutures();
            return map;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteCompute withName(String taskName) {
        A.notNull(taskName, "taskName");
        this.guard();
        try {
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_TASK_NAME, taskName);
        }
        finally {
            this.unguard();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteCompute withTimeout(long timeout) {
        A.ensure(timeout >= 0L, "timeout >= 0");
        this.guard();
        try {
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_TIMEOUT, timeout);
        }
        finally {
            this.unguard();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteCompute withNoFailover() {
        this.guard();
        try {
            this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_NO_FAILOVER, true);
        }
        finally {
            this.unguard();
        }
        return this;
    }

    @Override
    public void localDeployTask(Class<? extends ComputeTask> taskCls, ClassLoader clsLdr) {
        A.notNull(taskCls, "taskCls", clsLdr, "clsLdr");
        this.guard();
        try {
            GridDeployment dep = this.ctx.deploy().deploy(taskCls, clsLdr);
            if (dep == null) {
                throw new IgniteDeploymentException("Failed to deploy task (was task (re|un)deployed?): " + taskCls);
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Class<? extends ComputeTask<?, ?>>> localTasks() {
        this.guard();
        try {
            Map<String, Class<? extends ComputeTask<?, ?>>> map = this.ctx.deploy().findAllTasks(new IgnitePredicate[0]);
            return map;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeployTask(String taskName) {
        A.notNull(taskName, "taskName");
        this.guard();
        try {
            this.ctx.deploy().undeployTask(taskName, this.prj.node(this.ctx.localNodeId()) != null, this.prj.forRemotes().nodes());
        }
        finally {
            this.unguard();
        }
    }

    private void guard() {
        this.ctx.gateway().readLock();
    }

    private void unguard() {
        this.ctx.gateway().readUnlock();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.prj);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.prj = (ClusterGroupAdapter)in.readObject();
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.prj.compute();
    }

    @Override
    protected <R> IgniteFuture<R> createFuture(IgniteInternalFuture<R> fut) {
        assert (fut instanceof ComputeTaskInternalFuture) : fut;
        return ((ComputeTaskInternalFuture)fut).publicFuture();
    }

    @Override
    public <R> ComputeTaskFuture<R> future() {
        return (ComputeTaskFuture)super.future();
    }
}

