/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteAtomicReference;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteAtomicStamped;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteCountDownLatch;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteEvents;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteFileSystem;
import org.apache.ignite.IgniteLock;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteMessaging;
import org.apache.ignite.IgniteQueue;
import org.apache.ignite.IgniteScheduler;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.IgniteServices;
import org.apache.ignite.IgniteSet;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.CollectionConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.ClusterLocalNodeMetricsMXBeanImpl;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridDiagnostic;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridKernalContextImpl;
import org.apache.ignite.internal.GridKernalGateway;
import org.apache.ignite.internal.GridKernalGatewayImpl;
import org.apache.ignite.internal.GridKernalState;
import org.apache.ignite.internal.GridLoggerProxy;
import org.apache.ignite.internal.GridPluginComponent;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteSchedulerImpl;
import org.apache.ignite.internal.IgniteTransactionsEx;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.SkipDaemon;
import org.apache.ignite.internal.ThreadPoolMXBeanAdapter;
import org.apache.ignite.internal.binary.BinaryEnumCache;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.cluster.ClusterGroupAdapter;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.managers.GridManager;
import org.apache.ignite.internal.managers.checkpoint.GridCheckpointManager;
import org.apache.ignite.internal.managers.collision.GridCollisionManager;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.deployment.GridDeploymentManager;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.managers.failover.GridFailoverManager;
import org.apache.ignite.internal.managers.indexing.GridIndexingManager;
import org.apache.ignite.internal.managers.loadbalancer.GridLoadBalancerManager;
import org.apache.ignite.internal.managers.swapspace.GridSwapSpaceManager;
import org.apache.ignite.internal.processors.GridProcessor;
import org.apache.ignite.internal.processors.affinity.GridAffinityProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheUtilityKey;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.clock.GridClockSyncProcessor;
import org.apache.ignite.internal.processors.closure.GridClosureProcessor;
import org.apache.ignite.internal.processors.cluster.ClusterProcessor;
import org.apache.ignite.internal.processors.continuous.GridContinuousProcessor;
import org.apache.ignite.internal.processors.datastreamer.DataStreamProcessor;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerImpl;
import org.apache.ignite.internal.processors.datastructures.DataStructuresProcessor;
import org.apache.ignite.internal.processors.hadoop.Hadoop;
import org.apache.ignite.internal.processors.hadoop.HadoopProcessorAdapter;
import org.apache.ignite.internal.processors.job.GridJobProcessor;
import org.apache.ignite.internal.processors.jobmetrics.GridJobMetricsProcessor;
import org.apache.ignite.internal.processors.nodevalidation.DiscoveryNodeValidationProcessor;
import org.apache.ignite.internal.processors.nodevalidation.OsDiscoveryNodeValidationProcessor;
import org.apache.ignite.internal.processors.odbc.OdbcProcessor;
import org.apache.ignite.internal.processors.offheap.GridOffHeapProcessor;
import org.apache.ignite.internal.processors.platform.PlatformNoopProcessor;
import org.apache.ignite.internal.processors.platform.PlatformProcessor;
import org.apache.ignite.internal.processors.plugin.IgnitePluginProcessor;
import org.apache.ignite.internal.processors.pool.PoolProcessor;
import org.apache.ignite.internal.processors.port.GridPortProcessor;
import org.apache.ignite.internal.processors.port.GridPortRecord;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.resource.GridResourceProcessor;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.processors.rest.GridRestProcessor;
import org.apache.ignite.internal.processors.security.GridSecurityProcessor;
import org.apache.ignite.internal.processors.segmentation.GridSegmentationProcessor;
import org.apache.ignite.internal.processors.service.GridServiceProcessor;
import org.apache.ignite.internal.processors.session.GridTaskSessionProcessor;
import org.apache.ignite.internal.processors.task.GridTaskProcessor;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.suggestions.GridPerformanceSuggestions;
import org.apache.ignite.internal.suggestions.JvmConfigurationSuggestions;
import org.apache.ignite.internal.suggestions.OsConfigurationSuggestions;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.lang.GridAbsClosure;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lifecycle.LifecycleBean;
import org.apache.ignite.lifecycle.LifecycleEventType;
import org.apache.ignite.marshaller.MarshallerExclusions;
import org.apache.ignite.marshaller.optimized.OptimizedMarshaller;
import org.apache.ignite.mxbean.ClusterLocalNodeMetricsMXBean;
import org.apache.ignite.mxbean.IgniteMXBean;
import org.apache.ignite.mxbean.ThreadPoolMXBean;
import org.apache.ignite.plugin.IgnitePlugin;
import org.apache.ignite.plugin.PluginContext;
import org.apache.ignite.plugin.PluginNotFoundException;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiVersionCheckException;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.thread.IgniteStripedThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

public class IgniteKernal
implements IgniteEx,
IgniteMXBean,
Externalizable {
    private static final long serialVersionUID = 0L;
    public static final String SITE = "ignite.apache.org";
    private static final String NL = U.nl();
    private static final long PERIODIC_STARVATION_CHECK_FREQ = 30000L;
    @GridToStringExclude
    private GridKernalContextImpl ctx;
    private IgniteConfiguration cfg;
    @GridToStringExclude
    private GridLoggerProxy log;
    private String gridName;
    @GridToStringExclude
    private ObjectName kernalMBean;
    @GridToStringExclude
    private ObjectName locNodeMBean;
    @GridToStringExclude
    private ObjectName pubExecSvcMBean;
    @GridToStringExclude
    private ObjectName sysExecSvcMBean;
    @GridToStringExclude
    private ObjectName mgmtExecSvcMBean;
    @GridToStringExclude
    private ObjectName p2PExecSvcMBean;
    @GridToStringExclude
    private ObjectName restExecSvcMBean;
    private long startTime = U.currentTimeMillis();
    private GridSpringResourceContext rsrcCtx;
    @GridToStringExclude
    private GridTimeoutProcessor.CancelableTask starveTask;
    @GridToStringExclude
    private GridTimeoutProcessor.CancelableTask metricsLogTask;
    @GridToStringExclude
    private GridTimeoutProcessor.CancelableTask longOpDumpTask;
    @GridToStringExclude
    private boolean errOnStop;
    @GridToStringExclude
    private IgniteScheduler scheduler;
    @GridToStringExclude
    private final AtomicReference<GridKernalGateway> gw = new AtomicReference();
    @GridToStringExclude
    private final AtomicBoolean stopGuard = new AtomicBoolean();

    public IgniteKernal() {
        this(null);
    }

    public IgniteKernal(@Nullable GridSpringResourceContext rsrcCtx) {
        this.rsrcCtx = rsrcCtx;
    }

    @Override
    public IgniteClusterEx cluster() {
        return this.ctx.cluster().get();
    }

    @Override
    public ClusterNode localNode() {
        return this.ctx.cluster().get().localNode();
    }

    @Override
    public IgniteCompute compute() {
        return ((ClusterGroupAdapter)this.ctx.cluster().get().forServers()).compute();
    }

    @Override
    public IgniteMessaging message() {
        return this.ctx.cluster().get().message();
    }

    @Override
    public IgniteEvents events() {
        return this.ctx.cluster().get().events();
    }

    @Override
    public IgniteServices services() {
        return ((ClusterGroupAdapter)this.ctx.cluster().get().forServers()).services();
    }

    @Override
    public ExecutorService executorService() {
        return this.ctx.cluster().get().executorService();
    }

    @Override
    public final IgniteCompute compute(ClusterGroup grp) {
        return ((ClusterGroupAdapter)grp).compute();
    }

    @Override
    public final IgniteMessaging message(ClusterGroup prj) {
        return ((ClusterGroupAdapter)prj).message();
    }

    @Override
    public final IgniteEvents events(ClusterGroup grp) {
        return ((ClusterGroupAdapter)grp).events();
    }

    @Override
    public IgniteServices services(ClusterGroup grp) {
        return ((ClusterGroupAdapter)grp).services();
    }

    @Override
    public ExecutorService executorService(ClusterGroup grp) {
        return ((ClusterGroupAdapter)grp).executorService();
    }

    @Override
    public String name() {
        return this.gridName;
    }

    @Override
    public String getCopyright() {
        return "2017 Copyright(C) Apache Software Foundation";
    }

    @Override
    public long getStartTimestamp() {
        return this.startTime;
    }

    @Override
    public String getStartTimestampFormatted() {
        return DateFormat.getDateTimeInstance().format(new Date(this.startTime));
    }

    @Override
    public long getUpTime() {
        return U.currentTimeMillis() - this.startTime;
    }

    @Override
    public String getUpTimeFormatted() {
        return X.timeSpan2HMSM(U.currentTimeMillis() - this.startTime);
    }

    @Override
    public String getFullVersion() {
        return IgniteVersionUtils.VER_STR + '-' + IgniteVersionUtils.BUILD_TSTAMP_STR;
    }

    @Override
    public String getCheckpointSpiFormatted() {
        assert (this.cfg != null);
        return Arrays.toString(this.cfg.getCheckpointSpi());
    }

    @Override
    public String getSwapSpaceSpiFormatted() {
        assert (this.cfg != null);
        return this.cfg.getSwapSpaceSpi().toString();
    }

    @Override
    public String getCommunicationSpiFormatted() {
        assert (this.cfg != null);
        return this.cfg.getCommunicationSpi().toString();
    }

    @Override
    public String getDeploymentSpiFormatted() {
        assert (this.cfg != null);
        return this.cfg.getDeploymentSpi().toString();
    }

    @Override
    public String getDiscoverySpiFormatted() {
        assert (this.cfg != null);
        return this.cfg.getDiscoverySpi().toString();
    }

    @Override
    public String getEventStorageSpiFormatted() {
        assert (this.cfg != null);
        return this.cfg.getEventStorageSpi().toString();
    }

    @Override
    public String getCollisionSpiFormatted() {
        assert (this.cfg != null);
        return this.cfg.getCollisionSpi().toString();
    }

    @Override
    public String getFailoverSpiFormatted() {
        assert (this.cfg != null);
        return Arrays.toString(this.cfg.getFailoverSpi());
    }

    @Override
    public String getLoadBalancingSpiFormatted() {
        assert (this.cfg != null);
        return Arrays.toString(this.cfg.getLoadBalancingSpi());
    }

    @Override
    public String getOsInformation() {
        return U.osString();
    }

    @Override
    public String getJdkInformation() {
        return U.jdkString();
    }

    @Override
    public String getOsUser() {
        return System.getProperty("user.name");
    }

    @Override
    public void printLastErrors() {
        this.ctx.exceptionRegistry().printErrors(this.log);
    }

    @Override
    public String getVmName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    @Override
    public String getInstanceName() {
        return this.gridName;
    }

    @Override
    public String getExecutorServiceFormatted() {
        assert (this.cfg != null);
        return String.valueOf(this.cfg.getPublicThreadPoolSize());
    }

    @Override
    public String getIgniteHome() {
        assert (this.cfg != null);
        return this.cfg.getIgniteHome();
    }

    @Override
    public String getGridLoggerFormatted() {
        assert (this.cfg != null);
        return this.cfg.getGridLogger().toString();
    }

    @Override
    public String getMBeanServerFormatted() {
        assert (this.cfg != null);
        return this.cfg.getMBeanServer().toString();
    }

    @Override
    public UUID getLocalNodeId() {
        assert (this.cfg != null);
        return this.cfg.getNodeId();
    }

    @Override
    public List<String> getUserAttributesFormatted() {
        assert (this.cfg != null);
        return (List)F.transform(this.cfg.getUserAttributes().entrySet(), new C1<Map.Entry<String, ?>, String>(){

            @Override
            public String apply(Map.Entry<String, ?> e) {
                return e.getKey() + ", " + e.getValue().toString();
            }
        });
    }

    @Override
    public boolean isPeerClassLoadingEnabled() {
        assert (this.cfg != null);
        return this.cfg.isPeerClassLoadingEnabled();
    }

    @Override
    public List<String> getLifecycleBeansFormatted() {
        LifecycleBean[] beans = this.cfg.getLifecycleBeans();
        if (F.isEmpty(beans)) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>(beans.length);
        for (LifecycleBean bean : beans) {
            res.add(String.valueOf(bean));
        }
        return res;
    }

    private void add(String name, @Nullable Serializable val) throws IgniteCheckedException {
        assert (name != null);
        if (this.ctx.addNodeAttribute(name, val) != null) {
            if (name.endsWith("org.apache.ignite.spi.class")) {
                throw new IgniteCheckedException("Failed to set SPI attribute. Duplicated SPI name found: " + name.substring(0, name.length() - "org.apache.ignite.spi.class".length()));
            }
            assert (false) : "Duplicate attribute: " + name;
        }
    }

    private void notifyLifecycleBeans(LifecycleEventType evt) throws IgniteCheckedException {
        if (!this.cfg.isDaemon() && this.cfg.getLifecycleBeans() != null) {
            for (LifecycleBean bean : this.cfg.getLifecycleBeans()) {
                if (bean == null) continue;
                try {
                    bean.onLifecycleEvent(evt);
                }
                catch (Exception e) {
                    throw new IgniteCheckedException(e);
                }
            }
        }
    }

    private void notifyLifecycleBeansEx(LifecycleEventType evt) {
        block2: {
            try {
                this.notifyLifecycleBeans(evt);
            }
            catch (Throwable e) {
                U.error(this.log, "Failed to notify lifecycle bean (safely ignored) [evt=" + (Object)((Object)evt) + (this.gridName == null ? "" : ", gridName=" + this.gridName) + ']', e);
                if (!(e instanceof Error)) break block2;
                throw (Error)e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(IgniteConfiguration cfg, ExecutorService utilityCachePool, ExecutorService marshCachePool, final ExecutorService execSvc, final ExecutorService sysExecSvc, final StripedExecutor stripedExecSvc, ExecutorService p2pExecSvc, ExecutorService mgmtExecSvc, ExecutorService igfsExecSvc, ExecutorService restExecSvc, ExecutorService affExecSvc, @Nullable ExecutorService idxExecSvc, IgniteStripedThreadPoolExecutor callbackExecSvc, GridAbsClosure errHnd) throws IgniteCheckedException {
        long longOpDumpTimeout;
        long metricsLogFreq;
        boolean starveCheck;
        this.gw.compareAndSet(null, new GridKernalGatewayImpl(cfg.getGridName()));
        GridKernalGateway gw = this.gw.get();
        gw.writeLock();
        try {
            switch (gw.getState()) {
                case STARTED: {
                    U.warn(this.log, "Grid has already been started (ignored).");
                    return;
                }
                case STARTING: {
                    U.warn(this.log, "Grid is already in process of being started (ignored).");
                    return;
                }
                case STOPPING: {
                    throw new IgniteCheckedException("Grid is in process of being stopped");
                }
            }
            gw.setState(GridKernalState.STARTING);
        }
        finally {
            gw.writeUnlock();
        }
        assert (cfg != null);
        this.validateCommon(cfg);
        this.gridName = cfg.getGridName();
        this.cfg = cfg;
        this.log = (GridLoggerProxy)cfg.getGridLogger().getLogger(this.getClass().getName() + (this.gridName != null ? '%' + this.gridName : ""));
        RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();
        this.ackAsciiLogo();
        this.ackConfigUrl();
        this.ackDaemon();
        this.ackOsInfo();
        this.ackLanguageRuntime();
        this.ackRemoteManagement();
        this.ackVmArguments(rtBean);
        this.ackClassPaths(rtBean);
        this.ackSystemProperties();
        this.ackEnvironmentVariables();
        this.ackCacheConfiguration();
        this.ackP2pConfiguration();
        this.ackRebalanceConfiguration();
        GridDiagnostic.runBackgroundCheck(this.gridName, execSvc, this.log);
        if (this.log.isInfoEnabled() && cfg.getIgniteHome() != null) {
            this.log.info("3-rd party licenses can be found at: " + cfg.getIgniteHome() + File.separatorChar + "libs" + File.separatorChar + "licenses");
        }
        for (String name : cfg.getUserAttributes().keySet()) {
            if (!name.startsWith("org.apache.ignite")) continue;
            throw new IgniteCheckedException("User attribute has illegal name: '" + name + "'. Note that all names " + "starting with '" + "org.apache.ignite" + "' are reserved for internal use.");
        }
        this.logNodeUserAttributes();
        this.ackSpis();
        List<PluginProvider> plugins = U.allPluginProviders();
        try {
            this.ctx = new GridKernalContextImpl(this.log, this, cfg, gw, utilityCachePool, marshCachePool, execSvc, sysExecSvc, stripedExecSvc, p2pExecSvc, mgmtExecSvc, igfsExecSvc, restExecSvc, affExecSvc, idxExecSvc, callbackExecSvc, plugins);
            cfg.getMarshaller().setContext(this.ctx.marshallerContext());
            ClusterProcessor clusterProc = new ClusterProcessor(this.ctx);
            this.startProcessor(clusterProc);
            U.onGridStart();
            GridResourceProcessor rsrcProc = new GridResourceProcessor(this.ctx);
            rsrcProc.setSpringContext(this.rsrcCtx);
            this.scheduler = new IgniteSchedulerImpl(this.ctx);
            this.startProcessor(rsrcProc);
            if (!cfg.isDaemon() && cfg.getLifecycleBeans() != null) {
                for (LifecycleBean bean : cfg.getLifecycleBeans()) {
                    if (bean == null) continue;
                    rsrcProc.inject(bean);
                }
            }
            this.notifyLifecycleBeans(LifecycleEventType.BEFORE_NODE_START);
            U.startLifecycleAware(this.lifecycleAwares(cfg));
            this.addHelper(IgniteComponentType.IGFS_HELPER.create(F.isEmpty(cfg.getFileSystemConfiguration())));
            this.addHelper(IgniteComponentType.HADOOP_HELPER.createIfInClassPath(this.ctx, false));
            this.startProcessor(new IgnitePluginProcessor(this.ctx, cfg, plugins));
            this.startProcessor(new PoolProcessor(this.ctx));
            this.startProcessor(new GridOffHeapProcessor(this.ctx));
            this.startProcessor(new GridClosureProcessor(this.ctx));
            this.startProcessor(new GridPortProcessor(this.ctx));
            this.startProcessor(new GridJobMetricsProcessor(this.ctx));
            this.startProcessor(new GridTimeoutProcessor(this.ctx));
            this.startProcessor(IgniteKernal.createComponent(GridSecurityProcessor.class, this.ctx));
            this.startManager(new GridIoManager(this.ctx));
            this.startManager(new GridCheckpointManager(this.ctx));
            this.startManager(new GridEventStorageManager(this.ctx));
            this.startManager(new GridDeploymentManager(this.ctx));
            this.startManager(new GridLoadBalancerManager(this.ctx));
            this.startManager(new GridFailoverManager(this.ctx));
            this.startManager(new GridCollisionManager(this.ctx));
            this.startManager(new GridSwapSpaceManager(this.ctx));
            this.startManager(new GridIndexingManager(this.ctx));
            this.ackSecurity();
            GridDiscoveryManager discoMgr = new GridDiscoveryManager(this.ctx);
            this.ctx.add(discoMgr, false);
            this.startProcessor(IgniteKernal.createComponent(DiscoveryNodeValidationProcessor.class, this.ctx));
            this.startProcessor(new GridClockSyncProcessor(this.ctx));
            this.startProcessor(new GridAffinityProcessor(this.ctx));
            this.startProcessor(IgniteKernal.createComponent(GridSegmentationProcessor.class, this.ctx));
            this.startProcessor(IgniteKernal.createComponent(IgniteCacheObjectProcessor.class, this.ctx));
            this.startProcessor(new GridCacheProcessor(this.ctx));
            this.startProcessor(new GridQueryProcessor(this.ctx));
            this.startProcessor(new OdbcProcessor(this.ctx));
            this.startProcessor(new GridServiceProcessor(this.ctx));
            this.startProcessor(new GridTaskSessionProcessor(this.ctx));
            this.startProcessor(new GridJobProcessor(this.ctx));
            this.startProcessor(new GridTaskProcessor(this.ctx));
            this.startProcessor((GridProcessor)IgniteComponentType.SCHEDULE.createOptional(this.ctx));
            this.startProcessor(new GridRestProcessor(this.ctx));
            this.startProcessor(new DataStreamProcessor(this.ctx));
            this.startProcessor((GridProcessor)IgniteComponentType.IGFS.create(this.ctx, F.isEmpty(cfg.getFileSystemConfiguration())));
            this.startProcessor(new GridContinuousProcessor(this.ctx));
            this.startProcessor(this.createHadoopComponent());
            this.startProcessor(new DataStructuresProcessor(this.ctx));
            this.startProcessor(IgniteKernal.createComponent(PlatformProcessor.class, this.ctx));
            for (PluginProvider provider : this.ctx.plugins().allProviders()) {
                this.ctx.add(new GridPluginComponent(provider));
                provider.start((PluginContext)this.ctx.plugins().pluginContextForProvider(provider));
            }
            this.fillNodeAttributes(clusterProc.updateNotifierEnabled());
            gw.writeLock();
            try {
                gw.setState(GridKernalState.STARTED);
                this.startManager(discoMgr);
            }
            finally {
                gw.writeUnlock();
            }
            this.checkPhysicalRam();
            this.suggestOptimizations(cfg);
            this.ctx.performance().addAll(JvmConfigurationSuggestions.getSuggestions());
            this.ctx.performance().addAll(OsConfigurationSuggestions.getSuggestions());
            this.ctx.discovery().onKernalStart();
            this.ctx.io().onKernalStart();
            for (GridComponent comp : this.ctx) {
                if (comp instanceof GridDiscoveryManager || comp instanceof GridIoManager || this.skipDaemon(comp)) continue;
                comp.onKernalStart();
            }
            this.registerKernalMBean();
            this.registerLocalNodeMBean();
            this.registerExecutorMBeans(execSvc, sysExecSvc, p2pExecSvc, mgmtExecSvc, restExecSvc);
            this.notifyLifecycleBeans(LifecycleEventType.AFTER_NODE_START);
        }
        catch (Throwable e) {
            IgniteSpiVersionCheckException verCheckErr = X.cause(e, IgniteSpiVersionCheckException.class);
            if (verCheckErr != null) {
                U.error(this.log, verCheckErr.getMessage());
            } else if (X.hasCause(e, InterruptedException.class, IgniteInterruptedCheckedException.class)) {
                U.warn(this.log, "Grid startup routine has been interrupted (will rollback).");
            } else {
                U.error(this.log, "Got exception while starting (will rollback startup routine).", e);
            }
            errHnd.apply();
            this.stop(true);
            if (e instanceof Error) {
                throw e;
            }
            if (e instanceof IgniteCheckedException) {
                throw (IgniteCheckedException)e;
            }
            throw new IgniteCheckedException(e);
        }
        this.startTime = U.currentTimeMillis();
        String intervalStr = IgniteSystemProperties.getString("IGNITE_STARVATION_CHECK_INTERVAL");
        boolean bl = starveCheck = !this.isDaemon() && !"0".equals(intervalStr);
        if (starveCheck) {
            final long interval = F.isEmpty(intervalStr) ? 30000L : Long.parseLong(intervalStr);
            this.starveTask = this.ctx.timeout().schedule(new Runnable(){
                private long lastCompletedCntPub;
                private long lastCompletedCntSys;

                @Override
                public void run() {
                    ThreadPoolExecutor exec;
                    if (execSvc instanceof ThreadPoolExecutor) {
                        exec = (ThreadPoolExecutor)execSvc;
                        this.lastCompletedCntPub = this.checkPoolStarvation(exec, this.lastCompletedCntPub, "public");
                    }
                    if (sysExecSvc instanceof ThreadPoolExecutor) {
                        exec = (ThreadPoolExecutor)sysExecSvc;
                        this.lastCompletedCntSys = this.checkPoolStarvation(exec, this.lastCompletedCntSys, "system");
                    }
                    if (stripedExecSvc != null) {
                        stripedExecSvc.checkStarvation();
                    }
                }

                private long checkPoolStarvation(ThreadPoolExecutor exec, long lastCompletedCnt, String pool) {
                    long completedCnt = exec.getCompletedTaskCount();
                    if (exec.getPoolSize() == exec.getActiveCount() && completedCnt == lastCompletedCnt && !exec.getQueue().isEmpty()) {
                        LT.warn(IgniteKernal.this.log, "Possible thread pool starvation detected (no task completed in last " + interval + "ms, is " + pool + " thread pool size large enough?)");
                    }
                    return completedCnt;
                }
            }, interval, interval);
        }
        if ((metricsLogFreq = cfg.getMetricsLogFrequency()) > 0L) {
            this.metricsLogTask = this.ctx.timeout().schedule(new Runnable(){
                private final DecimalFormat dblFmt = new DecimalFormat("#.##");

                @Override
                public void run() {
                    if (IgniteKernal.this.log.isInfoEnabled()) {
                        try {
                            ClusterMetrics m = IgniteKernal.this.cluster().localNode().metrics();
                            double cpuLoadPct = m.getCurrentCpuLoad() * 100.0;
                            double avgCpuLoadPct = m.getAverageCpuLoad() * 100.0;
                            double gcPct = m.getCurrentGcCpuLoad() * 100.0;
                            long heapUsed = m.getHeapMemoryUsed();
                            long heapMax = m.getHeapMemoryMaximum();
                            long heapUsedInMBytes = heapUsed / 1024L / 1024L;
                            long heapCommInMBytes = m.getHeapMemoryCommitted() / 1024L / 1024L;
                            double freeHeapPct = heapMax > 0L ? (double)((heapMax - heapUsed) * 100L) / (double)heapMax : -1.0;
                            long nonHeapUsed = m.getNonHeapMemoryUsed();
                            long nonHeapMax = m.getNonHeapMemoryMaximum();
                            long nonHeapUsedInMBytes = nonHeapUsed / 1024L / 1024L;
                            long nonHeapCommInMBytes = m.getNonHeapMemoryCommitted() / 1024L / 1024L;
                            double freeNonHeapPct = nonHeapMax > 0L ? (double)((nonHeapMax - nonHeapUsed) * 100L) / (double)nonHeapMax : -1.0;
                            int hosts = 0;
                            int nodes = 0;
                            int cpus = 0;
                            try {
                                ClusterMetrics metrics = IgniteKernal.this.cluster().metrics();
                                Collection<ClusterNode> nodes0 = IgniteKernal.this.cluster().nodes();
                                hosts = U.neighborhood(nodes0).size();
                                nodes = metrics.getTotalNodes();
                                cpus = metrics.getTotalCpus();
                            }
                            catch (IgniteException metrics) {
                                // empty catch block
                            }
                            int pubPoolActiveThreads = 0;
                            int pubPoolIdleThreads = 0;
                            int pubPoolQSize = 0;
                            if (execSvc instanceof ThreadPoolExecutor) {
                                ThreadPoolExecutor exec = (ThreadPoolExecutor)execSvc;
                                int poolSize = exec.getPoolSize();
                                pubPoolActiveThreads = Math.min(poolSize, exec.getActiveCount());
                                pubPoolIdleThreads = poolSize - pubPoolActiveThreads;
                                pubPoolQSize = exec.getQueue().size();
                            }
                            int sysPoolActiveThreads = 0;
                            int sysPoolIdleThreads = 0;
                            int sysPoolQSize = 0;
                            if (sysExecSvc instanceof ThreadPoolExecutor) {
                                ThreadPoolExecutor exec = (ThreadPoolExecutor)sysExecSvc;
                                int poolSize = exec.getPoolSize();
                                sysPoolActiveThreads = Math.min(poolSize, exec.getActiveCount());
                                sysPoolIdleThreads = poolSize - sysPoolActiveThreads;
                                sysPoolQSize = exec.getQueue().size();
                            }
                            String id = U.id8(IgniteKernal.this.localNode().id());
                            String msg = NL + "Metrics for local node (to disable set 'metricsLogFrequency' to 0)" + NL + "    ^-- Node [id=" + id + ", name=" + IgniteKernal.this.name() + ", uptime=" + IgniteKernal.this.getUpTimeFormatted() + "]" + NL + "    ^-- H/N/C [hosts=" + hosts + ", nodes=" + nodes + ", CPUs=" + cpus + "]" + NL + "    ^-- CPU [cur=" + this.dblFmt.format(cpuLoadPct) + "%, avg=" + this.dblFmt.format(avgCpuLoadPct) + "%, GC=" + this.dblFmt.format(gcPct) + "%]" + NL + "    ^-- Heap [used=" + this.dblFmt.format(heapUsedInMBytes) + "MB, free=" + this.dblFmt.format(freeHeapPct) + "%, comm=" + this.dblFmt.format(heapCommInMBytes) + "MB]" + NL + "    ^-- Non heap [used=" + this.dblFmt.format(nonHeapUsedInMBytes) + "MB, free=" + this.dblFmt.format(freeNonHeapPct) + "%, comm=" + this.dblFmt.format(nonHeapCommInMBytes) + "MB]" + NL + "    ^-- Public thread pool [active=" + pubPoolActiveThreads + ", idle=" + pubPoolIdleThreads + ", qSize=" + pubPoolQSize + "]" + NL + "    ^-- System thread pool [active=" + sysPoolActiveThreads + ", idle=" + sysPoolIdleThreads + ", qSize=" + sysPoolQSize + "]" + NL + "    ^-- Outbound messages queue [size=" + m.getOutboundMessagesQueueSize() + "]";
                            IgniteKernal.this.log.info(msg);
                        }
                        catch (IgniteClientDisconnectedException igniteClientDisconnectedException) {
                            // empty catch block
                        }
                    }
                }
            }, metricsLogFreq, metricsLogFreq);
        }
        if ((longOpDumpTimeout = IgniteSystemProperties.getLong("IGNITE_LONG_OPERATIONS_DUMP_TIMEOUT", 60000L)) > 0L) {
            this.longOpDumpTask = this.ctx.timeout().schedule(new Runnable(){

                @Override
                public void run() {
                    GridKernalContextImpl ctx = IgniteKernal.this.ctx;
                    if (ctx != null) {
                        ctx.cache().context().exchange().dumpLongRunningOperations(longOpDumpTimeout);
                    }
                }
            }, longOpDumpTimeout, longOpDumpTimeout);
        }
        this.ctx.performance().add("Disable assertions (remove '-ea' from JVM options)", !U.assertionsEnabled());
        this.ctx.performance().logSuggestions(this.log, this.gridName);
        U.quietAndInfo(this.log, "To start Console Management & Monitoring run ignitevisorcmd.{sh|bat}");
        this.ackStart(rtBean);
        if (!this.isDaemon()) {
            this.ctx.discovery().ackTopology(this.localNode().order());
        }
    }

    private HadoopProcessorAdapter createHadoopComponent() throws IgniteCheckedException {
        boolean mandatory;
        boolean bl = mandatory = this.cfg.getHadoopConfiguration() != null;
        if (mandatory) {
            if (this.cfg.isPeerClassLoadingEnabled()) {
                throw new IgniteCheckedException("Hadoop module cannot be used with peer class loading enabled (set IgniteConfiguration.peerClassLoadingEnabled to \"false\").");
            }
            HadoopProcessorAdapter res = (HadoopProcessorAdapter)IgniteComponentType.HADOOP.createIfInClassPath(this.ctx, true);
            res.validateEnvironment();
            return res;
        }
        HadoopProcessorAdapter cmp = null;
        if (!this.ctx.hadoopHelper().isNoOp() && this.cfg.isPeerClassLoadingEnabled()) {
            U.warn(this.log, "Hadoop module is found in classpath, but will not be started because peer class loading is enabled (set IgniteConfiguration.peerClassLoadingEnabled to \"false\" if you want to use Hadoop module).");
        } else {
            cmp = (HadoopProcessorAdapter)IgniteComponentType.HADOOP.createIfInClassPath(this.ctx, false);
            try {
                cmp.validateEnvironment();
            }
            catch (IgniteCheckedException | IgniteException e) {
                U.quietAndWarn(this.log, "Hadoop module will not start due to exception: " + e.getMessage());
                cmp = null;
            }
        }
        if (cmp == null) {
            cmp = (HadoopProcessorAdapter)IgniteComponentType.HADOOP.create(this.ctx, true);
        }
        return cmp;
    }

    private void validateCommon(IgniteConfiguration cfg) {
        A.notNull(cfg.getNodeId(), "cfg.getNodeId()");
        A.notNull(cfg.getMBeanServer(), "cfg.getMBeanServer()");
        A.notNull(cfg.getGridLogger(), "cfg.getGridLogger()");
        A.notNull(cfg.getMarshaller(), "cfg.getMarshaller()");
        A.notNull(cfg.getUserAttributes(), "cfg.getUserAttributes()");
        A.notNull(cfg.getSwapSpaceSpi(), "cfg.getSwapSpaceSpi()");
        A.notNull(cfg.getCheckpointSpi(), "cfg.getCheckpointSpi()");
        A.notNull(cfg.getCommunicationSpi(), "cfg.getCommunicationSpi()");
        A.notNull(cfg.getDeploymentSpi(), "cfg.getDeploymentSpi()");
        A.notNull(cfg.getDiscoverySpi(), "cfg.getDiscoverySpi()");
        A.notNull(cfg.getEventStorageSpi(), "cfg.getEventStorageSpi()");
        A.notNull(cfg.getCollisionSpi(), "cfg.getCollisionSpi()");
        A.notNull(cfg.getFailoverSpi(), "cfg.getFailoverSpi()");
        A.notNull(cfg.getLoadBalancingSpi(), "cfg.getLoadBalancingSpi()");
        A.notNull(cfg.getIndexingSpi(), "cfg.getIndexingSpi()");
        A.ensure(cfg.getNetworkTimeout() > 0L, "cfg.getNetworkTimeout() > 0");
        A.ensure(cfg.getNetworkSendRetryDelay() > 0L, "cfg.getNetworkSendRetryDelay() > 0");
        A.ensure(cfg.getNetworkSendRetryCount() > 0, "cfg.getNetworkSendRetryCount() > 0");
    }

    private void checkPhysicalRam() {
        long ram = (Long)this.ctx.discovery().localNode().attribute("org.apache.ignite.phy.ram");
        if (ram != -1L) {
            String macs = (String)this.ctx.discovery().localNode().attribute("org.apache.ignite.macs");
            long totalHeap = 0L;
            for (ClusterNode node : this.ctx.discovery().allNodes()) {
                long heap;
                if (!macs.equals(node.attribute("org.apache.ignite.macs")) || (heap = node.metrics().getHeapMemoryMaximum()) == -1L) continue;
                totalHeap += heap;
            }
            if (totalHeap > ram) {
                U.quietAndWarn(this.log, "Attempting to start more nodes than physical RAM available on current host (this can cause significant slowdown)");
            }
        }
    }

    private void suggestOptimizations(IgniteConfiguration cfg) {
        GridPerformanceSuggestions perf = this.ctx.performance();
        if (this.ctx.collision().enabled()) {
            perf.add("Disable collision resolution (remove 'collisionSpi' from configuration)");
        }
        if (this.ctx.checkpoint().enabled()) {
            perf.add("Disable checkpoints (remove 'checkpointSpi' from configuration)");
        }
        if (cfg.isMarshalLocalJobs()) {
            perf.add("Disable local jobs marshalling (set 'marshalLocalJobs' to false)");
        }
        if (cfg.getIncludeEventTypes() != null && cfg.getIncludeEventTypes().length != 0) {
            perf.add("Disable grid events (remove 'includeEventTypes' from configuration)");
        }
        if (BinaryMarshaller.available() && cfg.getMarshaller() != null && !(cfg.getMarshaller() instanceof BinaryMarshaller)) {
            perf.add("Use default binary marshaller (do not set 'marshaller' explicitly)");
        }
    }

    private void fillNodeAttributes(boolean notifyEnabled) throws IgniteCheckedException {
        String portStr;
        String[] incProps = this.cfg.getIncludeProperties();
        try {
            for (Map.Entry<String, String> sysEntry : System.getenv().entrySet()) {
                String name = sysEntry.getKey();
                if (incProps != null && !U.containsStringArray(incProps, name, true) && !U.isVisorNodeStartProperty(name) && !U.isVisorRequiredProperty(name)) continue;
                this.ctx.addNodeAttribute(name, sysEntry.getValue());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Added environment properties to node attributes.");
            }
        }
        catch (SecurityException e) {
            throw new IgniteCheckedException("Failed to add environment properties to node attributes due to security violation: " + e.getMessage());
        }
        try {
            for (Map.Entry<Object, Object> e : IgniteSystemProperties.snapshot().entrySet()) {
                String key = (String)e.getKey();
                if (incProps != null && !U.containsStringArray(incProps, key, true) && !U.isVisorRequiredProperty(key)) continue;
                Object val = this.ctx.nodeAttribute(key);
                if (val != null && !val.equals(e.getValue())) {
                    U.warn(this.log, "System property will override environment variable with the same name: " + key);
                }
                this.ctx.addNodeAttribute(key, e.getValue());
            }
            this.ctx.addNodeAttribute("org.apache.ignite.update.notifier.enabled", notifyEnabled);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Added system properties to node attributes.");
            }
        }
        catch (SecurityException e) {
            throw new IgniteCheckedException("Failed to add system properties to node attributes due to security violation: " + e.getMessage());
        }
        String ips = F.concat(U.allLocalIps(), ", ");
        String macs = F.concat(U.allLocalMACs(), ", ");
        if (this.log.isInfoEnabled()) {
            this.log.info("Non-loopback local IPs: " + (F.isEmpty(ips) ? "N/A" : ips));
            this.log.info("Enabled local MACs: " + (F.isEmpty(macs) ? "N/A" : macs));
        }
        if (ips.isEmpty() && macs.isEmpty()) {
            U.warn(this.log, "Ignite is starting on loopback address... Only nodes on the same physical computer can participate in topology.", "Ignite is starting on loopback address...");
        }
        this.add("org.apache.ignite.ips", (Serializable)((Object)(ips.isEmpty() ? "" : ips)));
        this.add("org.apache.ignite.macs", (Serializable)((Object)(macs.isEmpty() ? "" : macs)));
        this.add("org.apache.ignite.jit.name", (Serializable)((Object)(U.getCompilerMx() == null ? "" : U.getCompilerMx().getName())));
        this.add("org.apache.ignite.build.ver", (Serializable)((Object)IgniteVersionUtils.VER_STR));
        this.add("org.apache.ignite.build.date", (Serializable)((Object)IgniteVersionUtils.BUILD_TSTAMP_STR));
        this.add("org.apache.ignite.marshaller", (Serializable)((Object)this.cfg.getMarshaller().getClass().getName()));
        this.add("org.apache.ignite.marshaller.useDefaultSUID", Boolean.valueOf(IgniteSystemProperties.getBoolean("IGNITE_OPTIMIZED_MARSHALLER_USE_DEFAULT_SUID", OptimizedMarshaller.USE_DFLT_SUID)));
        this.add("org.apache.ignite.cache.lateAffinity", Boolean.valueOf(this.cfg.isLateAffinityAssignment()));
        if (this.cfg.getMarshaller() instanceof BinaryMarshaller) {
            this.add("org.apache.ignite.marshaller.compactFooter", Boolean.valueOf(this.cfg.getBinaryConfiguration() == null ? true : this.cfg.getBinaryConfiguration().isCompactFooter()));
            this.add("org.apache.ignite.marshaller.utf8SerializationVer2", Boolean.valueOf(IgniteSystemProperties.getBoolean("IGNITE_BINARY_MARSHALLER_USE_STRING_SERIALIZATION_VER_2", BinaryUtils.USE_STR_SERIALIZATION_VER_2)));
        }
        this.add("org.apache.ignite.user.name", (Serializable)((Object)System.getProperty("user.name")));
        this.add("org.apache.ignite.ignite.name", (Serializable)((Object)this.gridName));
        this.add("org.apache.ignite.peer.classloading.enabled", Boolean.valueOf(this.cfg.isPeerClassLoadingEnabled()));
        this.add("org.apache.ignite.ignite.dep.mode", (Serializable)((Object)this.cfg.getDeploymentMode()));
        this.add("org.apache.ignite.lang.rt", (Serializable)((Object)this.getLanguage()));
        this.add("org.apache.ignite.jvm.pid", Integer.valueOf(U.jvmPid()));
        this.add("org.apache.ignite.cache.client", this.cfg.isClientMode());
        this.add("org.apache.ignite.consistency.check.skipped", Boolean.valueOf(IgniteSystemProperties.getBoolean("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK")));
        if (this.cfg.getConsistentId() != null) {
            this.add("org.apache.ignite.consistent.id", this.cfg.getConsistentId());
        }
        SB jvmArgs = new SB(512);
        for (String string : U.jvmArgs()) {
            if (string.startsWith("-")) {
                jvmArgs.a("@@@");
            } else {
                jvmArgs.a(' ');
            }
            jvmArgs.a(string);
        }
        this.add("org.apache.ignite.jvm.args", (Serializable)((Object)jvmArgs.toString()));
        if (this.isDaemon()) {
            this.add("org.apache.ignite.daemon", (Serializable)((Object)"true"));
        }
        if (this.isJmxRemoteEnabled() && (portStr = System.getProperty("com.sun.management.jmxremote.port")) != null) {
            try {
                this.add("org.apache.ignite.jmx.port", Integer.valueOf(Integer.parseInt(portStr)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.add("org.apache.ignite.restart.enabled", (Serializable)((Object)Boolean.toString(this.isRestartEnabled())));
        if (this.cfg.getConnectorConfiguration() != null) {
            this.add("org.apache.ignite.rest.port.range", Integer.valueOf(this.cfg.getConnectorConfiguration().getPortRange()));
        }
        this.addSpiAttributes(this.cfg.getCollisionSpi());
        this.addSpiAttributes(this.cfg.getSwapSpaceSpi());
        this.addSpiAttributes(this.cfg.getDiscoverySpi());
        this.addSpiAttributes(this.cfg.getFailoverSpi());
        this.addSpiAttributes(this.cfg.getCommunicationSpi());
        this.addSpiAttributes(this.cfg.getEventStorageSpi());
        this.addSpiAttributes(this.cfg.getCheckpointSpi());
        this.addSpiAttributes(this.cfg.getLoadBalancingSpi());
        this.addSpiAttributes(this.cfg.getDeploymentSpi());
        if (this.cfg.getUserAttributes() != null) {
            for (Map.Entry entry : this.cfg.getUserAttributes().entrySet()) {
                if (this.ctx.hasNodeAttribute((String)entry.getKey())) {
                    U.warn(this.log, "User or internal attribute has the same name as environment or system property and will take precedence: " + (String)entry.getKey());
                }
                this.ctx.addNodeAttribute((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private void addSpiAttributes(IgniteSpi ... spiList) throws IgniteCheckedException {
        for (IgniteSpi spi : spiList) {
            Class<?> spiCls = spi.getClass();
            this.add(U.spiAttribute(spi, "org.apache.ignite.spi.class"), (Serializable)((Object)spiCls.getName()));
        }
    }

    private void registerKernalMBean() throws IgniteCheckedException {
        try {
            this.kernalMBean = U.registerMBean(this.cfg.getMBeanServer(), this.cfg.getGridName(), "Kernal", this.getClass().getSimpleName(), this, IgniteMXBean.class);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registered kernal MBean: " + this.kernalMBean);
            }
        }
        catch (JMException e) {
            this.kernalMBean = null;
            throw new IgniteCheckedException("Failed to register kernal MBean.", e);
        }
    }

    private void registerLocalNodeMBean() throws IgniteCheckedException {
        ClusterLocalNodeMetricsMXBeanImpl mbean = new ClusterLocalNodeMetricsMXBeanImpl(this.ctx.discovery().localNode());
        try {
            this.locNodeMBean = U.registerMBean(this.cfg.getMBeanServer(), this.cfg.getGridName(), "Kernal", mbean.getClass().getSimpleName(), mbean, ClusterLocalNodeMetricsMXBean.class);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registered local node MBean: " + this.locNodeMBean);
            }
        }
        catch (JMException e) {
            this.locNodeMBean = null;
            throw new IgniteCheckedException("Failed to register local node MBean.", e);
        }
    }

    private void registerExecutorMBeans(ExecutorService execSvc, ExecutorService sysExecSvc, ExecutorService p2pExecSvc, ExecutorService mgmtExecSvc, ExecutorService restExecSvc) throws IgniteCheckedException {
        this.pubExecSvcMBean = this.registerExecutorMBean(execSvc, "GridExecutionExecutor");
        this.sysExecSvcMBean = this.registerExecutorMBean(sysExecSvc, "GridSystemExecutor");
        this.mgmtExecSvcMBean = this.registerExecutorMBean(mgmtExecSvc, "GridManagementExecutor");
        this.p2PExecSvcMBean = this.registerExecutorMBean(p2pExecSvc, "GridClassLoadingExecutor");
        ConnectorConfiguration clientCfg = this.cfg.getConnectorConfiguration();
        if (clientCfg != null) {
            this.restExecSvcMBean = this.registerExecutorMBean(restExecSvc, "GridRestExecutor");
        }
    }

    private ObjectName registerExecutorMBean(ExecutorService exec, String name) throws IgniteCheckedException {
        assert (exec != null);
        try {
            ObjectName res = U.registerMBean(this.cfg.getMBeanServer(), this.cfg.getGridName(), "Thread Pools", name, new ThreadPoolMXBeanAdapter(exec), ThreadPoolMXBean.class);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registered executor service MBean: " + res);
            }
            return res;
        }
        catch (JMException e) {
            throw new IgniteCheckedException("Failed to register executor service MBean [name=" + name + ", exec=" + exec + ']', e);
        }
    }

    private boolean unregisterMBean(@Nullable ObjectName mbean) {
        if (mbean != null) {
            try {
                this.cfg.getMBeanServer().unregisterMBean(mbean);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Unregistered MBean: " + mbean);
                }
                return true;
            }
            catch (JMException e) {
                U.error(this.log, "Failed to unregister MBean.", e);
                return false;
            }
        }
        return true;
    }

    private void startManager(GridManager mgr) throws IgniteCheckedException {
        this.ctx.add(mgr);
        try {
            if (!this.skipDaemon(mgr)) {
                mgr.start();
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to start manager: " + mgr, e);
            throw new IgniteCheckedException("Failed to start manager: " + mgr, e);
        }
    }

    private void startProcessor(GridProcessor proc) throws IgniteCheckedException {
        this.ctx.add(proc);
        try {
            if (!this.skipDaemon(proc)) {
                proc.start();
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteCheckedException("Failed to start processor: " + proc, e);
        }
    }

    private void addHelper(Object helper) {
        this.ctx.addHelper(helper);
    }

    private String onOff(boolean b) {
        return b ? "on" : "off";
    }

    private boolean isRestEnabled() {
        assert (this.cfg != null);
        return this.cfg.getConnectorConfiguration() != null && (!this.isClientNode() || this.isClientNode() && IgniteSystemProperties.getBoolean("IGNITE_REST_START_ON_CLIENT"));
    }

    private boolean isClientNode() {
        return this.cfg.isClientMode() != false || this.cfg.isDaemon();
    }

    private void ackRemoteManagement() {
        assert (this.log != null);
        if (!this.log.isInfoEnabled()) {
            return;
        }
        SB sb = new SB();
        sb.a("Remote Management [");
        boolean on = this.isJmxRemoteEnabled();
        sb.a("restart: ").a(this.onOff(this.isRestartEnabled())).a(", ");
        sb.a("REST: ").a(this.onOff(this.isRestEnabled())).a(", ");
        sb.a("JMX (");
        sb.a("remote: ").a(this.onOff(on));
        if (on) {
            sb.a(", ");
            sb.a("port: ").a(System.getProperty("com.sun.management.jmxremote.port", "<n/a>")).a(", ");
            sb.a("auth: ").a(this.onOff(Boolean.getBoolean("com.sun.management.jmxremote.authenticate"))).a(", ");
            sb.a("ssl: ").a(this.onOff(Boolean.getBoolean("com.sun.management.jmxremote.ssl") || System.getProperty("com.sun.management.jmxremote.ssl") == null));
        }
        sb.a(")");
        sb.a(']');
        this.log.info(sb.toString());
    }

    private void ackConfigUrl() {
        assert (this.log != null);
        if (this.log.isInfoEnabled()) {
            this.log.info("Config URL: " + System.getProperty("IGNITE_CONFIG_URL", "n/a"));
        }
    }

    private void ackAsciiLogo() {
        assert (this.log != null);
        if (System.getProperty("IGNITE_NO_ASCII") == null) {
            String ver = "ver. " + IgniteVersionUtils.ACK_VER_STR;
            if (this.log.isInfoEnabled()) {
                this.log.info(NL + NL + ">>>    __________  ________________  " + NL + ">>>   /  _/ ___/ |/ /  _/_  __/ __/  " + NL + ">>>  _/ // (7 7    // /  / / / _/    " + NL + ">>> /___/\\___/_/|_/___/ /_/ /___/   " + NL + ">>> " + NL + ">>> " + ver + NL + ">>> " + "2017 Copyright(C) Apache Software Foundation" + NL + ">>> " + NL + ">>> Ignite documentation: " + "http://" + SITE + NL);
            }
            if (this.log.isQuiet()) {
                U.quiet(false, "   __________  ________________ ", "  /  _/ ___/ |/ /  _/_  __/ __/ ", " _/ // (7 7    // /  / / / _/   ", "/___/\\___/_/|_/___/ /_/ /___/  ", "", ver, "2017 Copyright(C) Apache Software Foundation", "", "Ignite documentation: http://ignite.apache.org", "", "Quiet mode.");
                String fileName = this.log.fileName();
                if (fileName != null) {
                    U.quiet(false, "  ^-- Logging to file '" + fileName + '\'');
                }
                U.quiet(false, "  ^-- To see **FULL** console log here add -DIGNITE_QUIET=false or \"-v\" to ignite.{sh|bat}", "");
            }
        }
    }

    private void ackStart(RuntimeMXBean rtBean) {
        ClusterNode locNode = this.localNode();
        if (this.log.isQuiet()) {
            U.quiet(false, "");
            U.quiet(false, "Ignite node started OK (id=" + U.id8(locNode.id()) + (F.isEmpty(this.gridName) ? "" : ", grid=" + this.gridName) + ')');
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("");
            String ack = "Ignite ver. " + IgniteVersionUtils.VER_STR + '#' + IgniteVersionUtils.BUILD_TSTAMP_STR + "-sha1:" + IgniteVersionUtils.REV_HASH_STR;
            String dash = U.dash(ack.length());
            SB sb = new SB();
            for (GridPortRecord rec : this.ctx.ports().records()) {
                sb.a((Object)rec.protocol()).a(":").a(rec.port()).a(" ");
            }
            String str = NL + NL + ">>> " + dash + NL + ">>> " + ack + NL + ">>> " + dash + NL + ">>> OS name: " + U.osString() + NL + ">>> CPU(s): " + locNode.metrics().getTotalCpus() + NL + ">>> Heap: " + U.heapSize(locNode, 2) + "GB" + NL + ">>> VM name: " + rtBean.getName() + NL + (this.gridName == null ? "" : ">>> Grid name: " + this.gridName + NL) + ">>> Local node [" + "ID=" + locNode.id().toString().toUpperCase() + ", order=" + locNode.order() + ", clientMode=" + this.ctx.clientNode() + "]" + NL + ">>> Local node addresses: " + U.addressesAsString(locNode) + NL + ">>> Local ports: " + sb + NL;
            this.log.info(str);
        }
    }

    private void ackOsInfo() {
        assert (this.log != null);
        if (this.log.isQuiet()) {
            U.quiet(false, "OS: " + U.osString());
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("OS: " + U.osString());
            this.log.info("OS user: " + System.getProperty("user.name"));
            int jvmPid = U.jvmPid();
            this.log.info("PID: " + (jvmPid == -1 ? "N/A" : Integer.valueOf(jvmPid)));
        }
    }

    private void ackLanguageRuntime() {
        assert (this.log != null);
        if (this.log.isQuiet()) {
            U.quiet(false, "VM information: " + U.jdkString());
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Language runtime: " + this.getLanguage());
            this.log.info("VM information: " + U.jdkString());
            this.log.info("VM total memory: " + U.heapSize(2) + "GB");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLanguage() {
        boolean scala = false;
        boolean groovy = false;
        boolean clojure = false;
        for (StackTraceElement elem : Thread.currentThread().getStackTrace()) {
            String s = elem.getClassName().toLowerCase();
            if (s.contains("scala")) {
                scala = true;
                break;
            }
            if (s.contains("groovy")) {
                groovy = true;
                break;
            }
            if (!s.contains("clojure")) continue;
            clojure = true;
            break;
        }
        if (scala) {
            try (InputStream in = this.getClass().getResourceAsStream("/library.properties");){
                Properties props = new Properties();
                if (in != null) {
                    props.load(in);
                }
                String string = "Scala ver. " + props.getProperty("version.number", "<unknown>");
                return string;
            }
            catch (Exception ignore) {
                return "Scala ver. <unknown>";
            }
        }
        if (groovy) {
            return "Groovy";
        }
        if (clojure) {
            return "Clojure";
        }
        String string = U.jdkName() + " ver. " + U.jdkVersion();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean cancel) {
        boolean interrupted = Thread.interrupted();
        try {
            this.stop0(cancel);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isStopping() {
        return this.stopGuard.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop0(boolean cancel) {
        this.gw.compareAndSet(null, new GridKernalGatewayImpl(this.gridName));
        GridKernalGateway gw = this.gw.get();
        if (this.stopGuard.compareAndSet(false, true)) {
            boolean firstStop = false;
            GridKernalState state = gw.getState();
            if (state == GridKernalState.STARTED || state == GridKernalState.DISCONNECTED) {
                firstStop = true;
            } else if (state == GridKernalState.STARTING) {
                U.warn(this.log, "Attempt to stop starting grid. This operation cannot be guaranteed to be successful.");
            }
            if (firstStop) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Notifying lifecycle beans.");
                }
                this.notifyLifecycleBeansEx(LifecycleEventType.BEFORE_NODE_STOP);
            }
            List<GridComponent> comps = this.ctx.components();
            this.ctx.marshallerContext().onKernalStop();
            ListIterator<GridComponent> it = comps.listIterator(comps.size());
            while (it.hasPrevious()) {
                GridComponent comp = it.previous();
                try {
                    if (this.skipDaemon(comp)) continue;
                    comp.onKernalStop(cancel);
                }
                catch (Throwable e) {
                    this.errOnStop = true;
                    U.error(this.log, "Failed to pre-stop processor: " + comp, e);
                    if (!(e instanceof Error)) continue;
                    throw e;
                }
            }
            if (this.starveTask != null) {
                this.starveTask.close();
            }
            if (this.metricsLogTask != null) {
                this.metricsLogTask.close();
            }
            if (this.longOpDumpTask != null) {
                this.longOpDumpTask.close();
            }
            boolean interrupted = false;
            while (true) {
                try {
                    while (!gw.tryWriteLock(10L)) {
                    }
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            try {
                assert (gw.getState() == GridKernalState.STARTED || gw.getState() == GridKernalState.STARTING || gw.getState() == GridKernalState.DISCONNECTED);
                gw.setState(GridKernalState.STOPPING);
                this.ctx.cluster().get().clearNodeMap();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Grid " + (this.gridName == null ? "" : '\'' + this.gridName + "' ") + "is stopping.");
                }
            }
            finally {
                gw.writeUnlock();
            }
            GridCacheProcessor cache = this.ctx.cache();
            if (cache != null) {
                cache.blockGateways();
            }
            if (!(this.unregisterMBean(this.pubExecSvcMBean) & this.unregisterMBean(this.sysExecSvcMBean) & this.unregisterMBean(this.mgmtExecSvcMBean) & this.unregisterMBean(this.p2PExecSvcMBean) & this.unregisterMBean(this.kernalMBean) & this.unregisterMBean(this.locNodeMBean) & this.unregisterMBean(this.restExecSvcMBean))) {
                this.errOnStop = false;
            }
            ListIterator<GridComponent> it2 = comps.listIterator(comps.size());
            while (it2.hasPrevious()) {
                GridComponent comp = it2.previous();
                try {
                    if (this.skipDaemon(comp)) continue;
                    comp.stop(cancel);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Component stopped: " + comp);
                }
                catch (Throwable e) {
                    this.errOnStop = true;
                    U.error(this.log, "Failed to stop component (ignoring): " + comp, e);
                    if (!(e instanceof Error)) continue;
                    throw (Error)e;
                }
            }
            U.stopLifecycleAware(this.log, this.lifecycleAwares(this.cfg));
            this.notifyLifecycleBeansEx(LifecycleEventType.AFTER_NODE_STOP);
            U.clearClassCache();
            MarshallerExclusions.clearCache();
            BinaryEnumCache.clear();
            gw.writeLock();
            try {
                gw.setState(GridKernalState.STOPPED);
            }
            finally {
                gw.writeUnlock();
            }
            if (this.log.isQuiet()) {
                String nodeName;
                String string = nodeName = this.gridName == null ? "" : "name=" + this.gridName + ", ";
                if (!this.errOnStop) {
                    U.quiet(false, "Ignite node stopped OK [" + nodeName + "uptime=" + X.timeSpan2HMSM(U.currentTimeMillis() - this.startTime) + ']');
                } else {
                    U.quiet(true, "Ignite node stopped wih ERRORS [" + nodeName + "uptime=" + X.timeSpan2HMSM(U.currentTimeMillis() - this.startTime) + ']');
                }
            }
            if (this.log.isInfoEnabled()) {
                String dash;
                String ack;
                if (!this.errOnStop) {
                    ack = "Ignite ver. " + IgniteVersionUtils.VER_STR + '#' + IgniteVersionUtils.BUILD_TSTAMP_STR + "-sha1:" + IgniteVersionUtils.REV_HASH_STR + " stopped OK";
                    dash = U.dash(ack.length());
                    this.log.info(NL + NL + ">>> " + dash + NL + ">>> " + ack + NL + ">>> " + dash + NL + (this.gridName == null ? "" : ">>> Grid name: " + this.gridName + NL) + ">>> Grid uptime: " + X.timeSpan2HMSM(U.currentTimeMillis() - this.startTime) + NL + NL);
                } else {
                    ack = "Ignite ver. " + IgniteVersionUtils.VER_STR + '#' + IgniteVersionUtils.BUILD_TSTAMP_STR + "-sha1:" + IgniteVersionUtils.REV_HASH_STR + " stopped with ERRORS";
                    dash = U.dash(ack.length());
                    this.log.info(NL + NL + ">>> " + ack + NL + ">>> " + dash + NL + (this.gridName == null ? "" : ">>> Grid name: " + this.gridName + NL) + ">>> Grid uptime: " + X.timeSpan2HMSM(U.currentTimeMillis() - this.startTime) + NL + ">>> See log above for detailed error message." + NL + ">>> Note that some errors during stop can prevent grid from" + NL + ">>> maintaining correct topology since this node may have" + NL + ">>> not exited grid properly." + NL + NL);
                }
            }
            try {
                U.onGridStop();
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        } else if (this.log.isDebugEnabled()) {
            if (gw.getState() == GridKernalState.STOPPED) {
                this.log.debug("Grid is already stopped. Nothing to do.");
            } else {
                this.log.debug("Grid is being stopped by another thread. Aborting this stop sequence allowing other thread to finish.");
            }
        }
    }

    public <K, V> GridCacheAdapter<K, V> internalCache() {
        return this.internalCache(null);
    }

    public <K, V> GridCacheAdapter<K, V> internalCache(@Nullable String name) {
        return this.ctx.cache().internalCache(name);
    }

    @Override
    public GridKernalContext context() {
        return this.ctx;
    }

    private void ackSystemProperties() {
        assert (this.log != null);
        if (this.log.isDebugEnabled()) {
            for (Map.Entry<Object, Object> entry : IgniteSystemProperties.snapshot().entrySet()) {
                this.log.debug("System property [" + entry.getKey() + '=' + entry.getValue() + ']');
            }
        }
    }

    private void logNodeUserAttributes() {
        assert (this.log != null);
        if (this.log.isInfoEnabled()) {
            for (Map.Entry<String, ?> attr : this.cfg.getUserAttributes().entrySet()) {
                this.log.info("Local node user attribute [" + attr.getKey() + '=' + attr.getValue() + ']');
            }
        }
    }

    private void ackEnvironmentVariables() {
        assert (this.log != null);
        if (this.log.isDebugEnabled()) {
            for (Map.Entry<String, String> envVar : System.getenv().entrySet()) {
                this.log.debug("Environment variable [" + envVar.getKey() + '=' + envVar.getValue() + ']');
            }
        }
    }

    private void ackDaemon() {
        assert (this.log != null);
        if (this.log.isInfoEnabled()) {
            this.log.info("Daemon mode: " + (this.isDaemon() ? "on" : "off"));
        }
    }

    private boolean isDaemon() {
        assert (this.cfg != null);
        return this.cfg.isDaemon() || "true".equalsIgnoreCase(System.getProperty("IGNITE_DAEMON"));
    }

    @Override
    public boolean isJmxRemoteEnabled() {
        return System.getProperty("com.sun.management.jmxremote") != null;
    }

    @Override
    public boolean isRestartEnabled() {
        return System.getProperty("IGNITE_SUCCESS_FILE") != null;
    }

    private void ackSpis() {
        assert (this.log != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("+-------------+");
            this.log.debug("START SPI LIST:");
            this.log.debug("+-------------+");
            this.log.debug("Grid checkpoint SPI     : " + Arrays.toString(this.cfg.getCheckpointSpi()));
            this.log.debug("Grid collision SPI      : " + this.cfg.getCollisionSpi());
            this.log.debug("Grid communication SPI  : " + this.cfg.getCommunicationSpi());
            this.log.debug("Grid deployment SPI     : " + this.cfg.getDeploymentSpi());
            this.log.debug("Grid discovery SPI      : " + this.cfg.getDiscoverySpi());
            this.log.debug("Grid event storage SPI  : " + this.cfg.getEventStorageSpi());
            this.log.debug("Grid failover SPI       : " + Arrays.toString(this.cfg.getFailoverSpi()));
            this.log.debug("Grid load balancing SPI : " + Arrays.toString(this.cfg.getLoadBalancingSpi()));
            this.log.debug("Grid swap space SPI     : " + this.cfg.getSwapSpaceSpi());
        }
    }

    private void ackRebalanceConfiguration() throws IgniteCheckedException {
        if (this.cfg.getSystemThreadPoolSize() <= this.cfg.getRebalanceThreadPoolSize()) {
            throw new IgniteCheckedException("Rebalance thread pool size exceed or equals System thread pool size. Change IgniteConfiguration.rebalanceThreadPoolSize property before next start.");
        }
        if (this.cfg.getRebalanceThreadPoolSize() < 1) {
            throw new IgniteCheckedException("Rebalance thread pool size minimal allowed value is 1. Change IgniteConfiguration.rebalanceThreadPoolSize property before next start.");
        }
        for (CacheConfiguration ccfg : this.cfg.getCacheConfiguration()) {
            if (ccfg.getRebalanceBatchesPrefetchCount() >= 1L) continue;
            throw new IgniteCheckedException("Rebalance batches prefetch count minimal allowed value is 1. Change CacheConfiguration.rebalanceBatchesPrefetchCount property before next start. [cache=" + ccfg.getName() + "]");
        }
    }

    private void ackCacheConfiguration() {
        CacheConfiguration[] cacheCfgs = this.cfg.getCacheConfiguration();
        if (cacheCfgs == null || cacheCfgs.length == 0) {
            U.warn(this.log, "Cache is not configured - in-memory data grid is off.");
        } else {
            SB sb = new SB();
            for (CacheConfiguration c : cacheCfgs) {
                String name = U.maskName(c.getName());
                sb.a("'").a(name).a("', ");
            }
            String names = sb.toString();
            U.log(this.log, "Configured caches [" + names.substring(0, names.length() - 2) + ']');
        }
    }

    private void ackP2pConfiguration() {
        assert (this.cfg != null);
        if (this.cfg.isPeerClassLoadingEnabled()) {
            U.warn(this.log, "Peer class loading is enabled (disable it in production for performance and deployment consistency reasons)", "Peer class loading is enabled (disable it for better performance)");
        }
    }

    private void ackSecurity() {
        assert (this.log != null);
        U.quietAndInfo(this.log, "Security status [authentication=" + this.onOff(this.ctx.security().enabled()) + ", tls/ssl=" + this.onOff(this.ctx.config().getSslContextFactory() != null) + ']');
    }

    private void ackVmArguments(RuntimeMXBean rtBean) {
        assert (this.log != null);
        if (this.log.isInfoEnabled()) {
            this.log.info("IGNITE_HOME=" + this.cfg.getIgniteHome());
            this.log.info("VM arguments: " + rtBean.getInputArguments());
        }
    }

    private void ackClassPaths(RuntimeMXBean rtBean) {
        assert (this.log != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Boot class path: " + rtBean.getBootClassPath());
            this.log.debug("Class path: " + rtBean.getClassPath());
            this.log.debug("Library path: " + rtBean.getLibraryPath());
        }
    }

    private Iterable<Object> lifecycleAwares(IgniteConfiguration cfg) {
        ArrayList<Object> objs = new ArrayList<Object>();
        if (cfg.getLifecycleBeans() != null) {
            Collections.addAll(objs, cfg.getLifecycleBeans());
        }
        if (cfg.getSegmentationResolvers() != null) {
            Collections.addAll(objs, cfg.getSegmentationResolvers());
        }
        if (cfg.getConnectorConfiguration() != null) {
            objs.add(cfg.getConnectorConfiguration().getMessageInterceptor());
            objs.add(cfg.getConnectorConfiguration().getSslContextFactory());
        }
        objs.add(cfg.getMarshaller());
        objs.add(cfg.getGridLogger());
        objs.add(cfg.getMBeanServer());
        return objs;
    }

    @Override
    public IgniteConfiguration configuration() {
        return this.cfg;
    }

    @Override
    public IgniteLogger log() {
        return this.cfg.getGridLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeCheckpoint(String key) {
        A.notNull(key, "key");
        this.guard();
        try {
            boolean bl = this.ctx.checkpoint().removeCheckpoint(key);
            return bl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public boolean pingNode(String nodeId) {
        A.notNull(nodeId, "nodeId");
        return this.cluster().pingNode(UUID.fromString(nodeId));
    }

    @Override
    public void undeployTaskFromGrid(String taskName) throws JMException {
        A.notNull(taskName, "taskName");
        try {
            this.compute().undeployTask(taskName);
        }
        catch (IgniteException e) {
            throw U.jmException(e);
        }
    }

    @Override
    public String executeTask(String taskName, String arg) throws JMException {
        try {
            return (String)this.compute().execute(taskName, arg);
        }
        catch (IgniteException e) {
            throw U.jmException(e);
        }
    }

    @Override
    public boolean pingNodeByAddress(String host) {
        this.guard();
        try {
            for (ClusterNode n : this.cluster().nodes()) {
                if (!n.addresses().contains(host)) continue;
                boolean bl = this.ctx.discovery().pingNode(n.id());
                return bl;
            }
            boolean i$ = false;
            return i$;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean eventUserRecordable(int type) {
        this.guard();
        try {
            boolean bl = this.ctx.event().isUserRecordable(type);
            return bl;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allEventsUserRecordable(int[] types) {
        A.notNull(types, "types");
        this.guard();
        try {
            boolean bl = this.ctx.event().isAllUserRecordable(types);
            return bl;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteTransactions transactions() {
        this.guard();
        try {
            IgniteTransactionsEx igniteTransactionsEx = this.ctx.cache().transactions();
            return igniteTransactionsEx;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> IgniteInternalCache<K, V> getCache(@Nullable String name) {
        this.guard();
        try {
            IgniteInternalCache igniteInternalCache = this.ctx.cache().publicCache(name);
            return igniteInternalCache;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> cache(@Nullable String name) {
        this.guard();
        try {
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(name, false, true);
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> createCache(CacheConfiguration<K, V> cacheCfg) {
        A.notNull(cacheCfg, "cacheCfg");
        this.guard();
        try {
            this.ctx.cache().dynamicStartCache(cacheCfg, cacheCfg.getName(), null, true, true, true).get();
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(cacheCfg.getName());
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<IgniteCache> createCaches(Collection<CacheConfiguration> cacheCfgs) {
        A.notNull(cacheCfgs, "cacheCfgs");
        this.guard();
        try {
            this.ctx.cache().dynamicStartCaches(cacheCfgs, true, true).get();
            ArrayList<IgniteCache> createdCaches = new ArrayList<IgniteCache>(cacheCfgs.size());
            for (CacheConfiguration cacheCfg : cacheCfgs) {
                createdCaches.add(this.ctx.cache().publicJCache(cacheCfg.getName()));
            }
            ArrayList<IgniteCache> arrayList = createdCaches;
            return arrayList;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> createCache(String cacheName) {
        this.guard();
        try {
            this.ctx.cache().createFromTemplate(cacheName).get();
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(cacheName);
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> getOrCreateCache(CacheConfiguration<K, V> cacheCfg) {
        A.notNull(cacheCfg, "cacheCfg");
        this.guard();
        try {
            if (this.ctx.cache().cache(cacheCfg.getName()) == null) {
                this.ctx.cache().dynamicStartCache(cacheCfg, cacheCfg.getName(), null, false, true, true).get();
            }
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(cacheCfg.getName());
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<IgniteCache> getOrCreateCaches(Collection<CacheConfiguration> cacheCfgs) {
        A.notNull(cacheCfgs, "cacheCfgs");
        this.guard();
        try {
            this.ctx.cache().dynamicStartCaches(cacheCfgs, false, true).get();
            ArrayList<IgniteCache> createdCaches = new ArrayList<IgniteCache>(cacheCfgs.size());
            for (CacheConfiguration cacheCfg : cacheCfgs) {
                createdCaches.add(this.ctx.cache().publicJCache(cacheCfg.getName()));
            }
            ArrayList<IgniteCache> arrayList = createdCaches;
            return arrayList;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> createCache(CacheConfiguration<K, V> cacheCfg, NearCacheConfiguration<K, V> nearCfg) {
        A.notNull(cacheCfg, "cacheCfg");
        A.notNull(nearCfg, "nearCfg");
        this.guard();
        try {
            this.ctx.cache().dynamicStartCache(cacheCfg, cacheCfg.getName(), nearCfg, true, true, true).get();
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(cacheCfg.getName());
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> getOrCreateCache(CacheConfiguration<K, V> cacheCfg, NearCacheConfiguration<K, V> nearCfg) {
        A.notNull(cacheCfg, "cacheCfg");
        A.notNull(nearCfg, "nearCfg");
        this.guard();
        try {
            IgniteInternalCache cache = this.ctx.cache().cache(cacheCfg.getName());
            if (cache == null) {
                this.ctx.cache().dynamicStartCache(cacheCfg, cacheCfg.getName(), nearCfg, false, true, true).get();
            } else if (cache.configuration().getNearConfiguration() == null) {
                this.ctx.cache().dynamicStartCache(cacheCfg, cacheCfg.getName(), nearCfg, false, true, true).get();
            }
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(cacheCfg.getName());
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> createNearCache(String cacheName, NearCacheConfiguration<K, V> nearCfg) {
        A.notNull(nearCfg, "nearCfg");
        this.guard();
        try {
            this.ctx.cache().dynamicStartCache(null, cacheName, nearCfg, true, true, true).get();
            IgniteCacheProxy cache = this.ctx.cache().publicJCache(cacheName);
            this.checkNearCacheStarted(cache);
            IgniteCacheProxy igniteCacheProxy = cache;
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> getOrCreateNearCache(@Nullable String cacheName, NearCacheConfiguration<K, V> nearCfg) {
        A.notNull(nearCfg, "nearCfg");
        this.guard();
        try {
            IgniteInternalCache internalCache = this.ctx.cache().cache(cacheName);
            if (internalCache == null) {
                this.ctx.cache().dynamicStartCache(null, cacheName, nearCfg, false, true, true).get();
            } else if (internalCache.configuration().getNearConfiguration() == null) {
                this.ctx.cache().dynamicStartCache(null, cacheName, nearCfg, false, true, true).get();
            }
            IgniteCacheProxy cache = this.ctx.cache().publicJCache(cacheName);
            this.checkNearCacheStarted(cache);
            IgniteCacheProxy igniteCacheProxy = cache;
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    private void checkNearCacheStarted(IgniteCacheProxy<?, ?> cache) throws IgniteCheckedException {
        if (!cache.context().isNear()) {
            throw new IgniteCheckedException("Failed to start near cache (a cache with the same name without near cache is already started)");
        }
    }

    @Override
    public void destroyCache(String cacheName) {
        IgniteInternalFuture<?> stopFut = this.destroyCacheAsync(cacheName, true);
        try {
            stopFut.get();
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
    }

    @Override
    public void destroyCaches(Collection<String> cacheNames) {
        IgniteInternalFuture<?> stopFut = this.destroyCachesAsync(cacheNames, true);
        try {
            stopFut.get();
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<?> destroyCacheAsync(String cacheName, boolean checkThreadTx) {
        this.guard();
        try {
            IgniteInternalFuture<?> igniteInternalFuture = this.ctx.cache().dynamicDestroyCache(cacheName, checkThreadTx);
            return igniteInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<?> destroyCachesAsync(Collection<String> cacheNames, boolean checkThreadTx) {
        this.guard();
        try {
            IgniteInternalFuture<?> igniteInternalFuture = this.ctx.cache().dynamicDestroyCaches(cacheNames, checkThreadTx);
            return igniteInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> getOrCreateCache(String cacheName) {
        this.guard();
        try {
            if (this.ctx.cache().cache(cacheName) == null) {
                this.ctx.cache().getOrCreateFromTemplate(cacheName, true).get();
            }
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(cacheName);
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<?> getOrCreateCacheAsync(String cacheName, boolean checkThreadTx) {
        this.guard();
        try {
            if (this.ctx.cache().cache(cacheName) == null) {
                IgniteInternalFuture<?> igniteInternalFuture = this.ctx.cache().getOrCreateFromTemplate(cacheName, checkThreadTx);
                return igniteInternalFuture;
            }
            GridFinishedFuture gridFinishedFuture = new GridFinishedFuture();
            return gridFinishedFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> void addCacheConfiguration(CacheConfiguration<K, V> cacheCfg) {
        A.notNull(cacheCfg, "cacheCfg");
        this.guard();
        try {
            this.ctx.cache().addCacheConfiguration(cacheCfg);
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IgniteCacheProxy<?, ?>> caches() {
        this.guard();
        try {
            Collection<IgniteCacheProxy<?, ?>> collection = this.ctx.cache().publicCaches();
            return collection;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> cacheNames() {
        this.guard();
        try {
            Collection<String> collection = this.ctx.cache().publicCacheNames();
            return collection;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K extends GridCacheUtilityKey, V> IgniteInternalCache<K, V> utilityCache() {
        this.guard();
        try {
            IgniteInternalCache igniteInternalCache = this.ctx.cache().utilityCache();
            return igniteInternalCache;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> IgniteInternalCache<K, V> cachex(@Nullable String name) {
        this.guard();
        try {
            IgniteInternalCache igniteInternalCache = this.ctx.cache().cache(name);
            return igniteInternalCache;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> IgniteInternalCache<K, V> cachex() {
        this.guard();
        try {
            IgniteInternalCache igniteInternalCache = this.ctx.cache().cache();
            return igniteInternalCache;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IgniteInternalCache<?, ?>> cachesx(IgnitePredicate<? super IgniteInternalCache<?, ?>>[] p) {
        this.guard();
        try {
            Collection<IgniteInternalCache<?, ?>> collection = F.retain(this.ctx.cache().caches(), true, p);
            return collection;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> IgniteDataStreamer<K, V> dataStreamer(@Nullable String cacheName) {
        this.guard();
        try {
            DataStreamerImpl dataStreamerImpl = this.ctx.dataStream().dataStreamer(cacheName);
            return dataStreamerImpl;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFileSystem fileSystem(String name) {
        this.guard();
        try {
            IgniteFileSystem fs = this.ctx.igfs().igfs(name);
            if (fs == null) {
                throw new IllegalArgumentException("IGFS is not configured: " + name);
            }
            IgniteFileSystem igniteFileSystem = fs;
            return igniteFileSystem;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public IgniteFileSystem igfsx(@Nullable String name) {
        this.guard();
        try {
            IgniteFileSystem igniteFileSystem = this.ctx.igfs().igfs(name);
            return igniteFileSystem;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IgniteFileSystem> fileSystems() {
        this.guard();
        try {
            Collection<IgniteFileSystem> collection = this.ctx.igfs().igfss();
            return collection;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hadoop hadoop() {
        this.guard();
        try {
            Hadoop hadoop = this.ctx.hadoop().hadoop();
            return hadoop;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IgnitePlugin> T plugin(String name) throws PluginNotFoundException {
        this.guard();
        try {
            Object t = this.ctx.pluginProvider(name).plugin();
            return t;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public IgniteBinary binary() {
        IgniteCacheObjectProcessor objProc = this.ctx.cacheObjects();
        return objProc.binary();
    }

    @Override
    public IgniteProductVersion version() {
        return IgniteVersionUtils.VER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String latestVersion() {
        this.ctx.gateway().readLock();
        try {
            String string = this.ctx.cluster().latestVersion();
            return string;
        }
        finally {
            this.ctx.gateway().readUnlock();
        }
    }

    @Override
    public IgniteScheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public void close() throws IgniteException {
        Ignition.stop(this.gridName, true);
    }

    @Override
    public <K> Affinity<K> affinity(String cacheName) {
        GridCacheAdapter cache = this.ctx.cache().internalCache(cacheName);
        if (cache != null) {
            return cache.affinity();
        }
        return this.ctx.affinity().affinityProxy(cacheName);
    }

    @Override
    @Nullable
    public IgniteAtomicSequence atomicSequence(String name, long initVal, boolean create) {
        this.guard();
        try {
            IgniteAtomicSequence igniteAtomicSequence = this.ctx.dataStructures().sequence(name, initVal, create);
            return igniteAtomicSequence;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public IgniteAtomicLong atomicLong(String name, long initVal, boolean create) {
        this.guard();
        try {
            IgniteAtomicLong igniteAtomicLong = this.ctx.dataStructures().atomicLong(name, initVal, create);
            return igniteAtomicLong;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public <T> IgniteAtomicReference<T> atomicReference(String name, @Nullable T initVal, boolean create) {
        this.guard();
        try {
            IgniteAtomicReference<T> igniteAtomicReference = this.ctx.dataStructures().atomicReference(name, initVal, create);
            return igniteAtomicReference;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public <T, S> IgniteAtomicStamped<T, S> atomicStamped(String name, @Nullable T initVal, @Nullable S initStamp, boolean create) {
        this.guard();
        try {
            IgniteAtomicStamped<T, S> igniteAtomicStamped = this.ctx.dataStructures().atomicStamped(name, initVal, initStamp, create);
            return igniteAtomicStamped;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public IgniteCountDownLatch countDownLatch(String name, int cnt, boolean autoDel, boolean create) {
        this.guard();
        try {
            IgniteCountDownLatch igniteCountDownLatch = this.ctx.dataStructures().countDownLatch(name, cnt, autoDel, create);
            return igniteCountDownLatch;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public IgniteSemaphore semaphore(String name, int cnt, boolean failoverSafe, boolean create) {
        this.guard();
        try {
            IgniteSemaphore igniteSemaphore = this.ctx.dataStructures().semaphore(name, cnt, failoverSafe, create);
            return igniteSemaphore;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public IgniteLock reentrantLock(String name, boolean failoverSafe, boolean fair, boolean create) {
        this.guard();
        try {
            IgniteLock igniteLock = this.ctx.dataStructures().reentrantLock(name, failoverSafe, fair, create);
            return igniteLock;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public <T> IgniteQueue<T> queue(String name, int cap, CollectionConfiguration cfg) {
        this.guard();
        try {
            IgniteQueue igniteQueue = this.ctx.dataStructures().queue(name, cap, cfg);
            return igniteQueue;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public <T> IgniteSet<T> set(String name, CollectionConfiguration cfg) {
        this.guard();
        try {
            IgniteSet igniteSet = this.ctx.dataStructures().set(name, cfg);
            return igniteSet;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    private void guard() {
        assert (this.ctx != null);
        this.ctx.gateway().readLock();
    }

    private void unguard() {
        assert (this.ctx != null);
        this.ctx.gateway().readUnlock();
    }

    public void onDisconnected() {
        Throwable err = null;
        GridFutureAdapter<?> reconnectFut = this.ctx.gateway().onDisconnected();
        if (reconnectFut == null) {
            assert (this.ctx.gateway().getState() != GridKernalState.STARTED) : this.ctx.gateway().getState();
            return;
        }
        IgniteFutureImpl userFut = new IgniteFutureImpl(reconnectFut);
        this.ctx.cluster().get().clientReconnectFuture(userFut);
        this.ctx.disconnected(true);
        List<GridComponent> comps = this.ctx.components();
        ListIterator<GridComponent> it = comps.listIterator(comps.size());
        while (it.hasPrevious()) {
            GridComponent comp = it.previous();
            try {
                if (this.skipDaemon(comp)) continue;
                comp.onDisconnected(userFut);
            }
            catch (IgniteCheckedException e) {
                err = e;
            }
            catch (Throwable e) {
                err = e;
                if (!(e instanceof Error)) continue;
                throw e;
            }
        }
        for (GridCacheContext cctx : this.ctx.cache().context().cacheContexts()) {
            cctx.gate().writeLock();
            cctx.gate().writeUnlock();
        }
        this.ctx.gateway().writeLock();
        this.ctx.gateway().writeUnlock();
        if (err != null) {
            reconnectFut.onDone(err);
            U.error(this.log, "Failed to reconnect, will stop node", err);
            this.close();
        }
    }

    public void onReconnected(boolean clusterRestarted) {
        Throwable err;
        block5: {
            err = null;
            try {
                this.ctx.disconnected(false);
                GridCompoundFuture reconnectFut = new GridCompoundFuture();
                for (GridComponent comp : this.ctx.components()) {
                    IgniteInternalFuture<?> fut = comp.onReconnected(clusterRestarted);
                    if (fut == null) continue;
                    reconnectFut.add(fut);
                }
                reconnectFut.add(this.ctx.cache().context().exchange().reconnectExchangeFuture());
                reconnectFut.markInitialized();
                reconnectFut.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> fut) {
                        try {
                            fut.get();
                            IgniteKernal.this.ctx.gateway().onReconnected();
                        }
                        catch (IgniteCheckedException e) {
                            U.error(IgniteKernal.this.log, "Failed to reconnect, will stop node", e);
                            IgniteKernal.this.close();
                        }
                    }
                });
            }
            catch (IgniteCheckedException e) {
                err = e;
            }
            catch (Throwable e) {
                err = e;
                if (!(e instanceof Error)) break block5;
                throw e;
            }
        }
        if (err != null) {
            U.error(this.log, "Failed to reconnect, will stop node", err);
            this.close();
        }
    }

    private static <T extends GridComponent> T createComponent(Class<T> cls, GridKernalContext ctx) throws IgniteCheckedException {
        Constructor<?> constructor;
        assert (cls.isInterface()) : cls;
        GridComponent comp = (GridComponent)ctx.plugins().createComponent(cls);
        if (comp != null) {
            return (T)comp;
        }
        if (cls.equals(IgniteCacheObjectProcessor.class)) {
            return (T)new CacheObjectBinaryProcessorImpl(ctx);
        }
        if (cls.equals(DiscoveryNodeValidationProcessor.class)) {
            return (T)new OsDiscoveryNodeValidationProcessor(ctx);
        }
        Class<?> implCls = null;
        try {
            String clsName = cls.equals(PlatformProcessor.class) ? (ctx.config().getPlatformConfiguration() == null ? PlatformNoopProcessor.class.getName() : cls.getName() + "Impl") : IgniteKernal.componentClassName(cls);
            implCls = Class.forName(clsName);
        }
        catch (ClassNotFoundException clsName) {
            // empty catch block
        }
        if (implCls == null) {
            throw new IgniteCheckedException("Failed to find component implementation: " + cls.getName());
        }
        if (!cls.isAssignableFrom(implCls)) {
            throw new IgniteCheckedException("Component implementation does not implement component interface [component=" + cls.getName() + ", implementation=" + implCls.getName() + ']');
        }
        try {
            constructor = implCls.getConstructor(GridKernalContext.class);
        }
        catch (NoSuchMethodException e) {
            throw new IgniteCheckedException("Component does not have expected constructor: " + implCls.getName(), e);
        }
        try {
            return (T)((GridComponent)constructor.newInstance(ctx));
        }
        catch (ReflectiveOperationException e) {
            throw new IgniteCheckedException("Failed to create component [component=" + cls.getName() + ", implementation=" + implCls.getName() + ']', e);
        }
    }

    private static String componentClassName(Class<?> cls) {
        return cls.getPackage().getName() + ".os." + cls.getSimpleName().replace("Grid", "GridOs");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.gridName = U.readString(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.gridName);
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            return IgnitionEx.localIgnite();
        }
        catch (IllegalStateException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
    }

    private boolean skipDaemon(GridComponent comp) {
        return this.ctx.isDaemon() && U.hasAnnotation(comp.getClass(), SkipDaemon.class);
    }

    @Override
    public void dumpDebugInfo() {
        try {
            ClusterNode locNode;
            GridKernalContextImpl ctx = this.ctx;
            GridDiscoveryManager discoMrg = ctx != null ? ctx.discovery() : null;
            ClusterNode clusterNode = locNode = discoMrg != null ? discoMrg.localNode() : null;
            if (ctx != null && discoMrg != null && locNode != null) {
                boolean client = ctx.clientNode();
                UUID routerId = locNode instanceof TcpDiscoveryNode ? ((TcpDiscoveryNode)locNode).clientRouterNodeId() : null;
                U.warn(this.log, "Dumping debug info for node [id=" + locNode.id() + ", name=" + ctx.gridName() + ", order=" + locNode.order() + ", topVer=" + discoMrg.topologyVersion() + ", client=" + client + (client && routerId != null ? ", routerId=" + routerId : "") + ']');
                ctx.cache().context().exchange().dumpDebugInfo();
            } else {
                U.warn(this.log, "Dumping debug info for node, context is not initialized [name=" + this.gridName + ']');
            }
        }
        catch (Exception e) {
            U.error(this.log, "Failed to dump debug info for node: " + e, e);
        }
    }

    public IgniteInternalFuture sendIoTest(ClusterNode node, byte[] payload, boolean procFromNioThread) {
        return this.ctx.io().sendIoTest(node, payload, procFromNioThread);
    }

    public IgniteInternalFuture sendIoTest(List<ClusterNode> nodes, byte[] payload, boolean procFromNioThread) {
        return this.ctx.io().sendIoTest(nodes, payload, procFromNioThread);
    }

    public String toString() {
        return S.toString(IgniteKernal.class, this);
    }
}

