/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteState;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.Ignition;
import org.apache.ignite.IgnitionListener;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.configuration.FileSystemConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.GridLoggerProxy;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgnitionMXBeanAdapter;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.igfs.IgfsThreadFactory;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.spring.IgniteSpringHelper;
import org.apache.ignite.internal.util.typedef.CA;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.logger.LoggerNodeIdAware;
import org.apache.ignite.logger.java.JavaLogger;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.mxbean.IgnitionMXBean;
import org.apache.ignite.plugin.segmentation.SegmentationPolicy;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.checkpoint.noop.NoopCheckpointSpi;
import org.apache.ignite.spi.collision.noop.NoopCollisionSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.deployment.local.LocalDeploymentSpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.multicast.TcpDiscoveryMulticastIpFinder;
import org.apache.ignite.spi.eventstorage.memory.MemoryEventStorageSpi;
import org.apache.ignite.spi.failover.always.AlwaysFailoverSpi;
import org.apache.ignite.spi.indexing.noop.NoopIndexingSpi;
import org.apache.ignite.spi.loadbalancing.LoadBalancingSpi;
import org.apache.ignite.spi.loadbalancing.roundrobin.RoundRobinLoadBalancingSpi;
import org.apache.ignite.spi.swapspace.SwapSpaceSpi;
import org.apache.ignite.spi.swapspace.file.FileSwapSpaceSpi;
import org.apache.ignite.spi.swapspace.noop.NoopSwapSpaceSpi;
import org.apache.ignite.thread.IgniteStripedThreadPoolExecutor;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class IgnitionEx {
    public static final String DFLT_CFG = "config/default-config.xml";
    private static final ConcurrentMap<Object, IgniteNamedInstance> grids = new ConcurrentHashMap8<Object, IgniteNamedInstance>();
    private static final Map<Object, IgniteState> gridStates = new ConcurrentHashMap8<Object, IgniteState>();
    private static final Object dfltGridMux = new Object();
    private static volatile IgniteNamedInstance dfltGrid;
    private static volatile IgniteState dfltGridState;
    private static final Collection<IgnitionListener> lsnrs;
    private static ThreadLocal<Boolean> daemon;
    private static ThreadLocal<Boolean> clientMode;

    private IgnitionEx() {
    }

    public static void setDaemon(boolean daemon) {
        IgnitionEx.daemon.set(daemon);
    }

    public static boolean isDaemon() {
        return daemon.get();
    }

    public static void setClientMode(boolean clientMode) {
        IgnitionEx.clientMode.set(clientMode);
    }

    public static boolean isClientMode() {
        return clientMode.get() == null ? false : clientMode.get();
    }

    public static IgniteState state() {
        return IgnitionEx.state(null);
    }

    public static IgniteState state(@Nullable String name) {
        IgniteNamedInstance grid;
        IgniteNamedInstance igniteNamedInstance = grid = name != null ? (IgniteNamedInstance)grids.get(name) : dfltGrid;
        if (grid == null) {
            IgniteState state = name != null ? gridStates.get(name) : dfltGridState;
            return state != null ? state : IgniteState.STOPPED;
        }
        return grid.state();
    }

    public static boolean stop(boolean cancel) {
        return IgnitionEx.stop(null, cancel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stop(@Nullable String name, boolean cancel, boolean stopNotStarted) {
        IgniteNamedInstance grid;
        IgniteNamedInstance igniteNamedInstance = grid = name != null ? (IgniteNamedInstance)grids.get(name) : dfltGrid;
        if (grid != null && stopNotStarted && grid.startLatch.getCount() != 0L) {
            grid.starterThreadInterrupted = true;
            grid.starterThread.interrupt();
        }
        if (grid != null && grid.state() == IgniteState.STARTED) {
            boolean fireEvt;
            grid.stop(cancel);
            if (name != null) {
                fireEvt = grids.remove(name, grid);
            } else {
                Object object = dfltGridMux;
                synchronized (object) {
                    boolean bl = fireEvt = dfltGrid == grid;
                    if (fireEvt) {
                        dfltGrid = null;
                    }
                }
            }
            if (fireEvt) {
                IgnitionEx.notifyStateChange(grid.getName(), grid.state());
            }
            return true;
        }
        U.warn(null, "Ignoring stopping grid instance that was already stopped or never started: " + name);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAll(boolean cancel) {
        IgniteNamedInstance dfltGrid0 = dfltGrid;
        if (dfltGrid0 != null) {
            boolean fireEvt;
            dfltGrid0.stop(cancel);
            Object object = dfltGridMux;
            synchronized (object) {
                boolean bl = fireEvt = dfltGrid == dfltGrid0;
                if (fireEvt) {
                    dfltGrid = null;
                }
            }
            if (fireEvt) {
                IgnitionEx.notifyStateChange(dfltGrid0.getName(), dfltGrid0.state());
            }
        }
        for (IgniteNamedInstance grid : grids.values()) {
            grid.stop(cancel);
            boolean fireEvt = grids.remove(grid.getName(), grid);
            if (!fireEvt) continue;
            IgnitionEx.notifyStateChange(grid.getName(), grid.state());
        }
    }

    public static void restart(boolean cancel) {
        String file = System.getProperty("IGNITE_SUCCESS_FILE");
        if (file == null) {
            U.warn(null, "Cannot restart node when restart not enabled.");
        } else {
            try {
                new File(file).createNewFile();
            }
            catch (IOException e) {
                U.error(null, "Failed to create restart marker file (restart aborted): " + e.getMessage());
                return;
            }
            U.log(null, "Restarting node. Will exit (250).");
            System.setProperty("IGNITE_RESTART_CODE", Integer.toString(250));
            IgnitionEx.stopAll(cancel);
            System.exit(250);
        }
    }

    public static void kill(boolean cancel) {
        IgnitionEx.stopAll(cancel);
        System.exit(130);
    }

    public static Ignite start() throws IgniteCheckedException {
        return IgnitionEx.start((GridSpringResourceContext)null);
    }

    public static Ignite start(@Nullable GridSpringResourceContext springCtx) throws IgniteCheckedException {
        URL url = U.resolveIgniteUrl(DFLT_CFG);
        if (url != null) {
            return IgnitionEx.start(DFLT_CFG, null, springCtx, null);
        }
        U.warn(null, "Default Spring XML file not found (is IGNITE_HOME set?): config/default-config.xml");
        return IgnitionEx.start0(new GridStartContext(new IgniteConfiguration(), null, springCtx), true).grid();
    }

    public static Ignite start(IgniteConfiguration cfg) throws IgniteCheckedException {
        return IgnitionEx.start(cfg, null, true);
    }

    public static Ignite start(IgniteConfiguration cfg, boolean failIfStarted) throws IgniteCheckedException {
        return IgnitionEx.start(cfg, null, failIfStarted);
    }

    public static Ignite start(IgniteConfiguration cfg, @Nullable GridSpringResourceContext springCtx) throws IgniteCheckedException {
        A.notNull(cfg, "cfg");
        return IgnitionEx.start0(new GridStartContext(cfg, null, springCtx), true).grid();
    }

    public static Ignite start(IgniteConfiguration cfg, @Nullable GridSpringResourceContext springCtx, boolean failIfStarted) throws IgniteCheckedException {
        A.notNull(cfg, "cfg");
        return IgnitionEx.start0(new GridStartContext(cfg, null, springCtx), failIfStarted).grid();
    }

    public static Ignite start(@Nullable String springCfgPath) throws IgniteCheckedException {
        return springCfgPath == null ? IgnitionEx.start() : IgnitionEx.start(springCfgPath, null);
    }

    public static Ignite start(@Nullable String springCfgPath, @Nullable String gridName) throws IgniteCheckedException {
        if (springCfgPath == null) {
            IgniteConfiguration cfg = new IgniteConfiguration();
            if (cfg.getGridName() == null && !F.isEmpty(gridName)) {
                cfg.setGridName(gridName);
            }
            return IgnitionEx.start(cfg);
        }
        return IgnitionEx.start(springCfgPath, gridName, null, null);
    }

    public static IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> loadConfigurations(URL springCfgUrl) throws IgniteCheckedException {
        IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
        return spring.loadConfigurations(springCfgUrl, new String[0]);
    }

    public static IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> loadConfigurations(InputStream springCfgStream) throws IgniteCheckedException {
        IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
        return spring.loadConfigurations(springCfgStream, new String[0]);
    }

    public static IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> loadConfigurations(String springCfgPath) throws IgniteCheckedException {
        A.notNull(springCfgPath, "springCfgPath");
        return IgnitionEx.loadConfigurations(IgniteUtils.resolveSpringUrl(springCfgPath));
    }

    public static IgniteBiTuple<IgniteConfiguration, GridSpringResourceContext> loadConfiguration(URL springCfgUrl) throws IgniteCheckedException {
        IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> t = IgnitionEx.loadConfigurations(springCfgUrl);
        return F.t(F.first((Iterable)t.get1()), t.get2());
    }

    public static IgniteBiTuple<IgniteConfiguration, GridSpringResourceContext> loadConfiguration(String springCfgPath) throws IgniteCheckedException {
        IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> t = IgnitionEx.loadConfigurations(springCfgPath);
        return F.t(F.first((Iterable)t.get1()), t.get2());
    }

    public static Ignite start(String springCfgPath, @Nullable String gridName, @Nullable GridSpringResourceContext springCtx, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        URL url = U.resolveSpringUrl(springCfgPath);
        return IgnitionEx.start(url, gridName, springCtx, ldr);
    }

    public static Ignite start(URL springCfgUrl) throws IgniteCheckedException {
        return IgnitionEx.start(springCfgUrl, null, null, null);
    }

    public static Ignite start(URL springCfgUrl, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        return IgnitionEx.start(springCfgUrl, null, null, ldr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ignite start(URL springCfgUrl, @Nullable String gridName, @Nullable GridSpringResourceContext springCtx, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> cfgMap;
        A.notNull(springCfgUrl, "springCfgUrl");
        boolean isLog4jUsed = U.gridClassLoader().getResource("org/apache/log4j/Appender.class") != null;
        IgniteBiTuple<Object, Object> t = null;
        if (isLog4jUsed) {
            try {
                t = U.addLog4jNoOpLogger();
            }
            catch (IgniteCheckedException ignore) {
                isLog4jUsed = false;
            }
        }
        Collection<Handler> savedHnds = null;
        if (!isLog4jUsed) {
            savedHnds = U.addJavaNoOpLogger();
        }
        try {
            cfgMap = IgnitionEx.loadConfigurations(springCfgUrl);
        }
        finally {
            if (isLog4jUsed && t != null) {
                U.removeLog4jNoOpLogger(t);
            }
            if (!isLog4jUsed) {
                U.removeJavaNoOpLogger(savedHnds);
            }
        }
        return IgnitionEx.startConfigurations(cfgMap, springCfgUrl, gridName, springCtx, ldr);
    }

    public static Ignite start(InputStream springCfgStream) throws IgniteCheckedException {
        return IgnitionEx.start(springCfgStream, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ignite start(InputStream springCfgStream, @Nullable String gridName, @Nullable GridSpringResourceContext springCtx, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> cfgMap;
        A.notNull(springCfgStream, "springCfgUrl");
        boolean isLog4jUsed = U.gridClassLoader().getResource("org/apache/log4j/Appender.class") != null;
        IgniteBiTuple<Object, Object> t = null;
        if (isLog4jUsed) {
            try {
                t = U.addLog4jNoOpLogger();
            }
            catch (IgniteCheckedException ignore) {
                isLog4jUsed = false;
            }
        }
        Collection<Handler> savedHnds = null;
        if (!isLog4jUsed) {
            savedHnds = U.addJavaNoOpLogger();
        }
        try {
            cfgMap = IgnitionEx.loadConfigurations(springCfgStream);
        }
        finally {
            if (isLog4jUsed && t != null) {
                U.removeLog4jNoOpLogger(t);
            }
            if (!isLog4jUsed) {
                U.removeJavaNoOpLogger(savedHnds);
            }
        }
        return IgnitionEx.startConfigurations(cfgMap, null, gridName, springCtx, ldr);
    }

    private static Ignite startConfigurations(IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> cfgMap, URL springCfgUrl, @Nullable String gridName, @Nullable GridSpringResourceContext springCtx, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        ArrayList<IgniteNamedInstance> grids = new ArrayList<IgniteNamedInstance>(cfgMap.size());
        try {
            for (IgniteConfiguration cfg : cfgMap.get1()) {
                IgniteNamedInstance grid;
                assert (cfg != null);
                if (cfg.getGridName() == null && !F.isEmpty(gridName)) {
                    cfg.setGridName(gridName);
                }
                if (ldr != null && cfg.getClassLoader() == null) {
                    cfg.setClassLoader(ldr);
                }
                if ((grid = IgnitionEx.start0(new GridStartContext(cfg, springCfgUrl, springCtx == null ? cfgMap.get2() : springCtx), true)) == null) continue;
                grids.add(grid);
            }
        }
        catch (IgniteCheckedException e) {
            for (IgniteNamedInstance grid : grids) {
                try {
                    grid.stop(true);
                }
                catch (Exception e1) {
                    U.error(grid.log, "Error when stopping grid: " + grid, e1);
                }
            }
            throw e;
        }
        IgniteNamedInstance res = !grids.isEmpty() ? (IgniteNamedInstance)grids.get(0) : null;
        return res != null ? res.grid() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IgniteNamedInstance start0(GridStartContext startCtx, boolean failIfStarted) throws IgniteCheckedException {
        IgniteNamedInstance old;
        assert (startCtx != null);
        String name = startCtx.config().getGridName();
        if (name != null && name.isEmpty()) {
            throw new IgniteCheckedException("Non default grid instances cannot have empty string name.");
        }
        IgniteNamedInstance grid = new IgniteNamedInstance(name);
        if (name != null) {
            old = grids.putIfAbsent(name, grid);
        } else {
            Object object = dfltGridMux;
            synchronized (object) {
                old = dfltGrid;
                if (old == null) {
                    dfltGrid = grid;
                }
            }
        }
        if (old != null) {
            if (failIfStarted) {
                if (name == null) {
                    throw new IgniteCheckedException("Default Ignite instance has already been started.");
                }
                throw new IgniteCheckedException("Ignite instance with this name has already been started: " + name);
            }
            return old;
        }
        if (startCtx.config().getWarmupClosure() != null) {
            startCtx.config().getWarmupClosure().apply(startCtx.config());
        }
        startCtx.single(grids.size() == 1);
        boolean success = false;
        try {
            try {
                grid.start(startCtx);
            }
            catch (IgniteInterruptedCheckedException e) {
                if (grid.starterThreadInterrupted) {
                    Thread.interrupted();
                }
                throw e;
            }
            IgnitionEx.notifyStateChange(name, IgniteState.STARTED);
            success = true;
        }
        finally {
            if (!success) {
                if (name != null) {
                    grids.remove(name, grid);
                } else {
                    Object object = dfltGridMux;
                    synchronized (object) {
                        if (dfltGrid == grid) {
                            dfltGrid = null;
                        }
                    }
                }
                grid = null;
            }
        }
        if (grid == null) {
            throw new IgniteCheckedException("Failed to start grid with provided configuration.");
        }
        return grid;
    }

    public static <T> T loadSpringBean(String springXmlPath, String beanName) throws IgniteCheckedException {
        A.notNull(springXmlPath, "springXmlPath");
        A.notNull(beanName, "beanName");
        URL url = U.resolveSpringUrl(springXmlPath);
        assert (url != null);
        return IgnitionEx.loadSpringBean(url, beanName);
    }

    public static <T> T loadSpringBean(URL springXmlUrl, String beanName) throws IgniteCheckedException {
        A.notNull(springXmlUrl, "springXmlUrl");
        A.notNull(beanName, "beanName");
        IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
        return spring.loadBean(springXmlUrl, beanName);
    }

    public static <T> T loadSpringBean(InputStream springXmlStream, String beanName) throws IgniteCheckedException {
        A.notNull(springXmlStream, "springXmlPath");
        A.notNull(beanName, "beanName");
        IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
        return spring.loadBean(springXmlStream, beanName);
    }

    public static Ignite grid() throws IgniteIllegalStateException {
        return IgnitionEx.grid((String)null);
    }

    public static List<Ignite> allGrids() {
        return IgnitionEx.allGrids(true);
    }

    public static List<Ignite> allGridsx() {
        return IgnitionEx.allGrids(false);
    }

    private static List<Ignite> allGrids(boolean wait) {
        ArrayList<Ignite> allIgnites = new ArrayList<Ignite>(grids.size() + 1);
        for (IgniteNamedInstance grid : grids.values()) {
            IgniteKernal g = wait ? grid.grid() : grid.gridx();
            if (g == null) continue;
            allIgnites.add(g);
        }
        IgniteNamedInstance dfltGrid0 = dfltGrid;
        if (dfltGrid0 != null) {
            IgniteKernal g;
            IgniteKernal igniteKernal = g = wait ? dfltGrid0.grid() : dfltGrid0.gridx();
            if (g != null) {
                allIgnites.add(g);
            }
        }
        return allIgnites;
    }

    public static Ignite grid(UUID locNodeId) throws IgniteIllegalStateException {
        IgniteKernal g;
        A.notNull(locNodeId, "locNodeId");
        IgniteNamedInstance dfltGrid0 = dfltGrid;
        if (dfltGrid0 != null && (g = dfltGrid0.grid()) != null && g.getLocalNodeId().equals(locNodeId)) {
            return g;
        }
        for (IgniteNamedInstance grid : grids.values()) {
            IgniteKernal g2 = grid.grid();
            if (g2 == null || !g2.getLocalNodeId().equals(locNodeId)) continue;
            return g2;
        }
        throw new IgniteIllegalStateException("Grid instance with given local node ID was not properly started or was stopped: " + locNodeId);
    }

    public static IgniteKernal gridxx(UUID locNodeId) {
        IgniteKernal g;
        IgniteNamedInstance dfltGrid0 = dfltGrid;
        if (dfltGrid0 != null && (g = dfltGrid0.grid()) != null && g.getLocalNodeId().equals(locNodeId)) {
            return g;
        }
        for (IgniteNamedInstance grid : grids.values()) {
            IgniteKernal g2 = grid.grid();
            if (g2 == null || !g2.getLocalNodeId().equals(locNodeId)) continue;
            return g2;
        }
        return null;
    }

    public static Ignite grid(@Nullable String name) throws IgniteIllegalStateException {
        IgniteKernal res;
        IgniteNamedInstance grid;
        IgniteNamedInstance igniteNamedInstance = grid = name != null ? (IgniteNamedInstance)grids.get(name) : dfltGrid;
        if (grid == null || (res = grid.grid()) == null) {
            throw new IgniteIllegalStateException("Ignite instance with provided name doesn't exist. Did you call Ignition.start(..) to start an Ignite instance? [name=" + name + ']');
        }
        return res;
    }

    public static IgniteKernal localIgnite() throws IllegalArgumentException {
        String name = U.getCurrentIgniteName();
        if (U.isCurrentIgniteNameSet(name)) {
            return IgnitionEx.gridx(name);
        }
        if (Thread.currentThread() instanceof IgniteThread) {
            return IgnitionEx.gridx(((IgniteThread)Thread.currentThread()).getGridName());
        }
        throw new IllegalArgumentException("Ignite grid name thread local must be set or this method should be accessed under " + IgniteThread.class.getName());
    }

    private static IgniteKernal gridx(@Nullable String name) {
        IgniteKernal res;
        IgniteNamedInstance grid;
        IgniteNamedInstance igniteNamedInstance = grid = name != null ? (IgniteNamedInstance)grids.get(name) : dfltGrid;
        if (grid == null || (res = grid.gridx()) == null) {
            throw new IgniteIllegalStateException("Ignite instance with provided name doesn't exist. Did you call Ignition.start(..) to start an Ignite instance? [name=" + name + ']');
        }
        return res;
    }

    public static void addListener(IgnitionListener lsnr) {
        A.notNull(lsnr, "lsnr");
        lsnrs.add(lsnr);
    }

    public static boolean removeListener(IgnitionListener lsnr) {
        A.notNull(lsnr, "lsnr");
        return lsnrs.remove(lsnr);
    }

    private static void notifyStateChange(@Nullable String gridName, IgniteState state) {
        if (gridName != null) {
            gridStates.put(gridName, state);
        } else {
            dfltGridState = state;
        }
        for (IgnitionListener lsnr : lsnrs) {
            lsnr.onStateChange(gridName, state);
        }
    }

    static {
        lsnrs = new GridConcurrentHashSet<IgnitionListener>(4);
        daemon = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        clientMode = new ThreadLocal();
        if (!U.jdkVersion().contains("1.7") && !U.jdkVersion().contains("1.8")) {
            throw new IllegalStateException("Ignite requires Java 7 or above. Current Java version is not supported: " + U.jdkVersion());
        }
        UUID.randomUUID();
    }

    private static final class IgniteNamedInstance {
        private static final Map<MBeanServer, GridMBeanServerData> mbeans = new HashMap<MBeanServer, GridMBeanServerData>();
        private static final String[] EMPTY_STR_ARR = new String[0];
        private final String name;
        private volatile IgniteKernal grid;
        private ThreadPoolExecutor execSvc;
        private ThreadPoolExecutor sysExecSvc;
        private StripedExecutor stripedExecSvc;
        private ThreadPoolExecutor mgmtExecSvc;
        private ThreadPoolExecutor p2pExecSvc;
        private ThreadPoolExecutor igfsExecSvc;
        private ThreadPoolExecutor restExecSvc;
        private ThreadPoolExecutor utilityCacheExecSvc;
        private ThreadPoolExecutor marshCacheExecSvc;
        private ThreadPoolExecutor affExecSvc;
        private ThreadPoolExecutor idxExecSvc;
        private IgniteStripedThreadPoolExecutor callbackExecSvc;
        private volatile IgniteState state = IgniteState.STOPPED;
        private Thread shutdownHook;
        private IgniteLogger log;
        private final AtomicBoolean startGuard = new AtomicBoolean();
        private final CountDownLatch startLatch = new CountDownLatch(1);
        private Thread starterThread;
        private boolean starterThreadInterrupted;

        IgniteNamedInstance(@Nullable String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        IgniteKernal grid() {
            if (this.starterThread != Thread.currentThread()) {
                U.awaitQuiet(this.startLatch);
            }
            return this.grid;
        }

        public IgniteKernal gridx() {
            return this.grid;
        }

        IgniteState state() {
            if (this.starterThread != Thread.currentThread()) {
                U.awaitQuiet(this.startLatch);
            }
            return this.state;
        }

        private void ensureMultiInstanceSupport(IgniteSpi spi) throws IgniteCheckedException {
            IgniteSpiMultipleInstancesSupport ann = U.getAnnotation(spi.getClass(), IgniteSpiMultipleInstancesSupport.class);
            if (ann == null || !ann.value()) {
                throw new IgniteCheckedException("SPI implementation doesn't support multiple grid instances in the same VM: " + spi);
            }
        }

        private void ensureMultiInstanceSupport(IgniteSpi[] spis) throws IgniteCheckedException {
            for (IgniteSpi spi : spis) {
                this.ensureMultiInstanceSupport(spi);
            }
        }

        synchronized void start(GridStartContext startCtx) throws IgniteCheckedException {
            if (this.startGuard.compareAndSet(false, true)) {
                try {
                    this.starterThread = Thread.currentThread();
                    this.start0(startCtx);
                }
                catch (Exception e) {
                    if (this.log != null) {
                        this.stopExecutors(this.log);
                    }
                    throw e;
                }
                finally {
                    this.startLatch.countDown();
                }
            } else {
                U.awaitQuiet(this.startLatch);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void start0(GridStartContext startCtx) throws IgniteCheckedException {
            assert (this.grid == null) : "Grid is already started: " + this.name;
            IgniteConfiguration cfg = startCtx.config() != null ? startCtx.config() : new IgniteConfiguration();
            IgniteConfiguration myCfg = this.initializeConfiguration(cfg);
            if (startCtx.configUrl() != null) {
                System.setProperty("IGNITE_CONFIG_URL", startCtx.configUrl().toString());
            }
            if (!startCtx.single()) {
                this.ensureMultiInstanceSupport(myCfg.getDeploymentSpi());
                this.ensureMultiInstanceSupport(myCfg.getCommunicationSpi());
                this.ensureMultiInstanceSupport(myCfg.getDiscoverySpi());
                this.ensureMultiInstanceSupport(myCfg.getCheckpointSpi());
                this.ensureMultiInstanceSupport(myCfg.getEventStorageSpi());
                this.ensureMultiInstanceSupport(myCfg.getCollisionSpi());
                this.ensureMultiInstanceSupport(myCfg.getFailoverSpi());
                this.ensureMultiInstanceSupport(myCfg.getLoadBalancingSpi());
                this.ensureMultiInstanceSupport(myCfg.getSwapSpaceSpi());
            }
            IgniteNamedInstance.validateThreadPoolSize(cfg.getPublicThreadPoolSize(), "public");
            this.execSvc = new IgniteThreadPoolExecutor("pub", cfg.getGridName(), cfg.getPublicThreadPoolSize(), cfg.getPublicThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>());
            this.execSvc.allowCoreThreadTimeOut(true);
            IgniteNamedInstance.validateThreadPoolSize(cfg.getSystemThreadPoolSize(), "system");
            this.sysExecSvc = new IgniteThreadPoolExecutor("sys", cfg.getGridName(), cfg.getSystemThreadPoolSize(), cfg.getSystemThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>());
            this.sysExecSvc.allowCoreThreadTimeOut(true);
            if (cfg.getStripedPoolSize() > 0) {
                this.stripedExecSvc = new StripedExecutor(cfg.getStripedPoolSize(), cfg.getGridName(), "sys", this.log);
            }
            IgniteNamedInstance.validateThreadPoolSize(cfg.getManagementThreadPoolSize(), "management");
            this.mgmtExecSvc = new IgniteThreadPoolExecutor("mgmt", cfg.getGridName(), cfg.getManagementThreadPoolSize(), cfg.getManagementThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>());
            this.mgmtExecSvc.allowCoreThreadTimeOut(true);
            IgniteNamedInstance.validateThreadPoolSize(cfg.getPeerClassLoadingThreadPoolSize(), "peer class loading");
            this.p2pExecSvc = new IgniteThreadPoolExecutor("p2p", cfg.getGridName(), cfg.getPeerClassLoadingThreadPoolSize(), cfg.getPeerClassLoadingThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>());
            this.p2pExecSvc.allowCoreThreadTimeOut(true);
            IgniteNamedInstance.validateThreadPoolSize(cfg.getIgfsThreadPoolSize(), "IGFS");
            this.igfsExecSvc = new IgniteThreadPoolExecutor(cfg.getIgfsThreadPoolSize(), cfg.getIgfsThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), new IgfsThreadFactory(cfg.getGridName(), "igfs"), null);
            this.igfsExecSvc.allowCoreThreadTimeOut(true);
            IgniteNamedInstance.validateThreadPoolSize(cfg.getAsyncCallbackPoolSize(), "async callback");
            this.callbackExecSvc = new IgniteStripedThreadPoolExecutor(cfg.getAsyncCallbackPoolSize(), cfg.getGridName(), "callback");
            if (myCfg.getConnectorConfiguration() != null) {
                IgniteNamedInstance.validateThreadPoolSize(myCfg.getConnectorConfiguration().getThreadPoolSize(), "connector");
                this.restExecSvc = new IgniteThreadPoolExecutor("rest", myCfg.getGridName(), myCfg.getConnectorConfiguration().getThreadPoolSize(), myCfg.getConnectorConfiguration().getThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>());
                this.restExecSvc.allowCoreThreadTimeOut(true);
            }
            IgniteNamedInstance.validateThreadPoolSize(myCfg.getUtilityCacheThreadPoolSize(), "utility cache");
            this.utilityCacheExecSvc = new IgniteThreadPoolExecutor("utility", cfg.getGridName(), myCfg.getUtilityCacheThreadPoolSize(), myCfg.getUtilityCacheThreadPoolSize(), myCfg.getUtilityCacheKeepAliveTime(), new LinkedBlockingQueue<Runnable>());
            this.utilityCacheExecSvc.allowCoreThreadTimeOut(true);
            IgniteNamedInstance.validateThreadPoolSize(myCfg.getMarshallerCacheThreadPoolSize(), "marshaller cache");
            this.marshCacheExecSvc = new IgniteThreadPoolExecutor("marshaller-cache", cfg.getGridName(), myCfg.getMarshallerCacheThreadPoolSize(), myCfg.getMarshallerCacheThreadPoolSize(), myCfg.getMarshallerCacheKeepAliveTime(), new LinkedBlockingQueue<Runnable>());
            this.marshCacheExecSvc.allowCoreThreadTimeOut(true);
            this.affExecSvc = new IgniteThreadPoolExecutor("aff", cfg.getGridName(), 1, 1, 60000L, new LinkedBlockingQueue<Runnable>());
            this.affExecSvc.allowCoreThreadTimeOut(true);
            if (IgniteComponentType.INDEXING.inClassPath()) {
                int cpus = Runtime.getRuntime().availableProcessors();
                this.idxExecSvc = new IgniteThreadPoolExecutor("idx", cfg.getGridName(), cpus, cpus * 2, 3000L, new LinkedBlockingQueue<Runnable>(1000));
            }
            this.registerFactoryMbean(myCfg.getMBeanServer());
            boolean started = false;
            try {
                IgniteKernal grid0;
                this.grid = grid0 = new IgniteKernal(startCtx.springContext());
                grid0.start(myCfg, this.utilityCacheExecSvc, this.marshCacheExecSvc, this.execSvc, this.sysExecSvc, this.stripedExecSvc, this.p2pExecSvc, this.mgmtExecSvc, this.igfsExecSvc, this.restExecSvc, this.affExecSvc, this.idxExecSvc, this.callbackExecSvc, new CA(){

                    @Override
                    public void apply() {
                        IgniteNamedInstance.this.startLatch.countDown();
                    }
                });
                this.state = IgniteState.STARTED;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Grid factory started ok: " + this.name);
                }
                started = true;
            }
            catch (IgniteCheckedException e) {
                this.unregisterFactoryMBean();
                throw e;
            }
            catch (Throwable e) {
                this.unregisterFactoryMBean();
                if (!(e instanceof Error)) throw new IgniteCheckedException("Unexpected exception when starting grid.", e);
                throw e;
            }
            finally {
                if (!started) {
                    this.grid = null;
                }
            }
            if (!IgniteSystemProperties.getBoolean("IGNITE_NO_SHUTDOWN_HOOK", false)) {
                try {
                    this.shutdownHook = new Thread(){

                        @Override
                        public void run() {
                            if (IgniteNamedInstance.this.log.isInfoEnabled()) {
                                IgniteNamedInstance.this.log.info("Invoking shutdown hook...");
                            }
                            IgniteNamedInstance.this.stop(true);
                        }
                    };
                    Runtime.getRuntime().addShutdownHook(this.shutdownHook);
                    if (!this.log.isDebugEnabled()) return;
                    this.log.debug("Shutdown hook is installed.");
                    return;
                }
                catch (IllegalStateException e) {
                    this.stop(true);
                    throw new IgniteCheckedException("Failed to install shutdown hook.", e);
                }
            } else {
                if (!this.log.isDebugEnabled()) return;
                this.log.debug("Shutdown hook has not been installed because environment or system property IGNITE_NO_SHUTDOWN_HOOK is set.");
            }
        }

        private static void validateThreadPoolSize(int poolSize, String poolName) throws IgniteCheckedException {
            if (poolSize <= 0) {
                throw new IgniteCheckedException("Invalid " + poolName + " thread pool size" + " (must be greater than 0), actual value: " + poolSize);
            }
        }

        private IgniteConfiguration initializeConfiguration(IgniteConfiguration cfg) throws IgniteCheckedException {
            FileSystemConfiguration[] igfsCfgs;
            Marshaller marsh;
            String depModeName;
            File ggHomeFile;
            IgniteConfiguration myCfg = new IgniteConfiguration(cfg);
            String ggHome = cfg.getIgniteHome();
            if (ggHome == null) {
                ggHome = U.getIgniteHome();
            } else {
                U.setIgniteHome(ggHome);
            }
            String workDir = U.workDirectory(cfg.getWorkDirectory(), ggHome);
            myCfg.setWorkDirectory(workDir);
            assert (F.eq(this.name, cfg.getGridName()));
            UUID nodeId = cfg.getNodeId() != null ? cfg.getNodeId() : UUID.randomUUID();
            myCfg.setNodeId(nodeId);
            IgniteLogger cfgLog = this.initLogger(cfg.getGridLogger(), nodeId, workDir);
            assert (cfgLog != null);
            cfgLog = new GridLoggerProxy(cfgLog, null, this.name, U.id8(nodeId));
            this.log = cfgLog.getLogger(G.class);
            myCfg.setGridLogger(cfgLog);
            if (!(ggHome == null || (ggHomeFile = new File(ggHome)).exists() && ggHomeFile.isDirectory())) {
                throw new IgniteCheckedException("Invalid Ignite installation home folder: " + ggHome);
            }
            myCfg.setIgniteHome(ggHome);
            SegmentationPolicy segPlc = cfg.getSegmentationPolicy();
            if (!F.isEmpty(cfg.getSegmentationResolvers()) && segPlc == SegmentationPolicy.RESTART_JVM && !cfg.isWaitForSegmentOnStart()) {
                U.warn(this.log, "Found potential configuration problem (forgot to enable waiting for segmenton start?) [segPlc=" + (Object)((Object)segPlc) + ", wait=false]");
            }
            myCfg.setTransactionConfiguration(myCfg.getTransactionConfiguration() != null ? new TransactionConfiguration(myCfg.getTransactionConfiguration()) : null);
            myCfg.setConnectorConfiguration(myCfg.getConnectorConfiguration() != null ? new ConnectorConfiguration(myCfg.getConnectorConfiguration()) : null);
            String locHost = IgniteSystemProperties.getString("IGNITE_LOCAL_HOST");
            myCfg.setLocalHost(F.isEmpty(locHost) ? myCfg.getLocalHost() : locHost);
            if (((Boolean)daemon.get()).booleanValue()) {
                myCfg.setDaemon(true);
            }
            if (myCfg.isClientMode() == null) {
                Boolean threadClient = (Boolean)clientMode.get();
                if (threadClient == null) {
                    myCfg.setClientMode(IgniteSystemProperties.getBoolean("IGNITE_CACHE_CLIENT", false));
                } else {
                    myCfg.setClientMode(threadClient);
                }
            }
            if (!F.isEmpty(depModeName = IgniteSystemProperties.getString("IGNITE_DEPLOYMENT_MODE_OVERRIDE"))) {
                if (!F.isEmpty(myCfg.getCacheConfiguration())) {
                    U.quietAndInfo(this.log, "Skipping deployment mode override for caches (custom closure execution may not work for console Visor)");
                } else {
                    try {
                        DeploymentMode depMode = DeploymentMode.valueOf(depModeName);
                        if (myCfg.getDeploymentMode() != depMode) {
                            myCfg.setDeploymentMode(depMode);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw new IgniteCheckedException("Failed to override deployment mode using system property (are there any misspellings?)[name=IGNITE_DEPLOYMENT_MODE_OVERRIDE, value=" + depModeName + ']', e);
                    }
                }
            }
            if (myCfg.getUserAttributes() == null) {
                myCfg.setUserAttributes(Collections.emptyMap());
            }
            if (myCfg.getMBeanServer() == null) {
                myCfg.setMBeanServer(ManagementFactory.getPlatformMBeanServer());
            }
            if ((marsh = myCfg.getMarshaller()) == null) {
                if (!BinaryMarshaller.available()) {
                    U.warn(this.log, "OptimizedMarshaller is not supported on this JVM (only recent 1.6 and 1.7 versions HotSpot VMs are supported). To enable fast marshalling upgrade to recent 1.6 or 1.7 HotSpot VM release. Switching to standard JDK marshalling - object serialization performance will be significantly slower.", "To enable fast marshalling upgrade to recent 1.6 or 1.7 HotSpot VM release.");
                    marsh = new JdkMarshaller();
                } else {
                    marsh = new BinaryMarshaller();
                }
            }
            MarshallerUtils.setNodeName(marsh, cfg.getGridName());
            myCfg.setMarshaller(marsh);
            if (myCfg.getPeerClassLoadingLocalClassPathExclude() == null) {
                myCfg.setPeerClassLoadingLocalClassPathExclude(EMPTY_STR_ARR);
            }
            if ((igfsCfgs = myCfg.getFileSystemConfiguration()) != null) {
                FileSystemConfiguration[] clone = (FileSystemConfiguration[])igfsCfgs.clone();
                for (int i = 0; i < igfsCfgs.length; ++i) {
                    clone[i] = new FileSystemConfiguration(igfsCfgs[i]);
                }
                myCfg.setFileSystemConfiguration(clone);
            }
            this.initializeDefaultSpi(myCfg);
            this.initializeDefaultCacheConfiguration(myCfg);
            return myCfg;
        }

        public void initializeDefaultCacheConfiguration(IgniteConfiguration cfg) throws IgniteCheckedException {
            ArrayList<CacheConfiguration> cacheCfgs = new ArrayList<CacheConfiguration>();
            cacheCfgs.add(IgniteNamedInstance.marshallerSystemCache());
            cacheCfgs.add(IgniteNamedInstance.utilitySystemCache());
            if (IgniteComponentType.HADOOP.inClassPath()) {
                cacheCfgs.add(CU.hadoopSystemCache());
            }
            cacheCfgs.add(IgniteNamedInstance.atomicsSystemCache(cfg.getAtomicConfiguration()));
            CacheConfiguration[] userCaches = cfg.getCacheConfiguration();
            if (userCaches != null && userCaches.length > 0) {
                if (!U.discoOrdered(cfg.getDiscoverySpi()) && !U.relaxDiscoveryOrdered()) {
                    throw new IgniteCheckedException("Discovery SPI implementation does not support node ordering and cannot be used with cache (use SPI with @DiscoverySpiOrderSupport annotation, like TcpDiscoverySpi)");
                }
                for (CacheConfiguration ccfg : userCaches) {
                    if (CU.isHadoopSystemCache(ccfg.getName())) {
                        throw new IgniteCheckedException("Cache name cannot be \"ignite-hadoop-mr-sys-cache\" because it is reserved for internal purposes.");
                    }
                    if (CU.isAtomicsCache(ccfg.getName())) {
                        throw new IgniteCheckedException("Cache name cannot be \"ignite-atomics-sys-cache\" because it is reserved for internal purposes.");
                    }
                    if (CU.isUtilityCache(ccfg.getName())) {
                        throw new IgniteCheckedException("Cache name cannot be \"ignite-sys-cache\" because it is reserved for internal purposes.");
                    }
                    if (CU.isMarshallerCache(ccfg.getName())) {
                        throw new IgniteCheckedException("Cache name cannot be \"ignite-marshaller-sys-cache\" because it is reserved for internal purposes.");
                    }
                    cacheCfgs.add(ccfg);
                }
            }
            cfg.setCacheConfiguration(cacheCfgs.toArray(new CacheConfiguration[cacheCfgs.size()]));
            assert (cfg.getCacheConfiguration() != null);
            for (CacheConfiguration ccfg : cfg.getCacheConfiguration()) {
                IgfsUtils.prepareCacheConfiguration(cfg, ccfg);
            }
        }

        private void initializeDefaultSpi(IgniteConfiguration cfg) {
            TcpDiscoverySpi tcpDisco;
            if (cfg.getDiscoverySpi() == null) {
                cfg.setDiscoverySpi(new TcpDiscoverySpi());
            }
            if (cfg.getDiscoverySpi() instanceof TcpDiscoverySpi && (tcpDisco = (TcpDiscoverySpi)cfg.getDiscoverySpi()).getIpFinder() == null) {
                tcpDisco.setIpFinder(new TcpDiscoveryMulticastIpFinder());
            }
            if (cfg.getCommunicationSpi() == null) {
                cfg.setCommunicationSpi(new TcpCommunicationSpi());
            }
            if (cfg.getDeploymentSpi() == null) {
                cfg.setDeploymentSpi(new LocalDeploymentSpi());
            }
            if (cfg.getEventStorageSpi() == null) {
                cfg.setEventStorageSpi(new MemoryEventStorageSpi());
            }
            if (cfg.getCheckpointSpi() == null) {
                cfg.setCheckpointSpi(new NoopCheckpointSpi());
            }
            if (cfg.getCollisionSpi() == null) {
                cfg.setCollisionSpi(new NoopCollisionSpi());
            }
            if (cfg.getFailoverSpi() == null) {
                cfg.setFailoverSpi(new AlwaysFailoverSpi());
            }
            if (cfg.getLoadBalancingSpi() == null) {
                cfg.setLoadBalancingSpi(new RoundRobinLoadBalancingSpi());
            } else {
                ArrayList<LoadBalancingSpi> spis = new ArrayList<LoadBalancingSpi>();
                boolean dfltLoadBalancingSpi = false;
                for (LoadBalancingSpi spi : cfg.getLoadBalancingSpi()) {
                    spis.add(spi);
                    if (dfltLoadBalancingSpi || !(spi instanceof RoundRobinLoadBalancingSpi)) continue;
                    dfltLoadBalancingSpi = true;
                }
                if (!dfltLoadBalancingSpi) {
                    spis.add(new RoundRobinLoadBalancingSpi());
                }
                cfg.setLoadBalancingSpi(spis.toArray(new LoadBalancingSpi[spis.size()]));
            }
            if (cfg.getIndexingSpi() == null) {
                cfg.setIndexingSpi(new NoopIndexingSpi());
            }
            if (cfg.getSwapSpaceSpi() == null) {
                boolean needSwap = false;
                if (cfg.getCacheConfiguration() != null && !Boolean.TRUE.equals(cfg.isClientMode())) {
                    for (CacheConfiguration c : cfg.getCacheConfiguration()) {
                        if (!c.isSwapEnabled()) continue;
                        needSwap = true;
                        break;
                    }
                }
                cfg.setSwapSpaceSpi((SwapSpaceSpi)((Object)(needSwap ? new FileSwapSpaceSpi() : new NoopSwapSpaceSpi())));
            }
        }

        private IgniteLogger initLogger(@Nullable IgniteLogger cfgLog, UUID nodeId, String workDir) throws IgniteCheckedException {
            try {
                Exception log4jInitErr = null;
                if (cfgLog == null) {
                    Class<?> log4jCls;
                    try {
                        log4jCls = Class.forName("org.apache.ignite.logger.log4j.Log4JLogger");
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError ignored) {
                        log4jCls = null;
                    }
                    if (log4jCls != null) {
                        try {
                            boolean configured;
                            URL url = U.resolveIgniteUrl("config/ignite-log4j.xml");
                            if (url == null) {
                                File cfgFile = new File("config/ignite-log4j.xml");
                                if (!cfgFile.exists()) {
                                    cfgFile = new File("../config/ignite-log4j.xml");
                                }
                                if (cfgFile.exists()) {
                                    try {
                                        url = cfgFile.toURI().toURL();
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (url != null && (configured = ((Boolean)log4jCls.getMethod("isConfigured", new Class[0]).invoke(null, new Object[0])).booleanValue())) {
                                url = null;
                            }
                            if (url != null) {
                                Constructor<?> ctor = log4jCls.getConstructor(URL.class);
                                cfgLog = (IgniteLogger)ctor.newInstance(url);
                            } else {
                                cfgLog = (IgniteLogger)log4jCls.newInstance();
                            }
                        }
                        catch (Exception e) {
                            log4jInitErr = e;
                        }
                    }
                    if (log4jCls == null || log4jInitErr != null) {
                        cfgLog = new JavaLogger();
                    }
                }
                if (cfgLog instanceof JavaLogger) {
                    ((JavaLogger)cfgLog).setWorkDirectory(workDir);
                }
                if (cfgLog instanceof LoggerNodeIdAware) {
                    ((LoggerNodeIdAware)((Object)cfgLog)).setNodeId(nodeId);
                }
                if (log4jInitErr != null) {
                    U.warn(cfgLog, "Failed to initialize Log4JLogger (falling back to standard java logging): " + log4jInitErr.getCause());
                }
                return cfgLog;
            }
            catch (Exception e) {
                throw new IgniteCheckedException("Failed to create logger.", e);
            }
        }

        private static CacheConfiguration marshallerSystemCache() {
            CacheConfiguration cache = new CacheConfiguration();
            cache.setName("ignite-marshaller-sys-cache");
            cache.setCacheMode(CacheMode.REPLICATED);
            cache.setAtomicityMode(CacheAtomicityMode.ATOMIC);
            cache.setSwapEnabled(false);
            cache.setRebalanceMode(CacheRebalanceMode.SYNC);
            cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
            cache.setAffinity(new RendezvousAffinityFunction(false, 20));
            cache.setNodeFilter(CacheConfiguration.ALL_NODES);
            cache.setStartSize(300);
            cache.setRebalanceOrder(-2);
            cache.setCopyOnRead(false);
            return cache;
        }

        private static CacheConfiguration utilitySystemCache() {
            CacheConfiguration cache = new CacheConfiguration();
            cache.setName("ignite-sys-cache");
            cache.setCacheMode(CacheMode.REPLICATED);
            cache.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
            cache.setSwapEnabled(false);
            cache.setRebalanceMode(CacheRebalanceMode.SYNC);
            cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
            cache.setAffinity(new RendezvousAffinityFunction(false, 100));
            cache.setNodeFilter(CacheConfiguration.ALL_NODES);
            cache.setRebalanceOrder(-2);
            cache.setCopyOnRead(false);
            return cache;
        }

        private static CacheConfiguration atomicsSystemCache(AtomicConfiguration cfg) {
            CacheConfiguration ccfg = new CacheConfiguration();
            ccfg.setName("ignite-atomics-sys-cache");
            ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
            ccfg.setSwapEnabled(false);
            ccfg.setRebalanceMode(CacheRebalanceMode.SYNC);
            ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
            ccfg.setCacheMode(cfg.getCacheMode());
            ccfg.setNodeFilter(CacheConfiguration.ALL_NODES);
            ccfg.setRebalanceOrder(-1);
            if (cfg.getCacheMode() == CacheMode.PARTITIONED) {
                ccfg.setBackups(cfg.getBackups());
            }
            return ccfg;
        }

        void stop(boolean cancel) {
            assert (this.startGuard.get());
            this.stop0(cancel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void stop0(boolean cancel) {
            IgniteKernal grid0;
            block12: {
                grid0 = this.grid;
                if (grid0 == null) {
                    if (this.log != null) {
                        U.warn(this.log, "Attempting to stop an already stopped grid instance (ignore): " + this.name);
                    }
                    return;
                }
                if (this.shutdownHook != null) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                        this.shutdownHook = null;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Shutdown hook is removed.");
                        }
                    }
                    catch (IllegalStateException e) {
                        if (!this.log.isDebugEnabled()) break block12;
                        this.log.debug("Shutdown is in progress (ignoring): " + e.getMessage());
                    }
                }
            }
            this.unregisterFactoryMBean();
            try {
                grid0.stop(cancel);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Grid instance stopped ok: " + this.name);
                }
                this.state = grid0.context().segmented() ? IgniteState.STOPPED_ON_SEGMENTATION : IgniteState.STOPPED;
            }
            catch (Throwable e) {
                try {
                    U.error(this.log, "Failed to properly stop grid instance due to undeclared exception.", e);
                    if (e instanceof Error) {
                        throw e;
                    }
                    this.state = grid0.context().segmented() ? IgniteState.STOPPED_ON_SEGMENTATION : IgniteState.STOPPED;
                }
                catch (Throwable throwable) {
                    this.state = grid0.context().segmented() ? IgniteState.STOPPED_ON_SEGMENTATION : IgniteState.STOPPED;
                    this.grid = null;
                    this.stopExecutors(this.log);
                    this.log = null;
                    throw throwable;
                }
                this.grid = null;
                this.stopExecutors(this.log);
                this.log = null;
            }
            this.grid = null;
            this.stopExecutors(this.log);
            this.log = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopExecutors(IgniteLogger log) {
            boolean interrupted = Thread.interrupted();
            try {
                this.stopExecutors0(log);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private void stopExecutors0(IgniteLogger log) {
            assert (log != null);
            U.shutdownNow(this.getClass(), this.execSvc, log);
            this.execSvc = null;
            U.shutdownNow(this.getClass(), this.sysExecSvc, log);
            this.sysExecSvc = null;
            U.shutdownNow(this.getClass(), this.stripedExecSvc, log);
            this.stripedExecSvc = null;
            U.shutdownNow(this.getClass(), this.mgmtExecSvc, log);
            this.mgmtExecSvc = null;
            U.shutdownNow(this.getClass(), this.p2pExecSvc, log);
            this.p2pExecSvc = null;
            U.shutdownNow(this.getClass(), this.igfsExecSvc, log);
            this.igfsExecSvc = null;
            if (this.restExecSvc != null) {
                U.shutdownNow(this.getClass(), this.restExecSvc, log);
            }
            this.restExecSvc = null;
            U.shutdownNow(this.getClass(), this.utilityCacheExecSvc, log);
            this.utilityCacheExecSvc = null;
            U.shutdownNow(this.getClass(), this.marshCacheExecSvc, log);
            this.marshCacheExecSvc = null;
            U.shutdownNow(this.getClass(), this.affExecSvc, log);
            this.affExecSvc = null;
            U.shutdownNow(this.getClass(), this.idxExecSvc, log);
            this.idxExecSvc = null;
            U.shutdownNow(this.getClass(), this.callbackExecSvc, log);
            this.callbackExecSvc = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerFactoryMbean(MBeanServer srv) throws IgniteCheckedException {
            Map<MBeanServer, GridMBeanServerData> map = mbeans;
            synchronized (map) {
                GridMBeanServerData data = mbeans.get(srv);
                if (data == null) {
                    try {
                        IgnitionMXBeanAdapter mbean = new IgnitionMXBeanAdapter();
                        ObjectName objName = U.makeMBeanName(null, "Kernal", Ignition.class.getSimpleName());
                        if (!srv.queryMBeans(objName, null).isEmpty()) {
                            throw new IgniteCheckedException("MBean was already registered: " + objName);
                        }
                        objName = U.registerMBean(srv, null, "Kernal", Ignition.class.getSimpleName(), mbean, IgnitionMXBean.class);
                        data = new GridMBeanServerData(objName);
                        mbeans.put(srv, data);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Registered MBean: " + objName);
                        }
                    }
                    catch (JMException e) {
                        throw new IgniteCheckedException("Failed to register MBean.", e);
                    }
                }
                assert (data != null);
                data.addGrid(this.name);
                data.setCounter(data.getCounter() + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterFactoryMBean() {
            Map<MBeanServer, GridMBeanServerData> map = mbeans;
            synchronized (map) {
                Iterator<Map.Entry<MBeanServer, GridMBeanServerData>> iter = mbeans.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<MBeanServer, GridMBeanServerData> entry = iter.next();
                    if (!entry.getValue().containsGrid(this.name)) continue;
                    GridMBeanServerData data = entry.getValue();
                    assert (data != null);
                    if (data.getCounter() == 1) {
                        try {
                            entry.getKey().unregisterMBean(data.getMbean());
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Unregistered MBean: " + data.getMbean());
                            }
                        }
                        catch (JMException e) {
                            U.error(this.log, "Failed to unregister MBean.", e);
                        }
                        iter.remove();
                        continue;
                    }
                    data.setCounter(data.getCounter() - 1);
                    data.removeGrid(this.name);
                }
            }
        }

        private static class GridMBeanServerData {
            private Collection<String> gridNames = new HashSet<String>();
            private ObjectName mbean;
            private int cnt;

            GridMBeanServerData(ObjectName mbean) {
                assert (mbean != null);
                this.mbean = mbean;
            }

            public void addGrid(String gridName) {
                this.gridNames.add(gridName);
            }

            public void removeGrid(String gridName) {
                this.gridNames.remove(gridName);
            }

            public boolean containsGrid(String gridName) {
                return this.gridNames.contains(gridName);
            }

            public ObjectName getMbean() {
                return this.mbean;
            }

            public int getCounter() {
                return this.cnt;
            }

            public void setCounter(int cnt) {
                this.cnt = cnt;
            }
        }
    }

    private static final class GridStartContext {
        private IgniteConfiguration cfg;
        private URL cfgUrl;
        private GridSpringResourceContext springCtx;
        private boolean single;

        GridStartContext(IgniteConfiguration cfg, @Nullable URL cfgUrl, @Nullable GridSpringResourceContext springCtx) {
            assert (cfg != null);
            this.cfg = cfg;
            this.cfgUrl = cfgUrl;
            this.springCtx = springCtx;
        }

        public boolean single() {
            return this.single;
        }

        public void single(boolean single) {
            this.single = single;
        }

        IgniteConfiguration config() {
            return this.cfg;
        }

        void config(IgniteConfiguration cfg) {
            this.cfg = cfg;
        }

        URL configUrl() {
            return this.cfgUrl;
        }

        void configUrl(URL cfgUrl) {
            this.cfgUrl = cfgUrl;
        }

        public GridSpringResourceContext springContext() {
            return this.springCtx;
        }
    }
}

