/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.MarshallerContext;
import org.apache.ignite.plugin.PluginProvider;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public abstract class MarshallerContextAdapter
implements MarshallerContext {
    private static final String CLS_NAMES_FILE = "META-INF/classnames.properties";
    private static final String JDK_CLS_NAMES_FILE = "META-INF/classnames-jdk.properties";
    private final ConcurrentMap<Integer, String> map = new ConcurrentHashMap8<Integer, String>();
    private final Set<String> registeredSystemTypes = new HashSet<String>();

    public MarshallerContextAdapter(@Nullable List<PluginProvider> plugins) {
        try {
            ClassLoader ldr = U.gridClassLoader();
            Enumeration<URL> urls = ldr.getResources(CLS_NAMES_FILE);
            boolean foundClsNames = false;
            while (urls.hasMoreElements()) {
                this.processResource(urls.nextElement());
                foundClsNames = true;
            }
            if (!foundClsNames) {
                throw new IgniteException("Failed to load class names properties file packaged with ignite binaries [file=META-INF/classnames.properties, ldr=" + ldr + ']');
            }
            URL jdkClsNames = ldr.getResource(JDK_CLS_NAMES_FILE);
            if (jdkClsNames == null) {
                throw new IgniteException("Failed to load class names properties file packaged with ignite binaries [file=META-INF/classnames-jdk.properties, ldr=" + ldr + ']');
            }
            this.processResource(jdkClsNames);
            this.checkHasClassName(GridDhtPartitionFullMap.class.getName(), ldr, CLS_NAMES_FILE);
            this.checkHasClassName(GridDhtPartitionMap2.class.getName(), ldr, CLS_NAMES_FILE);
            this.checkHasClassName(HashMap.class.getName(), ldr, JDK_CLS_NAMES_FILE);
            if (plugins != null && !plugins.isEmpty()) {
                for (PluginProvider plugin : plugins) {
                    URL pluginClsNames = ldr.getResource("META-INF/" + plugin.name().toLowerCase() + ".classnames.properties");
                    if (pluginClsNames == null) continue;
                    this.processResource(pluginClsNames);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to initialize marshaller context.", e);
        }
    }

    public void checkHasClassName(String clsName, ClassLoader ldr, String fileName) {
        if (!this.map.containsKey(clsName.hashCode())) {
            throw new IgniteException("Failed to read class name from class names properties file. Make sure class names properties file packaged with ignite binaries is not corrupted [clsName=" + clsName + ", fileName=" + fileName + ", ldr=" + ldr + ']');
        }
    }

    private void processResource(URL url) throws IOException {
        try (InputStream in = url.openStream();){
            String line;
            BufferedReader rdr = new BufferedReader(new InputStreamReader(in));
            while ((line = rdr.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("#")) continue;
                String clsName = line.trim();
                int typeId = clsName.hashCode();
                String oldClsName = this.map.put(typeId, clsName);
                if (oldClsName != null && !oldClsName.equals(clsName)) {
                    throw new IgniteException("Duplicate type ID [id=" + typeId + ", clsName=" + clsName + ", oldClsName=" + oldClsName + ']');
                }
                this.registeredSystemTypes.add(clsName);
            }
        }
    }

    @Override
    public boolean registerClass(int id, Class cls) throws IgniteCheckedException {
        boolean registered = true;
        String clsName = (String)this.map.get(id);
        if (clsName == null) {
            registered = this.registerClassName(id, cls.getName());
            if (registered) {
                this.map.putIfAbsent(id, cls.getName());
            }
        } else if (!clsName.equals(cls.getName())) {
            throw new IgniteCheckedException("Duplicate ID [id=" + id + ", oldCls=" + clsName + ", newCls=" + cls.getName());
        }
        return registered;
    }

    @Override
    public Class getClass(int id, ClassLoader ldr) throws ClassNotFoundException, IgniteCheckedException {
        String clsName = (String)this.map.get(id);
        if (clsName == null) {
            clsName = this.className(id);
            if (clsName == null) {
                throw new ClassNotFoundException("Unknown type ID: " + id);
            }
            String old = this.map.putIfAbsent(id, clsName);
            if (old != null) {
                clsName = old;
            }
        }
        return U.forName(clsName, ldr);
    }

    @Override
    public boolean isSystemType(String typeName) {
        return this.registeredSystemTypes.contains(typeName);
    }

    protected abstract boolean registerClassName(int var1, String var2) throws IgniteCheckedException;

    protected abstract String className(int var1) throws IgniteCheckedException;
}

