/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.Lock;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryUpdatedListener;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.MarshallerContextAdapter;
import org.apache.ignite.internal.processors.cache.CachePartialUpdateCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheTryPutFailedException;
import org.apache.ignite.internal.util.GridStripedLock;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginProvider;

public class MarshallerContextImpl
extends MarshallerContextAdapter {
    private static final GridStripedLock fileLock = new GridStripedLock(32);
    private final CountDownLatch latch = new CountDownLatch(1);
    private final File workDir;
    private IgniteLogger log;
    private volatile GridCacheAdapter<Integer, String> cache;
    private int failedCnt;
    private ContinuousQueryListener lsnr;

    public MarshallerContextImpl(String igniteWorkDir, List<PluginProvider> plugins) throws IgniteCheckedException {
        super(plugins);
        this.workDir = U.resolveWorkDirectory(igniteWorkDir, "marshaller", false);
    }

    public void onContinuousProcessorStarted(GridKernalContext ctx) throws IgniteCheckedException {
        if (ctx.clientNode()) {
            this.lsnr = new ContinuousQueryListener(ctx.log(MarshallerContextImpl.class), this.workDir);
            ctx.continuous().registerStaticRoutine("ignite-marshaller-sys-cache", this.lsnr, null, null);
        }
    }

    public void onMarshallerCacheStarted(GridKernalContext ctx) throws IgniteCheckedException {
        assert (ctx != null);
        this.log = ctx.log(MarshallerContextImpl.class);
        this.cache = ctx.cache().marshallerCache();
        if (ctx.cache().marshallerCache().context().affinityNode()) {
            ctx.cache().marshallerCache().context().continuousQueries().executeInternalQuery(new ContinuousQueryListener(this.log, this.workDir), null, true, true, false);
        } else if (this.lsnr != null) {
            ctx.closure().runLocalSafe(new Runnable(){

                @Override
                public void run() {
                    try {
                        Iterable<CacheEntryEvent<? extends Integer, ? extends String>> entries = MarshallerContextImpl.this.cache.context().continuousQueries().existingEntries(false, null);
                        MarshallerContextImpl.this.lsnr.onUpdated(entries);
                    }
                    catch (IgniteCheckedException e) {
                        U.error(MarshallerContextImpl.this.log, "Failed to load marshaller cache entries: " + e, e);
                    }
                }
            });
        }
        this.latch.countDown();
    }

    public void onKernalStop() {
        this.latch.countDown();
    }

    @Override
    protected boolean registerClassName(int id, String clsName) throws IgniteCheckedException {
        GridCacheAdapter<Integer, String> cache0 = this.cache;
        if (cache0 == null) {
            return false;
        }
        try {
            String old = cache0.tryGetAndPut(id, clsName);
            if (old != null && !old.equals(clsName)) {
                throw new IgniteCheckedException("Type ID collision detected [id=" + id + ", clsName1=" + clsName + ", clsName2=" + old + ']');
            }
            this.failedCnt = 0;
            return true;
        }
        catch (CachePartialUpdateCheckedException | GridCacheTryPutFailedException ignored) {
            if (++this.failedCnt > 10) {
                if (this.log.isQuiet()) {
                    U.quiet(false, "Failed to register marshalled class for more than 10 times in a row (may affect performance).");
                }
                this.failedCnt = 0;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String className(int id) throws IgniteCheckedException {
        String clsName;
        GridCacheAdapter<Integer, String> cache0 = this.cache;
        if (cache0 == null) {
            U.awaitQuiet(this.latch);
            cache0 = this.cache;
            if (cache0 == null) {
                throw new IllegalStateException("Failed to initialize marshaller context (grid is stopping).");
            }
        }
        if ((clsName = cache0.getTopologySafe(id)) == null) {
            String fileName = id + ".classname";
            Lock lock = MarshallerContextImpl.fileLock(fileName);
            lock.lock();
            try {
                File file = new File(this.workDir, fileName);
                try (FileInputStream in = new FileInputStream(file);){
                    FileLock fileLock = MarshallerContextImpl.fileLock(in.getChannel(), true);
                    assert (fileLock != null) : fileName;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));){
                        clsName = reader.readLine();
                    }
                }
                catch (IOException ignored) {
                    throw new IgniteCheckedException("Class definition was not found at marshaller cache and local file. [id=" + id + ", file=" + file.getAbsolutePath() + ']');
                }
            }
            finally {
                lock.unlock();
            }
            this.registerClassName(id, clsName);
        }
        return clsName;
    }

    private static Lock fileLock(String fileName) {
        return fileLock.getLock(fileName.hashCode());
    }

    private static FileLock fileLock(FileChannel ch, boolean shared) throws IOException, IgniteInterruptedCheckedException {
        FileLock fileLock;
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        while ((fileLock = ch.tryLock(0L, Long.MAX_VALUE, shared)) == null) {
            U.sleep(rnd.nextLong(50L));
        }
        return fileLock;
    }

    public static class ContinuousQueryListener
    implements CacheEntryUpdatedListener<Integer, String> {
        private final IgniteLogger log;
        private final File workDir;

        public ContinuousQueryListener(IgniteLogger log, File workDir) {
            this.log = log;
            this.workDir = workDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUpdated(Iterable<CacheEntryEvent<? extends Integer, ? extends String>> evts) throws CacheEntryListenerException {
            for (CacheEntryEvent<? extends Integer, ? extends String> evt : evts) {
                assert (evt.getOldValue() == null || F.eq(evt.getOldValue(), evt.getValue())) : "Received cache entry update for system marshaller cache: " + evt;
                if (evt.getOldValue() != null) continue;
                String fileName = evt.getKey() + ".classname";
                Lock lock = MarshallerContextImpl.fileLock(fileName);
                lock.lock();
                try {
                    File file = new File(this.workDir, fileName);
                    try {
                        FileOutputStream out = new FileOutputStream(file);
                        Throwable throwable = null;
                        try {
                            FileLock fileLock = MarshallerContextImpl.fileLock(out.getChannel(), false);
                            assert (fileLock != null) : fileName;
                            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
                            Throwable throwable2 = null;
                            try {
                                writer.write((String)evt.getValue());
                                ((Writer)writer).flush();
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (writer == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        ((Writer)writer).close();
                                    }
                                    catch (Throwable x2) {
                                        throwable2.addSuppressed(x2);
                                    }
                                    continue;
                                }
                                ((Writer)writer).close();
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (out == null) continue;
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            out.close();
                        }
                    }
                    catch (IOException e) {
                        U.error(this.log, "Failed to write class name to file [id=" + evt.getKey() + ", clsName=" + (String)evt.getValue() + ", file=" + file.getAbsolutePath() + ']', e);
                    }
                    catch (OverlappingFileLockException ignored) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("File already locked (will ignore): " + file.getAbsolutePath());
                    }
                    catch (IgniteInterruptedCheckedException e) {
                        U.error(this.log, "Interrupted while waiting for acquiring file lock: " + file, e);
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }
}

