/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.util.HashMap;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryMetadataHandler;
import org.apache.ignite.internal.binary.BinaryTypeImpl;
import org.apache.ignite.internal.binary.BinaryUtils;

public class BinaryCachingMetadataHandler
implements BinaryMetadataHandler {
    private final HashMap<Integer, BinaryType> metas = new HashMap();

    public static BinaryCachingMetadataHandler create() {
        return new BinaryCachingMetadataHandler();
    }

    private BinaryCachingMetadataHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addMeta(int typeId, BinaryType type) throws BinaryObjectException {
        BinaryCachingMetadataHandler binaryCachingMetadataHandler = this;
        synchronized (binaryCachingMetadataHandler) {
            BinaryType oldType = this.metas.put(typeId, type);
            if (oldType != null) {
                BinaryMetadata oldMeta = ((BinaryTypeImpl)oldType).metadata();
                BinaryMetadata newMeta = ((BinaryTypeImpl)type).metadata();
                BinaryMetadata mergedMeta = BinaryUtils.mergeMetadata(oldMeta, newMeta);
                BinaryTypeImpl mergedType = mergedMeta.wrap(((BinaryTypeImpl)oldType).context());
                this.metas.put(typeId, mergedType);
            }
        }
    }

    @Override
    public synchronized BinaryType metadata(int typeId) throws BinaryObjectException {
        return this.metas.get(typeId);
    }
}

