/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import org.apache.ignite.binary.BinaryField;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryObjectExImpl;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinarySchemaRegistry;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class BinaryFieldImpl
implements BinaryField {
    private final int typeId;
    @GridToStringExclude
    private final BinarySchemaRegistry schemas;
    private final String fieldName;
    private final int fieldId;

    public BinaryFieldImpl(int typeId, BinarySchemaRegistry schemas, String fieldName, int fieldId) {
        assert (typeId != 0);
        assert (schemas != null);
        assert (fieldId != 0);
        this.typeId = typeId;
        this.schemas = schemas;
        this.fieldName = fieldName;
        this.fieldId = fieldId;
    }

    @Override
    public String name() {
        return this.fieldName;
    }

    public int fieldId() {
        return this.fieldId;
    }

    @Override
    public boolean exists(BinaryObject obj) {
        BinaryObjectExImpl obj0 = (BinaryObjectExImpl)obj;
        return this.fieldOrder(obj0) != -1;
    }

    @Override
    public <T> T value(BinaryObject obj) {
        BinaryObjectExImpl obj0 = (BinaryObjectExImpl)obj;
        int order = this.fieldOrder(obj0);
        return order != -1 ? (T)obj0.fieldByOrder(order) : null;
    }

    public int fieldOrder(BinaryObjectExImpl obj) {
        if (this.typeId != obj.typeId()) {
            throw new BinaryObjectException("Failed to get field because type ID of passed object differs from type ID this " + BinaryField.class.getSimpleName() + " belongs to [expected=" + this.typeId + ", actual=" + obj.typeId() + ']');
        }
        int schemaId = obj.schemaId();
        BinarySchema schema = this.schemas.schema(schemaId);
        if (schema == null) {
            schema = obj.createSchema();
            this.schemas.addSchema(schemaId, schema);
        }
        assert (schema != null);
        return schema.order(this.fieldId);
    }

    public String toString() {
        return S.toString(BinaryFieldImpl.class, this);
    }
}

