/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinaryTypeImpl;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class BinaryMetadata
implements Externalizable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude(sensitive=true)
    private int typeId;
    @GridToStringInclude(sensitive=true)
    private String typeName;
    @GridToStringInclude(sensitive=true)
    private Map<String, Integer> fields;
    @GridToStringInclude(sensitive=true)
    private String affKeyFieldName;
    private Collection<BinarySchema> schemas;
    private boolean isEnum;

    public BinaryMetadata() {
    }

    public BinaryMetadata(int typeId, String typeName, @Nullable Map<String, Integer> fields, @Nullable String affKeyFieldName, @Nullable Collection<BinarySchema> schemas, boolean isEnum) {
        assert (typeName != null);
        this.typeId = typeId;
        this.typeName = typeName;
        this.fields = fields;
        this.affKeyFieldName = affKeyFieldName;
        this.schemas = schemas;
        this.isEnum = isEnum;
    }

    public int typeId() {
        return this.typeId;
    }

    public String typeName() {
        return this.typeName;
    }

    public Collection<String> fields() {
        return this.fields != null ? this.fields.keySet() : Collections.emptyList();
    }

    public Map<String, Integer> fieldsMap() {
        return this.fields != null ? this.fields : Collections.emptyMap();
    }

    @Nullable
    public String fieldTypeName(String fieldName) {
        Integer typeId = this.fields != null ? this.fields.get(fieldName) : null;
        return typeId != null ? BinaryUtils.fieldTypeName(typeId) : null;
    }

    @Nullable
    public String affinityKeyFieldName() {
        return this.affKeyFieldName;
    }

    public Collection<BinarySchema> schemas() {
        return this.schemas != null ? this.schemas : Collections.emptyList();
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public BinaryTypeImpl wrap(BinaryContext ctx) {
        return new BinaryTypeImpl(ctx, this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeTo(out);
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeInt(this.typeId);
        U.writeString(out, this.typeName);
        if (this.fields == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.fields.size());
            for (Map.Entry<String, Integer> fieldEntry : this.fields.entrySet()) {
                U.writeString(out, fieldEntry.getKey());
                out.writeInt(fieldEntry.getValue());
            }
        }
        U.writeString(out, this.affKeyFieldName);
        if (this.schemas == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.schemas.size());
            for (BinarySchema schema : this.schemas) {
                schema.writeTo(out);
            }
        }
        out.writeBoolean(this.isEnum);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readFrom(in);
    }

    public void readFrom(DataInput in) throws IOException {
        this.typeId = in.readInt();
        this.typeName = U.readString(in);
        int fieldsSize = in.readInt();
        if (fieldsSize == -1) {
            this.fields = null;
        } else {
            this.fields = new HashMap<String, Integer>();
            for (int i = 0; i < fieldsSize; ++i) {
                String fieldName = U.readString(in);
                int fieldId = in.readInt();
                this.fields.put(fieldName, fieldId);
            }
        }
        this.affKeyFieldName = U.readString(in);
        int schemasSize = in.readInt();
        if (schemasSize == -1) {
            this.schemas = null;
        } else {
            this.schemas = new ArrayList<BinarySchema>();
            for (int i = 0; i < schemasSize; ++i) {
                BinarySchema schema = new BinarySchema();
                schema.readFrom(in);
                this.schemas.add(schema);
            }
        }
        this.isEnum = in.readBoolean();
    }

    public String toString() {
        return S.toString(BinaryMetadata.class, this);
    }
}

