/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.internal.binary.BinaryInternalMapper;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriteMode;
import org.jetbrains.annotations.Nullable;

class BinaryMetadataCollector
implements BinaryWriter {
    private final int typeId;
    private final String typeName;
    private final BinaryInternalMapper mapper;
    private final Map<String, Integer> meta = new HashMap<String, Integer>();
    private BinarySchema.Builder schemaBuilder = BinarySchema.Builder.newBuilder();

    BinaryMetadataCollector(int typeId, String typeName, BinaryInternalMapper mapper) {
        this.typeId = typeId;
        this.typeName = typeName;
        this.mapper = mapper;
    }

    Map<String, Integer> meta() {
        return this.meta;
    }

    BinarySchema schema() {
        return this.schemaBuilder.build();
    }

    @Override
    public void writeByte(String fieldName, byte val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.BYTE);
    }

    @Override
    public void writeShort(String fieldName, short val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.SHORT);
    }

    @Override
    public void writeInt(String fieldName, int val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.INT);
    }

    @Override
    public void writeLong(String fieldName, long val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.LONG);
    }

    @Override
    public void writeFloat(String fieldName, float val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.FLOAT);
    }

    @Override
    public void writeDouble(String fieldName, double val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.DOUBLE);
    }

    @Override
    public void writeChar(String fieldName, char val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.CHAR);
    }

    @Override
    public void writeBoolean(String fieldName, boolean val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.BOOLEAN);
    }

    @Override
    public void writeDecimal(String fieldName, @Nullable BigDecimal val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.DECIMAL);
    }

    @Override
    public void writeString(String fieldName, @Nullable String val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.STRING);
    }

    @Override
    public void writeUuid(String fieldName, @Nullable UUID val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.UUID);
    }

    @Override
    public void writeDate(String fieldName, @Nullable Date val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.DATE);
    }

    @Override
    public void writeTimestamp(String fieldName, @Nullable Timestamp val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.TIMESTAMP);
    }

    @Override
    public <T extends Enum<?>> void writeEnum(String fieldName, T val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.ENUM);
    }

    @Override
    public <T extends Enum<?>> void writeEnumArray(String fieldName, T[] val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.ENUM_ARR);
    }

    @Override
    public void writeObject(String fieldName, @Nullable Object obj) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.OBJECT);
    }

    @Override
    public void writeByteArray(String fieldName, @Nullable byte[] val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.BYTE_ARR);
    }

    @Override
    public void writeShortArray(String fieldName, @Nullable short[] val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.SHORT_ARR);
    }

    @Override
    public void writeIntArray(String fieldName, @Nullable int[] val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.INT_ARR);
    }

    @Override
    public void writeLongArray(String fieldName, @Nullable long[] val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.LONG_ARR);
    }

    @Override
    public void writeFloatArray(String fieldName, @Nullable float[] val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.FLOAT_ARR);
    }

    @Override
    public void writeDoubleArray(String fieldName, @Nullable double[] val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.DOUBLE_ARR);
    }

    @Override
    public void writeCharArray(String fieldName, @Nullable char[] val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.CHAR_ARR);
    }

    @Override
    public void writeBooleanArray(String fieldName, @Nullable boolean[] val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.BOOLEAN_ARR);
    }

    @Override
    public void writeDecimalArray(String fieldName, @Nullable BigDecimal[] val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.DECIMAL_ARR);
    }

    @Override
    public void writeStringArray(String fieldName, @Nullable String[] val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.STRING_ARR);
    }

    @Override
    public void writeUuidArray(String fieldName, @Nullable UUID[] val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.UUID_ARR);
    }

    @Override
    public void writeDateArray(String fieldName, @Nullable Date[] val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.DATE_ARR);
    }

    @Override
    public void writeTimestampArray(String fieldName, @Nullable Timestamp[] val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.TIMESTAMP_ARR);
    }

    @Override
    public void writeObjectArray(String fieldName, @Nullable Object[] val) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.OBJECT_ARR);
    }

    @Override
    public <T> void writeCollection(String fieldName, @Nullable Collection<T> col) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.COL);
    }

    @Override
    public <K, V> void writeMap(String fieldName, @Nullable Map<K, V> map) throws BinaryObjectException {
        this.add(fieldName, BinaryWriteMode.MAP);
    }

    @Override
    public BinaryRawWriter rawWriter() {
        return (BinaryRawWriter)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{BinaryRawWriterEx.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method mtd, Object[] args) throws Throwable {
                return null;
            }
        });
    }

    private void add(String name, BinaryWriteMode mode) throws BinaryObjectException {
        assert (name != null);
        int fieldTypeId = mode.typeId();
        Integer oldFieldTypeId = this.meta.put(name, fieldTypeId);
        if (oldFieldTypeId != null && !oldFieldTypeId.equals(fieldTypeId)) {
            throw new BinaryObjectException("Field is written twice with different types [typeName=" + this.typeName + ", fieldName=" + name + ", fieldTypeName1=" + BinaryUtils.fieldTypeName(oldFieldTypeId) + ", fieldTypeName2=" + BinaryUtils.fieldTypeName(fieldTypeId) + ']');
        }
        this.schemaBuilder.addField(this.mapper.fieldId(this.typeId, name));
    }
}

