/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryArrayIdentityResolver;
import org.apache.ignite.binary.BinaryIdentityResolver;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.binary.BinaryReaderHandles;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinarySerializedFieldComparator;
import org.apache.ignite.internal.binary.builder.BinaryObjectBuilderImpl;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public abstract class BinaryObjectExImpl
implements BinaryObjectEx {
    public abstract int length();

    public abstract int start();

    public abstract boolean hasArray();

    public abstract byte[] array();

    public abstract long offheapAddress();

    @Nullable
    public abstract <F> F field(int var1) throws BinaryObjectException;

    @Override
    public int enumOrdinal() throws BinaryObjectException {
        throw new BinaryObjectException("Object is not enum.");
    }

    public abstract int dataStartOffset();

    public abstract int footerStartOffset();

    @Nullable
    public abstract <F> F fieldByOrder(int var1);

    public abstract BinarySerializedFieldComparator createFieldComparator();

    @Nullable
    protected abstract <F> F field(BinaryReaderHandles var1, String var2);

    public abstract boolean hasSchema();

    public abstract int schemaId();

    public abstract BinarySchema createSchema();

    public abstract BinaryContext context();

    @Override
    public BinaryObjectBuilder toBuilder() throws BinaryObjectException {
        return BinaryObjectBuilderImpl.wrap(this);
    }

    @Override
    public BinaryObject clone() throws CloneNotSupportedException {
        return (BinaryObject)super.clone();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BinaryObject)) {
            return false;
        }
        BinaryIdentityResolver identity = this.context().identity(this.typeId());
        if (identity == null) {
            identity = BinaryArrayIdentityResolver.instance();
        }
        return identity.equals(this, (BinaryObject)other);
    }

    public String toString() {
        try {
            BinaryReaderHandles ctx = new BinaryReaderHandles();
            ctx.put(this.start(), this);
            return this.toString(ctx, new IdentityHashMap<BinaryObject, Integer>());
        }
        catch (BinaryObjectException e) {
            throw new IgniteException("Failed to create string representation of binary object.", e);
        }
    }

    private String toString(BinaryReaderHandles ctx, IdentityHashMap<BinaryObject, Integer> handles) {
        BinaryType meta;
        int idHash = System.identityHashCode(this);
        int hash = this.hashCode();
        try {
            meta = this.rawType();
        }
        catch (BinaryObjectException ignore) {
            meta = null;
        }
        if (meta == null || !S.INCLUDE_SENSITIVE) {
            return S.toString(S.INCLUDE_SENSITIVE ? BinaryObject.class.getSimpleName() : "BinaryObject", "idHash", idHash, false, "hash", (Object)hash, false, "typeId", this.typeId(), true);
        }
        handles.put(this, idHash);
        SB buf = new SB(meta.typeName());
        if (meta.fieldNames() != null) {
            buf.a(" [idHash=").a(idHash).a(", hash=").a(hash);
            for (String name : meta.fieldNames()) {
                Object val = this.field(ctx, name);
                buf.a(", ").a(name).a('=');
                this.appendValue(val, buf, ctx, handles);
            }
            buf.a(']');
        }
        return buf.toString();
    }

    private void appendValue(Object val, SB buf, BinaryReaderHandles ctx, IdentityHashMap<BinaryObject, Integer> handles) {
        if (val instanceof byte[]) {
            buf.a(Arrays.toString((byte[])val));
        } else if (val instanceof short[]) {
            buf.a(Arrays.toString((short[])val));
        } else if (val instanceof int[]) {
            buf.a(Arrays.toString((int[])val));
        } else if (val instanceof long[]) {
            buf.a(Arrays.toString((long[])val));
        } else if (val instanceof float[]) {
            buf.a(Arrays.toString((float[])val));
        } else if (val instanceof double[]) {
            buf.a(Arrays.toString((double[])val));
        } else if (val instanceof char[]) {
            buf.a(Arrays.toString((char[])val));
        } else if (val instanceof boolean[]) {
            buf.a(Arrays.toString((boolean[])val));
        } else if (val instanceof BigDecimal[]) {
            buf.a(Arrays.toString((BigDecimal[])val));
        } else if (val instanceof IgniteUuid) {
            buf.a(val);
        } else if (val instanceof BinaryObjectExImpl) {
            BinaryObjectExImpl po = (BinaryObjectExImpl)val;
            Integer idHash0 = handles.get(val);
            if (idHash0 != null) {
                BinaryType meta0 = po.rawType();
                assert (meta0 != null);
                buf.a(meta0.typeName()).a(" [hash=").a(idHash0).a(", ...]");
            } else {
                buf.a(po.toString(ctx, handles));
            }
        } else if (val instanceof Object[]) {
            Object[] arr = (Object[])val;
            buf.a('[');
            for (int i = 0; i < arr.length; ++i) {
                Object o = arr[i];
                this.appendValue(o, buf, ctx, handles);
                if (i >= arr.length - 1) continue;
                buf.a(", ");
            }
        } else if (val instanceof Iterable) {
            Iterable col = (Iterable)val;
            buf.a(col.getClass().getSimpleName()).a(" {");
            Iterator it = col.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                this.appendValue(o, buf, ctx, handles);
                if (!it.hasNext()) continue;
                buf.a(", ");
            }
            buf.a('}');
        } else if (val instanceof Map) {
            Map map = (Map)val;
            buf.a(map.getClass().getSimpleName()).a(" {");
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                this.appendValue(e.getKey(), buf, ctx, handles);
                buf.a('=');
                this.appendValue(e.getValue(), buf, ctx, handles);
                if (!it.hasNext()) continue;
                buf.a(", ");
            }
            buf.a('}');
        } else {
            buf.a(val);
        }
    }
}

