/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Date;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.IgniteCodeGeneratingFail;
import org.apache.ignite.internal.binary.BinaryClassDescriptor;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryObjectExImpl;
import org.apache.ignite.internal.binary.BinaryPrimitives;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryReaderHandles;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinarySerializedFieldComparator;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

@IgniteCodeGeneratingFail
public final class BinaryObjectImpl
extends BinaryObjectExImpl
implements Externalizable,
KeyCacheObject {
    private static final long serialVersionUID = 0L;
    @GridDirectTransient
    private BinaryContext ctx;
    private byte[] arr;
    private int start;
    @GridDirectTransient
    private Object obj;
    @GridDirectTransient
    private boolean detachAllowed;
    @GridDirectTransient
    private int part = -1;

    public BinaryObjectImpl() {
    }

    public BinaryObjectImpl(BinaryContext ctx, byte[] arr, int start) {
        assert (ctx != null);
        assert (arr != null);
        this.ctx = ctx;
        this.arr = arr;
        this.start = start;
    }

    @Override
    public KeyCacheObject copy(int part) {
        if (this.part == part) {
            return this;
        }
        BinaryObjectImpl cp = new BinaryObjectImpl(this.ctx, this.arr, this.start);
        cp.part = part;
        return cp;
    }

    @Override
    public int partition() {
        return this.part;
    }

    @Override
    public void partition(int part) {
        this.part = part;
    }

    @Override
    public byte cacheObjectType() {
        return 100;
    }

    @Override
    public boolean isPlatformType() {
        return false;
    }

    @Override
    public boolean internal() {
        return false;
    }

    @Override
    @Nullable
    public <T> T value(CacheObjectContext ctx, boolean cpy) {
        Object obj0 = this.obj;
        if (obj0 == null || cpy && this.needCopy(ctx)) {
            obj0 = this.deserializeValue(ctx);
        }
        return (T)obj0;
    }

    @Override
    public byte[] valueBytes(CacheObjectContext ctx) throws IgniteCheckedException {
        if (this.detached()) {
            return this.array();
        }
        int len = this.length();
        byte[] arr0 = new byte[len];
        U.arrayCopy(this.arr, this.start, arr0, 0, len);
        return arr0;
    }

    @Override
    public CacheObject prepareForCache(CacheObjectContext ctx) {
        if (this.detached()) {
            return this;
        }
        return (BinaryObjectImpl)this.detach();
    }

    @Override
    public void finishUnmarshal(CacheObjectContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        this.ctx = ((CacheObjectBinaryProcessorImpl)ctx.processor()).binaryContext();
    }

    @Override
    public void prepareMarshal(CacheObjectContext ctx) throws IgniteCheckedException {
    }

    @Override
    public int length() {
        return BinaryPrimitives.readInt(this.arr, this.start + 12);
    }

    public BinaryObject detach() {
        if (!this.detachAllowed || this.detached()) {
            return this;
        }
        int len = this.length();
        byte[] arr0 = new byte[len];
        U.arrayCopy(this.arr, this.start, arr0, 0, len);
        return new BinaryObjectImpl(this.ctx, arr0, 0);
    }

    public boolean detached() {
        return this.start == 0 && this.length() == this.arr.length;
    }

    public void detachAllowed(boolean detachAllowed) {
        this.detachAllowed = detachAllowed;
    }

    @Override
    public BinaryContext context() {
        return this.ctx;
    }

    public void context(BinaryContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public byte[] array() {
        return this.arr;
    }

    @Override
    public int start() {
        return this.start;
    }

    @Override
    public long offheapAddress() {
        return 0L;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public boolean isFlagSet(short flag) {
        short flags = BinaryPrimitives.readShort(this.arr, this.start + 2);
        return BinaryUtils.isFlagSet(flags, flag);
    }

    @Override
    public int typeId() {
        int off = this.start + 4;
        int typeId = BinaryPrimitives.readInt(this.arr, off);
        if (typeId == 0) {
            off = this.start + 24;
            assert (this.arr[off] == 9) : this.arr[off];
            int len = BinaryPrimitives.readInt(this.arr, ++off);
            String clsName = new String(this.arr, off + 4, len, StandardCharsets.UTF_8);
            typeId = this.ctx.typeId(clsName);
        }
        return typeId;
    }

    @Override
    @Nullable
    public BinaryType type() throws BinaryObjectException {
        return BinaryUtils.typeProxy(this.ctx, this);
    }

    @Override
    @Nullable
    public BinaryType rawType() throws BinaryObjectException {
        return BinaryUtils.type(this.ctx, this);
    }

    @Override
    @Nullable
    public <F> F field(String fieldName) throws BinaryObjectException {
        return (F)this.reader(null, false).unmarshalField(fieldName);
    }

    @Override
    @Nullable
    public <F> F field(int fieldId) throws BinaryObjectException {
        return (F)this.reader(null, false).unmarshalField(fieldId);
    }

    @Override
    public BinarySerializedFieldComparator createFieldComparator() {
        int schemaOff = BinaryPrimitives.readInt(this.arr, this.start + 20);
        short flags = BinaryPrimitives.readShort(this.arr, this.start + 2);
        int fieldIdLen = BinaryUtils.isCompactFooter(flags) ? 0 : 4;
        int fieldOffLen = BinaryUtils.fieldOffsetLength(flags);
        int orderBase = this.start + schemaOff + fieldIdLen;
        int orderMultiplier = fieldIdLen + fieldOffLen;
        return new BinarySerializedFieldComparator(this, this.arr, 0L, this.start, orderBase, orderMultiplier, fieldOffLen);
    }

    @Override
    public int dataStartOffset() {
        int typeId = BinaryPrimitives.readInt(this.arr, this.start + 4);
        if (typeId == 0) {
            int len = BinaryPrimitives.readInt(this.arr, this.start + 24 + 1);
            return this.start + 24 + len + 5;
        }
        return this.start + 24;
    }

    @Override
    public int footerStartOffset() {
        short flags = BinaryPrimitives.readShort(this.arr, this.start + 2);
        if (!BinaryUtils.hasSchema(flags)) {
            return this.start + this.length();
        }
        return this.start + BinaryPrimitives.readInt(this.arr, this.start + 20);
    }

    @Override
    @Nullable
    public <F> F fieldByOrder(int order) {
        Object val;
        if (order == -1) {
            return null;
        }
        int schemaOff = BinaryPrimitives.readInt(this.arr, this.start + 20);
        short flags = BinaryPrimitives.readShort(this.arr, this.start + 2);
        int fieldIdLen = BinaryUtils.isCompactFooter(flags) ? 0 : 4;
        int fieldOffLen = BinaryUtils.fieldOffsetLength(flags);
        int fieldOffsetPos = this.start + schemaOff + order * (fieldIdLen + fieldOffLen) + fieldIdLen;
        int fieldPos = fieldOffLen == 1 ? this.start + (BinaryPrimitives.readByte(this.arr, fieldOffsetPos) & 0xFF) : (fieldOffLen == 2 ? this.start + (BinaryPrimitives.readShort(this.arr, fieldOffsetPos) & 0xFFFF) : this.start + BinaryPrimitives.readInt(this.arr, fieldOffsetPos));
        byte hdr = BinaryPrimitives.readByte(this.arr, fieldPos);
        switch (hdr) {
            case 3: {
                val = BinaryPrimitives.readInt(this.arr, fieldPos + 1);
                break;
            }
            case 4: {
                val = BinaryPrimitives.readLong(this.arr, fieldPos + 1);
                break;
            }
            case 8: {
                val = BinaryPrimitives.readBoolean(this.arr, fieldPos + 1);
                break;
            }
            case 2: {
                val = BinaryPrimitives.readShort(this.arr, fieldPos + 1);
                break;
            }
            case 1: {
                val = BinaryPrimitives.readByte(this.arr, fieldPos + 1);
                break;
            }
            case 7: {
                val = Character.valueOf(BinaryPrimitives.readChar(this.arr, fieldPos + 1));
                break;
            }
            case 5: {
                val = Float.valueOf(BinaryPrimitives.readFloat(this.arr, fieldPos + 1));
                break;
            }
            case 6: {
                val = BinaryPrimitives.readDouble(this.arr, fieldPos + 1);
                break;
            }
            case 9: {
                int dataLen = BinaryPrimitives.readInt(this.arr, fieldPos + 1);
                val = new String(this.arr, fieldPos + 5, dataLen, StandardCharsets.UTF_8);
                break;
            }
            case 11: {
                long time = BinaryPrimitives.readLong(this.arr, fieldPos + 1);
                val = new Date(time);
                break;
            }
            case 33: {
                long time = BinaryPrimitives.readLong(this.arr, fieldPos + 1);
                int nanos = BinaryPrimitives.readInt(this.arr, fieldPos + 1 + 8);
                Timestamp ts = new Timestamp(time);
                ts.setNanos(ts.getNanos() + nanos);
                val = ts;
                break;
            }
            case 10: {
                long most = BinaryPrimitives.readLong(this.arr, fieldPos + 1);
                long least = BinaryPrimitives.readLong(this.arr, fieldPos + 1 + 8);
                val = new UUID(most, least);
                break;
            }
            case 30: {
                int scale = BinaryPrimitives.readInt(this.arr, fieldPos + 1);
                int dataLen = BinaryPrimitives.readInt(this.arr, fieldPos + 5);
                byte[] data = BinaryPrimitives.readByteArray(this.arr, fieldPos + 9, dataLen);
                BigInteger intVal = new BigInteger(data);
                if (scale < 0) {
                    scale &= Integer.MAX_VALUE;
                    intVal = intVal.negate();
                }
                val = new BigDecimal(intVal, scale);
                break;
            }
            case 101: {
                val = null;
                break;
            }
            default: {
                val = BinaryUtils.unmarshal(BinaryHeapInputStream.create(this.arr, fieldPos), this.ctx, null);
            }
        }
        return (F)val;
    }

    @Override
    @Nullable
    protected <F> F field(BinaryReaderHandles rCtx, String fieldName) {
        return (F)this.reader(rCtx, false).unmarshalField(fieldName);
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.reader(null, false).findFieldByName(fieldName);
    }

    @Override
    @Nullable
    public <T> T deserialize() throws BinaryObjectException {
        Object obj0 = this.obj;
        if (obj0 == null) {
            obj0 = this.deserializeValue(null);
        }
        return (T)obj0;
    }

    @Override
    public BinaryObject clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int hashCode() {
        return BinaryPrimitives.readInt(this.arr, this.start + 8);
    }

    @Override
    public boolean hasSchema() {
        short flags = BinaryPrimitives.readShort(this.arr, this.start + 2);
        return BinaryUtils.hasSchema(flags);
    }

    @Override
    public int schemaId() {
        return BinaryPrimitives.readInt(this.arr, this.start + 16);
    }

    @Override
    public BinarySchema createSchema() {
        return this.reader(null, false).getOrCreateSchema();
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.detachAllowed) {
            int len = this.length();
            out.writeInt(len);
            out.write(this.arr, this.start, len);
            out.writeInt(0);
        } else {
            out.writeInt(this.arr.length);
            out.write(this.arr);
            out.writeInt(this.start);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ctx = GridBinaryMarshaller.threadLocalContext();
        this.arr = new byte[in.readInt()];
        in.readFully(this.arr);
        this.start = in.readInt();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("arr", this.arr, this.detachAllowed ? (long)this.start : 0L, this.detachAllowed ? this.length() : this.arr.length)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeInt("start", this.detachAllowed ? 0 : this.start)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.arr = reader.readByteArray("arr");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.start = reader.readInt("start");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return true;
    }

    @Override
    public byte directType() {
        return 113;
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }

    private Object deserializeValue(@Nullable CacheObjectContext coCtx) {
        BinaryReaderExImpl reader = this.reader(null, coCtx != null ? coCtx.kernalContext().config().getClassLoader() : this.ctx.configuration().getClassLoader(), true);
        Object obj0 = reader.deserialize();
        BinaryClassDescriptor desc = reader.descriptor();
        assert (desc != null);
        if (coCtx != null && coCtx.storeValue()) {
            this.obj = obj0;
        }
        return obj0;
    }

    private boolean needCopy(CacheObjectContext ctx) {
        return ctx.copyOnGet() && this.obj != null && !ctx.processor().immutable(this.obj);
    }

    private BinaryReaderExImpl reader(@Nullable BinaryReaderHandles rCtx, @Nullable ClassLoader ldr, boolean forUnmarshal) {
        if (ldr == null) {
            ldr = this.ctx.configuration().getClassLoader();
        }
        return new BinaryReaderExImpl(this.ctx, BinaryHeapInputStream.create(this.arr, this.start), ldr, rCtx, forUnmarshal);
    }

    private BinaryReaderExImpl reader(@Nullable BinaryReaderHandles rCtx, boolean forUnmarshal) {
        return this.reader(rCtx, null, forUnmarshal);
    }

    @Override
    public String toString() {
        if (this.arr == null || this.ctx == null) {
            return "BinaryObjectImpl [arr= " + (this.arr != null) + ", ctx=" + (this.ctx != null) + ", start=" + this.start + "]";
        }
        return super.toString();
    }
}

