/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.util.Collection;
import org.apache.ignite.binary.BinaryField;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class BinaryTypeProxy
implements BinaryType {
    @GridToStringExclude
    private final BinaryContext ctx;
    private int typeId;
    private final String clsName;
    @GridToStringExclude
    private volatile BinaryType target;

    public BinaryTypeProxy(BinaryContext ctx, int typeId, @Nullable String clsName) {
        this.ctx = ctx;
        this.typeId = typeId;
        this.clsName = clsName;
    }

    @Override
    public int typeId() {
        return this.typeId;
    }

    @Override
    public BinaryField field(String fieldName) {
        return this.ctx.createField(this.typeId, fieldName);
    }

    @Override
    public String typeName() {
        return this.target().typeName();
    }

    @Override
    public Collection<String> fieldNames() {
        return this.target().fieldNames();
    }

    @Override
    public String fieldTypeName(String fieldName) {
        return this.target().fieldTypeName(fieldName);
    }

    @Override
    public String affinityKeyFieldName() {
        return this.target().affinityKeyFieldName();
    }

    @Override
    public boolean isEnum() {
        return this.target().isEnum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryType target() {
        if (this.target == null) {
            BinaryTypeProxy binaryTypeProxy = this;
            synchronized (binaryTypeProxy) {
                if (this.target == null) {
                    if (this.typeId == 0 && this.clsName != null) {
                        this.typeId = this.ctx.typeId(this.clsName);
                    }
                    this.target = this.ctx.metadata(this.typeId);
                    if (this.target == null) {
                        throw new BinaryObjectException("Failed to get binary type details [typeId=" + this.typeId + ']');
                    }
                }
            }
        }
        return this.target;
    }

    public String toString() {
        return S.toString(BinaryTypeProxy.class, this);
    }
}

