/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.binary.BinaryCollectionFactory;
import org.apache.ignite.binary.BinaryInvalidTypeException;
import org.apache.ignite.binary.BinaryMapFactory;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryEnumCache;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.binary.BinaryObjectExImpl;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.binary.BinaryObjectOffheapImpl;
import org.apache.ignite.internal.binary.BinaryPositionReadable;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryReaderHandlesHolder;
import org.apache.ignite.internal.binary.BinaryReaderHandlesHolderImpl;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinaryTreeMapWriteReplacer;
import org.apache.ignite.internal.binary.BinaryTreeSetWriteReplacer;
import org.apache.ignite.internal.binary.BinaryTypeProxy;
import org.apache.ignite.internal.binary.BinaryWriteMode;
import org.apache.ignite.internal.binary.BinaryWriteReplacer;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.builder.BinaryLazyValue;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class BinaryUtils {
    public static final Map<Class<?>, Byte> PLAIN_CLASS_TO_FLAG = new HashMap();
    public static final Map<Byte, Class<?>> FLAG_TO_CLASS = new HashMap();
    public static final boolean USE_STR_SERIALIZATION_VER_2 = IgniteSystemProperties.getBoolean("IGNITE_BINARY_MARSHALLER_USE_STRING_SERIALIZATION_VER_2", false);
    public static final Map<Class, BinaryWriteReplacer> CLS_TO_WRITE_REPLACER = new HashMap<Class, BinaryWriteReplacer>();
    private static final boolean[] PLAIN_TYPE_FLAG = new boolean[102];
    private static final Collection<Class<?>> BINARY_CLS = new HashSet();
    public static final short FLAG_USR_TYP = 1;
    public static final short FLAG_HAS_SCHEMA = 2;
    public static final short FLAG_HAS_RAW = 4;
    public static final short FLAG_OFFSET_ONE_BYTE = 8;
    public static final short FLAG_OFFSET_TWO_BYTES = 16;
    public static final short FLAG_COMPACT_FOOTER = 32;
    public static final short FLAG_EMPTY_HASH_CODE = 64;
    public static final int OFFSET_1 = 1;
    public static final int OFFSET_2 = 2;
    public static final int OFFSET_4 = 4;
    public static final int FIELD_ID_LEN = 4;
    public static final boolean WRAP_TREES = !IgniteSystemProperties.getBoolean("IGNITE_BINARY_DONT_WRAP_TREE_STRUCTURES");
    public static final boolean FIELDS_SORTED_ORDER = IgniteSystemProperties.getBoolean("IGNITE_BINARY_SORT_OBJECT_FIELDS");
    private static final String[] FIELD_TYPE_NAMES;
    private static final int FNV1_OFFSET_BASIS = -2128831035;
    private static final int FNV1_PRIME = 16777619;

    public static boolean isUserType(short flags) {
        return BinaryUtils.isFlagSet(flags, (short)1);
    }

    public static boolean hasSchema(short flags) {
        return BinaryUtils.isFlagSet(flags, (short)2);
    }

    public static boolean hasRaw(short flags) {
        return BinaryUtils.isFlagSet(flags, (short)4);
    }

    public static boolean isCompactFooter(short flags) {
        return BinaryUtils.isFlagSet(flags, (short)32);
    }

    public static boolean isFlagSet(short flags, short flag) {
        return (flags & flag) == flag;
    }

    public static int schemaInitialId() {
        return -2128831035;
    }

    public static int updateSchemaId(int schemaId, int fieldId) {
        schemaId ^= fieldId & 0xFF;
        schemaId *= 16777619;
        schemaId ^= fieldId >> 8 & 0xFF;
        schemaId *= 16777619;
        schemaId ^= fieldId >> 16 & 0xFF;
        schemaId *= 16777619;
        schemaId ^= fieldId >> 24 & 0xFF;
        return schemaId *= 16777619;
    }

    public static String fieldTypeName(int typeId) {
        assert (typeId >= 0 && typeId < FIELD_TYPE_NAMES.length) : typeId;
        String typeName = FIELD_TYPE_NAMES[typeId];
        assert (typeName != null) : typeId;
        return typeName;
    }

    public static void writePlainObject(BinaryWriterExImpl writer, Object val) {
        Byte flag = PLAIN_CLASS_TO_FLAG.get(val.getClass());
        if (flag == null) {
            throw new IllegalArgumentException("Can't write object with type: " + val.getClass());
        }
        switch (flag) {
            case 1: {
                writer.writeByte(flag);
                writer.writeByte((Byte)val);
                break;
            }
            case 2: {
                writer.writeByte(flag);
                writer.writeShort((Short)val);
                break;
            }
            case 3: {
                writer.writeByte(flag);
                writer.writeInt((Integer)val);
                break;
            }
            case 4: {
                writer.writeByte(flag);
                writer.writeLong((Long)val);
                break;
            }
            case 5: {
                writer.writeByte(flag);
                writer.writeFloat(((Float)val).floatValue());
                break;
            }
            case 6: {
                writer.writeByte(flag);
                writer.writeDouble((Double)val);
                break;
            }
            case 7: {
                writer.writeByte(flag);
                writer.writeChar(((Character)val).charValue());
                break;
            }
            case 8: {
                writer.writeByte(flag);
                writer.writeBoolean((Boolean)val);
                break;
            }
            case 30: {
                writer.doWriteDecimal((BigDecimal)val);
                break;
            }
            case 9: {
                writer.doWriteString((String)val);
                break;
            }
            case 10: {
                writer.doWriteUuid((UUID)val);
                break;
            }
            case 11: {
                writer.doWriteDate((Date)val);
                break;
            }
            case 33: {
                writer.doWriteTimestamp((Timestamp)val);
                break;
            }
            case 12: {
                writer.doWriteByteArray((byte[])val);
                break;
            }
            case 13: {
                writer.doWriteShortArray((short[])val);
                break;
            }
            case 14: {
                writer.doWriteIntArray((int[])val);
                break;
            }
            case 15: {
                writer.doWriteLongArray((long[])val);
                break;
            }
            case 16: {
                writer.doWriteFloatArray((float[])val);
                break;
            }
            case 17: {
                writer.doWriteDoubleArray((double[])val);
                break;
            }
            case 18: {
                writer.doWriteCharArray((char[])val);
                break;
            }
            case 19: {
                writer.doWriteBooleanArray((boolean[])val);
                break;
            }
            case 31: {
                writer.doWriteDecimalArray((BigDecimal[])val);
                break;
            }
            case 20: {
                writer.doWriteStringArray((String[])val);
                break;
            }
            case 21: {
                writer.doWriteUuidArray((UUID[])val);
                break;
            }
            case 22: {
                writer.doWriteDateArray((Date[])val);
                break;
            }
            case 34: {
                writer.doWriteTimestampArray((Timestamp[])val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't write object with type: " + val.getClass());
            }
        }
    }

    public static Object unwrapLazy(@Nullable Object obj) {
        if (obj instanceof BinaryLazyValue) {
            return ((BinaryLazyValue)obj).value();
        }
        return obj;
    }

    public static Iterator<Object> unwrapLazyIterator(final Iterator<Object> delegate) {
        return new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public Object next() {
                return BinaryUtils.unwrapLazy(delegate.next());
            }

            @Override
            public void remove() {
                delegate.remove();
            }
        };
    }

    public static boolean isPlainType(int type) {
        return type > 0 && type < PLAIN_TYPE_FLAG.length && PLAIN_TYPE_FLAG[type];
    }

    public static boolean isPlainArrayType(int type) {
        return type >= 12 && type <= 22 || type == 34;
    }

    public static byte typeByClass(Class<?> cls) {
        Byte type = PLAIN_CLASS_TO_FLAG.get(cls);
        if (type != null) {
            return type;
        }
        if (cls.isEnum()) {
            return 28;
        }
        if (cls.isArray()) {
            return (byte)(cls.getComponentType().isEnum() || cls.getComponentType() == Enum.class ? 29 : 23);
        }
        if (BinaryUtils.isSpecialCollection(cls)) {
            return 24;
        }
        if (BinaryUtils.isSpecialMap(cls)) {
            return 25;
        }
        return 103;
    }

    public static boolean isBinaryType(Class<?> cls) {
        assert (cls != null);
        return BinaryObject.class.isAssignableFrom(cls) || Proxy.class.isAssignableFrom(cls) || BINARY_CLS.contains(cls);
    }

    public static boolean wrapTrees() {
        return WRAP_TREES;
    }

    public static boolean knownMap(Object map) {
        Class<?> cls = map == null ? null : map.getClass();
        return cls == HashMap.class || cls == LinkedHashMap.class || !BinaryUtils.wrapTrees() && cls == TreeMap.class || cls == ConcurrentHashMap8.class || cls == ConcurrentHashMap.class;
    }

    public static <K, V> Map<K, V> newKnownMap(Object map) {
        Class<?> cls;
        Class<?> clazz = cls = map == null ? null : map.getClass();
        if (cls == HashMap.class) {
            return U.newHashMap(((Map)map).size());
        }
        if (cls == LinkedHashMap.class) {
            return U.newLinkedHashMap(((Map)map).size());
        }
        if (!BinaryUtils.wrapTrees() && cls == TreeMap.class) {
            return new TreeMap(((TreeMap)map).comparator());
        }
        if (cls == ConcurrentHashMap8.class) {
            return new ConcurrentHashMap8(U.capacity(((Map)map).size()));
        }
        if (cls == ConcurrentHashMap.class) {
            return new ConcurrentHashMap(U.capacity(((Map)map).size()));
        }
        return null;
    }

    public static <K, V> Map<K, V> newMap(Map<K, V> map) {
        if (map instanceof LinkedHashMap) {
            return U.newLinkedHashMap(map.size());
        }
        if (map instanceof TreeMap) {
            return new TreeMap(((TreeMap)map).comparator());
        }
        if (map instanceof ConcurrentHashMap8) {
            return new ConcurrentHashMap8(U.capacity(map.size()));
        }
        if (map instanceof ConcurrentHashMap) {
            return new ConcurrentHashMap(U.capacity(map.size()));
        }
        return U.newHashMap(map.size());
    }

    public static boolean knownCollection(Object col) {
        Class<?> cls = col == null ? null : col.getClass();
        return cls == HashSet.class || cls == LinkedHashSet.class || !BinaryUtils.wrapTrees() && cls == TreeSet.class || cls == ConcurrentSkipListSet.class || cls == ArrayList.class || cls == LinkedList.class;
    }

    public static boolean knownArray(Object arr) {
        if (arr == null) {
            return false;
        }
        Class<?> cls = arr.getClass();
        return cls == byte[].class || cls == short[].class || cls == int[].class || cls == long[].class || cls == float[].class || cls == double[].class || cls == char[].class || cls == boolean[].class || cls == String[].class || cls == UUID[].class || cls == Date[].class || cls == Timestamp[].class || cls == BigDecimal[].class;
    }

    public static <V> Collection<V> newKnownCollection(Object col) {
        Class<?> cls;
        Class<?> clazz = cls = col == null ? null : col.getClass();
        if (cls == HashSet.class) {
            return U.newHashSet(((Collection)col).size());
        }
        if (cls == LinkedHashSet.class) {
            return U.newLinkedHashSet(((Collection)col).size());
        }
        if (!BinaryUtils.wrapTrees() && cls == TreeSet.class) {
            return new TreeSet(((TreeSet)col).comparator());
        }
        if (cls == ConcurrentSkipListSet.class) {
            return new ConcurrentSkipListSet(((ConcurrentSkipListSet)col).comparator());
        }
        if (cls == ArrayList.class) {
            return new ArrayList(((Collection)col).size());
        }
        if (cls == LinkedList.class) {
            return new LinkedList();
        }
        return null;
    }

    public static <V> Set<V> newSet(Set<V> set) {
        if (set instanceof LinkedHashSet) {
            return U.newLinkedHashSet(set.size());
        }
        if (set instanceof TreeSet) {
            return new TreeSet(((TreeSet)set).comparator());
        }
        if (set instanceof ConcurrentSkipListSet) {
            return new ConcurrentSkipListSet(((ConcurrentSkipListSet)set).comparator());
        }
        return U.newHashSet(set.size());
    }

    public static void checkProtocolVersion(byte protoVer) {
        if (1 != protoVer) {
            throw new BinaryObjectException("Unsupported protocol version: " + protoVer);
        }
    }

    public static int length(BinaryPositionReadable in, int start) {
        return in.readIntPositioned(start + 12);
    }

    public static int footerStartRelative(BinaryPositionReadable in, int start) {
        short flags = in.readShortPositioned(start + 2);
        if (BinaryUtils.hasSchema(flags)) {
            return in.readIntPositioned(start + 20);
        }
        return BinaryUtils.length(in, start);
    }

    public static int footerStartAbsolute(BinaryPositionReadable in, int start) {
        return BinaryUtils.footerStartRelative(in, start) + start;
    }

    public static IgniteBiTuple<Integer, Integer> footerAbsolute(BinaryPositionReadable in, int start) {
        short flags = in.readShortPositioned(start + 2);
        int footerEnd = BinaryUtils.length(in, start);
        if (BinaryUtils.hasSchema(flags)) {
            int footerStart = in.readIntPositioned(start + 20);
            if (BinaryUtils.hasRaw(flags)) {
                footerEnd -= 4;
            }
            assert (footerStart <= footerEnd);
            return F.t(start + footerStart, start + footerEnd);
        }
        return F.t(start + footerEnd, start + footerEnd);
    }

    public static int rawOffsetRelative(BinaryPositionReadable in, int start) {
        short flags = in.readShortPositioned(start + 2);
        int len = BinaryUtils.length(in, start);
        if (BinaryUtils.hasSchema(flags)) {
            if (BinaryUtils.hasRaw(flags)) {
                return in.readIntPositioned(start + len - 4);
            }
            return in.readIntPositioned(start + 20);
        }
        return in.readIntPositioned(start + 20);
    }

    public static int rawOffsetAbsolute(BinaryPositionReadable in, int start) {
        return start + BinaryUtils.rawOffsetRelative(in, start);
    }

    public static int fieldOffsetLength(short flags) {
        if ((flags & 8) == 8) {
            return 1;
        }
        if ((flags & 0x10) == 16) {
            return 2;
        }
        return 4;
    }

    public static int fieldIdLength(short flags) {
        return BinaryUtils.isCompactFooter(flags) ? 0 : 4;
    }

    public static int fieldOffsetRelative(BinaryPositionReadable stream, int pos, int fieldOffsetSize) {
        int res = fieldOffsetSize == 1 ? stream.readBytePositioned(pos) & 0xFF : (fieldOffsetSize == 2 ? stream.readShortPositioned(pos) & 0xFFFF : stream.readIntPositioned(pos));
        return res;
    }

    public static BinaryMetadata mergeMetadata(@Nullable BinaryMetadata oldMeta, BinaryMetadata newMeta) {
        assert (newMeta != null);
        if (oldMeta == null) {
            return newMeta;
        }
        assert (oldMeta.typeId() == newMeta.typeId());
        if (!F.eq(oldMeta.typeName(), newMeta.typeName())) {
            throw new BinaryObjectException("Two binary types have duplicate type ID [typeId=" + oldMeta.typeId() + ", typeName1=" + oldMeta.typeName() + ", typeName2=" + newMeta.typeName() + ']');
        }
        if (!F.eq(oldMeta.affinityKeyFieldName(), newMeta.affinityKeyFieldName())) {
            throw new BinaryObjectException("Binary type has different affinity key fields [typeName=" + newMeta.typeName() + ", affKeyFieldName1=" + oldMeta.affinityKeyFieldName() + ", affKeyFieldName2=" + newMeta.affinityKeyFieldName() + ']');
        }
        if (oldMeta.isEnum() != newMeta.isEnum()) {
            if (oldMeta.isEnum()) {
                throw new BinaryObjectException("Binary type already registered as enum: " + newMeta.typeName());
            }
            throw new BinaryObjectException("Binary type already registered as non-enum: " + newMeta.typeName());
        }
        AbstractMap mergedFields = FIELDS_SORTED_ORDER ? new TreeMap<String, Integer>(oldMeta.fieldsMap()) : new LinkedHashMap<String, Integer>(oldMeta.fieldsMap());
        Map<String, Integer> newFields = newMeta.fieldsMap();
        boolean changed = false;
        for (Map.Entry<String, Integer> newField : newFields.entrySet()) {
            String newFieldTypeName;
            Integer oldFieldType = mergedFields.put((String)newField.getKey(), (Integer)newField.getValue());
            if (oldFieldType == null) {
                changed = true;
                continue;
            }
            String oldFieldTypeName = BinaryUtils.fieldTypeName(oldFieldType);
            if (F.eq(oldFieldTypeName, newFieldTypeName = BinaryUtils.fieldTypeName(newField.getValue()))) continue;
            throw new BinaryObjectException("Binary type has different field types [typeName=" + oldMeta.typeName() + ", fieldName=" + newField.getKey() + ", fieldTypeName1=" + oldFieldTypeName + ", fieldTypeName2=" + newFieldTypeName + ']');
        }
        HashSet<BinarySchema> mergedSchemas = new HashSet<BinarySchema>(oldMeta.schemas());
        for (BinarySchema newSchema : newMeta.schemas()) {
            if (!mergedSchemas.add(newSchema)) continue;
            changed = true;
        }
        return changed ? new BinaryMetadata(oldMeta.typeId(), oldMeta.typeName(), mergedFields, oldMeta.affinityKeyFieldName(), mergedSchemas, oldMeta.isEnum()) : oldMeta;
    }

    public static BinaryWriteMode mode(Class<?> cls) {
        assert (cls != null);
        if (cls == Byte.TYPE) {
            return BinaryWriteMode.P_BYTE;
        }
        if (cls == Boolean.TYPE) {
            return BinaryWriteMode.P_BOOLEAN;
        }
        if (cls == Short.TYPE) {
            return BinaryWriteMode.P_SHORT;
        }
        if (cls == Character.TYPE) {
            return BinaryWriteMode.P_CHAR;
        }
        if (cls == Integer.TYPE) {
            return BinaryWriteMode.P_INT;
        }
        if (cls == Long.TYPE) {
            return BinaryWriteMode.P_LONG;
        }
        if (cls == Float.TYPE) {
            return BinaryWriteMode.P_FLOAT;
        }
        if (cls == Double.TYPE) {
            return BinaryWriteMode.P_DOUBLE;
        }
        if (cls == Byte.class) {
            return BinaryWriteMode.BYTE;
        }
        if (cls == Boolean.class) {
            return BinaryWriteMode.BOOLEAN;
        }
        if (cls == Short.class) {
            return BinaryWriteMode.SHORT;
        }
        if (cls == Character.class) {
            return BinaryWriteMode.CHAR;
        }
        if (cls == Integer.class) {
            return BinaryWriteMode.INT;
        }
        if (cls == Long.class) {
            return BinaryWriteMode.LONG;
        }
        if (cls == Float.class) {
            return BinaryWriteMode.FLOAT;
        }
        if (cls == Double.class) {
            return BinaryWriteMode.DOUBLE;
        }
        if (cls == BigDecimal.class) {
            return BinaryWriteMode.DECIMAL;
        }
        if (cls == String.class) {
            return BinaryWriteMode.STRING;
        }
        if (cls == UUID.class) {
            return BinaryWriteMode.UUID;
        }
        if (cls == Date.class) {
            return BinaryWriteMode.DATE;
        }
        if (cls == Timestamp.class) {
            return BinaryWriteMode.TIMESTAMP;
        }
        if (cls == byte[].class) {
            return BinaryWriteMode.BYTE_ARR;
        }
        if (cls == short[].class) {
            return BinaryWriteMode.SHORT_ARR;
        }
        if (cls == int[].class) {
            return BinaryWriteMode.INT_ARR;
        }
        if (cls == long[].class) {
            return BinaryWriteMode.LONG_ARR;
        }
        if (cls == float[].class) {
            return BinaryWriteMode.FLOAT_ARR;
        }
        if (cls == double[].class) {
            return BinaryWriteMode.DOUBLE_ARR;
        }
        if (cls == char[].class) {
            return BinaryWriteMode.CHAR_ARR;
        }
        if (cls == boolean[].class) {
            return BinaryWriteMode.BOOLEAN_ARR;
        }
        if (cls == BigDecimal[].class) {
            return BinaryWriteMode.DECIMAL_ARR;
        }
        if (cls == String[].class) {
            return BinaryWriteMode.STRING_ARR;
        }
        if (cls == UUID[].class) {
            return BinaryWriteMode.UUID_ARR;
        }
        if (cls == Date[].class) {
            return BinaryWriteMode.DATE_ARR;
        }
        if (cls == Timestamp[].class) {
            return BinaryWriteMode.TIMESTAMP_ARR;
        }
        if (cls.isArray()) {
            return cls.getComponentType().isEnum() ? BinaryWriteMode.ENUM_ARR : BinaryWriteMode.OBJECT_ARR;
        }
        if (cls == BinaryObjectImpl.class) {
            return BinaryWriteMode.BINARY_OBJ;
        }
        if (Binarylizable.class.isAssignableFrom(cls)) {
            return BinaryWriteMode.BINARY;
        }
        if (BinaryUtils.isSpecialCollection(cls)) {
            return BinaryWriteMode.COL;
        }
        if (BinaryUtils.isSpecialMap(cls)) {
            return BinaryWriteMode.MAP;
        }
        if (cls.isEnum()) {
            return BinaryWriteMode.ENUM;
        }
        if (cls == Class.class) {
            return BinaryWriteMode.CLASS;
        }
        if (Proxy.class.isAssignableFrom(cls)) {
            return BinaryWriteMode.PROXY;
        }
        return BinaryWriteMode.OBJECT;
    }

    public static boolean isSpecialCollection(Class cls) {
        return ArrayList.class.equals((Object)cls) || LinkedList.class.equals((Object)cls) || HashSet.class.equals((Object)cls) || LinkedHashSet.class.equals((Object)cls);
    }

    public static boolean isSpecialMap(Class cls) {
        return HashMap.class.equals((Object)cls) || LinkedHashMap.class.equals((Object)cls);
    }

    public static byte[] doReadByteArray(BinaryInputStream in) {
        int len = in.readInt();
        return in.readByteArray(len);
    }

    public static boolean[] doReadBooleanArray(BinaryInputStream in) {
        int len = in.readInt();
        return in.readBooleanArray(len);
    }

    public static short[] doReadShortArray(BinaryInputStream in) {
        int len = in.readInt();
        return in.readShortArray(len);
    }

    public static char[] doReadCharArray(BinaryInputStream in) {
        int len = in.readInt();
        return in.readCharArray(len);
    }

    public static int[] doReadIntArray(BinaryInputStream in) {
        int len = in.readInt();
        return in.readIntArray(len);
    }

    public static long[] doReadLongArray(BinaryInputStream in) {
        int len = in.readInt();
        return in.readLongArray(len);
    }

    public static float[] doReadFloatArray(BinaryInputStream in) {
        int len = in.readInt();
        return in.readFloatArray(len);
    }

    public static double[] doReadDoubleArray(BinaryInputStream in) {
        int len = in.readInt();
        return in.readDoubleArray(len);
    }

    public static BigDecimal doReadDecimal(BinaryInputStream in) {
        int scale = in.readInt();
        byte[] mag = BinaryUtils.doReadByteArray(in);
        BigInteger intVal = new BigInteger(mag);
        if (scale < 0) {
            scale &= Integer.MAX_VALUE;
            intVal = intVal.negate();
        }
        return new BigDecimal(intVal, scale);
    }

    public static String doReadString(BinaryInputStream in) {
        if (!in.hasArray()) {
            byte[] arr = BinaryUtils.doReadByteArray(in);
            if (USE_STR_SERIALIZATION_VER_2) {
                return BinaryUtils.utf8BytesToStr(arr, 0, arr.length);
            }
            return new String(arr, StandardCharsets.UTF_8);
        }
        int strLen = in.readInt();
        int pos = in.position();
        String res = USE_STR_SERIALIZATION_VER_2 ? BinaryUtils.utf8BytesToStr(in.array(), pos, strLen) : new String(in.array(), pos, strLen, StandardCharsets.UTF_8);
        in.position(pos + strLen);
        return res;
    }

    public static UUID doReadUuid(BinaryInputStream in) {
        return new UUID(in.readLong(), in.readLong());
    }

    public static Date doReadDate(BinaryInputStream in) {
        long time = in.readLong();
        return new Date(time);
    }

    public static Timestamp doReadTimestamp(BinaryInputStream in) {
        long time = in.readLong();
        int nanos = in.readInt();
        Timestamp ts = new Timestamp(time);
        ts.setNanos(ts.getNanos() + nanos);
        return ts;
    }

    public static BigDecimal[] doReadDecimalArray(BinaryInputStream in) throws BinaryObjectException {
        int len = in.readInt();
        BigDecimal[] arr = new BigDecimal[len];
        for (int i = 0; i < len; ++i) {
            byte flag = in.readByte();
            if (flag == 101) {
                arr[i] = null;
                continue;
            }
            if (flag != 30) {
                throw new BinaryObjectException("Invalid flag value: " + flag);
            }
            arr[i] = BinaryUtils.doReadDecimal(in);
        }
        return arr;
    }

    public static String[] doReadStringArray(BinaryInputStream in) throws BinaryObjectException {
        int len = in.readInt();
        String[] arr = new String[len];
        for (int i = 0; i < len; ++i) {
            byte flag = in.readByte();
            if (flag == 101) {
                arr[i] = null;
                continue;
            }
            if (flag != 9) {
                throw new BinaryObjectException("Invalid flag value: " + flag);
            }
            arr[i] = BinaryUtils.doReadString(in);
        }
        return arr;
    }

    public static UUID[] doReadUuidArray(BinaryInputStream in) throws BinaryObjectException {
        int len = in.readInt();
        UUID[] arr = new UUID[len];
        for (int i = 0; i < len; ++i) {
            byte flag = in.readByte();
            if (flag == 101) {
                arr[i] = null;
                continue;
            }
            if (flag != 10) {
                throw new BinaryObjectException("Invalid flag value: " + flag);
            }
            arr[i] = BinaryUtils.doReadUuid(in);
        }
        return arr;
    }

    public static Date[] doReadDateArray(BinaryInputStream in) throws BinaryObjectException {
        int len = in.readInt();
        Date[] arr = new Date[len];
        for (int i = 0; i < len; ++i) {
            byte flag = in.readByte();
            if (flag == 101) {
                arr[i] = null;
                continue;
            }
            if (flag != 11) {
                throw new BinaryObjectException("Invalid flag value: " + flag);
            }
            arr[i] = BinaryUtils.doReadDate(in);
        }
        return arr;
    }

    public static Timestamp[] doReadTimestampArray(BinaryInputStream in) throws BinaryObjectException {
        int len = in.readInt();
        Timestamp[] arr = new Timestamp[len];
        for (int i = 0; i < len; ++i) {
            byte flag = in.readByte();
            if (flag == 101) {
                arr[i] = null;
                continue;
            }
            if (flag != 33) {
                throw new BinaryObjectException("Invalid flag value: " + flag);
            }
            arr[i] = BinaryUtils.doReadTimestamp(in);
        }
        return arr;
    }

    public static BinaryObject doReadBinaryObject(BinaryInputStream in, BinaryContext ctx) {
        if (in.offheapPointer() > 0L) {
            int len = in.readInt();
            int pos = in.position();
            in.position(in.position() + len);
            int start = in.readInt();
            return new BinaryObjectOffheapImpl(ctx, in.offheapPointer() + (long)pos, start, len);
        }
        byte[] arr = BinaryUtils.doReadByteArray(in);
        int start = in.readInt();
        return new BinaryObjectImpl(ctx, arr, start);
    }

    public static Class doReadClass(BinaryInputStream in, BinaryContext ctx, ClassLoader ldr) throws BinaryObjectException {
        int typeId = in.readInt();
        return BinaryUtils.doReadClass(in, ctx, ldr, typeId);
    }

    public static Object doReadProxy(BinaryInputStream in, BinaryContext ctx, ClassLoader ldr, BinaryReaderHandlesHolder handles) {
        Class[] intfs = new Class[in.readInt()];
        for (int i = 0; i < intfs.length; ++i) {
            intfs[i] = BinaryUtils.doReadClass(in, ctx, ldr);
        }
        InvocationHandler ih = (InvocationHandler)BinaryUtils.doReadObject(in, ctx, ldr, handles);
        return Proxy.newProxyInstance(ldr != null ? ldr : U.gridClassLoader(), intfs, ih);
    }

    private static EnumType doReadEnumType(BinaryInputStream in) {
        int typeId = in.readInt();
        if (typeId != 0) {
            return new EnumType(typeId, null);
        }
        String clsName = BinaryUtils.doReadClassName(in);
        return new EnumType(0, clsName);
    }

    public static String doReadClassName(BinaryInputStream in) {
        byte flag = in.readByte();
        if (flag != 9) {
            throw new BinaryObjectException("Failed to read class name [position=" + (in.position() - 1) + ']');
        }
        return BinaryUtils.doReadString(in);
    }

    public static Class doReadClass(BinaryInputStream in, BinaryContext ctx, ClassLoader ldr, int typeId) throws BinaryObjectException {
        Class<?> cls;
        if (typeId == -1) {
            return Object.class;
        }
        if (typeId != 0) {
            cls = ctx.descriptorForTypeId(true, typeId, ldr, false).describedClass();
        } else {
            String clsName = BinaryUtils.doReadClassName(in);
            try {
                cls = U.forName(clsName, ldr);
            }
            catch (ClassNotFoundException e) {
                throw new BinaryInvalidTypeException("Failed to load the class: " + clsName, e);
            }
            ctx.descriptorForClass(cls, true);
        }
        return cls;
    }

    public static Class resolveClass(BinaryContext ctx, int typeId, @Nullable String clsName, @Nullable ClassLoader ldr, boolean deserialize) {
        Class<?> cls;
        if (typeId == -1) {
            return Object.class;
        }
        if (typeId != 0) {
            cls = ctx.descriptorForTypeId(true, typeId, ldr, deserialize).describedClass();
        } else {
            try {
                cls = U.forName(clsName, ldr);
            }
            catch (ClassNotFoundException e) {
                throw new BinaryInvalidTypeException("Failed to load the class: " + clsName, e);
            }
            ctx.descriptorForClass(cls, true);
        }
        return cls;
    }

    private static BinaryEnumObjectImpl doReadBinaryEnum(BinaryInputStream in, BinaryContext ctx, EnumType type) {
        return new BinaryEnumObjectImpl(ctx, type.typeId, type.clsName, in.readInt());
    }

    private static Object[] doReadBinaryEnumArray(BinaryInputStream in, BinaryContext ctx) {
        int len = in.readInt();
        Object[] arr = (Object[])Array.newInstance(BinaryObject.class, len);
        for (int i = 0; i < len; ++i) {
            byte flag = in.readByte();
            arr[i] = flag == 101 ? null : BinaryUtils.doReadBinaryEnum(in, ctx, BinaryUtils.doReadEnumType(in));
        }
        return arr;
    }

    public static Enum<?> doReadEnum(BinaryInputStream in, Class<?> cls) throws BinaryObjectException {
        assert (cls != null);
        if (!cls.isEnum()) {
            throw new BinaryObjectException("Class does not represent enum type: " + cls.getName());
        }
        int ord = in.readInt();
        return (Enum)BinaryEnumCache.get(cls, ord);
    }

    public static Object[] doReadEnumArray(BinaryInputStream in, BinaryContext ctx, ClassLoader ldr, Class<?> cls) throws BinaryObjectException {
        int len = in.readInt();
        Object[] arr = (Object[])Array.newInstance(cls, len);
        for (int i = 0; i < len; ++i) {
            byte flag = in.readByte();
            arr[i] = flag == 101 ? null : BinaryUtils.doReadEnum(in, BinaryUtils.doReadClass(in, ctx, ldr));
        }
        return arr;
    }

    public static Object doReadOptimized(BinaryInputStream in, BinaryContext ctx, @Nullable ClassLoader clsLdr) {
        int len = in.readInt();
        ByteArrayInputStream input = new ByteArrayInputStream(in.array(), in.position(), len);
        try {
            Object t = ctx.optimizedMarsh().unmarshal(input, U.resolveClassLoader(clsLdr, ctx.configuration()));
            return t;
        }
        catch (IgniteCheckedException e) {
            throw new BinaryObjectException("Failed to unmarshal object with optimized marshaller", e);
        }
        finally {
            in.position(in.position() + len);
        }
    }

    @Nullable
    public static Object doReadObject(BinaryInputStream in, BinaryContext ctx, ClassLoader ldr, BinaryReaderHandlesHolder handles) throws BinaryObjectException {
        return new BinaryReaderExImpl(ctx, in, ldr, handles.handles(), true).deserialize();
    }

    @Nullable
    public static Object unmarshal(BinaryInputStream in, BinaryContext ctx, ClassLoader ldr) throws BinaryObjectException {
        return BinaryUtils.unmarshal(in, ctx, ldr, new BinaryReaderHandlesHolderImpl());
    }

    @Nullable
    public static Object unmarshal(BinaryInputStream in, BinaryContext ctx, ClassLoader ldr, BinaryReaderHandlesHolder handles) throws BinaryObjectException {
        return BinaryUtils.unmarshal(in, ctx, ldr, handles, false);
    }

    @Nullable
    public static Object unmarshal(BinaryInputStream in, BinaryContext ctx, ClassLoader ldr, BinaryReaderHandlesHolder handles, boolean detach) throws BinaryObjectException {
        int start = in.position();
        byte flag = in.readByte();
        switch (flag) {
            case 101: {
                return null;
            }
            case 102: {
                int handlePos = start - in.readInt();
                Object obj = handles.getHandle(handlePos);
                if (obj == null) {
                    int retPos = in.position();
                    in.position(handlePos);
                    obj = BinaryUtils.unmarshal(in, ctx, ldr, handles);
                    in.position(retPos);
                }
                return obj;
            }
            case 103: {
                BinaryObjectExImpl po;
                BinaryUtils.checkProtocolVersion(in.readByte());
                int len = BinaryUtils.length(in, start);
                if (detach) {
                    in.position(start);
                    po = new BinaryObjectImpl(ctx, in.readByteArray(len), 0);
                } else {
                    po = in.offheapPointer() == 0L ? new BinaryObjectImpl(ctx, in.array(), start) : new BinaryObjectOffheapImpl(ctx, in.offheapPointer(), start, in.remaining() + in.position());
                    in.position(start + ((BinaryObjectExImpl)po).length());
                }
                handles.setHandle(po, start);
                return po;
            }
            case 1: {
                return in.readByte();
            }
            case 2: {
                return in.readShort();
            }
            case 3: {
                return in.readInt();
            }
            case 4: {
                return in.readLong();
            }
            case 5: {
                return Float.valueOf(in.readFloat());
            }
            case 6: {
                return in.readDouble();
            }
            case 7: {
                return Character.valueOf(in.readChar());
            }
            case 8: {
                return in.readBoolean();
            }
            case 30: {
                return BinaryUtils.doReadDecimal(in);
            }
            case 9: {
                return BinaryUtils.doReadString(in);
            }
            case 10: {
                return BinaryUtils.doReadUuid(in);
            }
            case 11: {
                return BinaryUtils.doReadDate(in);
            }
            case 33: {
                return BinaryUtils.doReadTimestamp(in);
            }
            case 12: {
                return BinaryUtils.doReadByteArray(in);
            }
            case 13: {
                return BinaryUtils.doReadShortArray(in);
            }
            case 14: {
                return BinaryUtils.doReadIntArray(in);
            }
            case 15: {
                return BinaryUtils.doReadLongArray(in);
            }
            case 16: {
                return BinaryUtils.doReadFloatArray(in);
            }
            case 17: {
                return BinaryUtils.doReadDoubleArray(in);
            }
            case 18: {
                return BinaryUtils.doReadCharArray(in);
            }
            case 19: {
                return BinaryUtils.doReadBooleanArray(in);
            }
            case 31: {
                return BinaryUtils.doReadDecimalArray(in);
            }
            case 20: {
                return BinaryUtils.doReadStringArray(in);
            }
            case 21: {
                return BinaryUtils.doReadUuidArray(in);
            }
            case 22: {
                return BinaryUtils.doReadDateArray(in);
            }
            case 34: {
                return BinaryUtils.doReadTimestampArray(in);
            }
            case 23: {
                return BinaryUtils.doReadObjectArray(in, ctx, ldr, handles, false);
            }
            case 24: {
                return BinaryUtils.doReadCollection(in, ctx, ldr, handles, false, null);
            }
            case 25: {
                return BinaryUtils.doReadMap(in, ctx, ldr, handles, false, null);
            }
            case 27: {
                return BinaryUtils.doReadBinaryObject(in, ctx);
            }
            case 28: {
                return BinaryUtils.doReadBinaryEnum(in, ctx, BinaryUtils.doReadEnumType(in));
            }
            case 29: {
                BinaryUtils.doReadEnumType(in);
                return BinaryUtils.doReadBinaryEnumArray(in, ctx);
            }
            case 32: {
                return BinaryUtils.doReadClass(in, ctx, ldr);
            }
            case 35: {
                return BinaryUtils.doReadProxy(in, ctx, ldr, handles);
            }
            case -2: {
                return BinaryUtils.doReadOptimized(in, ctx, ldr);
            }
        }
        throw new BinaryObjectException("Invalid flag value: " + flag);
    }

    public static Object[] doReadObjectArray(BinaryInputStream in, BinaryContext ctx, ClassLoader ldr, BinaryReaderHandlesHolder handles, boolean deserialize) throws BinaryObjectException {
        int hPos = BinaryUtils.positionForHandle(in);
        Class compType = BinaryUtils.doReadClass(in, ctx, ldr);
        int len = in.readInt();
        Object[] arr = deserialize ? (Object[])Array.newInstance(compType, len) : new Object[len];
        handles.setHandle(arr, hPos);
        for (int i = 0; i < len; ++i) {
            arr[i] = BinaryUtils.deserializeOrUnmarshal(in, ctx, ldr, handles, deserialize);
        }
        return arr;
    }

    public static Collection<?> doReadCollection(BinaryInputStream in, BinaryContext ctx, ClassLoader ldr, BinaryReaderHandlesHolder handles, boolean deserialize, BinaryCollectionFactory factory) throws BinaryObjectException {
        Collection col;
        int hPos = BinaryUtils.positionForHandle(in);
        int size = in.readInt();
        assert (size >= 0);
        byte colType = in.readByte();
        if (factory != null) {
            col = factory.create(size);
        } else {
            switch (colType) {
                case 1: {
                    col = new ArrayList(size);
                    break;
                }
                case 2: {
                    col = new LinkedList();
                    break;
                }
                case 3: {
                    col = U.newHashSet(size);
                    break;
                }
                case 4: {
                    col = U.newLinkedHashSet(size);
                    break;
                }
                case -1: {
                    col = U.newHashSet(size);
                    break;
                }
                case 0: {
                    col = new ArrayList(size);
                    break;
                }
                default: {
                    throw new BinaryObjectException("Invalid collection type: " + colType);
                }
            }
        }
        handles.setHandle(col, hPos);
        for (int i = 0; i < size; ++i) {
            col.add(BinaryUtils.deserializeOrUnmarshal(in, ctx, ldr, handles, deserialize));
        }
        return col;
    }

    public static Map<?, ?> doReadMap(BinaryInputStream in, BinaryContext ctx, ClassLoader ldr, BinaryReaderHandlesHolder handles, boolean deserialize, BinaryMapFactory factory) throws BinaryObjectException {
        Map<Object, Object> map;
        int hPos = BinaryUtils.positionForHandle(in);
        int size = in.readInt();
        assert (size >= 0);
        byte mapType = in.readByte();
        if (factory != null) {
            map = factory.create(size);
        } else {
            switch (mapType) {
                case 1: {
                    map = U.newHashMap(size);
                    break;
                }
                case 2: {
                    map = U.newLinkedHashMap(size);
                    break;
                }
                case 0: {
                    map = U.newHashMap(size);
                    break;
                }
                default: {
                    throw new BinaryObjectException("Invalid map type: " + mapType);
                }
            }
        }
        handles.setHandle(map, hPos);
        for (int i = 0; i < size; ++i) {
            Object key = BinaryUtils.deserializeOrUnmarshal(in, ctx, ldr, handles, deserialize);
            Object val = BinaryUtils.deserializeOrUnmarshal(in, ctx, ldr, handles, deserialize);
            map.put(key, val);
        }
        return map;
    }

    private static Object deserializeOrUnmarshal(BinaryInputStream in, BinaryContext ctx, ClassLoader ldr, BinaryReaderHandlesHolder handles, boolean deserialize) {
        return deserialize ? BinaryUtils.doReadObject(in, ctx, ldr, handles) : BinaryUtils.unmarshal(in, ctx, ldr, handles);
    }

    public static int positionForHandle(BinaryInputStream in) {
        return in.position() - 1;
    }

    public static boolean isBinarylizable(Class cls) {
        for (Class c = cls; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
            if (!Binarylizable.class.isAssignableFrom(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCustomJavaSerialization(Class cls) {
        for (Class c = cls; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
            if (Externalizable.class.isAssignableFrom(c)) {
                return true;
            }
            try {
                Method writeObj = c.getDeclaredMethod("writeObject", ObjectOutputStream.class);
                Method readObj = c.getDeclaredMethod("readObject", ObjectInputStream.class);
                if (Modifier.isStatic(writeObj.getModifiers()) || Modifier.isStatic(readObj.getModifiers()) || writeObj.getReturnType() != Void.TYPE || readObj.getReturnType() != Void.TYPE) continue;
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }

    public static String qualifiedFieldName(Class cls, String fieldName) {
        return cls.getName() + "." + fieldName;
    }

    public static void writeIgniteUuid(BinaryRawWriter out, @Nullable IgniteUuid val) {
        if (val != null) {
            out.writeBoolean(true);
            out.writeLong(val.globalId().getMostSignificantBits());
            out.writeLong(val.globalId().getLeastSignificantBits());
            out.writeLong(val.localId());
        } else {
            out.writeBoolean(false);
        }
    }

    @Nullable
    public static IgniteUuid readIgniteUuid(BinaryRawReader in) {
        if (in.readBoolean()) {
            UUID globalId = new UUID(in.readLong(), in.readLong());
            return new IgniteUuid(globalId, in.readLong());
        }
        return null;
    }

    public static String utf8BytesToStr(byte[] arr, int off, int len) {
        int c;
        int charArrCnt = 0;
        int total = off + len;
        char[] res = new char[len];
        while (off < total && (c = arr[off] & 0xFF) <= 127) {
            ++off;
            res[charArrCnt++] = (char)c;
        }
        block6: while (off < total) {
            c = arr[off] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++off;
                    res[charArrCnt++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((off += 2) > total) {
                        throw new BinaryObjectException("Malformed input: partial character at end");
                    }
                    byte c2 = arr[off - 1];
                    if ((c2 & 0xC0) != 128) {
                        throw new BinaryObjectException("Malformed input around byte: " + off);
                    }
                    res[charArrCnt++] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((off += 3) > total) {
                        throw new BinaryObjectException("Malformed input: partial character at end");
                    }
                    byte c2 = arr[off - 2];
                    byte c3 = arr[off - 1];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new BinaryObjectException("Malformed input around byte: " + (off - 1));
                    }
                    res[charArrCnt++] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                    continue block6;
                }
            }
            throw new BinaryObjectException("Malformed input around byte: " + off);
        }
        return len == charArrCnt ? new String(res) : new String(res, 0, charArrCnt);
    }

    public static byte[] strToUtf8Bytes(String val) {
        char c;
        int cnt;
        int strLen = val.length();
        int utfLen = 0;
        for (cnt = 0; cnt < strLen; ++cnt) {
            c = val.charAt(cnt);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utfLen;
                continue;
            }
            if (c > '\u07ff') {
                utfLen += 3;
                continue;
            }
            utfLen += 2;
        }
        byte[] arr = new byte[utfLen];
        int position = 0;
        for (cnt = 0; cnt < strLen; ++cnt) {
            c = val.charAt(cnt);
            if (c >= '\u0001' && c <= '\u007f') {
                arr[position++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                arr[position++] = (byte)(0xE0 | c >> 12 & 0xF);
                arr[position++] = (byte)(0x80 | c >> 6 & 0x3F);
                arr[position++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            arr[position++] = (byte)(0xC0 | c >> 6 & 0x1F);
            arr[position++] = (byte)(0x80 | c & 0x3F);
        }
        return arr;
    }

    public static BinaryType typeProxy(BinaryContext ctx, BinaryObjectEx obj) {
        if (ctx == null) {
            throw new BinaryObjectException("BinaryContext is not set for the object.");
        }
        String clsName = obj instanceof BinaryEnumObjectImpl ? ((BinaryEnumObjectImpl)obj).className() : null;
        return new BinaryTypeProxy(ctx, obj.typeId(), clsName);
    }

    public static BinaryType type(BinaryContext ctx, BinaryObjectEx obj) {
        if (ctx == null) {
            throw new BinaryObjectException("BinaryContext is not set for the object.");
        }
        return ctx.metadata(obj.typeId());
    }

    public static BinaryWriteReplacer writeReplacer(Class cls) {
        return cls != null ? CLS_TO_WRITE_REPLACER.get(cls) : null;
    }

    static {
        PLAIN_CLASS_TO_FLAG.put(Byte.class, (byte)1);
        PLAIN_CLASS_TO_FLAG.put(Short.class, (byte)2);
        PLAIN_CLASS_TO_FLAG.put(Integer.class, (byte)3);
        PLAIN_CLASS_TO_FLAG.put(Long.class, (byte)4);
        PLAIN_CLASS_TO_FLAG.put(Float.class, (byte)5);
        PLAIN_CLASS_TO_FLAG.put(Double.class, (byte)6);
        PLAIN_CLASS_TO_FLAG.put(Character.class, (byte)7);
        PLAIN_CLASS_TO_FLAG.put(Boolean.class, (byte)8);
        PLAIN_CLASS_TO_FLAG.put(BigDecimal.class, (byte)30);
        PLAIN_CLASS_TO_FLAG.put(String.class, (byte)9);
        PLAIN_CLASS_TO_FLAG.put(UUID.class, (byte)10);
        PLAIN_CLASS_TO_FLAG.put(Date.class, (byte)11);
        PLAIN_CLASS_TO_FLAG.put(Timestamp.class, (byte)33);
        PLAIN_CLASS_TO_FLAG.put(byte[].class, (byte)12);
        PLAIN_CLASS_TO_FLAG.put(short[].class, (byte)13);
        PLAIN_CLASS_TO_FLAG.put(int[].class, (byte)14);
        PLAIN_CLASS_TO_FLAG.put(long[].class, (byte)15);
        PLAIN_CLASS_TO_FLAG.put(float[].class, (byte)16);
        PLAIN_CLASS_TO_FLAG.put(double[].class, (byte)17);
        PLAIN_CLASS_TO_FLAG.put(char[].class, (byte)18);
        PLAIN_CLASS_TO_FLAG.put(boolean[].class, (byte)19);
        PLAIN_CLASS_TO_FLAG.put(BigDecimal[].class, (byte)31);
        PLAIN_CLASS_TO_FLAG.put(String[].class, (byte)20);
        PLAIN_CLASS_TO_FLAG.put(UUID[].class, (byte)21);
        PLAIN_CLASS_TO_FLAG.put(Date[].class, (byte)22);
        PLAIN_CLASS_TO_FLAG.put(Timestamp[].class, (byte)34);
        for (Map.Entry<Class<?>, Byte> entry : PLAIN_CLASS_TO_FLAG.entrySet()) {
            FLAG_TO_CLASS.put(entry.getValue(), entry.getKey());
        }
        PLAIN_CLASS_TO_FLAG.put(Byte.TYPE, (byte)1);
        PLAIN_CLASS_TO_FLAG.put(Short.TYPE, (byte)2);
        PLAIN_CLASS_TO_FLAG.put(Integer.TYPE, (byte)3);
        PLAIN_CLASS_TO_FLAG.put(Long.TYPE, (byte)4);
        PLAIN_CLASS_TO_FLAG.put(Float.TYPE, (byte)5);
        PLAIN_CLASS_TO_FLAG.put(Double.TYPE, (byte)6);
        PLAIN_CLASS_TO_FLAG.put(Character.TYPE, (byte)7);
        PLAIN_CLASS_TO_FLAG.put(Boolean.TYPE, (byte)8);
        for (byte b : new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 30, 9, 10, 11, 33, 12, 13, 14, 15, 16, 17, 18, 19, 31, 20, 21, 22, 34, 28, 29, 101}) {
            BinaryUtils.PLAIN_TYPE_FLAG[b] = true;
        }
        BINARY_CLS.add(Byte.class);
        BINARY_CLS.add(Short.class);
        BINARY_CLS.add(Integer.class);
        BINARY_CLS.add(Long.class);
        BINARY_CLS.add(Float.class);
        BINARY_CLS.add(Double.class);
        BINARY_CLS.add(Character.class);
        BINARY_CLS.add(Boolean.class);
        BINARY_CLS.add(String.class);
        BINARY_CLS.add(UUID.class);
        BINARY_CLS.add(Date.class);
        BINARY_CLS.add(Timestamp.class);
        BINARY_CLS.add(BigDecimal.class);
        BINARY_CLS.add(byte[].class);
        BINARY_CLS.add(short[].class);
        BINARY_CLS.add(int[].class);
        BINARY_CLS.add(long[].class);
        BINARY_CLS.add(float[].class);
        BINARY_CLS.add(double[].class);
        BINARY_CLS.add(char[].class);
        BINARY_CLS.add(boolean[].class);
        BINARY_CLS.add(String[].class);
        BINARY_CLS.add(UUID[].class);
        BINARY_CLS.add(Date[].class);
        BINARY_CLS.add(Timestamp[].class);
        BINARY_CLS.add(BigDecimal[].class);
        FIELD_TYPE_NAMES = new String[104];
        BinaryUtils.FIELD_TYPE_NAMES[1] = "byte";
        BinaryUtils.FIELD_TYPE_NAMES[2] = "short";
        BinaryUtils.FIELD_TYPE_NAMES[3] = "int";
        BinaryUtils.FIELD_TYPE_NAMES[4] = "long";
        BinaryUtils.FIELD_TYPE_NAMES[8] = "boolean";
        BinaryUtils.FIELD_TYPE_NAMES[5] = "float";
        BinaryUtils.FIELD_TYPE_NAMES[6] = "double";
        BinaryUtils.FIELD_TYPE_NAMES[7] = "char";
        BinaryUtils.FIELD_TYPE_NAMES[10] = "UUID";
        BinaryUtils.FIELD_TYPE_NAMES[30] = "decimal";
        BinaryUtils.FIELD_TYPE_NAMES[9] = "String";
        BinaryUtils.FIELD_TYPE_NAMES[11] = "Date";
        BinaryUtils.FIELD_TYPE_NAMES[33] = "Timestamp";
        BinaryUtils.FIELD_TYPE_NAMES[28] = "Enum";
        BinaryUtils.FIELD_TYPE_NAMES[103] = "Object";
        BinaryUtils.FIELD_TYPE_NAMES[27] = "Object";
        BinaryUtils.FIELD_TYPE_NAMES[24] = "Collection";
        BinaryUtils.FIELD_TYPE_NAMES[25] = "Map";
        BinaryUtils.FIELD_TYPE_NAMES[32] = "Class";
        BinaryUtils.FIELD_TYPE_NAMES[12] = "byte[]";
        BinaryUtils.FIELD_TYPE_NAMES[13] = "short[]";
        BinaryUtils.FIELD_TYPE_NAMES[14] = "int[]";
        BinaryUtils.FIELD_TYPE_NAMES[15] = "long[]";
        BinaryUtils.FIELD_TYPE_NAMES[19] = "boolean[]";
        BinaryUtils.FIELD_TYPE_NAMES[16] = "float[]";
        BinaryUtils.FIELD_TYPE_NAMES[17] = "double[]";
        BinaryUtils.FIELD_TYPE_NAMES[18] = "char[]";
        BinaryUtils.FIELD_TYPE_NAMES[21] = "UUID[]";
        BinaryUtils.FIELD_TYPE_NAMES[31] = "decimal[]";
        BinaryUtils.FIELD_TYPE_NAMES[20] = "String[]";
        BinaryUtils.FIELD_TYPE_NAMES[22] = "Date[]";
        BinaryUtils.FIELD_TYPE_NAMES[34] = "Timestamp[]";
        BinaryUtils.FIELD_TYPE_NAMES[23] = "Object[]";
        BinaryUtils.FIELD_TYPE_NAMES[29] = "Enum[]";
        if (BinaryUtils.wrapTrees()) {
            CLS_TO_WRITE_REPLACER.put(TreeMap.class, new BinaryTreeMapWriteReplacer());
            CLS_TO_WRITE_REPLACER.put(TreeSet.class, new BinaryTreeSetWriteReplacer());
        }
    }

    private static class EnumType {
        private final int typeId;
        private final String clsName;

        public EnumType(int typeId, @Nullable String clsName) {
            assert (typeId != 0 && clsName == null || typeId == 0 && clsName != null);
            this.typeId = typeId;
            this.clsName = clsName;
        }
    }
}

