/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.ignite.internal.client.GridClientDataAffinity;
import org.apache.ignite.internal.client.GridClientDataConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientPartitionAffinity;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.internal.client.balancer.GridClientLoadBalancer;
import org.apache.ignite.internal.client.balancer.GridClientRandomBalancer;
import org.apache.ignite.internal.client.balancer.GridClientRoundRobinBalancer;
import org.apache.ignite.internal.client.marshaller.GridClientMarshaller;
import org.apache.ignite.internal.client.marshaller.optimized.GridClientOptimizedMarshaller;
import org.apache.ignite.internal.client.ssl.GridSslBasicContextFactory;
import org.apache.ignite.internal.client.ssl.GridSslContextFactory;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsBasicProvider;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.jetbrains.annotations.Nullable;

public class GridClientConfiguration {
    public static final GridClientProtocol DFLT_CLIENT_PROTOCOL = GridClientProtocol.TCP;
    public static final int DFLT_TOP_REFRESH_FREQ = 2000;
    public static final long DFLT_MAX_CONN_IDLE_TIME = 30000L;
    public static final long DFLT_PING_INTERVAL = 5000L;
    public static final long DFLT_PING_TIMEOUT = 7000L;
    public static final int DFLT_CONNECT_TIMEOUT = 10000;
    public static final boolean DFLT_TCP_NODELAY = true;
    private Collection<String> srvs = Collections.emptySet();
    private Collection<String> routers = Collections.emptySet();
    private GridClientProtocol proto = DFLT_CLIENT_PROTOCOL;
    private int connectTimeout = 10000;
    private boolean tcpNoDelay = true;
    private GridSslContextFactory sslCtxFactory;
    private boolean enableMetricsCache = true;
    private boolean enableAttrsCache = true;
    private boolean autoFetchMetrics = true;
    private boolean autoFetchAttrs = true;
    private long topRefreshFreq = 2000L;
    private long maxConnIdleTime = 30000L;
    private long pingInterval = 5000L;
    private long pingTimeout = 7000L;
    private GridClientLoadBalancer balancer = new GridClientRandomBalancer();
    private Map<String, GridClientDataConfiguration> dataCfgs = Collections.emptyMap();
    private SecurityCredentialsProvider credProvider;
    private ExecutorService executor;
    private GridClientMarshaller marshaller = new GridClientOptimizedMarshaller(U.allPluginProviders());
    private boolean daemon;

    public GridClientConfiguration() {
    }

    public GridClientConfiguration(GridClientConfiguration cfg) {
        this.autoFetchAttrs = cfg.isAutoFetchAttributes();
        this.autoFetchMetrics = cfg.isAutoFetchMetrics();
        this.balancer = cfg.getBalancer();
        this.connectTimeout = cfg.getConnectTimeout();
        this.credProvider = cfg.getSecurityCredentialsProvider();
        this.enableAttrsCache = cfg.isEnableAttributesCache();
        this.enableMetricsCache = cfg.isEnableMetricsCache();
        this.executor = cfg.getExecutorService();
        this.marshaller = cfg.getMarshaller();
        this.maxConnIdleTime = cfg.getMaxConnectionIdleTime();
        this.pingInterval = cfg.getPingInterval();
        this.pingTimeout = cfg.getPingTimeout();
        this.proto = cfg.getProtocol();
        this.routers = cfg.getRouters();
        this.srvs = cfg.getServers();
        this.sslCtxFactory = cfg.getSslContextFactory();
        this.tcpNoDelay = cfg.isTcpNoDelay();
        this.topRefreshFreq = cfg.getTopologyRefreshFrequency();
        this.daemon = cfg.isDaemon();
        this.setDataConfigurations(cfg.getDataConfigurations());
    }

    public GridClientConfiguration(Properties in) throws GridClientException {
        this("ignite.client", in);
    }

    public GridClientConfiguration(String prefix, Properties in) throws GridClientException {
        this.load(prefix, in);
    }

    public Collection<String> getServers() {
        return Collections.unmodifiableCollection(this.srvs);
    }

    public Collection<String> getRouters() {
        return this.routers;
    }

    public void setServers(Collection<String> srvs) {
        this.srvs = srvs != null ? srvs : Collections.emptySet();
    }

    public void setRouters(Collection<String> routers) {
        this.routers = routers != null ? routers : Collections.emptySet();
    }

    public GridClientProtocol getProtocol() {
        return this.proto;
    }

    public void setProtocol(GridClientProtocol proto) {
        this.proto = proto;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public GridSslContextFactory getSslContextFactory() {
        return this.sslCtxFactory;
    }

    public void setSslContextFactory(GridSslContextFactory sslCtxFactory) {
        this.sslCtxFactory = sslCtxFactory;
    }

    public GridClientLoadBalancer getBalancer() {
        return this.balancer;
    }

    public void setBalancer(GridClientLoadBalancer balancer) {
        this.balancer = balancer;
    }

    public SecurityCredentialsProvider getSecurityCredentialsProvider() {
        return this.credProvider;
    }

    public void setSecurityCredentialsProvider(SecurityCredentialsProvider credProvider) {
        this.credProvider = credProvider;
    }

    public Collection<GridClientDataConfiguration> getDataConfigurations() {
        return this.dataCfgs.values();
    }

    public void setDataConfigurations(Collection<? extends GridClientDataConfiguration> dataCfgs) {
        this.dataCfgs = U.newHashMap(dataCfgs.size());
        for (GridClientDataConfiguration gridClientDataConfiguration : dataCfgs) {
            this.dataCfgs.put(gridClientDataConfiguration.getName(), new GridClientDataConfiguration(gridClientDataConfiguration));
        }
    }

    public GridClientDataConfiguration getDataConfiguration(@Nullable String name) {
        return this.dataCfgs.get(name);
    }

    public void setEnableMetricsCache(boolean enableMetricsCache) {
        this.enableMetricsCache = enableMetricsCache;
    }

    public boolean isEnableMetricsCache() {
        return this.enableMetricsCache;
    }

    public void setEnableAttributesCache(boolean enableAttrsCache) {
        this.enableAttrsCache = enableAttrsCache;
    }

    public boolean isEnableAttributesCache() {
        return this.enableAttrsCache;
    }

    public void setAutoFetchMetrics(boolean autoFetchMetrics) {
        this.autoFetchMetrics = autoFetchMetrics;
    }

    public boolean isAutoFetchMetrics() {
        return this.autoFetchMetrics;
    }

    public void setAutoFetchAttributes(boolean autoFetchAttrs) {
        this.autoFetchAttrs = autoFetchAttrs;
    }

    public boolean isAutoFetchAttributes() {
        return this.autoFetchAttrs;
    }

    public long getTopologyRefreshFrequency() {
        return this.topRefreshFreq;
    }

    public void setTopologyRefreshFrequency(long topRefreshFreq) {
        this.topRefreshFreq = topRefreshFreq;
    }

    public long getMaxConnectionIdleTime() {
        return this.maxConnIdleTime;
    }

    public void setMaxConnectionIdleTime(long maxConnIdleTime) {
        this.maxConnIdleTime = maxConnIdleTime;
    }

    public long getPingInterval() {
        return this.pingInterval;
    }

    public void setPingInterval(long pingInterval) {
        this.pingInterval = pingInterval;
    }

    public long getPingTimeout() {
        return this.pingTimeout;
    }

    public void setPingTimeout(long pingTimeout) {
        this.pingTimeout = pingTimeout;
    }

    public ExecutorService getExecutorService() {
        return this.executor;
    }

    public void setExecutorService(ExecutorService executor) {
        this.executor = executor;
    }

    public GridClientMarshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(GridClientMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void load(String prefix, Properties in) throws GridClientException {
        while (prefix.endsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!prefix.isEmpty()) {
            prefix = prefix + ".";
        }
        String balancer = in.getProperty(prefix + "balancer");
        String connectTimeout = in.getProperty(prefix + "connectTimeout");
        String cred = in.getProperty(prefix + "credentials");
        String autoFetchMetrics = in.getProperty(prefix + "autoFetchMetrics");
        String autoFetchAttrs = in.getProperty(prefix + "autoFetchAttributes");
        String maxConnIdleTime = in.getProperty(prefix + "idleTimeout");
        String proto = in.getProperty(prefix + "protocol");
        String srvrs = in.getProperty(prefix + "servers");
        String tcpNoDelay = in.getProperty(prefix + "tcp.noDelay");
        String topRefreshFreq = in.getProperty(prefix + "topology.refresh");
        String sslEnabled = in.getProperty(prefix + "ssl.enabled");
        String sslProto = in.getProperty(prefix + "ssl.protocol", "TLS");
        String sslKeyAlg = in.getProperty(prefix + "ssl.key.algorithm", "SunX509");
        String keyStorePath = in.getProperty(prefix + "ssl.keystore.location");
        String keyStorePwd = in.getProperty(prefix + "ssl.keystore.password");
        String keyStoreType = in.getProperty(prefix + "ssl.keystore.type");
        String trustStorePath = in.getProperty(prefix + "ssl.truststore.location");
        String trustStorePwd = in.getProperty(prefix + "ssl.truststore.password");
        String trustStoreType = in.getProperty(prefix + "ssl.truststore.type");
        String dataCfgs = in.getProperty(prefix + "data.configurations");
        this.setBalancer(GridClientConfiguration.resolveBalancer(balancer));
        if (!F.isEmpty(connectTimeout)) {
            this.setConnectTimeout(Integer.parseInt(connectTimeout));
        }
        if (!F.isEmpty(cred)) {
            int idx = cred.indexOf(58);
            if (idx >= 0 && idx < cred.length() - 1) {
                this.setSecurityCredentialsProvider(new SecurityCredentialsBasicProvider(new SecurityCredentials(cred.substring(0, idx), cred.substring(idx + 1))));
            } else {
                this.setSecurityCredentialsProvider(new SecurityCredentialsBasicProvider(new SecurityCredentials(null, null, cred)));
            }
        }
        if (!F.isEmpty(autoFetchMetrics)) {
            this.setAutoFetchMetrics(Boolean.parseBoolean(autoFetchMetrics));
        }
        if (!F.isEmpty(autoFetchAttrs)) {
            this.setAutoFetchAttributes(Boolean.parseBoolean(autoFetchAttrs));
        }
        if (!F.isEmpty(maxConnIdleTime)) {
            this.setMaxConnectionIdleTime(Integer.parseInt(maxConnIdleTime));
        }
        if (!F.isEmpty(proto)) {
            this.setProtocol(GridClientProtocol.valueOf(proto));
        }
        if (!F.isEmpty(srvrs)) {
            this.setServers(Arrays.asList(srvrs.replaceAll("\\s+", "").split(",")));
        }
        if (!F.isEmpty(tcpNoDelay)) {
            this.setTcpNoDelay(Boolean.parseBoolean(tcpNoDelay));
        }
        if (!F.isEmpty(topRefreshFreq)) {
            this.setTopologyRefreshFrequency(Long.parseLong(topRefreshFreq));
        }
        if (!F.isEmpty(sslEnabled) && Boolean.parseBoolean(sslEnabled)) {
            GridSslBasicContextFactory factory = new GridSslBasicContextFactory();
            factory.setProtocol(F.isEmpty(sslProto) ? "TLS" : sslProto);
            factory.setKeyAlgorithm(F.isEmpty(sslKeyAlg) ? "SunX509" : sslKeyAlg);
            if (F.isEmpty(keyStorePath)) {
                throw new IllegalArgumentException("SSL key store location is not specified.");
            }
            factory.setKeyStoreFilePath(keyStorePath);
            if (keyStorePwd != null) {
                factory.setKeyStorePassword(keyStorePwd.toCharArray());
            }
            factory.setKeyStoreType(F.isEmpty(keyStoreType) ? "jks" : keyStoreType);
            if (F.isEmpty(trustStorePath)) {
                factory.setTrustManagers(GridSslBasicContextFactory.getDisabledTrustManager());
            } else {
                factory.setTrustStoreFilePath(trustStorePath);
                if (trustStorePwd != null) {
                    factory.setTrustStorePassword(trustStorePwd.toCharArray());
                }
                factory.setTrustStoreType(F.isEmpty(trustStoreType) ? "jks" : trustStoreType);
            }
            this.setSslContextFactory(factory);
        }
        if (!F.isEmpty(dataCfgs)) {
            String[] names = dataCfgs.replaceAll("\\s+", "").split(",");
            ArrayList<GridClientDataConfiguration> list = new ArrayList<GridClientDataConfiguration>();
            for (String cfgName : names) {
                if (F.isEmpty(cfgName)) continue;
                String name = in.getProperty(prefix + "data." + cfgName + ".name");
                String bal = in.getProperty(prefix + "data." + cfgName + ".balancer");
                String aff = in.getProperty(prefix + "data." + cfgName + ".affinity");
                GridClientDataConfiguration dataCfg = new GridClientDataConfiguration();
                dataCfg.setName(F.isEmpty(name) ? null : name);
                dataCfg.setBalancer(GridClientConfiguration.resolveBalancer(bal));
                dataCfg.setAffinity(GridClientConfiguration.resolveAffinity(aff));
                list.add(dataCfg);
            }
            this.setDataConfigurations(list);
        }
    }

    private static GridClientLoadBalancer resolveBalancer(String balancer) throws GridClientException {
        if (F.isEmpty(balancer) || "random".equals(balancer)) {
            return new GridClientRandomBalancer();
        }
        if ("roundrobin".equals(balancer)) {
            return new GridClientRoundRobinBalancer();
        }
        return GridClientConfiguration.newInstance(GridClientLoadBalancer.class, balancer);
    }

    private static GridClientDataAffinity resolveAffinity(String affinity) throws GridClientException {
        if (F.isEmpty(affinity)) {
            return null;
        }
        if ("partitioned".equals(affinity)) {
            return new GridClientPartitionAffinity();
        }
        return GridClientConfiguration.newInstance(GridClientDataAffinity.class, affinity);
    }

    private static <T> T newInstance(Class<T> exp, String clsName) throws GridClientException {
        Object obj;
        try {
            obj = Class.forName(clsName).newInstance();
        }
        catch (Exception e) {
            throw new GridClientException("Failed to create class instance: " + clsName, e);
        }
        return exp.cast(obj);
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public boolean isDaemon() {
        return this.daemon;
    }
}

