/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.impl.GridClientImpl;

public class GridClientFactory {
    private static ConcurrentMap<UUID, GridClientImpl> openClients = new ConcurrentHashMap<UUID, GridClientImpl>();
    private static ReadWriteLock busyLock = new ReentrantReadWriteLock();

    private GridClientFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GridClient start(GridClientConfiguration cfg) throws GridClientException {
        busyLock.readLock().lock();
        try {
            UUID clientId = UUID.randomUUID();
            GridClientImpl client = new GridClientImpl(clientId, cfg, false);
            GridClientImpl old = openClients.putIfAbsent(clientId, client);
            assert (old == null) : "Random unique UUID generation failed.";
            GridClientImpl gridClientImpl = client;
            return gridClientImpl;
        }
        finally {
            busyLock.readLock().unlock();
        }
    }

    public static void stopAll() {
        GridClientFactory.stopAll(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAll(boolean wait) {
        ConcurrentMap<UUID, GridClientImpl> old;
        busyLock.writeLock().lock();
        try {
            old = openClients;
            openClients = new ConcurrentHashMap<UUID, GridClientImpl>();
        }
        finally {
            busyLock.writeLock().unlock();
        }
        for (GridClientImpl client : old.values()) {
            client.stop(wait);
        }
    }

    public static void stop(UUID clientId) {
        GridClientFactory.stop(clientId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(UUID clientId, boolean wait) {
        busyLock.readLock().lock();
        try {
            GridClientImpl client = (GridClientImpl)openClients.remove(clientId);
            if (client != null) {
                client.stop(wait);
            }
        }
        finally {
            busyLock.readLock().unlock();
        }
    }
}

