/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.balancer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientTopologyListener;
import org.apache.ignite.internal.client.balancer.GridClientBalancerAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridClientRoundRobinBalancer
extends GridClientBalancerAdapter
implements GridClientTopologyListener {
    private Lock lock = new ReentrantLock();
    private LinkedList<UUID> nodeQueue = new LinkedList();

    @Override
    public GridClientNode balancedNode(Collection<? extends GridClientNode> nodes) throws GridClientException {
        Collection<GridClientNode> direct;
        int directSize;
        assert (!nodes.isEmpty());
        if (this.isPreferDirectNodes() && (directSize = (direct = GridClientRoundRobinBalancer.selectDirectNodes(nodes)).size()) > 0 && directSize < nodes.size()) {
            nodes = direct;
        }
        HashMap<UUID, GridClientNode> lookup = U.newHashMap(nodes.size());
        for (GridClientNode gridClientNode : nodes) {
            lookup.put(gridClientNode.nodeId(), gridClientNode);
        }
        this.lock.lock();
        try {
            GridClientNode balanced = null;
            Iterator iterator = this.nodeQueue.iterator();
            while (iterator.hasNext()) {
                UUID nodeId = (UUID)iterator.next();
                balanced = (GridClientNode)lookup.get(nodeId);
                if (balanced == null) continue;
                iterator.remove();
                break;
            }
            if (balanced != null) {
                this.nodeQueue.addLast(balanced.nodeId());
                GridClientNode gridClientNode = balanced;
                return gridClientNode;
            }
            throw new GridClientException("Passed nodes doesn't present in topology [nodes=" + nodes + ", top=" + this.nodeQueue);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNodeAdded(GridClientNode node) {
        this.lock.lock();
        try {
            this.nodeQueue.addFirst(node.nodeId());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNodeRemoved(GridClientNode node) {
        this.lock.lock();
        try {
            this.nodeQueue.remove(node.nodeId());
        }
        finally {
            this.lock.unlock();
        }
    }
}

