/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.impl.connection;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import org.apache.ignite.internal.client.GridClientCacheFlag;
import org.apache.ignite.internal.client.GridClientClosedException;
import org.apache.ignite.internal.client.GridClientDataMetrics;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFuture;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.impl.GridClientDataMetricsAdapter;
import org.apache.ignite.internal.client.impl.GridClientFutureAdapter;
import org.apache.ignite.internal.client.impl.GridClientFutureCallback;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionCloseReason;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionResetException;
import org.apache.ignite.internal.client.impl.connection.GridClientTopology;
import org.apache.ignite.internal.client.impl.connection.GridConnectionIdleClosedException;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public abstract class GridClientConnection {
    protected GridClientTopology top;
    protected final UUID clientId;
    private InetSocketAddress srvAddr;
    private SSLContext sslCtx;
    private Object cred;
    protected volatile GridClientConnectionCloseReason closeReason;

    protected GridClientConnection(UUID clientId, InetSocketAddress srvAddr, SSLContext sslCtx, GridClientTopology top, Object cred) {
        assert (top != null);
        this.clientId = clientId;
        this.srvAddr = srvAddr;
        this.top = top;
        this.sslCtx = sslCtx;
        this.cred = cred;
    }

    abstract void close(GridClientConnectionCloseReason var1, boolean var2);

    abstract boolean closeIfIdle(long var1);

    public InetSocketAddress serverAddress() {
        return this.srvAddr;
    }

    public static int encodeCacheFlags(Collection<GridClientCacheFlag> flagSet) {
        int bits = 0;
        if (flagSet.contains((Object)GridClientCacheFlag.SKIP_STORE)) {
            bits |= 1;
        }
        return bits;
    }

    public <K, V> GridClientFutureAdapter<Boolean> cachePut(String cacheName, K key, V val, Set<GridClientCacheFlag> flags, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
        return this.cachePutAll(cacheName, Collections.singletonMap(key, val), flags, destNodeId);
    }

    public <K, V> GridClientFutureAdapter<V> cacheGet(String cacheName, K key, Set<GridClientCacheFlag> flags, UUID destNodeId) throws GridClientConnectionResetException, GridClientClosedException {
        GridClientFutureAdapter<Map<K, V>> res = this.cacheGetAll(cacheName, Collections.singleton(key), flags, destNodeId);
        return res.chain(new GridClientFutureCallback<Map<K, V>, V>(){

            @Override
            public V onComplete(GridClientFuture<Map<K, V>> fut) throws GridClientException {
                Map map = fut.get();
                return F.firstValue(map);
            }
        });
    }

    public abstract <K> GridClientFutureAdapter<Boolean> cacheRemove(String var1, K var2, Set<GridClientCacheFlag> var3, UUID var4) throws GridClientConnectionResetException, GridClientClosedException;

    public abstract <K, V> GridClientFutureAdapter<Boolean> cachePutAll(String var1, Map<K, V> var2, Set<GridClientCacheFlag> var3, UUID var4) throws GridClientConnectionResetException, GridClientClosedException;

    public abstract <K, V> GridClientFutureAdapter<Map<K, V>> cacheGetAll(String var1, Collection<K> var2, Set<GridClientCacheFlag> var3, UUID var4) throws GridClientConnectionResetException, GridClientClosedException;

    public abstract <K> GridClientFutureAdapter<Boolean> cacheRemoveAll(String var1, Collection<K> var2, Set<GridClientCacheFlag> var3, UUID var4) throws GridClientConnectionResetException, GridClientClosedException;

    public abstract <K, V> GridClientFutureAdapter<Boolean> cacheReplace(String var1, K var2, V var3, Set<GridClientCacheFlag> var4, UUID var5) throws GridClientConnectionResetException, GridClientClosedException;

    public abstract <K, V> GridClientFutureAdapter<Boolean> cacheCompareAndSet(String var1, K var2, V var3, V var4, Set<GridClientCacheFlag> var5, UUID var6) throws GridClientConnectionResetException, GridClientClosedException;

    public abstract <K> GridClientFutureAdapter<GridClientDataMetrics> cacheMetrics(String var1, UUID var2) throws GridClientConnectionResetException, GridClientClosedException;

    public abstract <K, V> GridClientFutureAdapter<Boolean> cacheAppend(String var1, K var2, V var3, Set<GridClientCacheFlag> var4, UUID var5) throws GridClientConnectionResetException, GridClientClosedException;

    public abstract <K, V> GridClientFutureAdapter<Boolean> cachePrepend(String var1, K var2, V var3, Set<GridClientCacheFlag> var4, UUID var5) throws GridClientConnectionResetException, GridClientClosedException;

    public abstract <R> GridClientFutureAdapter<R> execute(String var1, Object var2, UUID var3, boolean var4) throws GridClientConnectionResetException, GridClientClosedException;

    public abstract GridClientFuture<GridClientNode> node(UUID var1, boolean var2, boolean var3, UUID var4) throws GridClientConnectionResetException, GridClientClosedException;

    public abstract GridClientFuture<GridClientNode> node(String var1, boolean var2, boolean var3, UUID var4) throws GridClientConnectionResetException, GridClientClosedException;

    public abstract GridClientFuture<List<GridClientNode>> topology(boolean var1, boolean var2, @Nullable UUID var3) throws GridClientConnectionResetException, GridClientClosedException;

    public abstract GridClientFutureAdapter<?> forwardMessage(Object var1) throws GridClientException;

    public boolean isClosed() {
        return this.closeReason != null;
    }

    protected SSLContext sslContext() {
        return this.sslCtx;
    }

    protected Object credentials() {
        return this.cred;
    }

    protected long safeLong(Map<String, Number> map, String key) {
        Number val = map.get(key);
        if (val == null) {
            return -1L;
        }
        return val.longValue();
    }

    protected double safeDouble(Map<String, Number> map, String key) {
        Number val = map.get(key);
        if (val == null) {
            return -1.0;
        }
        return val.doubleValue();
    }

    protected GridClientDataMetrics metricsMapToMetrics(Map<String, Number> metricsMap) {
        GridClientDataMetricsAdapter metrics = new GridClientDataMetricsAdapter();
        metrics.createTime(this.safeLong(metricsMap, "createTime"));
        metrics.readTime(this.safeLong(metricsMap, "readTime"));
        metrics.writeTime(this.safeLong(metricsMap, "writeTime"));
        metrics.reads((int)this.safeLong(metricsMap, "reads"));
        metrics.writes((int)this.safeLong(metricsMap, "writes"));
        metrics.hits((int)this.safeLong(metricsMap, "hits"));
        metrics.misses((int)this.safeLong(metricsMap, "misses"));
        return metrics;
    }

    protected void checkClosed(GridClientConnectionCloseReason reason) throws GridConnectionIdleClosedException, GridClientConnectionResetException, GridClientClosedException {
        if (reason == GridClientConnectionCloseReason.CONN_IDLE) {
            throw new GridConnectionIdleClosedException("Connection was closed by idle thread (will reconnect): " + this.serverAddress());
        }
        if (reason == GridClientConnectionCloseReason.FAILED) {
            throw new GridClientConnectionResetException("Failed to perform request (connection failed before message is sent): " + this.serverAddress());
        }
        if (reason == GridClientConnectionCloseReason.CLIENT_CLOSED) {
            throw new GridClientClosedException("Failed to perform request (connection was closed before message is sent): " + this.serverAddress());
        }
    }

    protected GridClientException getCloseReasonAsException(GridClientConnectionCloseReason reason, @Nullable Throwable cause) {
        if (reason == GridClientConnectionCloseReason.CONN_IDLE) {
            return new GridConnectionIdleClosedException("Connection was closed by idle thread: " + this.serverAddress());
        }
        if (reason == GridClientConnectionCloseReason.FAILED) {
            return new GridClientConnectionResetException("Failed to perform request (connection failed): " + this.serverAddress(), cause);
        }
        if (reason == GridClientConnectionCloseReason.CLIENT_CLOSED) {
            return new GridClientClosedException("Failed to perform request (client was closed): " + this.serverAddress());
        }
        return null;
    }

    protected String getCloseReasonMessage(GridClientConnectionCloseReason reason, @Nullable Throwable cause) {
        if (reason == GridClientConnectionCloseReason.CONN_IDLE) {
            return "Connection was closed by idle thread";
        }
        if (reason == GridClientConnectionCloseReason.FAILED) {
            return cause != null ? "Connection failed, cause: " + cause.getMessage() : "Connection failed";
        }
        if (reason == GridClientConnectionCloseReason.CLIENT_CLOSED) {
            return "Client was closed";
        }
        return null;
    }
}

