/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.impl.connection;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.client.GridClientClosedException;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientHandshakeException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.internal.client.GridServerUnreachableException;
import org.apache.ignite.internal.client.impl.GridClientFutureAdapter;
import org.apache.ignite.internal.client.impl.GridClientThreadFactory;
import org.apache.ignite.internal.client.impl.connection.GridClientConnection;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionCloseReason;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionManager;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionResetException;
import org.apache.ignite.internal.client.impl.connection.GridClientNioTcpConnection;
import org.apache.ignite.internal.client.impl.connection.GridClientTopology;
import org.apache.ignite.internal.client.marshaller.GridClientMarshaller;
import org.apache.ignite.internal.client.marshaller.optimized.GridClientZipOptimizedMarshaller;
import org.apache.ignite.internal.client.util.GridClientStripedLock;
import org.apache.ignite.internal.client.util.GridClientUtils;
import org.apache.ignite.internal.processors.rest.client.message.GridClientHandshakeResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridClientMessage;
import org.apache.ignite.internal.processors.rest.client.message.GridClientPingPacket;
import org.apache.ignite.internal.processors.rest.protocols.tcp.GridTcpRestParser;
import org.apache.ignite.internal.util.nio.GridNioCodecFilter;
import org.apache.ignite.internal.util.nio.GridNioFilter;
import org.apache.ignite.internal.util.nio.GridNioServer;
import org.apache.ignite.internal.util.nio.GridNioServerListener;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.ssl.GridNioSslFilter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.logger.java.JavaLogger;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.jetbrains.annotations.Nullable;

public abstract class GridClientConnectionManagerAdapter
implements GridClientConnectionManager {
    private static final int INIT_RETRY_CNT = 3;
    private static final int INIT_RETRY_INTERVAL = 1000;
    private final Logger log;
    private final Collection<String> macs;
    private GridNioServer srv;
    private final ConcurrentMap<InetSocketAddress, GridClientConnection> conns = new ConcurrentHashMap<InetSocketAddress, GridClientConnection>();
    private final ConcurrentMap<UUID, GridClientConnection> nodeConns = new ConcurrentHashMap<UUID, GridClientConnection>();
    private final SSLContext sslCtx;
    protected final GridClientConfiguration cfg;
    private final GridClientTopology top;
    private final UUID clientId;
    private final Collection<InetSocketAddress> routers;
    private volatile boolean closed;
    private final ExecutorService executor;
    private final GridClientStripedLock endpointStripedLock = new GridClientStripedLock(16);
    private final ScheduledExecutorService pingExecutor;
    private final Byte marshId;

    protected GridClientConnectionManagerAdapter(UUID clientId, SSLContext sslCtx, GridClientConfiguration cfg, Collection<InetSocketAddress> routers, GridClientTopology top, @Nullable Byte marshId, boolean routerClient) throws GridClientException {
        assert (clientId != null) : "clientId != null";
        assert (cfg != null) : "cfg != null";
        assert (routers != null) : "routers != null";
        assert (top != null) : "top != null";
        this.clientId = clientId;
        this.sslCtx = sslCtx;
        this.cfg = cfg;
        this.routers = new ArrayList<InetSocketAddress>(routers);
        this.top = top;
        this.log = Logger.getLogger(this.getClass().getName());
        this.executor = cfg.getExecutorService() != null ? cfg.getExecutorService() : Executors.newCachedThreadPool(new GridClientThreadFactory("exec", true));
        this.pingExecutor = cfg.getProtocol() == GridClientProtocol.TCP ? Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), new GridClientThreadFactory("exec", true)) : null;
        this.marshId = marshId;
        if (marshId == null && cfg.getMarshaller() == null) {
            throw new GridClientException("Failed to start client (marshaller is not configured).");
        }
        this.macs = U.allLocalMACs();
        if (cfg.getProtocol() == GridClientProtocol.TCP) {
            try {
                GridNioFilter[] filters;
                JavaLogger gridLog = new JavaLogger(false);
                GridNioCodecFilter codecFilter = new GridNioCodecFilter(new GridTcpRestParser(routerClient), gridLog, false);
                if (sslCtx != null) {
                    GridNioSslFilter sslFilter = new GridNioSslFilter(sslCtx, true, ByteOrder.nativeOrder(), gridLog);
                    sslFilter.directMode(false);
                    sslFilter.clientMode(true);
                    filters = new GridNioFilter[]{codecFilter, sslFilter};
                } else {
                    filters = new GridNioFilter[]{codecFilter};
                }
                this.srv = GridNioServer.builder().address(U.getLocalHost()).port(-1).listener(new NioListener(this.log)).filters(filters).logger(gridLog).selectorCount(Runtime.getRuntime().availableProcessors()).sendQueueLimit(1024).byteOrder(ByteOrder.nativeOrder()).tcpNoDelay(cfg.isTcpNoDelay()).directBuffer(true).directMode(false).socketReceiveBufferSize(0).socketSendBufferSize(0).idleTimeout(Long.MAX_VALUE).gridName(routerClient ? "routerClient" : "gridClient").serverName("tcp-client").daemon(cfg.isDaemon()).build();
                this.srv.start();
            }
            catch (IOException | IgniteCheckedException e) {
                throw new GridClientException("Failed to start connection server.", e);
            }
        }
    }

    @Override
    public void init(Collection<InetSocketAddress> srvs) throws GridClientException, InterruptedException {
        this.init0();
        GridClientException firstEx = null;
        for (int i = 0; i < 3; ++i) {
            ArrayList<InetSocketAddress> srvsCp = new ArrayList<InetSocketAddress>(srvs);
            while (!srvsCp.isEmpty()) {
                GridClientConnection conn = null;
                try {
                    conn = this.connect(null, srvsCp);
                    conn.topology(this.cfg.isAutoFetchAttributes(), this.cfg.isAutoFetchMetrics(), null).get();
                    return;
                }
                catch (GridServerUnreachableException e) {
                    assert (conn == null) : "GridClientConnectionResetException was thrown from GridClientConnection#topology";
                    if (firstEx != null) break;
                    firstEx = e;
                    break;
                }
                catch (GridClientConnectionResetException e) {
                    assert (conn != null) : "GridClientConnectionResetException was thrown from connect()";
                    if (firstEx == null) {
                        firstEx = e;
                    }
                    if (srvsCp.remove(conn.serverAddress())) continue;
                    break;
                }
            }
            Thread.sleep(1000L);
        }
        for (GridClientConnection c : this.conns.values()) {
            this.conns.remove(c.serverAddress(), c);
            c.close(GridClientConnectionCloseReason.FAILED, false);
        }
        throw firstEx;
    }

    protected abstract void init0() throws GridClientException;

    @Override
    public GridClientConnection connection(GridClientNode node) throws GridClientClosedException, GridServerUnreachableException, InterruptedException {
        assert (node != null);
        if (!this.routers.isEmpty()) {
            return this.connection(null, this.routers);
        }
        GridClientConnection conn = (GridClientConnection)this.nodeConns.get(node.nodeId());
        if (conn != null) {
            if (conn.closeIfIdle(this.cfg.getMaxConnectionIdleTime())) {
                this.closeIdle();
            } else {
                return conn;
            }
        }
        Collection<InetSocketAddress> endpoints = node.availableAddresses(this.cfg.getProtocol(), true);
        ArrayList<InetSocketAddress> resolvedEndpoints = new ArrayList<InetSocketAddress>(endpoints.size());
        for (InetSocketAddress endpoint : endpoints) {
            if (endpoint.isUnresolved()) continue;
            resolvedEndpoints.add(endpoint);
        }
        if (resolvedEndpoints.isEmpty()) {
            throw new GridServerUnreachableException("No available endpoints to connect (is rest enabled for this node?): " + node);
        }
        boolean sameHost = node.attributes().isEmpty() || F.containsAny(this.macs, node.attribute("org.apache.ignite.macs").toString().split(", "));
        LinkedHashSet<InetSocketAddress> srvs = new LinkedHashSet<InetSocketAddress>();
        if (sameHost) {
            Collections.sort(resolvedEndpoints, U.inetAddressesComparator(true));
            srvs.addAll(resolvedEndpoints);
        } else {
            for (InetSocketAddress endpoint : resolvedEndpoints) {
                if (endpoint.getAddress().isLoopbackAddress()) continue;
                srvs.add(endpoint);
            }
        }
        return this.connection(node.nodeId(), srvs);
    }

    public GridClientConnection connection(@Nullable UUID nodeId, Collection<InetSocketAddress> srvs) throws GridServerUnreachableException, GridClientClosedException, InterruptedException {
        if (srvs == null || srvs.isEmpty()) {
            throw new GridServerUnreachableException("Failed to establish connection to the grid (address list is empty).");
        }
        this.checkClosed();
        for (InetSocketAddress endPoint : srvs) {
            assert (endPoint != null);
            GridClientConnection conn = (GridClientConnection)this.conns.get(endPoint);
            if (conn == null) continue;
            if (conn.closeIfIdle(this.cfg.getMaxConnectionIdleTime())) {
                this.closeIdle();
                continue;
            }
            if (nodeId != null) {
                this.nodeConns.put(nodeId, conn);
            }
            return conn;
        }
        return this.connect(nodeId, srvs);
    }

    protected GridClientConnection connect(@Nullable UUID nodeId, Collection<InetSocketAddress> srvs) throws GridServerUnreachableException, InterruptedException {
        if (srvs.isEmpty()) {
            throw new GridServerUnreachableException("Failed to establish connection to the grid node (address list is empty).");
        }
        Exception cause = null;
        for (InetSocketAddress srv : srvs) {
            try {
                return this.connect(nodeId, srv);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                if (cause == null) {
                    cause = e;
                    continue;
                }
                if (!this.log.isLoggable(Level.INFO)) continue;
                this.log.info("Unable to connect to grid node [srvAddr=" + srv + ", msg=" + e.getMessage() + ']');
            }
        }
        assert (cause != null);
        throw new GridServerUnreachableException("Failed to connect to any of the servers in list: " + srvs, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GridClientConnection connect(@Nullable UUID nodeId, InetSocketAddress addr) throws IOException, GridClientException, InterruptedException {
        this.endpointStripedLock.lock(addr);
        try {
            GridClientNioTcpConnection conn;
            GridClientConnection old = (GridClientConnection)this.conns.get(addr);
            if (old != null) {
                if (old.isClosed()) {
                    this.conns.remove(addr, old);
                    if (nodeId != null) {
                        this.nodeConns.remove(nodeId, old);
                    }
                } else {
                    if (nodeId != null) {
                        this.nodeConns.put(nodeId, old);
                    }
                    GridClientConnection gridClientConnection = old;
                    return gridClientConnection;
                }
            }
            SecurityCredentials cred = null;
            try {
                if (this.cfg.getSecurityCredentialsProvider() != null) {
                    cred = this.cfg.getSecurityCredentialsProvider().credentials();
                }
            }
            catch (IgniteCheckedException e) {
                throw new GridClientException("Failed to obtain client credentials.", e);
            }
            if (this.cfg.getProtocol() == GridClientProtocol.TCP) {
                GridClientMarshaller marsh = this.cfg.getMarshaller();
                try {
                    conn = new GridClientNioTcpConnection(this.srv, this.clientId, addr, this.sslCtx, this.pingExecutor, this.cfg.getConnectTimeout(), this.cfg.getPingInterval(), this.cfg.getPingTimeout(), this.cfg.isTcpNoDelay(), marsh, this.marshId, this.top, cred, this.keepBinariesThreadLocal());
                }
                catch (GridClientException e) {
                    if (marsh instanceof GridClientZipOptimizedMarshaller) {
                        this.log.warning("Failed to connect with GridClientZipOptimizedMarshaller, trying to fallback to default marshaller: " + e);
                        conn = new GridClientNioTcpConnection(this.srv, this.clientId, addr, this.sslCtx, this.pingExecutor, this.cfg.getConnectTimeout(), this.cfg.getPingInterval(), this.cfg.getPingTimeout(), this.cfg.isTcpNoDelay(), ((GridClientZipOptimizedMarshaller)marsh).defaultMarshaller(), this.marshId, this.top, cred, this.keepBinariesThreadLocal());
                    }
                    throw e;
                }
            } else {
                throw new GridServerUnreachableException("Failed to create client (protocol is not supported): " + (Object)((Object)this.cfg.getProtocol()));
            }
            old = this.conns.putIfAbsent(addr, conn);
            assert (old == null);
            if (nodeId != null) {
                this.nodeConns.put(nodeId, conn);
            }
            GridClientNioTcpConnection gridClientNioTcpConnection = conn;
            return gridClientNioTcpConnection;
        }
        finally {
            this.endpointStripedLock.unlock(addr);
        }
    }

    protected ThreadLocal<Boolean> keepBinariesThreadLocal() {
        return null;
    }

    @Override
    public void terminateConnection(GridClientConnection conn, GridClientNode node, Throwable e) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Connection with remote node was terminated [node=" + node + ", srvAddr=" + conn.serverAddress() + ", errMsg=" + e.getMessage() + ']');
        }
        this.closeIdle();
        conn.close(GridClientConnectionCloseReason.FAILED, false);
    }

    @Override
    public void stop(boolean waitCompletion) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        ArrayList closeConns = new ArrayList(this.conns.values());
        this.conns.clear();
        this.nodeConns.clear();
        for (GridClientConnection conn : closeConns) {
            conn.close(GridClientConnectionCloseReason.CLIENT_CLOSED, waitCompletion);
        }
        if (this.pingExecutor != null) {
            GridClientUtils.shutdownNow(GridClientConnectionManager.class, this.pingExecutor, this.log);
        }
        GridClientUtils.shutdownNow(GridClientConnectionManager.class, this.executor, this.log);
        if (this.srv != null) {
            this.srv.stop();
        }
    }

    private void closeIdle() {
        for (Map.Entry entry : this.nodeConns.entrySet()) {
            GridClientConnection conn = (GridClientConnection)entry.getValue();
            if (!conn.closeIfIdle(this.cfg.getMaxConnectionIdleTime())) continue;
            this.conns.remove(conn.serverAddress(), conn);
            this.nodeConns.remove(entry.getKey(), conn);
        }
        for (GridClientConnection conn : this.conns.values()) {
            if (!conn.closeIfIdle(this.cfg.getMaxConnectionIdleTime())) continue;
            this.conns.remove(conn.serverAddress(), conn);
        }
    }

    private void checkClosed() throws GridClientClosedException {
        if (this.closed) {
            throw new GridClientClosedException("Client was closed (no public methods of client can be used anymore).");
        }
    }

    private static class NioListener
    implements GridNioServerListener {
        private final Logger log;

        private NioListener(Logger log) {
            this.log = log;
        }

        @Override
        public void onConnected(GridNioSession ses) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Session connected: " + ses);
            }
        }

        @Override
        public void onDisconnected(GridNioSession ses, @Nullable Exception e) {
            GridClientFutureAdapter handshakeFut;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Session disconnected: " + ses);
            }
            if ((handshakeFut = (GridClientFutureAdapter)ses.removeMeta(GridClientNioTcpConnection.SES_META_HANDSHAKE)) != null) {
                handshakeFut.onDone(new GridClientConnectionResetException("Failed to perform handshake (connection failed)."));
            } else {
                GridClientNioTcpConnection conn = (GridClientNioTcpConnection)ses.meta(GridClientNioTcpConnection.SES_META_CONN);
                if (conn != null) {
                    conn.close(GridClientConnectionCloseReason.FAILED, false);
                }
            }
        }

        public void onMessage(GridNioSession ses, Object msg) {
            GridClientFutureAdapter handshakeFut = (GridClientFutureAdapter)ses.removeMeta(GridClientNioTcpConnection.SES_META_HANDSHAKE);
            if (handshakeFut != null) {
                assert (msg instanceof GridClientHandshakeResponse);
                this.handleHandshakeResponse(handshakeFut, (GridClientHandshakeResponse)msg);
            } else {
                GridClientNioTcpConnection conn = (GridClientNioTcpConnection)ses.meta(GridClientNioTcpConnection.SES_META_CONN);
                assert (conn != null);
                if (msg instanceof GridClientPingPacket) {
                    conn.handlePingResponse();
                } else {
                    try {
                        conn.handleResponse((GridClientMessage)msg);
                    }
                    catch (IOException e) {
                        this.log.log(Level.SEVERE, "Failed to parse response.", e);
                    }
                }
            }
        }

        private void handleHandshakeResponse(GridClientFutureAdapter<Boolean> handshakeFut, GridClientHandshakeResponse msg) {
            byte rc = msg.resultCode();
            if (rc != GridClientHandshakeResponse.OK.resultCode()) {
                handshakeFut.onDone(new GridClientHandshakeException(rc, "Handshake failed due to internal error (see server log for more details)."));
            } else {
                handshakeFut.onDone(true);
            }
        }

        @Override
        public void onSessionWriteTimeout(GridNioSession ses) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Closing NIO session because of write timeout.");
            }
            ses.close();
        }

        @Override
        public void onSessionIdleTimeout(GridNioSession ses) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Closing NIO session because of idle timeout.");
            }
            ses.close();
        }
    }
}

