/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.marshaller.jdk;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.client.marshaller.GridClientMarshaller;
import org.apache.ignite.internal.util.io.GridByteArrayOutputStream;

public class GridClientJdkMarshaller
implements GridClientMarshaller {
    public static final byte ID = 2;

    @Override
    public ByteBuffer marshal(Object obj, int off) throws IOException {
        GridByteArrayOutputStream bOut = new GridByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bOut);
        out.writeObject(obj);
        out.flush();
        ByteBuffer buf = ByteBuffer.allocate(off + bOut.size());
        buf.position(off);
        buf.put(bOut.internalArray(), 0, bOut.size());
        buf.flip();
        return buf;
    }

    @Override
    public <T> T unmarshal(byte[] bytes) throws IOException {
        ByteArrayInputStream tmp = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(tmp);
        try {
            return (T)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed to unmarshal target object: " + e.getMessage(), e);
        }
    }
}

