/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCluster;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterStartNodeResult;
import org.apache.ignite.internal.AsyncSupportAdapter;
import org.apache.ignite.internal.cluster.IgniteClusterImpl;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class IgniteClusterAsyncImpl
extends AsyncSupportAdapter<IgniteCluster>
implements IgniteCluster,
Externalizable {
    private static final long serialVersionUID = 0L;
    private IgniteClusterImpl cluster;

    public IgniteClusterAsyncImpl() {
    }

    public IgniteClusterAsyncImpl(IgniteClusterImpl cluster) {
        super(true);
        this.cluster = cluster;
    }

    @Override
    public ClusterNode localNode() {
        return this.cluster.localNode();
    }

    @Override
    public ClusterGroup forLocal() {
        return this.cluster.forLocal();
    }

    @Override
    public <K, V> ConcurrentMap<K, V> nodeLocalMap() {
        return this.cluster.nodeLocalMap();
    }

    @Override
    public boolean pingNode(UUID nodeId) {
        return this.cluster.pingNode(nodeId);
    }

    @Override
    public long topologyVersion() {
        return this.cluster.topologyVersion();
    }

    @Override
    @Nullable
    public Collection<ClusterNode> topology(long topVer) {
        return this.cluster.topology(topVer);
    }

    @Override
    public <K> Map<ClusterNode, Collection<K>> mapKeysToNodes(@Nullable String cacheName, @Nullable Collection<? extends K> keys) {
        return this.cluster.mapKeysToNodes(cacheName, keys);
    }

    @Override
    @Nullable
    public <K> ClusterNode mapKeyToNode(@Nullable String cacheName, K key) {
        return this.cluster.mapKeyToNode(cacheName, key);
    }

    @Override
    public Collection<ClusterStartNodeResult> startNodes(File file, boolean restart, int timeout, int maxConn) {
        try {
            return this.saveOrGet(this.cluster.startNodesAsync(file, restart, timeout, maxConn));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public Collection<ClusterStartNodeResult> startNodes(Collection<Map<String, Object>> hosts, @Nullable Map<String, Object> dflts, boolean restart, int timeout, int maxConn) {
        try {
            return this.saveOrGet(this.cluster.startNodesAsync(hosts, dflts, restart, timeout, maxConn));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public void stopNodes() {
        this.cluster.stopNodes();
    }

    @Override
    public void stopNodes(Collection<UUID> ids) {
        this.cluster.stopNodes(ids);
    }

    @Override
    public void restartNodes() {
        this.cluster.restartNodes();
    }

    @Override
    public void restartNodes(Collection<UUID> ids) {
        this.cluster.restartNodes(ids);
    }

    @Override
    public void resetMetrics() {
        this.cluster.resetMetrics();
    }

    @Override
    public Ignite ignite() {
        return this.cluster.ignite();
    }

    @Override
    public ClusterGroup forNodes(Collection<? extends ClusterNode> nodes) {
        return this.cluster.forNodes(nodes);
    }

    @Override
    public ClusterGroup forNode(ClusterNode node, ClusterNode ... nodes) {
        return this.cluster.forNode(node, nodes);
    }

    @Override
    public ClusterGroup forOthers(ClusterNode node, ClusterNode ... nodes) {
        return this.cluster.forOthers(node, nodes);
    }

    @Override
    public ClusterGroup forOthers(ClusterGroup prj) {
        return this.cluster.forOthers(prj);
    }

    @Override
    public ClusterGroup forNodeIds(Collection<UUID> ids) {
        return this.cluster.forNodeIds(ids);
    }

    @Override
    public ClusterGroup forNodeId(UUID id, UUID ... ids) {
        return this.cluster.forNodeId(id, ids);
    }

    @Override
    public ClusterGroup forPredicate(IgnitePredicate<ClusterNode> p) {
        return this.cluster.forPredicate(p);
    }

    @Override
    public ClusterGroup forAttribute(String name, @Nullable Object val) {
        return this.cluster.forAttribute(name, val);
    }

    @Override
    public ClusterGroup forServers() {
        return this.cluster.forServers();
    }

    @Override
    public ClusterGroup forClients() {
        return this.cluster.forClients();
    }

    @Override
    public ClusterGroup forCacheNodes(String cacheName) {
        return this.cluster.forCacheNodes(cacheName);
    }

    @Override
    public ClusterGroup forDataNodes(String cacheName) {
        return this.cluster.forDataNodes(cacheName);
    }

    @Override
    public ClusterGroup forClientNodes(String cacheName) {
        return this.cluster.forClientNodes(cacheName);
    }

    @Override
    public ClusterGroup forRemotes() {
        return this.cluster.forRemotes();
    }

    @Override
    public ClusterGroup forHost(ClusterNode node) {
        return this.cluster.forHost(node);
    }

    @Override
    public ClusterGroup forHost(String host, String ... hosts) {
        return this.cluster.forHost(host, hosts);
    }

    @Override
    public ClusterGroup forDaemons() {
        return this.cluster.forDaemons();
    }

    @Override
    public ClusterGroup forRandom() {
        return this.cluster.forRandom();
    }

    @Override
    public ClusterGroup forOldest() {
        return this.cluster.forOldest();
    }

    @Override
    public ClusterGroup forYoungest() {
        return this.cluster.forYoungest();
    }

    @Override
    public Collection<ClusterNode> nodes() {
        return this.cluster.nodes();
    }

    @Override
    @Nullable
    public ClusterNode node(UUID id) {
        return this.cluster.node(id);
    }

    @Override
    public Collection<String> hostNames() {
        return this.cluster.hostNames();
    }

    @Override
    @Nullable
    public ClusterNode node() {
        return this.cluster.node();
    }

    @Override
    public IgnitePredicate<ClusterNode> predicate() {
        return this.cluster.predicate();
    }

    @Override
    public ClusterMetrics metrics() {
        return this.cluster.metrics();
    }

    @Override
    @Nullable
    public IgniteFuture<?> clientReconnectFuture() {
        return this.cluster.clientReconnectFuture();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cluster = (IgniteClusterImpl)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cluster);
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.cluster.withAsync();
    }
}

