/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCluster;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterGroupEmptyException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterStartNodeResult;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterGroupAdapter;
import org.apache.ignite.internal.cluster.ClusterNodeLocalMapImpl;
import org.apache.ignite.internal.cluster.IgniteClusterAsyncImpl;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.cluster.IgniteKillTask;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.nodestart.IgniteNodeStartUtils;
import org.apache.ignite.internal.util.nodestart.IgniteRemoteStartSpecification;
import org.apache.ignite.internal.util.nodestart.IgniteSshHelper;
import org.apache.ignite.internal.util.nodestart.StartNodeCallable;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class IgniteClusterImpl
extends ClusterGroupAdapter
implements IgniteClusterEx,
Externalizable {
    private static final long serialVersionUID = 0L;
    private IgniteConfiguration cfg;
    @GridToStringExclude
    private ConcurrentMap nodeLoc;
    private IgniteFuture<?> reconnecFut;

    public IgniteClusterImpl() {
    }

    public IgniteClusterImpl(GridKernalContext ctx) {
        super(ctx, null, (IgnitePredicate<ClusterNode>)null);
        this.cfg = ctx.config();
        this.nodeLoc = new ClusterNodeLocalMapImpl(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusterGroup forLocal() {
        this.guard();
        try {
            ClusterGroupAdapter clusterGroupAdapter = new ClusterGroupAdapter(this.ctx, null, Collections.singleton(this.cfg.getNodeId()));
            return clusterGroupAdapter;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusterNode localNode() {
        this.guard();
        try {
            ClusterNode node = this.ctx.discovery().localNode();
            assert (node != null);
            ClusterNode clusterNode = node;
            return clusterNode;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> ConcurrentMap<K, V> nodeLocalMap() {
        return this.nodeLoc;
    }

    @Override
    public boolean pingNode(UUID nodeId) {
        A.notNull(nodeId, "nodeId");
        this.guard();
        try {
            boolean bl = this.ctx.discovery().pingNode(nodeId);
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long topologyVersion() {
        this.guard();
        try {
            long l = this.ctx.discovery().topologyVersion();
            return l;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ClusterNode> topology(long topVer) throws UnsupportedOperationException {
        this.guard();
        try {
            Collection<ClusterNode> collection = this.ctx.discovery().topology(topVer);
            return collection;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K> Map<ClusterNode, Collection<K>> mapKeysToNodes(@Nullable String cacheName, @Nullable Collection<? extends K> keys) throws IgniteException {
        if (F.isEmpty(keys)) {
            return Collections.emptyMap();
        }
        this.guard();
        try {
            Map<ClusterNode, Collection<K>> map = this.ctx.affinity().mapKeysToNodes(cacheName, keys);
            return map;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K> ClusterNode mapKeyToNode(@Nullable String cacheName, K key) throws IgniteException {
        A.notNull(key, "key");
        this.guard();
        try {
            ClusterNode clusterNode = this.ctx.affinity().mapKeyToNode(cacheName, key);
            return clusterNode;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<ClusterStartNodeResult> startNodes(File file, boolean restart, int timeout, int maxConn) throws IgniteException {
        try {
            return this.startNodesAsync(file, restart, timeout, maxConn).get();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public Collection<ClusterStartNodeResult> startNodes(Collection<Map<String, Object>> hosts, @Nullable Map<String, Object> dflts, boolean restart, int timeout, int maxConn) throws IgniteException {
        try {
            return this.startNodesAsync(hosts, dflts, restart, timeout, maxConn).get();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopNodes() throws IgniteException {
        this.guard();
        try {
            this.compute().execute(IgniteKillTask.class, Boolean.valueOf(false));
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopNodes(Collection<UUID> ids) throws IgniteException {
        this.guard();
        try {
            this.ctx.grid().compute(this.forNodeIds(ids)).execute(IgniteKillTask.class, Boolean.valueOf(false));
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartNodes() throws IgniteException {
        this.guard();
        try {
            this.compute().execute(IgniteKillTask.class, Boolean.valueOf(true));
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartNodes(Collection<UUID> ids) throws IgniteException {
        this.guard();
        try {
            this.ctx.grid().compute(this.forNodeIds(ids)).execute(IgniteKillTask.class, Boolean.valueOf(true));
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetMetrics() {
        this.guard();
        try {
            this.ctx.jobMetric().reset();
            this.ctx.io().resetMetrics();
            this.ctx.task().resetMetrics();
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public IgniteCluster withAsync() {
        return new IgniteClusterAsyncImpl(this);
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public <R> IgniteFuture<R> future() {
        throw new IllegalStateException("Asynchronous mode is not enabled.");
    }

    IgniteInternalFuture<Collection<ClusterStartNodeResult>> startNodesAsync(File file, boolean restart, int timeout, int maxConn) {
        A.notNull(file, "file");
        A.ensure(file.exists(), "file doesn't exist.");
        A.ensure(file.isFile(), "file is a directory.");
        try {
            IgniteBiTuple<Collection<Map<String, Object>>, Map<String, Object>> t = IgniteNodeStartUtils.parseFile(file);
            return this.startNodesAsync(t.get1(), t.get2(), restart, timeout, maxConn);
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<Collection<ClusterStartNodeResult>>(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IgniteInternalFuture<Collection<ClusterStartNodeResult>> startNodesAsync(Collection<Map<String, Object>> hosts, @Nullable Map<String, Object> dflts, boolean restart, int timeout, int maxConn) {
        A.notNull(hosts, "hosts");
        this.guard();
        try {
            IgniteSshHelper sshHelper = (IgniteSshHelper)IgniteComponentType.SSH.create(false);
            Map<String, Collection<IgniteRemoteStartSpecification>> specsMap = IgniteNodeStartUtils.specifications(hosts, dflts);
            HashMap runMap = new HashMap();
            int nodeCallCnt = 0;
            for (String host : specsMap.keySet()) {
                InetAddress addr;
                try {
                    addr = InetAddress.getByName(host);
                }
                catch (UnknownHostException e) {
                    throw new IgniteCheckedException("Invalid host name: " + host, e);
                }
                Collection<ClusterNode> neighbors = null;
                if (addr.isLoopbackAddress()) {
                    neighbors = this.neighbors();
                } else {
                    for (Collection<ClusterNode> p : U.neighborhood(this.nodes()).values()) {
                        ClusterNode node = F.first(p);
                        if (!((String)node.attribute("org.apache.ignite.ips")).contains(addr.getHostAddress())) continue;
                        neighbors = p;
                        break;
                    }
                }
                int startIdx = 1;
                if (neighbors != null) {
                    if (restart && !neighbors.isEmpty()) {
                        try {
                            this.ctx.grid().compute(this.forNodes(neighbors)).execute(IgniteKillTask.class, Boolean.valueOf(false));
                        }
                        catch (ClusterGroupEmptyException p) {}
                    } else {
                        startIdx = neighbors.size() + 1;
                    }
                }
                ConcurrentLinkedQueue<StartNodeCallable> nodeRuns = new ConcurrentLinkedQueue<StartNodeCallable>();
                runMap.put(host, nodeRuns);
                for (IgniteRemoteStartSpecification spec : specsMap.get(host)) {
                    assert (spec.host().equals(host));
                    for (int i = startIdx; i <= spec.nodes(); ++i) {
                        nodeRuns.add(sshHelper.nodeStartCallable(spec, timeout));
                        ++nodeCallCnt;
                    }
                }
            }
            if (nodeCallCnt == 0) {
                GridFinishedFuture i$ = new GridFinishedFuture(Collections.emptyList());
                return i$;
            }
            GridCompoundFuture<ClusterStartNodeResult, Collection<ClusterStartNodeResult>> fut = new GridCompoundFuture<ClusterStartNodeResult, Collection<ClusterStartNodeResult>>(CU.objectsReducer());
            AtomicInteger cnt = new AtomicInteger(nodeCallCnt);
            for (ConcurrentLinkedQueue queue : runMap.values()) {
                for (int i = 0; i < maxConn && this.runNextNodeCallable(queue, fut, cnt); ++i) {
                }
            }
            GridCompoundFuture<ClusterStartNodeResult, Collection<ClusterStartNodeResult>> gridCompoundFuture = fut;
            return gridCompoundFuture;
        }
        catch (IgniteCheckedException e) {
            GridFinishedFuture<Collection<ClusterStartNodeResult>> gridFinishedFuture = new GridFinishedFuture<Collection<ClusterStartNodeResult>>(e);
            return gridFinishedFuture;
        }
        finally {
            this.unguard();
        }
    }

    private Collection<ClusterNode> neighbors() {
        ArrayList<ClusterNode> neighbors = new ArrayList<ClusterNode>(1);
        String macs = (String)this.localNode().attribute("org.apache.ignite.macs");
        assert (macs != null);
        for (ClusterNode n : this.forOthers(this.localNode(), new ClusterNode[0]).nodes()) {
            if (!macs.equals(n.attribute("org.apache.ignite.macs"))) continue;
            neighbors.add(n);
        }
        return neighbors;
    }

    private boolean runNextNodeCallable(final ConcurrentLinkedQueue<StartNodeCallable> queue, final GridCompoundFuture<ClusterStartNodeResult, Collection<ClusterStartNodeResult>> comp, final AtomicInteger cnt) {
        StartNodeCallable call = queue.poll();
        if (call == null) {
            return false;
        }
        IgniteInternalFuture<ClusterStartNodeResult> fut = this.ctx.closure().callLocalSafe(call, true);
        comp.add(fut);
        if (cnt.decrementAndGet() == 0) {
            comp.markInitialized();
        }
        fut.listen((IgniteInClosure<IgniteInternalFuture<ClusterStartNodeResult>>)new CI1<IgniteInternalFuture<ClusterStartNodeResult>>(){

            @Override
            public void apply(IgniteInternalFuture<ClusterStartNodeResult> f) {
                IgniteClusterImpl.this.runNextNodeCallable(queue, comp, cnt);
            }
        });
        return true;
    }

    public void clearNodeMap() {
        this.nodeLoc.clear();
    }

    public void clientReconnectFuture(IgniteFuture<?> reconnecFut) {
        this.reconnecFut = reconnecFut;
    }

    @Override
    @Nullable
    public IgniteFuture<?> clientReconnectFuture() {
        return this.reconnecFut;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ctx = (GridKernalContext)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx);
    }

    @Override
    protected Object readResolve() throws ObjectStreamException {
        return this.ctx.grid().cluster();
    }

    public String toString() {
        return "IgniteCluster [igniteName=" + this.ctx.gridName() + ']';
    }
}

