/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.igfs.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jsr166.ConcurrentHashMap8;
import org.jsr166.ConcurrentLinkedDeque8;

public final class IgfsLogger {
    public static final String DELIM_FIELD = ";";
    public static final String DELIM_FIELD_VAL = ",";
    public static final String HDR = "Timestamp;ThreadID;PID;Type;Path;Mode;StreamId;BufSize;DataLen;Append;Overwrite;Replication;BlockSize;Position;ReadLen;SkipCnt;ReadLimit;UserTime;SystemTime;TotalBytes;DestPath;Recursive;List";
    public static final int TYPE_OPEN_IN = 0;
    public static final int TYPE_OPEN_OUT = 1;
    public static final int TYPE_RANDOM_READ = 2;
    public static final int TYPE_SEEK = 3;
    public static final int TYPE_SKIP = 4;
    public static final int TYPE_MARK = 5;
    public static final int TYPE_RESET = 6;
    public static final int TYPE_CLOSE_IN = 7;
    public static final int TYPE_CLOSE_OUT = 8;
    public static final int TYPE_DIR_MAKE = 9;
    public static final int TYPE_DIR_LIST = 10;
    public static final int TYPE_RENAME = 11;
    public static final int TYPE_DELETE = 12;
    private static final AtomicLong CNTR = new AtomicLong();
    private static final ConcurrentHashMap8<String, IgfsLogger> loggers = new ConcurrentHashMap8();
    private static final ReadWriteLock logLock = new ReentrantReadWriteLock();
    private static final IgfsLogger disabledLogger = new IgfsLogger();
    private boolean enabled;
    private String endpoint;
    private int batchSize;
    private File file;
    private ReadWriteLock rwLock;
    private Lock flushLock;
    private Condition flushCond;
    private Thread flushWorker;
    private int pid;
    private Collection<Entry> entries;
    private AtomicInteger cnt;
    private AtomicInteger useCnt;

    public static long nextId() {
        return CNTR.incrementAndGet();
    }

    public static IgfsLogger disabledLogger() {
        return disabledLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IgfsLogger logger(String endpoint, String igfsName, String dir, int batchSize) {
        if (endpoint == null) {
            endpoint = "";
        }
        logLock.readLock().lock();
        try {
            IgfsLogger log0;
            IgfsLogger log = loggers.get(endpoint);
            if (log == null && (log0 = loggers.putIfAbsent(endpoint, log = new IgfsLogger(endpoint, igfsName, dir, batchSize))) != null) {
                log = log0;
            }
            log.useCnt.incrementAndGet();
            IgfsLogger igfsLogger = log;
            return igfsLogger;
        }
        finally {
            logLock.readLock().unlock();
        }
    }

    private IgfsLogger() {
    }

    private IgfsLogger(String endpoint, String igfsName, String dir, int batchSize) {
        A.notNull(endpoint, "endpoint cannot be null");
        A.notNull(dir, "dir cannot be null");
        A.ensure(batchSize > 0, "batch size cannot be negative");
        this.enabled = true;
        this.endpoint = endpoint;
        this.batchSize = batchSize;
        this.pid = U.jvmPid();
        File dirFile = new File(dir);
        A.ensure(dirFile.isDirectory(), "dir must point to a directory");
        A.ensure(dirFile.exists(), "dir must exist");
        this.file = new File(dirFile, "igfs-log-" + igfsName + "-" + this.pid + ".csv");
        this.entries = new ConcurrentLinkedDeque8<Entry>();
        this.cnt = new AtomicInteger();
        this.useCnt = new AtomicInteger();
        this.rwLock = new ReentrantReadWriteLock();
        this.flushLock = new ReentrantLock();
        this.flushCond = this.flushLock.newCondition();
        this.flushWorker = new Thread(new FlushWorker());
        this.flushWorker.setDaemon(true);
        this.flushWorker.start();
    }

    public boolean isLogEnabled() {
        return this.enabled;
    }

    public void logOpen(long streamId, IgfsPath path, IgfsMode mode, int bufSize, long dataLen) {
        this.addEntry(new Entry(0, path.toString(), mode, streamId, bufSize, dataLen, null, null, null, null, null, null, null, null, null, null, null, null, null, null));
    }

    public void logCreate(long streamId, IgfsPath path, IgfsMode mode, boolean overwrite, int bufSize, int replication, long blockSize) {
        this.addEntry(new Entry(1, path.toString(), mode, streamId, bufSize, null, false, overwrite, replication, blockSize, null, null, null, null, null, null, null, null, null, null));
    }

    public void logAppend(long streamId, IgfsPath path, IgfsMode mode, int bufSize) {
        this.addEntry(new Entry(1, path.toString(), mode, streamId, bufSize, null, true, null, null, null, null, null, null, null, null, null, null, null, null, null));
    }

    public void logRandomRead(long streamId, long pos, int readLen) {
        this.addEntry(new Entry(2, null, null, streamId, null, null, null, null, null, null, pos, readLen, null, null, null, null, null, null, null, null));
    }

    public void logSeek(long streamId, long pos) {
        this.addEntry(new Entry(3, null, null, streamId, null, null, null, null, null, null, pos, null, null, null, null, null, null, null, null, null));
    }

    public void logSkip(long streamId, long skipCnt) {
        this.addEntry(new Entry(4, null, null, streamId, null, null, null, null, null, null, null, null, skipCnt, null, null, null, null, null, null, null));
    }

    public void logMark(long streamId, long readLimit) {
        this.addEntry(new Entry(5, null, null, streamId, null, null, null, null, null, null, null, null, null, readLimit, null, null, null, null, null, null));
    }

    public void logReset(long streamId) {
        this.addEntry(new Entry(6, null, null, streamId, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null));
    }

    public void logCloseIn(long streamId, long userTime, long readTime, long total) {
        this.addEntry(new Entry(7, null, null, streamId, null, null, null, null, null, null, null, null, null, null, userTime, readTime, total, null, null, null));
    }

    public void logCloseOut(long streamId, long userTime, long writeTime, long total) {
        this.addEntry(new Entry(8, null, null, streamId, null, null, null, null, null, null, null, null, null, null, userTime, writeTime, total, null, null, null));
    }

    public void logMakeDirectory(IgfsPath path, IgfsMode mode) {
        this.addEntry(new Entry(9, path.toString(), mode, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null));
    }

    public void logListDirectory(IgfsPath path, IgfsMode mode, String[] files) {
        this.addEntry(new Entry(10, path.toString(), mode, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, files));
    }

    public void logRename(IgfsPath path, IgfsMode mode, IgfsPath destPath) {
        this.addEntry(new Entry(11, path.toString(), mode, null, null, null, null, null, null, null, null, null, null, null, null, null, null, destPath.toString(), null, null));
    }

    public void logDelete(IgfsPath path, IgfsMode mode, boolean recursive) {
        this.addEntry(new Entry(12, path.toString(), mode, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, recursive, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean close = false;
        if (this.useCnt.decrementAndGet() == 0) {
            logLock.writeLock().lock();
            try {
                if (this.useCnt.get() == 0) {
                    loggers.remove(this.endpoint);
                    close = true;
                }
            }
            finally {
                logLock.writeLock().unlock();
            }
        }
        if (close) {
            U.interrupt(this.flushWorker);
            try {
                U.join(this.flushWorker);
            }
            catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                // empty catch block
            }
            this.entries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(Entry entry) {
        assert (entry != null);
        this.rwLock.readLock().lock();
        try {
            this.entries.add(entry);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        if (this.cnt.incrementAndGet() >= this.batchSize && this.flushLock.tryLock()) {
            try {
                this.flushCond.signalAll();
            }
            finally {
                this.flushLock.unlock();
            }
        }
    }

    private class FlushWorker
    implements Runnable {
        private FlushWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread t = Thread.currentThread();
            while (!Thread.interrupted()) {
                IgfsLogger.this.flushLock.lock();
                try {
                    while (IgfsLogger.this.cnt.get() < IgfsLogger.this.batchSize && !t.isInterrupted()) {
                        try {
                            U.await(IgfsLogger.this.flushCond, 1000L, TimeUnit.MILLISECONDS);
                        }
                        catch (IgniteInterruptedCheckedException ignore) {
                            t.interrupt();
                            break;
                        }
                    }
                }
                finally {
                    IgfsLogger.this.flushLock.unlock();
                }
                if (t.isInterrupted()) continue;
                this.flush();
            }
            this.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flush() {
            block12: {
                Collection entries0;
                IgfsLogger.this.rwLock.writeLock().lock();
                try {
                    entries0 = IgfsLogger.this.entries;
                    IgfsLogger.this.entries = new ConcurrentLinkedDeque8();
                }
                finally {
                    IgfsLogger.this.rwLock.writeLock().unlock();
                }
                IgfsLogger.this.cnt.set(0);
                if (!entries0.isEmpty()) {
                    boolean addHdr = !IgfsLogger.this.file.exists();
                    FileOutputStream fos = null;
                    OutputStreamWriter osw = null;
                    BufferedWriter bw = null;
                    try {
                        fos = new FileOutputStream(IgfsLogger.this.file, true);
                        osw = new OutputStreamWriter(fos);
                        bw = new BufferedWriter(osw);
                        if (addHdr) {
                            bw.write(IgfsLogger.HDR + U.nl());
                        }
                        for (Entry entry : entries0) {
                            bw.write(entry + U.nl());
                        }
                        U.closeQuiet(bw);
                    }
                    catch (IOException e) {
                        U.error(null, "Failed to flush logged entries to a disk due to an IO exception.", e);
                        break block12;
                    }
                    finally {
                        U.closeQuiet(bw);
                        U.closeQuiet(osw);
                        U.closeQuiet(fos);
                    }
                    U.closeQuiet(osw);
                    U.closeQuiet(fos);
                }
            }
        }
    }

    private class Entry {
        private final long threadId = Thread.currentThread().getId();
        private final long ts = U.currentTimeMillis();
        private final int type;
        private final String path;
        private IgfsMode mode;
        private final long streamId;
        private final int bufSize;
        private final long dataLen;
        private final Boolean append;
        private final Boolean overwrite;
        private final int replication;
        private final long blockSize;
        private final long pos;
        private final int readLen;
        private final long skipCnt;
        private final long readLimit;
        private final long userTime;
        private final long sysTime;
        private final long total;
        private final String destPath;
        private final Boolean recursive;
        private final String[] list;

        Entry(int type, String path, IgfsMode mode, Long streamId, Integer bufSize, Long dataLen, Boolean append, Boolean overwrite, Integer replication, Long blockSize, Long pos, Integer readLen, Long skipCnt, Long readLimit, Long userTime, Long sysTime, Long total, String destPath, Boolean recursive, String[] list) {
            this.type = type;
            this.path = path;
            this.mode = mode;
            this.streamId = streamId != null ? streamId : -1L;
            this.bufSize = bufSize != null ? bufSize : -1;
            this.dataLen = dataLen != null ? dataLen : -1L;
            this.append = append;
            this.overwrite = overwrite;
            this.replication = replication != null ? replication : -1;
            this.blockSize = blockSize != null ? blockSize : -1L;
            this.pos = pos != null ? pos : -1L;
            this.readLen = readLen != null ? readLen : -1;
            this.skipCnt = skipCnt != null ? skipCnt : -1L;
            this.readLimit = readLimit != null ? readLimit : -1L;
            this.userTime = userTime != null ? userTime : -1L;
            this.sysTime = sysTime != null ? sysTime : -1L;
            this.total = total != null ? total : -1L;
            this.destPath = destPath;
            this.recursive = recursive;
            this.list = list;
        }

        private String string(int val) {
            return val != -1 ? String.valueOf(val) : "";
        }

        private String string(long val) {
            return val != -1L ? String.valueOf(val) : "";
        }

        private String string(Object val) {
            if (val == null) {
                return "";
            }
            if (val instanceof Boolean) {
                return (Boolean)val != false ? "1" : "0";
            }
            if (val instanceof String) {
                return ((String)val).replace(';', '~');
            }
            if (val instanceof String[]) {
                String[] val0 = (String[])val;
                SB buf = new SB();
                boolean first = true;
                for (String str : val0) {
                    if (first) {
                        first = false;
                    } else {
                        buf.a(IgfsLogger.DELIM_FIELD_VAL);
                    }
                    buf.a(str.replace(';', '~'));
                }
                return buf.toString();
            }
            return val.toString();
        }

        public String toString() {
            SB res = new SB();
            res.a(this.ts).a(IgfsLogger.DELIM_FIELD).a(this.threadId).a(IgfsLogger.DELIM_FIELD).a(IgfsLogger.this.pid).a(IgfsLogger.DELIM_FIELD).a(this.type).a(IgfsLogger.DELIM_FIELD).a(this.string(this.path)).a(IgfsLogger.DELIM_FIELD).a(this.string((Object)this.mode)).a(IgfsLogger.DELIM_FIELD).a(this.string(this.streamId)).a(IgfsLogger.DELIM_FIELD).a(this.string(this.bufSize)).a(IgfsLogger.DELIM_FIELD).a(this.string(this.dataLen)).a(IgfsLogger.DELIM_FIELD).a(this.string(this.append)).a(IgfsLogger.DELIM_FIELD).a(this.string(this.overwrite)).a(IgfsLogger.DELIM_FIELD).a(this.string(this.replication)).a(IgfsLogger.DELIM_FIELD).a(this.string(this.blockSize)).a(IgfsLogger.DELIM_FIELD).a(this.string(this.pos)).a(IgfsLogger.DELIM_FIELD).a(this.string(this.readLen)).a(IgfsLogger.DELIM_FIELD).a(this.string(this.skipCnt)).a(IgfsLogger.DELIM_FIELD).a(this.string(this.readLimit)).a(IgfsLogger.DELIM_FIELD).a(this.string(this.userTime)).a(IgfsLogger.DELIM_FIELD).a(this.string(this.sysTime)).a(IgfsLogger.DELIM_FIELD).a(this.string(this.total)).a(IgfsLogger.DELIM_FIELD).a(this.string(this.destPath)).a(IgfsLogger.DELIM_FIELD).a(this.string(this.recursive)).a(IgfsLogger.DELIM_FIELD).a(this.string(this.list));
            return res.toString();
        }
    }
}

