/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.compute.ComputeTaskTimeoutException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.jdbc2.JdbcDatabaseMetadata;
import org.apache.ignite.internal.jdbc2.JdbcPreparedStatement;
import org.apache.ignite.internal.jdbc2.JdbcStatement;
import org.apache.ignite.internal.jdbc2.JdbcStreamedPreparedStatement;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;

public class JdbcConnection
implements Connection {
    private static final String NULL = "null";
    private static final ConcurrentMap<String, IgniteNodeFuture> NODES = new ConcurrentHashMap<String, IgniteNodeFuture>();
    private final Ignite ignite;
    private final String cfg;
    private String cacheName;
    private boolean closed;
    private String url;
    private UUID nodeId;
    private boolean locQry;
    private boolean collocatedQry;
    private boolean distributedJoins;
    private final boolean stream;
    private final long streamFlushTimeout;
    private final int streamNodeBufSize;
    private final int streamNodeParOps;
    private final boolean streamAllowOverwrite;
    final Set<JdbcStatement> statements = new HashSet<JdbcStatement>();

    public JdbcConnection(String url, Properties props) throws SQLException {
        assert (url != null);
        assert (props != null);
        this.url = url;
        this.cacheName = props.getProperty("ignite.jdbc.cache");
        this.locQry = Boolean.parseBoolean(props.getProperty("ignite.jdbc.local"));
        this.collocatedQry = Boolean.parseBoolean(props.getProperty("ignite.jdbc.collocated"));
        this.distributedJoins = Boolean.parseBoolean(props.getProperty("ignite.jdbc.distributedJoins"));
        this.stream = Boolean.parseBoolean(props.getProperty("ignite.jdbc.streaming"));
        this.streamAllowOverwrite = Boolean.parseBoolean(props.getProperty("ignite.jdbc.streamingAllowOverwrite"));
        this.streamFlushTimeout = Long.parseLong(props.getProperty("ignite.jdbc.streamingFlushFrequency", "0"));
        this.streamNodeBufSize = Integer.parseInt(props.getProperty("ignite.jdbc.streamingPerNodeBufferSize", String.valueOf(1024)));
        this.streamNodeParOps = Integer.parseInt(props.getProperty("ignite.jdbc.streamingPerNodeParallelOperations", String.valueOf(16)));
        String nodeIdProp = props.getProperty("ignite.jdbc.nodeId");
        if (nodeIdProp != null) {
            this.nodeId = UUID.fromString(nodeIdProp);
        }
        try {
            String cfgUrl = props.getProperty("ignite.jdbc.cfg");
            this.cfg = cfgUrl == null || cfgUrl.isEmpty() ? NULL : cfgUrl;
            this.ignite = this.getIgnite(this.cfg);
            if (!this.isValid(2)) {
                throw new SQLException("Client is invalid. Probably cache name is wrong.");
            }
        }
        catch (Exception e) {
            this.close();
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException("Failed to start Ignite node.", e);
        }
    }

    private Ignite getIgnite(String cfgUrl) throws IgniteCheckedException {
        while (true) {
            IgniteNodeFuture fut;
            if ((fut = (IgniteNodeFuture)NODES.get(this.cfg)) == null) {
                fut = new IgniteNodeFuture();
                IgniteNodeFuture old = NODES.putIfAbsent(this.cfg, fut);
                if (old != null) {
                    fut = old;
                } else {
                    try {
                        Ignite ignite;
                        if (NULL.equals(this.cfg)) {
                            Ignition.setClientMode(true);
                            ignite = Ignition.start();
                        } else {
                            ignite = Ignition.start(this.loadConfiguration(cfgUrl));
                        }
                        fut.onDone(ignite);
                    }
                    catch (IgniteException e) {
                        fut.onDone(e);
                    }
                    return (Ignite)fut.get();
                }
            }
            if (fut.acquire()) {
                return (Ignite)fut.get();
            }
            NODES.remove(this.cfg, fut);
        }
    }

    private IgniteConfiguration loadConfiguration(String cfgUrl) {
        try {
            IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> cfgMap = IgnitionEx.loadConfigurations(cfgUrl);
            IgniteConfiguration cfg = (IgniteConfiguration)F.first((Iterable)cfgMap.get1());
            if (cfg.getGridName() == null) {
                cfg.setGridName("ignite-jdbc-driver-" + UUID.randomUUID().toString());
            }
            cfg.setClientMode(true);
            return cfg;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.ensureNotClosed();
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.ensureNotClosed();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.ensureNotClosed();
        if (!autoCommit) {
            throw new SQLFeatureNotSupportedException("Transactions are not supported.");
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.ensureNotClosed();
        return true;
    }

    @Override
    public void commit() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public void rollback() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Iterator<JdbcStatement> it = this.statements.iterator();
        while (it.hasNext()) {
            JdbcStatement stmt = it.next();
            stmt.closeInternal();
            it.remove();
        }
        IgniteNodeFuture fut = (IgniteNodeFuture)NODES.get(this.cfg);
        if (fut != null && fut.release()) {
            NODES.remove(this.cfg);
            if (this.ignite != null) {
                this.ignite.close();
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.ensureNotClosed();
        return new JdbcDatabaseMetadata(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureNotClosed();
        if (!readOnly) {
            throw new SQLFeatureNotSupportedException("Updates are not supported.");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureNotClosed();
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Catalogs are not supported.");
    }

    @Override
    public String getCatalog() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public Statement createStatement(int resSetType, int resSetConcurrency) throws SQLException {
        return this.createStatement(resSetType, resSetConcurrency, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resSetType, int resSetConcurrency) throws SQLException {
        this.ensureNotClosed();
        return this.prepareStatement(sql, resSetType, resSetConcurrency, 1);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resSetType, int resSetConcurrency) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException("Types mapping is not supported.");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Types mapping is not supported.");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.ensureNotClosed();
        if (holdability != 1) {
            throw new SQLFeatureNotSupportedException("Invalid holdability (transactions are not supported).");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureNotClosed();
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public Statement createStatement(int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        if (resSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Invalid result set type (only forward is supported.)");
        }
        if (resSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Invalid concurrency (updates are not supported).");
        }
        if (resSetHoldability != 1) {
            throw new SQLFeatureNotSupportedException("Invalid holdability (transactions are not supported).");
        }
        JdbcStatement stmt = new JdbcStatement(this);
        this.statements.add(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        JdbcPreparedStatement stmt;
        this.ensureNotClosed();
        if (resSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Invalid result set type (only forward is supported.)");
        }
        if (resSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Invalid concurrency (updates are not supported).");
        }
        if (resSetHoldability != 1) {
            throw new SQLFeatureNotSupportedException("Invalid holdability (transactions are not supported).");
        }
        if (!this.stream) {
            stmt = new JdbcPreparedStatement(this, sql);
        } else {
            PreparedStatement nativeStmt = this.prepareNativeStatement(sql);
            IgniteDataStreamer<?, ?> streamer = ((IgniteEx)this.ignite).context().query().createStreamer(this.cacheName, nativeStmt, this.streamFlushTimeout, this.streamNodeBufSize, this.streamNodeParOps, this.streamAllowOverwrite);
            stmt = new JdbcStreamedPreparedStatement(this, sql, streamer, nativeStmt);
        }
        this.statements.add(stmt);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public Clob createClob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.ensureNotClosed();
        if (timeout < 0) {
            throw new SQLException("Invalid timeout: " + timeout);
        }
        try {
            JdbcConnectionValidationTask task = new JdbcConnectionValidationTask(this.cacheName, this.nodeId == null ? this.ignite : null);
            if (this.nodeId != null) {
                ClusterGroup grp = this.ignite.cluster().forServers().forNodeId(this.nodeId, new UUID[0]);
                if (grp.nodes().isEmpty()) {
                    throw new SQLException("Failed to establish connection with node (is it a server node?): " + this.nodeId);
                }
                assert (grp.nodes().size() == 1);
                if (grp.node().isDaemon()) {
                    throw new SQLException("Failed to establish connection with node (is it a server node?): " + this.nodeId);
                }
                IgniteCompute compute = this.ignite.compute(grp).withAsync();
                compute.call(task);
                return (Boolean)compute.future().get(timeout, TimeUnit.SECONDS);
            }
            return task.call();
        }
        catch (IgniteClientDisconnectedException | ComputeTaskTimeoutException e) {
            throw new SQLException("Failed to establish connection.", e);
        }
        catch (IgniteException ignored) {
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String val) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Client info is not supported.");
    }

    @Override
    public void setClientInfo(Properties props) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Client info is not supported.");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.ensureNotClosed();
        return new Properties();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attrs) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Connection is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface == Connection.class;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        assert (this.ignite instanceof IgniteEx);
        this.cacheName = ((IgniteEx)this.ignite).context().query().space(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        String sqlSchema = this.ignite.cache(this.cacheName).getConfiguration(CacheConfiguration.class).getSqlSchema();
        return U.firstNotNull(sqlSchema, this.cacheName, "");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int ms) throws SQLException {
        throw new SQLFeatureNotSupportedException("Network timeout is not supported.");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("Network timeout is not supported.");
    }

    Ignite ignite() {
        return this.ignite;
    }

    String cacheName() {
        return this.cacheName;
    }

    String url() {
        return this.url;
    }

    UUID nodeId() {
        return this.nodeId;
    }

    boolean isDmlSupported() {
        return this.ignite.version().greaterThanEqual(1, 8, 0);
    }

    boolean isLocalQuery() {
        return this.locQry;
    }

    boolean isCollocatedQuery() {
        return this.collocatedQry;
    }

    boolean isDistributedJoins() {
        return this.distributedJoins;
    }

    private void ensureNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection is closed.");
        }
    }

    JdbcStatement createStatement0() throws SQLException {
        return (JdbcStatement)this.createStatement();
    }

    PreparedStatement prepareNativeStatement(String sql) throws SQLException {
        return ((IgniteCacheProxy)this.ignite().cache(this.cacheName())).context().kernalContext().query().prepareNativeStatement(this.getSchema(), sql);
    }

    private static class IgniteNodeFuture
    extends GridFutureAdapter<Ignite> {
        private final AtomicInteger refCnt = new AtomicInteger(1);

        private IgniteNodeFuture() {
        }

        public boolean acquire() {
            int cur;
            do {
                if ((cur = this.refCnt.get()) != 0) continue;
                return false;
            } while (!this.refCnt.compareAndSet(cur, cur + 1));
            return true;
        }

        public boolean release() {
            int cur;
            do {
                cur = this.refCnt.get();
                assert (cur > 0);
            } while (!this.refCnt.compareAndSet(cur, cur - 1));
            return cur == 1;
        }
    }

    private static class JdbcConnectionValidationTask
    implements IgniteCallable<Boolean> {
        private static final long serialVersionUID = 0L;
        private final String cacheName;
        @IgniteInstanceResource
        private Ignite ignite;

        public JdbcConnectionValidationTask(String cacheName, Ignite ignite) {
            this.cacheName = cacheName;
            this.ignite = ignite;
        }

        @Override
        public Boolean call() {
            return this.cacheName == null || this.ignite.cache(this.cacheName) != null;
        }
    }
}

