/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.jdbc2.JdbcConnection;
import org.apache.ignite.internal.jdbc2.JdbcQueryTask;
import org.apache.ignite.internal.jdbc2.JdbcQueryTaskV2;
import org.apache.ignite.internal.jdbc2.JdbcResultSet;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.util.typedef.F;

public class JdbcStatement
implements Statement {
    private static final int DFLT_FETCH_SIZE = 1024;
    protected final JdbcConnection conn;
    private boolean closed;
    private int maxRows;
    protected ResultSet rs;
    protected ArrayList<Object> args;
    private int fetchSize = 1024;
    final Set<JdbcResultSet> resSets = new HashSet<JdbcResultSet>();
    Map<String, Integer> fieldsIdxs = new HashMap<String, Integer>();
    long updateCnt = -1L;
    private List<String> batch;

    JdbcStatement(JdbcConnection conn) {
        assert (conn != null);
        this.conn = conn;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.ensureNotClosed();
        this.rs = null;
        this.updateCnt = -1L;
        if (F.isEmpty(sql)) {
            throw new SQLException("SQL query is empty");
        }
        Ignite ignite = this.conn.ignite();
        UUID nodeId = this.conn.nodeId();
        UUID uuid = UUID.randomUUID();
        boolean loc = nodeId == null;
        JdbcQueryTask qryTask = new JdbcQueryTask(loc ? ignite : null, this.conn.cacheName(), sql, loc, this.getArgs(), this.fetchSize, uuid, this.conn.isLocalQuery(), this.conn.isCollocatedQuery(), this.conn.isDistributedJoins());
        try {
            JdbcQueryTask.QueryResult res = loc ? qryTask.call() : ignite.compute(ignite.cluster().forNodeId(nodeId, new UUID[0])).call(qryTask);
            JdbcResultSet rs = new JdbcResultSet(uuid, this, res.getTbls(), res.getCols(), res.getTypes(), res.getRows(), res.isFinished());
            rs.setFetchSize(this.fetchSize);
            this.resSets.add(rs);
            return rs;
        }
        catch (IgniteSQLException e) {
            throw e.toJdbcException();
        }
        catch (Exception e) {
            throw new SQLException("Failed to query Ignite.", e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.ensureNotClosed();
        this.rs = null;
        this.updateCnt = -1L;
        return Long.valueOf(this.doUpdate(sql, this.getArgs())).intValue();
    }

    long doUpdate(String sql, Object[] args) throws SQLException {
        boolean loc;
        if (F.isEmpty(sql)) {
            throw new SQLException("SQL query is empty");
        }
        Ignite ignite = this.conn.ignite();
        UUID nodeId = this.conn.nodeId();
        UUID uuid = UUID.randomUUID();
        boolean bl = loc = nodeId == null;
        if (!this.conn.isDmlSupported()) {
            throw new SQLException("Failed to query Ignite: DML operations are supported in versions 1.8.0 and newer");
        }
        JdbcQueryTaskV2 qryTask = new JdbcQueryTaskV2(loc ? ignite : null, this.conn.cacheName(), sql, false, loc, args, this.fetchSize, uuid, this.conn.isLocalQuery(), this.conn.isCollocatedQuery(), this.conn.isDistributedJoins());
        try {
            JdbcQueryTaskV2.QueryResult qryRes = loc ? qryTask.call() : ignite.compute(ignite.cluster().forNodeId(nodeId, new UUID[0])).call(qryTask);
            this.updateCnt = JdbcStatement.updateCounterFromQueryResult(qryRes.getRows());
            return this.updateCnt;
        }
        catch (IgniteSQLException e) {
            throw e.toJdbcException();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Failed to query Ignite.", e);
        }
    }

    private static long updateCounterFromQueryResult(List<List<?>> rows) throws SQLException {
        if (F.isEmpty(rows)) {
            return -1L;
        }
        if (rows.size() != 1) {
            throw new SQLException("Expected fetch size of 1 for update operation");
        }
        List<?> row = rows.get(0);
        if (row.size() != 1) {
            throw new SQLException("Expected row size of 1 for update operation");
        }
        Object objRes = row.get(0);
        if (!(objRes instanceof Long)) {
            throw new SQLException("Unexpected update result type");
        }
        return (Long)objRes;
    }

    @Override
    public void close() throws SQLException {
        this.conn.statements.remove(this);
        this.closeInternal();
    }

    void closeInternal() throws SQLException {
        Iterator<JdbcResultSet> it = this.resSets.iterator();
        while (it.hasNext()) {
            JdbcResultSet rs = it.next();
            rs.closeInternal();
            it.remove();
        }
        this.closed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.ensureNotClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Field size limitation is not supported.");
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.ensureNotClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.ensureNotClosed();
        this.maxRows = maxRows;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Query timeout is not supported.");
    }

    @Override
    public void setQueryTimeout(int timeout) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Query timeout is not supported.");
    }

    @Override
    public void cancel() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Cancellation is not supported.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (!this.conn.isDmlSupported()) {
            this.rs = this.executeQuery(sql);
            return true;
        }
        this.ensureNotClosed();
        this.rs = null;
        this.updateCnt = -1L;
        if (F.isEmpty(sql)) {
            throw new SQLException("SQL query is empty");
        }
        Ignite ignite = this.conn.ignite();
        UUID nodeId = this.conn.nodeId();
        UUID uuid = UUID.randomUUID();
        boolean loc = nodeId == null;
        JdbcQueryTaskV2 qryTask = new JdbcQueryTaskV2(loc ? ignite : null, this.conn.cacheName(), sql, null, loc, this.getArgs(), this.fetchSize, uuid, this.conn.isLocalQuery(), this.conn.isCollocatedQuery(), this.conn.isDistributedJoins());
        try {
            JdbcQueryTaskV2.QueryResult res;
            JdbcQueryTaskV2.QueryResult queryResult = res = loc ? qryTask.call() : ignite.compute(ignite.cluster().forNodeId(nodeId, new UUID[0])).call(qryTask);
            if (res.isQuery()) {
                JdbcResultSet rs = JdbcResultSet.resultSetForQueryTaskV2(uuid, this, res.getTbls(), res.getCols(), res.getTypes(), res.getRows(), res.isFinished());
                rs.setFetchSize(this.fetchSize);
                this.resSets.add(rs);
                this.rs = rs;
            } else {
                this.updateCnt = JdbcStatement.updateCounterFromQueryResult(res.getRows());
            }
            return res.isQuery();
        }
        catch (IgniteSQLException e) {
            throw e.toJdbcException();
        }
        catch (Exception e) {
            throw new SQLException("Failed to query Ignite.", e);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.ensureNotClosed();
        ResultSet rs0 = this.rs;
        this.rs = null;
        return rs0;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.ensureNotClosed();
        long res = this.updateCnt;
        this.updateCnt = -1L;
        return Long.valueOf(res).intValue();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.ensureNotClosed();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ensureNotClosed();
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Only forward direction is supported");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureNotClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.ensureNotClosed();
        if (fetchSize < 0) {
            throw new SQLException("Fetch size must be greater or equal zero.");
        }
        this.fetchSize = fetchSize;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureNotClosed();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.ensureNotClosed();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.ensureNotClosed();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ensureNotClosed();
        if (F.isEmpty(sql)) {
            throw new SQLException("SQL query is empty");
        }
        if (this.batch == null) {
            this.batch = new ArrayList<String>();
        }
        this.batch.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureNotClosed();
        this.batch = null;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Batch statements are not supported yet.");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.ensureNotClosed();
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int curr) throws SQLException {
        this.ensureNotClosed();
        if (curr == 2 || curr == 3) {
            throw new SQLFeatureNotSupportedException("Multiple open results are not supported.");
        }
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        if (autoGeneratedKeys == 1) {
            throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
        }
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        if (!F.isEmpty(colIndexes)) {
            throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
        }
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        if (!F.isEmpty(colNames)) {
            throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
        }
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        if (autoGeneratedKeys == 1) {
            throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
        }
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        if (!F.isEmpty(colIndexes)) {
            throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
        }
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        if (!F.isEmpty(colNames)) {
            throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
        }
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.ensureNotClosed();
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ensureNotClosed();
        if (poolable) {
            throw new SQLFeatureNotSupportedException("Pooling is not supported.");
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.ensureNotClosed();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Statement is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface == Statement.class;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException("closeOnCompletion is not supported.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureNotClosed();
        return false;
    }

    protected final Object[] getArgs() {
        return this.args != null ? this.args.toArray() : null;
    }

    void ensureNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("Statement is closed.");
        }
    }
}

