/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.communication;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridIoUserMessage
implements Message {
    private static final long serialVersionUID = 0L;
    @GridDirectTransient
    private Object body;
    private byte[] bodyBytes;
    private IgniteUuid clsLdrId;
    @GridDirectTransient
    private Object topic;
    private byte[] topicBytes;
    private DeploymentMode depMode;
    private String depClsName;
    private String userVer;
    @GridToStringInclude
    @GridDirectMap(keyType=UUID.class, valueType=IgniteUuid.class)
    private Map<UUID, IgniteUuid> ldrParties;
    @GridDirectTransient
    private GridDeployment dep;

    GridIoUserMessage(Object body, @Nullable byte[] bodyBytes, @Nullable String depClsName, @Nullable Object topic, @Nullable byte[] topicBytes, @Nullable IgniteUuid clsLdrId, @Nullable DeploymentMode depMode, @Nullable String userVer, @Nullable Map<UUID, IgniteUuid> ldrParties) {
        this.body = body;
        this.bodyBytes = bodyBytes;
        this.depClsName = depClsName;
        this.topic = topic;
        this.topicBytes = topicBytes;
        this.depMode = depMode;
        this.clsLdrId = clsLdrId;
        this.userVer = userVer;
        this.ldrParties = ldrParties;
    }

    public GridIoUserMessage() {
    }

    @Nullable
    public byte[] bodyBytes() {
        return this.bodyBytes;
    }

    @Nullable
    public IgniteUuid classLoaderId() {
        return this.clsLdrId;
    }

    @Nullable
    public DeploymentMode deploymentMode() {
        return this.depMode;
    }

    @Nullable
    public String deploymentClassName() {
        return this.depClsName;
    }

    @Nullable
    public String userVersion() {
        return this.userVer;
    }

    @Nullable
    public Map<UUID, IgniteUuid> loaderParticipants() {
        return this.ldrParties != null ? Collections.unmodifiableMap(this.ldrParties) : null;
    }

    @Nullable
    public byte[] topicBytes() {
        return this.topicBytes;
    }

    public void topic(Object topic) {
        this.topic = topic;
    }

    @Nullable
    public Object topic() {
        return this.topic;
    }

    public void body(Object body) {
        this.body = body;
    }

    @Nullable
    public Object body() {
        return this.body;
    }

    public void deployment(GridDeployment dep) {
        this.dep = dep;
    }

    @Nullable
    public GridDeployment deployment() {
        return this.dep;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("bodyBytes", this.bodyBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeIgniteUuid("clsLdrId", this.clsLdrId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeString("depClsName", this.depClsName)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeByte("depMode", this.depMode != null ? (byte)this.depMode.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeMap("ldrParties", this.ldrParties, MessageCollectionItemType.UUID, MessageCollectionItemType.IGNITE_UUID)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeByteArray("topicBytes", this.topicBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeString("userVer", this.userVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.bodyBytes = reader.readByteArray("bodyBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.clsLdrId = reader.readIgniteUuid("clsLdrId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.depClsName = reader.readString("depClsName");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                byte depModeOrd = reader.readByte("depMode");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.depMode = DeploymentMode.fromOrdinal(depModeOrd);
                reader.incrementState();
            }
            case 4: {
                this.ldrParties = reader.readMap("ldrParties", MessageCollectionItemType.UUID, MessageCollectionItemType.IGNITE_UUID, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.topicBytes = reader.readByteArray("topicBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.userVer = reader.readString("userVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridIoUserMessage.class);
    }

    @Override
    public byte directType() {
        return 9;
    }

    @Override
    public byte fieldsCount() {
        return 7;
    }

    public String toString() {
        return S.toString(GridIoUserMessage.class, this);
    }
}

