/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.communication;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class IgniteIoTestMessage
implements Message {
    private static byte FLAG_PROC_FROM_NIO = 1;
    private static final long serialVersionUID = 0L;
    private long id;
    private byte flags;
    private boolean req;
    private byte[] payload;

    IgniteIoTestMessage() {
    }

    IgniteIoTestMessage(long id, boolean req, byte[] payload) {
        this.id = id;
        this.req = req;
        this.payload = payload;
    }

    boolean processFromNioThread() {
        return this.isFlag(FLAG_PROC_FROM_NIO);
    }

    void processFromNioThread(boolean procFromNioThread) {
        this.setFlag(procFromNioThread, FLAG_PROC_FROM_NIO);
    }

    public void flags(byte flags) {
        this.flags = flags;
    }

    public byte flags() {
        return this.flags;
    }

    private void setFlag(boolean flag, int mask) {
        this.flags = flag ? (byte)(this.flags | mask) : (byte)(this.flags & ~mask);
    }

    private boolean isFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    public boolean request() {
        return this.req;
    }

    public long id() {
        return this.id;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("id", this.id)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeByteArray("payload", this.payload)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeBoolean("req", this.req)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.id = reader.readLong("id");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.payload = reader.readByteArray("payload");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.req = reader.readBoolean("req");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(IgniteIoTestMessage.class);
    }

    @Override
    public byte directType() {
        return -43;
    }

    @Override
    public byte fieldsCount() {
        return 4;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(IgniteIoTestMessage.class, this);
    }
}

