/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.deployment;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfo;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDeploymentInfoBean
implements Message,
GridDeploymentInfo,
Externalizable {
    private static final long serialVersionUID = 0L;
    private IgniteUuid clsLdrId;
    private DeploymentMode depMode;
    private String userVer;
    private boolean locDepOwner;
    @GridToStringInclude
    @GridDirectMap(keyType=UUID.class, valueType=IgniteUuid.class)
    private Map<UUID, IgniteUuid> participants;

    public GridDeploymentInfoBean() {
    }

    public GridDeploymentInfoBean(IgniteUuid clsLdrId, String userVer, DeploymentMode depMode, Map<UUID, IgniteUuid> participants, boolean locDepOwner) {
        this.clsLdrId = clsLdrId;
        this.depMode = depMode;
        this.userVer = userVer;
        this.participants = participants;
        this.locDepOwner = locDepOwner;
    }

    public GridDeploymentInfoBean(GridDeploymentInfo dep) {
        this.clsLdrId = dep.classLoaderId();
        this.depMode = dep.deployMode();
        this.userVer = dep.userVersion();
        this.locDepOwner = dep.localDeploymentOwner();
        this.participants = dep.participants();
    }

    @Override
    public IgniteUuid classLoaderId() {
        return this.clsLdrId;
    }

    @Override
    public DeploymentMode deployMode() {
        return this.depMode;
    }

    @Override
    public String userVersion() {
        return this.userVer;
    }

    @Override
    public long sequenceNumber() {
        return this.clsLdrId.localId();
    }

    @Override
    public boolean localDeploymentOwner() {
        return this.locDepOwner;
    }

    @Override
    public Map<UUID, IgniteUuid> participants() {
        return this.participants;
    }

    public void localDeploymentOwner(boolean locDepOwner) {
        this.locDepOwner = locDepOwner;
    }

    @Override
    public void onAckReceived() {
    }

    public int hashCode() {
        return this.clsLdrId.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof GridDeploymentInfoBean && this.clsLdrId.equals(((GridDeploymentInfoBean)o).clsLdrId);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeIgniteUuid("clsLdrId", this.clsLdrId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByte("depMode", this.depMode != null ? (byte)this.depMode.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeBoolean("locDepOwner", this.locDepOwner)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeMap("participants", this.participants, MessageCollectionItemType.UUID, MessageCollectionItemType.IGNITE_UUID)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeString("userVer", this.userVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.clsLdrId = reader.readIgniteUuid("clsLdrId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                byte depModeOrd = reader.readByte("depMode");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.depMode = DeploymentMode.fromOrdinal(depModeOrd);
                reader.incrementState();
            }
            case 2: {
                this.locDepOwner = reader.readBoolean("locDepOwner");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.participants = reader.readMap("participants", MessageCollectionItemType.UUID, MessageCollectionItemType.IGNITE_UUID, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.userVer = reader.readString("userVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDeploymentInfoBean.class);
    }

    @Override
    public byte directType() {
        return 10;
    }

    @Override
    public byte fieldsCount() {
        return 5;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeGridUuid(out, this.clsLdrId);
        U.writeEnum(out, this.depMode);
        U.writeString(out, this.userVer);
        out.writeBoolean(this.locDepOwner);
        U.writeMap(out, this.participants);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.clsLdrId = U.readGridUuid(in);
        this.depMode = DeploymentMode.fromOrdinal(in.readByte());
        this.userVer = U.readString(in);
        this.locDepOwner = in.readBoolean();
        this.participants = U.readMap(in);
    }

    public String toString() {
        return S.toString(GridDeploymentInfoBean.class, this);
    }
}

