/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.deployment;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDeploymentRequest
implements Message {
    private static final long serialVersionUID = 0L;
    @GridDirectTransient
    private Object resTopic;
    private byte[] resTopicBytes;
    private String rsrcName;
    private IgniteUuid ldrId;
    private boolean isUndeploy;
    @GridToStringInclude
    @GridDirectCollection(value=UUID.class)
    private Collection<UUID> nodeIds;

    public GridDeploymentRequest() {
    }

    GridDeploymentRequest(Object resTopic, IgniteUuid ldrId, String rsrcName, boolean isUndeploy) {
        assert (isUndeploy || resTopic != null);
        assert (isUndeploy || ldrId != null);
        assert (rsrcName != null);
        this.resTopic = resTopic;
        this.ldrId = ldrId;
        this.rsrcName = rsrcName;
        this.isUndeploy = isUndeploy;
    }

    Object responseTopic() {
        return this.resTopic;
    }

    void responseTopic(Object resTopic) {
        this.resTopic = resTopic;
    }

    byte[] responseTopicBytes() {
        return this.resTopicBytes;
    }

    void responseTopicBytes(byte[] resTopicBytes) {
        this.resTopicBytes = resTopicBytes;
    }

    String resourceName() {
        return this.rsrcName;
    }

    IgniteUuid classLoaderId() {
        return this.ldrId;
    }

    boolean isUndeploy() {
        return this.isUndeploy;
    }

    public Collection<UUID> nodeIds() {
        return this.nodeIds;
    }

    public void nodeIds(Collection<UUID> nodeIds) {
        this.nodeIds = nodeIds;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeBoolean("isUndeploy", this.isUndeploy)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeIgniteUuid("ldrId", this.ldrId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeCollection("nodeIds", this.nodeIds, MessageCollectionItemType.UUID)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeByteArray("resTopicBytes", this.resTopicBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeString("rsrcName", this.rsrcName)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.isUndeploy = reader.readBoolean("isUndeploy");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.ldrId = reader.readIgniteUuid("ldrId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.nodeIds = reader.readCollection("nodeIds", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.resTopicBytes = reader.readByteArray("resTopicBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.rsrcName = reader.readString("rsrcName");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDeploymentRequest.class);
    }

    @Override
    public byte directType() {
        return 11;
    }

    @Override
    public byte fieldsCount() {
        return 5;
    }

    public String toString() {
        return S.toString(GridDeploymentRequest.class, this);
    }
}

