/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.discovery;

import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CRC32;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.ClusterMetricsSnapshot;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridNodeOrderComparator;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.discovery.CustomEventListener;
import org.apache.ignite.internal.managers.discovery.CustomMessageWrapper;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridLocalMetrics;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheAffinitySharedManager;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.jobmetrics.GridJobMetrics;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.service.GridServiceProcessor;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridTuple5;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.segmentation.SegmentationPolicy;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.DiscoveryMetricsProvider;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.DiscoverySpiDataExchange;
import org.apache.ignite.spi.discovery.DiscoverySpiHistorySupport;
import org.apache.ignite.spi.discovery.DiscoverySpiListener;
import org.apache.ignite.spi.discovery.DiscoverySpiNodeAuthenticator;
import org.apache.ignite.spi.discovery.DiscoverySpiOrderSupport;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class GridDiscoveryManager
extends GridManagerAdapter<DiscoverySpi> {
    private static final String NULL_CACHE_NAME = UUID.randomUUID().toString();
    private static final long METRICS_UPDATE_FREQ = 3000L;
    private static final MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
    private static final OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
    private static final RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
    private static final ThreadMXBean threads = ManagementFactory.getThreadMXBean();
    private static final Collection<GarbageCollectorMXBean> gc = ManagementFactory.getGarbageCollectorMXBeans();
    private static final String PREFIX = "Topology snapshot";
    static final int DISCOVERY_HISTORY_SIZE = IgniteSystemProperties.getInteger("IGNITE_DISCOVERY_HISTORY_SIZE", 500);
    private static final IgnitePredicate<ClusterNode> FILTER_DAEMON = new P1<ClusterNode>(){

        @Override
        public boolean apply(ClusterNode n) {
            return !n.isDaemon();
        }
    };
    private static final IgnitePredicate<ClusterNode> FILTER_CLI = new P1<ClusterNode>(){

        @Override
        public boolean apply(ClusterNode n) {
            return CU.clientNode(n);
        }
    };
    private final DiscoveryWorker discoWrk = new DiscoveryWorker();
    private SegmentCheckWorker segChkWrk;
    private IgniteThread segChkThread;
    private final AtomicLong lastLoggedTop = new AtomicLong();
    private ClusterNode locNode;
    private boolean isLocDaemon;
    private boolean hasRslvrs;
    private final AtomicBoolean lastSegChkRes = new AtomicBoolean(true);
    private final GridBoundedConcurrentLinkedHashMap<AffinityTopologyVersion, DiscoCache> discoCacheHist = new GridBoundedConcurrentLinkedHashMap(DISCOVERY_HISTORY_SIZE);
    private volatile Map<Long, Collection<ClusterNode>> topHist = new HashMap<Long, Collection<ClusterNode>>();
    private final AtomicReference<Snapshot> topSnap = new AtomicReference<Snapshot>(new Snapshot(AffinityTopologyVersion.ZERO, null));
    private int minorTopVer;
    private boolean discoOrdered;
    private boolean histSupported;
    private long segChkFreq;
    private GridFutureAdapter<DiscoveryEvent> locJoinEvt = new GridFutureAdapter();
    private volatile double gcCpuLoad;
    private volatile double cpuLoad;
    private final GridLocalMetrics metrics = this.createMetrics();
    private GridTimeoutProcessor.CancelableTask metricsUpdateTask;
    private ConcurrentMap<Class<?>, List<CustomEventListener<DiscoveryCustomMessage>>> customEvtLsnrs = new ConcurrentHashMap8();
    private Map<String, CachePredicate> registeredCaches = new HashMap<String, CachePredicate>();
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private final ArrayDeque<IgniteUuid> rcvdCustomMsgs = new ArrayDeque();
    private final CountDownLatch startLatch = new CountDownLatch(1);

    public GridDiscoveryManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])new DiscoverySpi[]{ctx.config().getDiscoverySpi()});
    }

    private MemoryUsage nonHeapMemoryUsage() {
        try {
            return mem.getNonHeapMemoryUsage();
        }
        catch (IllegalArgumentException ignored) {
            return new MemoryUsage(0L, 0L, 0L, 0L);
        }
    }

    @Override
    public void onBeforeSpiStart() {
        DiscoverySpi spi = (DiscoverySpi)this.getSpi();
        spi.setNodeAttributes(this.ctx.nodeAttributes(), IgniteVersionUtils.VER);
    }

    public void setCacheFilter(String cacheName, IgnitePredicate<ClusterNode> filter, boolean nearEnabled, CacheMode cacheMode) {
        if (!this.registeredCaches.containsKey(cacheName)) {
            this.registeredCaches.put(cacheName, new CachePredicate(filter, nearEnabled, cacheMode));
        }
    }

    public void removeCacheFilter(String cacheName) {
        CachePredicate p = this.registeredCaches.remove(cacheName);
        assert (p != null) : cacheName;
    }

    public boolean addClientNode(String cacheName, UUID clientNodeId, boolean nearEnabled) {
        CachePredicate p = this.registeredCaches.get(cacheName);
        assert (p != null) : cacheName;
        return p.addClientNode(clientNodeId, nearEnabled);
    }

    public boolean onClientCacheClose(String cacheName, UUID clientNodeId) {
        CachePredicate p = this.registeredCaches.get(cacheName);
        assert (p != null) : cacheName;
        return p.onNodeLeft(clientNodeId);
    }

    public Map<String, Map<UUID, Boolean>> clientNodesMap() {
        HashMap res = null;
        for (Map.Entry<String, CachePredicate> entry : this.registeredCaches.entrySet()) {
            CachePredicate pred = entry.getValue();
            if (F.isEmpty(pred.clientNodes)) continue;
            if (res == null) {
                res = U.newHashMap(this.registeredCaches.size());
            }
            res.put(entry.getKey(), new HashMap(pred.clientNodes));
        }
        return res;
    }

    private void updateClientNodes(UUID leftNodeId) {
        for (Map.Entry<String, CachePredicate> entry : this.registeredCaches.entrySet()) {
            CachePredicate pred = entry.getValue();
            pred.onNodeLeft(leftNodeId);
        }
    }

    @Override
    protected void onKernalStart0() throws IgniteCheckedException {
        if (Boolean.TRUE.equals(this.ctx.config().isClientMode()) && !((DiscoverySpi)this.getSpi()).isClientMode()) {
            this.ctx.performance().add("Enable client mode for TcpDiscoverySpi (set TcpDiscoverySpi.forceServerMode to false)");
        }
    }

    @Override
    public void start() throws IgniteCheckedException {
        long totSysMemory = -1L;
        try {
            totSysMemory = (Long)U.property(os, "totalPhysicalMemorySize");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.ctx.addNodeAttribute("org.apache.ignite.phy.ram", totSysMemory);
        DiscoverySpi spi = (DiscoverySpi)this.getSpi();
        this.discoOrdered = this.discoOrdered();
        this.histSupported = this.historySupported();
        this.isLocDaemon = this.ctx.isDaemon();
        this.hasRslvrs = this.ctx.config().isClientMode() == false && !F.isEmpty(this.ctx.config().getSegmentationResolvers());
        this.segChkFreq = this.ctx.config().getSegmentCheckFrequency();
        if (this.hasRslvrs) {
            int segResAttemp;
            if (this.segChkFreq < 0L) {
                throw new IgniteCheckedException("Segment check frequency cannot be negative: " + this.segChkFreq);
            }
            if (this.segChkFreq > 0L && this.segChkFreq < 2000L) {
                U.warn(this.log, "Configuration parameter 'segmentCheckFrequency' is too low (at least 2000 ms recommended): " + this.segChkFreq);
            }
            if ((segResAttemp = this.ctx.config().getSegmentationResolveAttempts()) < 1) {
                throw new IgniteCheckedException("Segment resolve attempts cannot be negative or zero: " + segResAttemp);
            }
            this.checkSegmentOnStart();
        }
        this.metricsUpdateTask = this.ctx.timeout().schedule(new MetricsUpdater(), 3000L, 3000L);
        spi.setMetricsProvider(this.createMetricsProvider());
        if (this.ctx.security().enabled()) {
            spi.setAuthenticator(new DiscoverySpiNodeAuthenticator(){

                @Override
                public SecurityContext authenticateNode(ClusterNode node, SecurityCredentials cred) {
                    try {
                        return GridDiscoveryManager.this.ctx.security().authenticateNode(node, cred);
                    }
                    catch (IgniteCheckedException e) {
                        throw U.convertException(e);
                    }
                }

                @Override
                public boolean isGlobalNodeAuthentication() {
                    return GridDiscoveryManager.this.ctx.security().isGlobalNodeAuthentication();
                }
            });
        }
        spi.setListener(new DiscoverySpiListener(){
            private long gridStartTime;

            @Override
            public void onDiscovery(final int type, long topVer, final ClusterNode node, final Collection<ClusterNode> topSnapshot, Map<Long, Collection<ClusterNode>> snapshots, @Nullable DiscoverySpiCustomMessage spiCustomMsg) {
                AffinityTopologyVersion nextTopVer;
                boolean verChanged;
                DiscoveryCustomMessage customMsg;
                DiscoveryCustomMessage discoveryCustomMessage = customMsg = spiCustomMsg == null ? null : ((CustomMessageWrapper)spiCustomMsg).delegate();
                if (GridDiscoveryManager.this.skipMessage(type, customMsg)) {
                    return;
                }
                ClusterNode locNode = GridDiscoveryManager.this.localNode();
                if (snapshots != null) {
                    GridDiscoveryManager.this.topHist = snapshots;
                }
                if (type == 13) {
                    verChanged = false;
                } else if (type != 14 && type != 16 && type != 17 && type != 18) {
                    GridDiscoveryManager.this.minorTopVer = 0;
                    verChanged = true;
                } else {
                    verChanged = false;
                }
                if (type == 12 || type == 11) {
                    for (DiscoCache c : GridDiscoveryManager.this.discoCacheHist.values()) {
                        c.updateAlives(node);
                    }
                    GridDiscoveryManager.this.updateClientNodes(node.id());
                }
                if (type == 18) {
                    assert (customMsg != null);
                    boolean incMinorTopVer = GridDiscoveryManager.this.ctx.cache().onCustomEvent(customMsg, new AffinityTopologyVersion(topVer, GridDiscoveryManager.this.minorTopVer));
                    if (incMinorTopVer) {
                        GridDiscoveryManager.this.minorTopVer++;
                        verChanged = true;
                    }
                    nextTopVer = new AffinityTopologyVersion(topVer, GridDiscoveryManager.this.minorTopVer);
                } else {
                    nextTopVer = new AffinityTopologyVersion(topVer, GridDiscoveryManager.this.minorTopVer);
                    GridDiscoveryManager.this.ctx.cache().onDiscoveryEvent(type, node, nextTopVer);
                }
                if (type == 18) {
                    for (Class<?> cls = customMsg.getClass(); cls != null; cls = cls.getSuperclass()) {
                        List list = (List)GridDiscoveryManager.this.customEvtLsnrs.get(cls);
                        if (list == null) continue;
                        for (CustomEventListener lsnr : list) {
                            try {
                                lsnr.onCustomEvent(nextTopVer, node, customMsg);
                            }
                            catch (Exception e) {
                                U.error(GridDiscoveryManager.this.log, "Failed to notify direct custom event listener: " + customMsg, e);
                            }
                        }
                    }
                }
                if (verChanged) {
                    DiscoCache cache = new DiscoCache(locNode, F.view(topSnapshot, F.remoteNodes(locNode.id())));
                    GridDiscoveryManager.this.discoCacheHist.put(nextTopVer, cache);
                    boolean set = GridDiscoveryManager.this.updateTopologyVersionIfGreater(nextTopVer, cache);
                    assert (set || topVer == 0L) : "Topology version has not been updated [this.topVer=" + GridDiscoveryManager.access$1800(GridDiscoveryManager.this) + ", topVer=" + topVer + ", node=" + node + ", evt=" + U.gridEventName(type) + ']';
                }
                if (type == 10 && node.id().equals(locNode.id())) {
                    if (this.gridStartTime == 0L) {
                        this.gridStartTime = ((DiscoverySpi)GridDiscoveryManager.this.getSpi()).getGridStartTime();
                    }
                    GridDiscoveryManager.this.updateTopologyVersionIfGreater(new AffinityTopologyVersion(locNode.order()), new DiscoCache(GridDiscoveryManager.this.localNode(), F.view(topSnapshot, F.remoteNodes(locNode.id()))));
                    GridDiscoveryManager.this.startLatch.countDown();
                    DiscoveryEvent discoEvt = new DiscoveryEvent();
                    discoEvt.node(GridDiscoveryManager.this.ctx.discovery().localNode());
                    discoEvt.eventNode(node);
                    discoEvt.type(10);
                    discoEvt.topologySnapshot(topVer, new ArrayList<ClusterNode>(F.viewReadOnly(topSnapshot, new C1<ClusterNode, ClusterNode>(){

                        @Override
                        public ClusterNode apply(ClusterNode e) {
                            return e;
                        }
                    }, FILTER_DAEMON)));
                    GridDiscoveryManager.this.locJoinEvt.onDone(discoEvt);
                    return;
                }
                if (type == 16) {
                    assert (locNode.isClient()) : locNode;
                    assert (node.isClient()) : node;
                    ((IgniteKernal)GridDiscoveryManager.this.ctx.grid()).onDisconnected();
                    GridDiscoveryManager.this.locJoinEvt = new GridFutureAdapter();
                    GridDiscoveryManager.this.registeredCaches.clear();
                    for (AffinityTopologyVersion histVer : GridDiscoveryManager.this.discoCacheHist.keySet()) {
                        Object rmvd = GridDiscoveryManager.this.discoCacheHist.remove(histVer);
                        assert (rmvd != null) : histVer;
                    }
                    GridDiscoveryManager.this.topHist.clear();
                    GridDiscoveryManager.this.topSnap.set(new Snapshot(AffinityTopologyVersion.ZERO, new DiscoCache(locNode, Collections.emptySet())));
                } else if (type == 17) {
                    assert (locNode.isClient()) : locNode;
                    assert (node.isClient()) : node;
                    boolean clusterRestarted = this.gridStartTime != ((DiscoverySpi)GridDiscoveryManager.this.getSpi()).getGridStartTime();
                    this.gridStartTime = ((DiscoverySpi)GridDiscoveryManager.this.getSpi()).getGridStartTime();
                    ((IgniteKernal)GridDiscoveryManager.this.ctx.grid()).onReconnected(clusterRestarted);
                    GridDiscoveryManager.this.ctx.cluster().clientReconnectFuture().listen(new CI1<IgniteFuture<?>>(){

                        @Override
                        public void apply(IgniteFuture<?> fut) {
                            try {
                                fut.get();
                                GridDiscoveryManager.this.discoWrk.addEvent(type, nextTopVer, node, topSnapshot, null);
                            }
                            catch (IgniteException igniteException) {
                                // empty catch block
                            }
                        }
                    });
                    return;
                }
                if (type == 16 || type == 14 || !GridDiscoveryManager.this.ctx.clientDisconnected()) {
                    GridDiscoveryManager.this.discoWrk.addEvent(type, nextTopVer, node, topSnapshot, customMsg);
                }
            }
        });
        spi.setDataExchange(new DiscoverySpiDataExchange(){

            @Override
            public Map<Integer, Serializable> collect(UUID nodeId) {
                assert (nodeId != null);
                HashMap<Integer, Serializable> data = new HashMap<Integer, Serializable>();
                for (GridComponent comp : GridDiscoveryManager.this.ctx.components()) {
                    Serializable compData = comp.collectDiscoveryData(nodeId);
                    if (compData == null) continue;
                    assert (comp.discoveryDataType() != null);
                    data.put(comp.discoveryDataType().ordinal(), compData);
                }
                return data;
            }

            @Override
            public void onExchange(UUID joiningNodeId, UUID nodeId, Map<Integer, Serializable> data) {
                for (Map.Entry<Integer, Serializable> e : data.entrySet()) {
                    GridComponent comp = null;
                    for (GridComponent c : GridDiscoveryManager.this.ctx.components()) {
                        if (c.discoveryDataType() == null || c.discoveryDataType().ordinal() != e.getKey().intValue()) continue;
                        comp = c;
                        break;
                    }
                    if (comp != null) {
                        comp.onDiscoveryDataReceived(joiningNodeId, nodeId, e.getValue());
                        continue;
                    }
                    if (!GridDiscoveryManager.this.log.isDebugEnabled()) continue;
                    GridDiscoveryManager.this.log.debug("Received discovery data for unknown component: " + e.getKey());
                }
            }
        });
        this.startSpi();
        try {
            U.await(this.startLatch);
        }
        catch (IgniteInterruptedException e) {
            throw new IgniteCheckedException("Failed to start discovery manager (thread has been interrupted).", e);
        }
        if (this.hasRslvrs && this.segChkFreq > 0L) {
            this.segChkWrk = new SegmentCheckWorker();
            this.segChkThread = new IgniteThread(this.segChkWrk);
            this.segChkThread.start();
        }
        this.locNode = spi.getLocalNode();
        this.checkAttributes(this.discoCache().remoteNodes());
        this.ctx.service().initCompatibilityMode(this.discoCache().remoteNodes());
        new IgniteThread(this.discoWrk).start();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    private boolean skipMessage(int type, @Nullable DiscoveryCustomMessage customMsg) {
        if (type == 18) {
            assert (customMsg != null && customMsg.id() != null) : customMsg;
            if (this.rcvdCustomMsgs.contains(customMsg.id())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received duplicated custom message, will ignore [msg=" + customMsg + "]");
                }
                return true;
            }
            this.rcvdCustomMsgs.addLast(customMsg.id());
            while (this.rcvdCustomMsgs.size() > DISCOVERY_HISTORY_SIZE) {
                this.rcvdCustomMsgs.pollFirst();
            }
        }
        return false;
    }

    public <T extends DiscoveryCustomMessage> void setCustomEventListener(Class<T> msgCls, CustomEventListener<T> lsnr) {
        List list = (List)this.customEvtLsnrs.get(msgCls);
        if (list == null) {
            list = F.addIfAbsent(this.customEvtLsnrs, msgCls, new CopyOnWriteArrayList());
        }
        list.add(lsnr);
    }

    private GridLocalMetrics createMetrics() {
        return new GridLocalMetrics(){

            @Override
            public int getAvailableProcessors() {
                return os.getAvailableProcessors();
            }

            @Override
            public double getCurrentCpuLoad() {
                return GridDiscoveryManager.this.cpuLoad;
            }

            @Override
            public double getCurrentGcCpuLoad() {
                return GridDiscoveryManager.this.gcCpuLoad;
            }

            @Override
            public long getHeapMemoryInitialized() {
                return mem.getHeapMemoryUsage().getInit();
            }

            @Override
            public long getHeapMemoryUsed() {
                return mem.getHeapMemoryUsage().getUsed();
            }

            @Override
            public long getHeapMemoryCommitted() {
                return mem.getHeapMemoryUsage().getCommitted();
            }

            @Override
            public long getHeapMemoryMaximum() {
                return mem.getHeapMemoryUsage().getMax();
            }

            @Override
            public long getNonHeapMemoryInitialized() {
                return GridDiscoveryManager.this.nonHeapMemoryUsage().getInit();
            }

            @Override
            public long getNonHeapMemoryUsed() {
                return GridDiscoveryManager.this.nonHeapMemoryUsage().getUsed();
            }

            @Override
            public long getNonHeapMemoryCommitted() {
                return GridDiscoveryManager.this.nonHeapMemoryUsage().getCommitted();
            }

            @Override
            public long getNonHeapMemoryMaximum() {
                return GridDiscoveryManager.this.nonHeapMemoryUsage().getMax();
            }

            @Override
            public long getUptime() {
                return rt.getUptime();
            }

            @Override
            public long getStartTime() {
                return rt.getStartTime();
            }

            @Override
            public int getThreadCount() {
                return threads.getThreadCount();
            }

            @Override
            public int getPeakThreadCount() {
                return threads.getPeakThreadCount();
            }

            @Override
            public long getTotalStartedThreadCount() {
                return threads.getTotalStartedThreadCount();
            }

            @Override
            public int getDaemonThreadCount() {
                return threads.getDaemonThreadCount();
            }
        };
    }

    private DiscoveryMetricsProvider createMetricsProvider() {
        return new DiscoveryMetricsProvider(){
            private final long startTime = U.currentTimeMillis();

            @Override
            public ClusterMetrics metrics() {
                GridJobMetrics jm = GridDiscoveryManager.this.ctx.jobMetric().getJobMetrics();
                ClusterMetricsSnapshot nm = new ClusterMetricsSnapshot();
                nm.setLastUpdateTime(U.currentTimeMillis());
                nm.setMaximumActiveJobs(jm.getMaximumActiveJobs());
                nm.setCurrentActiveJobs(jm.getCurrentActiveJobs());
                nm.setAverageActiveJobs(jm.getAverageActiveJobs());
                nm.setMaximumWaitingJobs(jm.getMaximumWaitingJobs());
                nm.setCurrentWaitingJobs(jm.getCurrentWaitingJobs());
                nm.setAverageWaitingJobs(jm.getAverageWaitingJobs());
                nm.setMaximumRejectedJobs(jm.getMaximumRejectedJobs());
                nm.setCurrentRejectedJobs(jm.getCurrentRejectedJobs());
                nm.setAverageRejectedJobs(jm.getAverageRejectedJobs());
                nm.setMaximumCancelledJobs(jm.getMaximumCancelledJobs());
                nm.setCurrentCancelledJobs(jm.getCurrentCancelledJobs());
                nm.setAverageCancelledJobs(jm.getAverageCancelledJobs());
                nm.setTotalRejectedJobs(jm.getTotalRejectedJobs());
                nm.setTotalCancelledJobs(jm.getTotalCancelledJobs());
                nm.setTotalExecutedJobs(jm.getTotalExecutedJobs());
                nm.setMaximumJobWaitTime(jm.getMaximumJobWaitTime());
                nm.setCurrentJobWaitTime(jm.getCurrentJobWaitTime());
                nm.setAverageJobWaitTime(jm.getAverageJobWaitTime());
                nm.setMaximumJobExecuteTime(jm.getMaximumJobExecuteTime());
                nm.setCurrentJobExecuteTime(jm.getCurrentJobExecuteTime());
                nm.setAverageJobExecuteTime(jm.getAverageJobExecuteTime());
                nm.setCurrentIdleTime(jm.getCurrentIdleTime());
                nm.setTotalIdleTime(jm.getTotalIdleTime());
                nm.setAverageCpuLoad(jm.getAverageCpuLoad());
                nm.setTotalExecutedTasks(GridDiscoveryManager.this.ctx.task().getTotalExecutedTasks());
                nm.setAvailableProcessors(GridDiscoveryManager.this.metrics.getAvailableProcessors());
                nm.setCurrentCpuLoad(GridDiscoveryManager.this.metrics.getCurrentCpuLoad());
                nm.setCurrentGcCpuLoad(GridDiscoveryManager.this.metrics.getCurrentGcCpuLoad());
                nm.setHeapMemoryInitialized(GridDiscoveryManager.this.metrics.getHeapMemoryInitialized());
                nm.setHeapMemoryUsed(GridDiscoveryManager.this.metrics.getHeapMemoryUsed());
                nm.setHeapMemoryCommitted(GridDiscoveryManager.this.metrics.getHeapMemoryCommitted());
                nm.setHeapMemoryMaximum(GridDiscoveryManager.this.metrics.getHeapMemoryMaximum());
                nm.setHeapMemoryTotal(GridDiscoveryManager.this.metrics.getHeapMemoryMaximum());
                nm.setNonHeapMemoryInitialized(GridDiscoveryManager.this.metrics.getNonHeapMemoryInitialized());
                this.nonHeapMemoryUsed(nm);
                nm.setNonHeapMemoryCommitted(GridDiscoveryManager.this.metrics.getNonHeapMemoryCommitted());
                nm.setNonHeapMemoryMaximum(GridDiscoveryManager.this.metrics.getNonHeapMemoryMaximum());
                nm.setNonHeapMemoryTotal(GridDiscoveryManager.this.metrics.getNonHeapMemoryMaximum());
                nm.setUpTime(GridDiscoveryManager.this.metrics.getUptime());
                nm.setStartTime(GridDiscoveryManager.this.metrics.getStartTime());
                nm.setNodeStartTime(this.startTime);
                nm.setCurrentThreadCount(GridDiscoveryManager.this.metrics.getThreadCount());
                nm.setMaximumThreadCount(GridDiscoveryManager.this.metrics.getPeakThreadCount());
                nm.setTotalStartedThreadCount(GridDiscoveryManager.this.metrics.getTotalStartedThreadCount());
                nm.setCurrentDaemonThreadCount(GridDiscoveryManager.this.metrics.getDaemonThreadCount());
                nm.setTotalNodes(1);
                nm.setLastDataVersion(GridDiscoveryManager.this.ctx.cache().lastDataVersion());
                GridIoManager io = GridDiscoveryManager.this.ctx.io();
                nm.setSentMessagesCount(io.getSentMessagesCount());
                nm.setSentBytesCount(io.getSentBytesCount());
                nm.setReceivedMessagesCount(io.getReceivedMessagesCount());
                nm.setReceivedBytesCount(io.getReceivedBytesCount());
                nm.setOutboundMessagesQueueSize(io.getOutboundMessagesQueueSize());
                return nm;
            }

            private void nonHeapMemoryUsed(ClusterMetricsSnapshot nm) {
                long nonHeapUsed = GridDiscoveryManager.this.metrics.getNonHeapMemoryUsed();
                Map<Integer, CacheMetrics> nodeCacheMetrics = this.cacheMetrics();
                if (nodeCacheMetrics != null) {
                    for (Map.Entry<Integer, CacheMetrics> entry : nodeCacheMetrics.entrySet()) {
                        CacheMetrics e = entry.getValue();
                        if (e == null) continue;
                        nonHeapUsed += e.getOffHeapAllocatedSize();
                    }
                }
                nm.setNonHeapMemoryUsed(nonHeapUsed);
            }

            @Override
            public Map<Integer, CacheMetrics> cacheMetrics() {
                Collection<GridCacheAdapter<?, ?>> caches = GridDiscoveryManager.this.ctx.cache().internalCaches();
                if (F.isEmpty(caches)) {
                    return Collections.emptyMap();
                }
                HashMap<Integer, CacheMetrics> metrics = null;
                for (GridCacheAdapter<?, ?> cache : caches) {
                    if (!cache.configuration().isStatisticsEnabled() || !cache.context().started() || cache.context().affinity().affinityTopologyVersion().topologyVersion() <= 0L) continue;
                    if (metrics == null) {
                        metrics = U.newHashMap(caches.size());
                    }
                    metrics.put(cache.context().cacheId(), cache.localMetrics());
                }
                return metrics == null ? Collections.emptyMap() : metrics;
            }
        };
    }

    public GridLocalMetrics metrics() {
        return this.metrics;
    }

    private boolean discoOrdered() {
        DiscoverySpiOrderSupport ann = U.getAnnotation(this.ctx.config().getDiscoverySpi().getClass(), DiscoverySpiOrderSupport.class);
        return ann != null && ann.value();
    }

    private boolean historySupported() {
        DiscoverySpiHistorySupport ann = U.getAnnotation(this.ctx.config().getDiscoverySpi().getClass(), DiscoverySpiHistorySupport.class);
        return ann != null && ann.value();
    }

    private void checkSegmentOnStart() throws IgniteCheckedException {
        assert (this.hasRslvrs);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting network segment check.");
        }
        while (!this.ctx.segmentation().isValidSegment()) {
            if (this.ctx.config().isWaitForSegmentOnStart()) {
                LT.warn(this.log, "Failed to check network segment (retrying every 2000 ms).");
                U.sleep(2000L);
                continue;
            }
            throw new IgniteCheckedException("Failed to check network segment.");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Finished network segment check successfully.");
        }
    }

    private void checkAttributes(Iterable<ClusterNode> nodes) throws IgniteCheckedException {
        ClusterNode locNode = ((DiscoverySpi)this.getSpi()).getLocalNode();
        assert (locNode != null);
        String locPreferIpV4 = (String)locNode.attribute("java.net.preferIPv4Stack");
        Object locMode = locNode.attribute("org.apache.ignite.ignite.dep.mode");
        int locJvmMajVer = this.nodeJavaMajorVersion(locNode);
        boolean locP2pEnabled = (Boolean)locNode.attribute("org.apache.ignite.peer.classloading.enabled");
        boolean ipV4Warned = false;
        boolean jvmMajVerWarned = false;
        Boolean locMarshUseDfltSuid = (Boolean)locNode.attribute("org.apache.ignite.marshaller.useDefaultSUID");
        boolean locMarshUseDfltSuidBool = locMarshUseDfltSuid == null ? true : locMarshUseDfltSuid;
        Boolean locMarshStrSerVer2 = (Boolean)locNode.attribute("org.apache.ignite.marshaller.utf8SerializationVer2");
        boolean locMarshStrSerVer2Bool = locMarshStrSerVer2 == null ? false : locMarshStrSerVer2;
        boolean locDelayAssign = (Boolean)locNode.attribute("org.apache.ignite.cache.lateAffinity");
        Boolean locSrvcCompatibilityEnabled = (Boolean)locNode.attribute("org.apache.ignite.services.compatibility.enabled");
        for (ClusterNode n : nodes) {
            boolean rmtMarshStrSerVer2Bool;
            Boolean rmtMarshUseDfltSuid;
            boolean rmtMarshUseDfltSuidBool;
            String rmtPreferIpV4;
            int rmtJvmMajVer = this.nodeJavaMajorVersion(n);
            if (locJvmMajVer != rmtJvmMajVer && !jvmMajVerWarned) {
                U.warn(this.log, "Local java version is different from remote [loc=" + locJvmMajVer + ", rmt=" + rmtJvmMajVer + "]");
                jvmMajVerWarned = true;
            }
            if (!F.eq(rmtPreferIpV4 = (String)n.attribute("java.net.preferIPv4Stack"), locPreferIpV4)) {
                if (!ipV4Warned) {
                    U.warn(this.log, "Local node's value of 'java.net.preferIPv4Stack' system property differs from remote node's (all nodes in topology should have identical value) [locPreferIpV4=" + locPreferIpV4 + ", rmtPreferIpV4=" + rmtPreferIpV4 + ", locId8=" + U.id8(locNode.id()) + ", rmtId8=" + U.id8(n.id()) + ", rmtAddrs=" + U.addressesAsString(n) + ']', "Local and remote 'java.net.preferIPv4Stack' system properties do not match.");
                }
                ipV4Warned = true;
            }
            if (!this.isLocDaemon && !n.isDaemon()) {
                Object rmtMode = n.attribute("org.apache.ignite.ignite.dep.mode");
                if (!locMode.equals(rmtMode)) {
                    throw new IgniteCheckedException("Remote node has deployment mode different from local [locId8=" + U.id8(locNode.id()) + ", locMode=" + locMode + ", rmtId8=" + U.id8(n.id()) + ", rmtMode=" + rmtMode + ", rmtAddrs=" + U.addressesAsString(n) + ']');
                }
                boolean rmtP2pEnabled = (Boolean)n.attribute("org.apache.ignite.peer.classloading.enabled");
                if (locP2pEnabled != rmtP2pEnabled) {
                    throw new IgniteCheckedException("Remote node has peer class loading enabled flag different from local [locId8=" + U.id8(locNode.id()) + ", locPeerClassLoading=" + locP2pEnabled + ", rmtId8=" + U.id8(n.id()) + ", rmtPeerClassLoading=" + rmtP2pEnabled + ", rmtAddrs=" + U.addressesAsString(n) + ']');
                }
            }
            boolean bl = rmtMarshUseDfltSuidBool = (rmtMarshUseDfltSuid = (Boolean)n.attribute("org.apache.ignite.marshaller.useDefaultSUID")) == null ? true : rmtMarshUseDfltSuid;
            if (locMarshUseDfltSuidBool != rmtMarshUseDfltSuidBool) {
                throw new IgniteCheckedException("Local node's IGNITE_OPTIMIZED_MARSHALLER_USE_DEFAULT_SUID property value differs from remote node's value (to make sure all nodes in topology have identical marshaller settings, configure system property explicitly) [locMarshUseDfltSuid=" + locMarshUseDfltSuid + ", rmtMarshUseDfltSuid=" + rmtMarshUseDfltSuid + ", locNodeAddrs=" + U.addressesAsString(locNode) + ", rmtNodeAddrs=" + U.addressesAsString(n) + ", locNodeId=" + locNode.id() + ", rmtNodeId=" + n.id() + ']');
            }
            Boolean rmtMarshStrSerVer2 = (Boolean)n.attribute("org.apache.ignite.marshaller.utf8SerializationVer2");
            boolean bl2 = rmtMarshStrSerVer2Bool = rmtMarshStrSerVer2 == null ? false : rmtMarshStrSerVer2;
            if (locMarshStrSerVer2Bool != rmtMarshStrSerVer2Bool) {
                throw new IgniteCheckedException("Local node's IGNITE_BINARY_MARSHALLER_USE_STRING_SERIALIZATION_VER_2 property value differs from remote node's value (to make sure all nodes in topology have identical marshaller settings, configure system property explicitly) [locMarshStrSerVer2=" + locMarshStrSerVer2 + ", rmtMarshStrSerVer2=" + rmtMarshStrSerVer2 + ", locNodeAddrs=" + U.addressesAsString(locNode) + ", rmtNodeAddrs=" + U.addressesAsString(n) + ", locNodeId=" + locNode.id() + ", rmtNodeId=" + n.id() + ']');
            }
            boolean rmtLateAssign = n.version().compareToIgnoreTimestamp(CacheAffinitySharedManager.LATE_AFF_ASSIGN_SINCE) >= 0 ? (Boolean)n.attribute("org.apache.ignite.cache.lateAffinity") : false;
            if (locDelayAssign != rmtLateAssign) {
                throw new IgniteCheckedException("Remote node has cache affinity assignment mode different from local [locId8=" + U.id8(locNode.id()) + ", locDelayAssign=" + locDelayAssign + ", rmtId8=" + U.id8(n.id()) + ", rmtLateAssign=" + rmtLateAssign + ", rmtAddrs=" + U.addressesAsString(n) + ']');
            }
            if (n.version().compareToIgnoreTimestamp(GridServiceProcessor.LAZY_SERVICES_CFG_SINCE) >= 0) {
                Boolean rmtSrvcCompatibilityEnabled = (Boolean)n.attribute("org.apache.ignite.services.compatibility.enabled");
                if (F.eq(locSrvcCompatibilityEnabled, rmtSrvcCompatibilityEnabled)) continue;
                throw new IgniteCheckedException("Local node's IGNITE_SERVICES_COMPATIBILITY_MODE property value differs from remote node's value (to make sure all nodes in topology have identical IgniteServices compatibility mode enabled, configure system property explicitly) [locSrvcCompatibilityEnabled=" + locSrvcCompatibilityEnabled + ", rmtSrvcCompatibilityEnabled=" + rmtSrvcCompatibilityEnabled + ", locNodeAddrs=" + U.addressesAsString(locNode) + ", rmtNodeAddrs=" + U.addressesAsString(n) + ", locNodeId=" + locNode.id() + ", rmtNodeId=" + n.id() + ']');
            }
            if (!Boolean.FALSE.equals(locSrvcCompatibilityEnabled)) continue;
            throw new IgniteCheckedException("Remote node doesn't support lazy services configuration and local node cannot join node because local node's IGNITE_SERVICES_COMPATIBILITY_MODE property value explicitly set to 'false'[locNodeAddrs=" + U.addressesAsString(locNode) + ", rmtNodeAddrs=" + U.addressesAsString(n) + ", locNodeId=" + locNode.id() + ", rmtNodeId=" + n.id() + ']');
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Finished node attributes consistency check.");
        }
    }

    private int nodeJavaMajorVersion(ClusterNode node) throws IgniteCheckedException {
        try {
            return Integer.parseInt(((String)node.attribute("java.version")).split("\\.")[1]);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to get java major version (unknown 'java.version' format) [ver=" + (String)node.attribute("java.version") + "]", e);
            return 0;
        }
    }

    private static int cpus(Collection<ClusterNode> nodes) {
        HashSet<String> macSet = new HashSet<String>(nodes.size(), 1.0f);
        int cpus = 0;
        for (ClusterNode n : nodes) {
            String macs = (String)n.attribute("org.apache.ignite.macs");
            if (!macSet.add(macs)) continue;
            cpus += n.metrics().getTotalCpus();
        }
        return cpus;
    }

    public void ackTopology(long topVer) {
        this.ackTopology(topVer, false);
    }

    private void ackTopology(long topVer, boolean throttle) {
        assert (!this.isLocDaemon);
        DiscoCache discoCache = (DiscoCache)this.discoCacheHist.get(new AffinityTopologyVersion(topVer));
        if (discoCache == null) {
            String msg = "Failed to resolve nodes topology [topVer=" + topVer + ", hist=" + this.discoCacheHist.keySet() + ']';
            if (this.log.isQuiet()) {
                U.quiet(false, msg);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(msg);
            } else if (this.log.isInfoEnabled()) {
                this.log.info(msg);
            }
            return;
        }
        Collection<ClusterNode> rmtNodes = discoCache.remoteNodes();
        Collection<ClusterNode> srvNodes = F.view(discoCache.allNodes(), F.not(FILTER_CLI));
        Collection<ClusterNode> clientNodes = F.view(discoCache.allNodes(), FILTER_CLI);
        ClusterNode locNode = discoCache.localNode();
        Collection<ClusterNode> allNodes = discoCache.allNodes();
        long hash = this.topologyHash(allNodes);
        if (throttle && this.lastLoggedTop.getAndSet(hash) == hash) {
            return;
        }
        int totalCpus = GridDiscoveryManager.cpus(allNodes);
        double heap = U.heapSize(allNodes, 2);
        if (this.log.isQuiet()) {
            U.quiet(false, this.topologySnapshotMessage(topVer, srvNodes.size(), clientNodes.size(), totalCpus, heap));
        }
        if (this.log.isDebugEnabled()) {
            String dbg = "";
            dbg = dbg + U.nl() + U.nl() + ">>> +----------------+" + U.nl() + ">>> " + PREFIX + "." + U.nl() + ">>> +----------------+" + U.nl() + ">>> Grid name: " + (this.ctx.gridName() == null ? "default" : this.ctx.gridName()) + U.nl() + ">>> Number of server nodes: " + srvNodes.size() + U.nl() + ">>> Number of client nodes: " + clientNodes.size() + U.nl() + (this.discoOrdered ? ">>> Topology version: " + topVer + U.nl() : "") + ">>> Topology hash: 0x" + Long.toHexString(hash).toUpperCase() + U.nl();
            dbg = dbg + ">>> Local: " + locNode.id().toString().toUpperCase() + ", " + U.addressesAsString(locNode) + ", " + locNode.order() + ", " + locNode.attribute("os.name") + ' ' + locNode.attribute("os.arch") + ' ' + locNode.attribute("os.version") + ", " + System.getProperty("user.name") + ", " + locNode.attribute("java.runtime.name") + ' ' + locNode.attribute("java.runtime.version") + U.nl();
            for (ClusterNode node : rmtNodes) {
                dbg = dbg + ">>> Remote: " + node.id().toString().toUpperCase() + ", " + U.addressesAsString(node) + ", " + node.order() + ", " + node.attribute("os.name") + ' ' + node.attribute("os.arch") + ' ' + node.attribute("os.version") + ", " + node.attribute("org.apache.ignite.user.name") + ", " + node.attribute("java.runtime.name") + ' ' + node.attribute("java.runtime.version") + U.nl();
            }
            dbg = dbg + ">>> Total number of CPUs: " + totalCpus + U.nl();
            dbg = dbg + ">>> Total heap size: " + heap + "GB" + U.nl();
            this.log.debug(dbg);
        } else if (this.log.isInfoEnabled()) {
            this.log.info(this.topologySnapshotMessage(topVer, srvNodes.size(), clientNodes.size(), totalCpus, heap));
        }
    }

    private String topologySnapshotMessage(long topVer, int srvNodesNum, int clientNodesNum, int totalCpus, double heap) {
        return "Topology snapshot [" + (this.discoOrdered ? "ver=" + topVer + ", " : "") + "servers=" + srvNodesNum + ", clients=" + clientNodesNum + ", CPUs=" + totalCpus + ", heap=" + heap + "GB]";
    }

    @Override
    public void onKernalStop0(boolean cancel) {
        this.startLatch.countDown();
        if (this.segChkWrk != null) {
            this.segChkWrk.cancel();
            U.join(this.segChkThread, this.log);
        }
        if (!this.locJoinEvt.isDone()) {
            this.locJoinEvt.onDone(new IgniteCheckedException("Failed to wait for local node joined event (grid is stopping)."));
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.busyLock.block();
        ((DiscoverySpi)this.getSpi()).setListener(null);
        U.closeQuiet(this.metricsUpdateTask);
        U.cancel(this.discoWrk);
        U.join(this.discoWrk, this.log);
        this.stopSpi();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    public boolean aliveAll(@Nullable Collection<UUID> nodeIds) {
        if (nodeIds == null || nodeIds.isEmpty()) {
            return false;
        }
        for (UUID id : nodeIds) {
            if (this.alive(id)) continue;
            return false;
        }
        return true;
    }

    public boolean alive(UUID nodeId) {
        return this.getAlive(nodeId) != null;
    }

    @Nullable
    public ClusterNode getAlive(UUID nodeId) {
        assert (nodeId != null);
        return ((DiscoverySpi)this.getSpi()).getNode(nodeId);
    }

    public boolean alive(ClusterNode node) {
        assert (node != null);
        return this.alive(node.id());
    }

    public boolean pingNode(UUID nodeId) throws IgniteClientDisconnectedCheckedException {
        assert (nodeId != null);
        if (!this.busyLock.enterBusy()) {
            return false;
        }
        try {
            boolean bl = ((DiscoverySpi)this.getSpi()).pingNode(nodeId);
            return bl;
        }
        catch (IgniteException e) {
            if (e.hasCause(IgniteClientDisconnectedCheckedException.class)) {
                IgniteFuture<?> reconnectFut = this.ctx.cluster().clientReconnectFuture();
                throw new IgniteClientDisconnectedCheckedException(reconnectFut, e.getMessage());
            }
            throw e;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pingNodeNoError(UUID nodeId) {
        assert (nodeId != null);
        if (!this.busyLock.enterBusy()) {
            return false;
        }
        try {
            boolean bl = ((DiscoverySpi)this.getSpi()).pingNode(nodeId);
            return bl;
        }
        catch (IgniteException ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Nullable
    public ClusterNode node(UUID nodeId) {
        assert (nodeId != null);
        return this.discoCache().node(nodeId);
    }

    public Collection<ClusterNode> nodes(@Nullable Collection<UUID> ids, IgnitePredicate<UUID> ... p) {
        return F.isEmpty(ids) ? Collections.emptyList() : F.view(F.viewReadOnly(ids, U.id2Node(this.ctx), p), F.notNull());
    }

    public long topologyHash(Iterable<? extends ClusterNode> nodes) {
        assert (nodes != null);
        Iterator<? extends ClusterNode> iter = nodes.iterator();
        if (!iter.hasNext()) {
            return 0L;
        }
        ArrayList<String> uids = new ArrayList<String>();
        for (ClusterNode clusterNode : nodes) {
            uids.add(clusterNode.id().toString());
        }
        Collections.sort(uids);
        CRC32 hash = new CRC32();
        for (String uuid : uids) {
            hash.update(uuid.getBytes());
        }
        return hash.getValue();
    }

    public IgniteInternalFuture<Long> topologyFuture(long awaitVer) {
        long topVer = this.topologyVersion();
        if (topVer >= awaitVer) {
            return new GridFinishedFuture<Long>(topVer);
        }
        DiscoTopologyFuture fut = new DiscoTopologyFuture(this.ctx, awaitVer);
        fut.init();
        return fut;
    }

    private DiscoCache discoCache() {
        Snapshot cur = this.topSnap.get();
        assert (cur != null);
        return cur.discoCache;
    }

    public DiscoCache discoCache(AffinityTopologyVersion topVer) {
        return (DiscoCache)this.discoCacheHist.get(topVer);
    }

    public Collection<ClusterNode> remoteNodes() {
        return this.discoCache().remoteNodes();
    }

    public Collection<ClusterNode> allNodes() {
        return this.discoCache().allNodes();
    }

    public int size() {
        return this.discoCache().allNodes().size();
    }

    public Collection<ClusterNode> nodes(long topVer) {
        return this.nodes(new AffinityTopologyVersion(topVer));
    }

    public Collection<ClusterNode> nodes(AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(null, topVer).allNodes();
    }

    public List<ClusterNode> serverNodes(AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(null, topVer).srvNodes;
    }

    public ClusterNode node(AffinityTopologyVersion topVer, UUID id) {
        return this.resolveDiscoCache(null, topVer).node(id);
    }

    public Collection<ClusterNode> cacheNodes(@Nullable String cacheName, AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(cacheName, topVer).cacheNodes(cacheName, topVer.topologyVersion());
    }

    public Collection<ClusterNode> cacheNodes(AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(null, topVer).allNodesWithCaches(topVer.topologyVersion());
    }

    public Collection<ClusterNode> remoteCacheNodes(AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(null, topVer).remoteCacheNodes(topVer.topologyVersion());
    }

    Collection<ClusterNode> aliveCacheNodes(@Nullable String cacheName, AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(cacheName, topVer).aliveCacheNodes(cacheName, topVer.topologyVersion());
    }

    Collection<ClusterNode> aliveRemoteCacheNodes(@Nullable String cacheName, AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(cacheName, topVer).aliveRemoteCacheNodes(cacheName, topVer.topologyVersion());
    }

    @Nullable
    public ClusterNode oldestAliveCacheServerNode(AffinityTopologyVersion topVer) {
        DiscoCache cache = this.resolveDiscoCache(null, topVer);
        Map.Entry e = cache.aliveSrvNodesWithCaches.firstEntry();
        return e != null ? (ClusterNode)e.getKey() : null;
    }

    public Collection<ClusterNode> cacheAffinityNodes(@Nullable String cacheName, AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(cacheName, topVer).cacheAffinityNodes(cacheName, topVer.topologyVersion());
    }

    public boolean cacheAffinityNode(ClusterNode node, String cacheName) {
        CachePredicate pred = this.registeredCaches.get(cacheName);
        return pred != null && pred.dataNode(node);
    }

    public boolean cacheNearNode(ClusterNode node, String cacheName) {
        CachePredicate pred = this.registeredCaches.get(cacheName);
        return pred != null && pred.nearNode(node);
    }

    public boolean cacheClientNode(ClusterNode node, String cacheName) {
        CachePredicate pred = this.registeredCaches.get(cacheName);
        return pred != null && pred.clientNode(node);
    }

    public boolean cacheNode(ClusterNode node, String cacheName) {
        CachePredicate pred = this.registeredCaches.get(cacheName);
        return pred != null && pred.cacheNode(node);
    }

    public Map<String, CacheMode> nodeCaches(ClusterNode node) {
        HashMap<String, CacheMode> caches = U.newHashMap(this.registeredCaches.size());
        for (Map.Entry<String, CachePredicate> entry : this.registeredCaches.entrySet()) {
            String cacheName = entry.getKey();
            CachePredicate pred = entry.getValue();
            if (CU.isSystemCache(cacheName) || CU.isIgfsCache(this.ctx.config(), cacheName) || pred == null || !pred.cacheNode(node)) continue;
            caches.put(cacheName, pred.cacheMode);
        }
        return caches;
    }

    public boolean hasNearCache(@Nullable String cacheName, AffinityTopologyVersion topVer) {
        return this.resolveDiscoCache(cacheName, topVer).hasNearCache(cacheName);
    }

    private DiscoCache resolveDiscoCache(@Nullable String cacheName, AffinityTopologyVersion topVer) {
        DiscoCache cache;
        Snapshot snap = this.topSnap.get();
        DiscoCache discoCache = cache = AffinityTopologyVersion.NONE.equals(topVer) || topVer.equals(snap.topVer) ? snap.discoCache : (DiscoCache)this.discoCacheHist.get(topVer);
        if (cache == null) {
            throw new IgniteException("Failed to resolve nodes topology [cacheName=" + cacheName + ", topVer=" + topVer + ", history=" + this.discoCacheHist.keySet() + ", snap=" + snap + ", locNode=" + this.ctx.discovery().localNode() + ']');
        }
        return cache;
    }

    @Nullable
    public Collection<ClusterNode> topology(long topVer) {
        if (!this.histSupported) {
            throw new UnsupportedOperationException("Current discovery SPI does not support topology snapshots history (consider using TCP discovery SPI).");
        }
        Map<Long, Collection<ClusterNode>> snapshots = this.topHist;
        return snapshots.get(topVer);
    }

    public Collection<ClusterNode> daemonNodes() {
        return this.discoCache().daemonNodes();
    }

    public ClusterNode localNode() {
        return this.locNode == null ? ((DiscoverySpi)this.getSpi()).getLocalNode() : this.locNode;
    }

    public long topologyVersion() {
        return this.topSnap.get().topVer.topologyVersion();
    }

    public AffinityTopologyVersion topologyVersionEx() {
        return this.topSnap.get().topVer;
    }

    public DiscoveryEvent localJoinEvent() {
        try {
            return this.locJoinEvt.get();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    public void sendCustomEvent(DiscoveryCustomMessage msg) throws IgniteCheckedException {
        try {
            ((DiscoverySpi)this.getSpi()).sendCustomEvent(new CustomMessageWrapper(msg));
        }
        catch (IgniteClientDisconnectedException e) {
            IgniteFuture<?> reconnectFut = this.ctx.cluster().clientReconnectFuture();
            throw new IgniteClientDisconnectedCheckedException(reconnectFut, e.getMessage());
        }
        catch (IgniteException e) {
            throw new IgniteCheckedException(e);
        }
    }

    public long gridStartTime() {
        return ((DiscoverySpi)this.getSpi()).getGridStartTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryFailNode(UUID nodeId, @Nullable String warning) {
        if (!this.busyLock.enterBusy()) {
            return false;
        }
        try {
            if (!((DiscoverySpi)this.getSpi()).pingNode(nodeId)) {
                ((DiscoverySpi)this.getSpi()).failNode(nodeId, warning);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failNode(UUID nodeId, @Nullable String warning) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            ((DiscoverySpi)this.getSpi()).failNode(nodeId, warning);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private boolean updateTopologyVersionIfGreater(AffinityTopologyVersion updated, DiscoCache discoCache) {
        Snapshot cur;
        while (updated.compareTo((cur = this.topSnap.get()).topVer) >= 0) {
            if (!this.topSnap.compareAndSet(cur, new Snapshot(updated, discoCache))) continue;
            return true;
        }
        return false;
    }

    private void stopNode() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                GridDiscoveryManager.this.ctx.markSegmented();
                G.stop(GridDiscoveryManager.this.ctx.gridName(), true);
            }
        }).start();
    }

    private void restartJvm() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                GridDiscoveryManager.this.ctx.markSegmented();
                G.restart(true);
            }
        }).start();
    }

    private static class CachePredicate {
        private final IgnitePredicate<ClusterNode> cacheFilter;
        private final boolean nearEnabled;
        private final CacheMode cacheMode;
        private final ConcurrentHashMap<UUID, Boolean> clientNodes;

        private CachePredicate(IgnitePredicate<ClusterNode> cacheFilter, boolean nearEnabled, CacheMode cacheMode) {
            assert (cacheFilter != null);
            this.cacheFilter = cacheFilter;
            this.nearEnabled = nearEnabled;
            this.cacheMode = cacheMode;
            this.clientNodes = new ConcurrentHashMap();
        }

        public boolean addClientNode(UUID nodeId, boolean nearEnabled) {
            assert (nodeId != null);
            Boolean old = this.clientNodes.putIfAbsent(nodeId, nearEnabled);
            return old == null;
        }

        public boolean onNodeLeft(UUID leftNodeId) {
            assert (leftNodeId != null);
            Boolean old = this.clientNodes.remove(leftNodeId);
            return old != null;
        }

        public boolean dataNode(ClusterNode node) {
            return !node.isDaemon() && CU.affinityNode(node, this.cacheFilter);
        }

        public boolean cacheNode(ClusterNode node) {
            return !node.isDaemon() && (CU.affinityNode(node, this.cacheFilter) || this.clientNodes.containsKey(node.id()));
        }

        public boolean nearNode(ClusterNode node) {
            if (node.isDaemon()) {
                return false;
            }
            if (CU.affinityNode(node, this.cacheFilter)) {
                return this.nearEnabled;
            }
            Boolean near = this.clientNodes.get(node.id());
            return near != null && near != false;
        }

        public boolean clientNode(ClusterNode node) {
            if (node.isDaemon()) {
                return false;
            }
            Boolean near = this.clientNodes.get(node.id());
            return near != null && near == false;
        }
    }

    private class DiscoCache {
        private final List<ClusterNode> rmtNodes;
        private final List<ClusterNode> allNodes;
        private final List<ClusterNode> srvNodes;
        @GridToStringInclude
        private final Collection<ClusterNode> allNodesWithCaches;
        @GridToStringInclude
        private final Collection<ClusterNode> rmtNodesWithCaches;
        @GridToStringInclude
        private final Map<String, Collection<ClusterNode>> allCacheNodes;
        @GridToStringInclude
        private final Map<String, Collection<ClusterNode>> rmtCacheNodes;
        @GridToStringInclude
        private final Map<String, Collection<ClusterNode>> affCacheNodes;
        @GridToStringInclude
        private final Set<String> nearEnabledCaches;
        private final NavigableMap<IgniteProductVersion, Collection<ClusterNode>> nodesByVer;
        private final List<ClusterNode> daemonNodes;
        private final Map<UUID, ClusterNode> nodeMap;
        private final ClusterNode loc;
        private final long maxOrder;
        private final ConcurrentMap<String, Collection<ClusterNode>> aliveCacheNodes;
        private final ConcurrentMap<String, Collection<ClusterNode>> aliveRmtCacheNodes;
        private final ConcurrentSkipListMap<ClusterNode, Boolean> aliveSrvNodesWithCaches;

        private DiscoCache(ClusterNode loc, Collection<ClusterNode> rmts) {
            this.loc = loc;
            this.rmtNodes = Collections.unmodifiableList(new ArrayList<ClusterNode>(F.view(rmts, FILTER_DAEMON)));
            assert (!this.rmtNodes.contains(loc)) : "Remote nodes collection shouldn't contain local node [rmtNodes=" + this.rmtNodes + ", loc=" + loc + ']';
            ArrayList<ClusterNode> all = new ArrayList<ClusterNode>(this.rmtNodes.size() + 1);
            if (!loc.isDaemon()) {
                all.add(loc);
            }
            all.addAll(this.rmtNodes);
            Collections.sort(all, GridNodeOrderComparator.INSTANCE);
            this.allNodes = Collections.unmodifiableList(all);
            HashMap<String, Collection<ClusterNode>> cacheMap = new HashMap<String, Collection<ClusterNode>>(this.allNodes.size(), 1.0f);
            HashMap<String, Collection<ClusterNode>> rmtCacheMap = new HashMap<String, Collection<ClusterNode>>(this.allNodes.size(), 1.0f);
            HashMap<String, Collection<ClusterNode>> dhtNodesMap = new HashMap<String, Collection<ClusterNode>>(this.allNodes.size(), 1.0f);
            HashSet<ClusterNode> nodesWithCaches = new HashSet<ClusterNode>(this.allNodes.size());
            HashSet<ClusterNode> rmtNodesWithCaches = new HashSet<ClusterNode>(this.allNodes.size());
            this.aliveCacheNodes = new ConcurrentHashMap8<String, Collection<ClusterNode>>(this.allNodes.size(), 1.0f);
            this.aliveRmtCacheNodes = new ConcurrentHashMap8<String, Collection<ClusterNode>>(this.allNodes.size(), 1.0f);
            this.aliveSrvNodesWithCaches = new ConcurrentSkipListMap(GridNodeOrderComparator.INSTANCE);
            this.nodesByVer = new TreeMap<IgniteProductVersion, Collection<ClusterNode>>();
            long maxOrder0 = 0L;
            HashSet<String> nearEnabledSet = new HashSet<String>();
            ArrayList<ClusterNode> srvNodes = new ArrayList<ClusterNode>();
            for (ClusterNode node : this.allNodes) {
                IgniteProductVersion nodeVer;
                ArrayList<ClusterNode> nodes;
                assert (node.order() != 0L) : "Invalid node order [locNode=" + loc + ", node=" + node + ']';
                assert (!node.isDaemon());
                if (!CU.clientNode(node)) {
                    srvNodes.add(node);
                }
                if (node.order() > maxOrder0) {
                    maxOrder0 = node.order();
                }
                boolean hasCaches = false;
                for (Map.Entry entry : GridDiscoveryManager.this.registeredCaches.entrySet()) {
                    String cacheName = (String)entry.getKey();
                    CachePredicate filter = (CachePredicate)entry.getValue();
                    if (!filter.cacheNode(node)) continue;
                    nodesWithCaches.add(node);
                    if (!loc.id().equals(node.id())) {
                        rmtNodesWithCaches.add(node);
                    }
                    this.addToMap(cacheMap, cacheName, node);
                    if (GridDiscoveryManager.this.alive(node.id())) {
                        this.addToMap(this.aliveCacheNodes, this.maskNull(cacheName), node);
                    }
                    if (filter.dataNode(node)) {
                        this.addToMap(dhtNodesMap, cacheName, node);
                    }
                    if (filter.nearNode(node)) {
                        nearEnabledSet.add(cacheName);
                    }
                    if (!loc.id().equals(node.id())) {
                        this.addToMap(rmtCacheMap, cacheName, node);
                        if (GridDiscoveryManager.this.alive(node.id())) {
                            this.addToMap(this.aliveRmtCacheNodes, this.maskNull(cacheName), node);
                        }
                    }
                    hasCaches = true;
                }
                if (hasCaches && GridDiscoveryManager.this.alive(node.id()) && !CU.clientNode(node)) {
                    this.aliveSrvNodesWithCaches.put(node, Boolean.TRUE);
                }
                if ((nodes = (ArrayList<ClusterNode>)this.nodesByVer.get(nodeVer = U.productVersion(node))) == null) {
                    nodes = new ArrayList<ClusterNode>(this.allNodes.size());
                    this.nodesByVer.put(nodeVer, nodes);
                }
                nodes.add(node);
            }
            Collections.sort(srvNodes, CU.nodeComparator(true));
            for (ClusterNode node : this.allNodes) {
                IgniteProductVersion nodeVer = U.productVersion(node);
                NavigableMap<IgniteProductVersion, Collection<ClusterNode>> updateView = this.nodesByVer.headMap(nodeVer, false);
                for (Collection prevVersions : updateView.values()) {
                    prevVersions.add(node);
                }
            }
            this.maxOrder = maxOrder0;
            this.allCacheNodes = Collections.unmodifiableMap(cacheMap);
            this.rmtCacheNodes = Collections.unmodifiableMap(rmtCacheMap);
            this.affCacheNodes = Collections.unmodifiableMap(dhtNodesMap);
            this.allNodesWithCaches = Collections.unmodifiableCollection(nodesWithCaches);
            this.rmtNodesWithCaches = Collections.unmodifiableCollection(rmtNodesWithCaches);
            this.nearEnabledCaches = Collections.unmodifiableSet(nearEnabledSet);
            this.srvNodes = Collections.unmodifiableList(srvNodes);
            this.daemonNodes = Collections.unmodifiableList(new ArrayList<ClusterNode>(F.view(F.concat(false, loc, rmts), F0.not(FILTER_DAEMON))));
            HashMap<UUID, ClusterNode> nodeMap = new HashMap<UUID, ClusterNode>(this.allNodes().size() + this.daemonNodes.size(), 1.0f);
            for (ClusterNode n : F.concat(false, this.allNodes(), this.daemonNodes())) {
                nodeMap.put(n.id(), n);
            }
            this.nodeMap = nodeMap;
        }

        private void addToMap(Map<String, Collection<ClusterNode>> cacheMap, String cacheName, ClusterNode rich) {
            Collection<ClusterNode> cacheNodes = cacheMap.get(cacheName);
            if (cacheNodes == null) {
                cacheNodes = new ArrayList<ClusterNode>(this.allNodes.size());
                cacheMap.put(cacheName, cacheNodes);
            }
            cacheNodes.add(rich);
        }

        ClusterNode localNode() {
            return this.loc;
        }

        Collection<ClusterNode> remoteNodes() {
            return this.rmtNodes;
        }

        Collection<ClusterNode> allNodes() {
            return this.allNodes;
        }

        Collection<ClusterNode> elderNodes(IgniteProductVersion ver) {
            Map.Entry<IgniteProductVersion, Collection<ClusterNode>> entry = this.nodesByVer.ceilingEntry(ver);
            if (entry == null) {
                return Collections.emptyList();
            }
            return entry.getValue();
        }

        NavigableMap<IgniteProductVersion, Collection<ClusterNode>> versionsMap() {
            return this.nodesByVer;
        }

        Collection<ClusterNode> allNodesWithCaches(long topVer) {
            return this.filter(topVer, this.allNodesWithCaches);
        }

        Collection<ClusterNode> cacheNodes(@Nullable String cacheName, long topVer) {
            return this.filter(topVer, this.allCacheNodes.get(cacheName));
        }

        Collection<ClusterNode> remoteCacheNodes(long topVer) {
            return this.filter(topVer, this.rmtNodesWithCaches);
        }

        Collection<ClusterNode> cacheAffinityNodes(@Nullable String cacheName, long topVer) {
            return this.filter(topVer, this.affCacheNodes.get(cacheName));
        }

        Collection<ClusterNode> aliveCacheNodes(@Nullable String cacheName, long topVer) {
            return this.filter(topVer, (Collection)this.aliveCacheNodes.get(this.maskNull(cacheName)));
        }

        Collection<ClusterNode> aliveRemoteCacheNodes(@Nullable String cacheName, long topVer) {
            return this.filter(topVer, (Collection)this.aliveRmtCacheNodes.get(this.maskNull(cacheName)));
        }

        boolean hasNearCache(@Nullable String cacheName) {
            return this.nearEnabledCaches.contains(cacheName);
        }

        void updateAlives(ClusterNode leftNode) {
            if (leftNode.order() > this.maxOrder) {
                return;
            }
            this.filterNodeMap(this.aliveCacheNodes, leftNode);
            this.filterNodeMap(this.aliveRmtCacheNodes, leftNode);
            this.aliveSrvNodesWithCaches.remove(leftNode);
        }

        private void filterNodeMap(ConcurrentMap<String, Collection<ClusterNode>> map, ClusterNode exclNode) {
            for (String cacheName : GridDiscoveryManager.this.registeredCaches.keySet()) {
                ArrayList newNodes;
                Collection oldNodes;
                String maskedName = this.maskNull(cacheName);
                while ((oldNodes = (Collection)map.get(maskedName)) != null && !oldNodes.isEmpty() && (newNodes = new ArrayList(oldNodes)).remove(exclNode) && !map.replace(maskedName, oldNodes, newNodes)) {
                }
            }
        }

        private String maskNull(@Nullable String cacheName) {
            return cacheName == null ? NULL_CACHE_NAME : cacheName;
        }

        private Collection<ClusterNode> filter(final long topVer, @Nullable Collection<ClusterNode> nodes) {
            if (nodes == null) {
                return Collections.emptyList();
            }
            return nodes.isEmpty() || topVer < 0L || topVer >= this.maxOrder ? nodes : F.view(nodes, new P1<ClusterNode>(){

                @Override
                public boolean apply(ClusterNode node) {
                    return node.order() <= topVer;
                }
            });
        }

        Collection<ClusterNode> daemonNodes() {
            return this.daemonNodes;
        }

        @Nullable
        ClusterNode node(UUID id) {
            return this.nodeMap.get(id);
        }

        public String toString() {
            return S.toString(DiscoCache.class, this, "allNodesWithDaemons", U.toShortString(this.allNodes));
        }
    }

    private static class Snapshot {
        private final AffinityTopologyVersion topVer;
        @GridToStringExclude
        private final DiscoCache discoCache;

        private Snapshot(AffinityTopologyVersion topVer, DiscoCache discoCache) {
            this.topVer = topVer;
            this.discoCache = discoCache;
        }

        public String toString() {
            return S.toString(Snapshot.class, this);
        }
    }

    private static class DiscoTopologyFuture
    extends GridFutureAdapter<Long>
    implements GridLocalEventListener {
        private static final long serialVersionUID = 0L;
        private GridKernalContext ctx;
        private long awaitVer;

        private DiscoTopologyFuture() {
        }

        private DiscoTopologyFuture(GridKernalContext ctx, long awaitVer) {
            this.ctx = ctx;
            this.awaitVer = awaitVer;
        }

        private void init() {
            this.ctx.event().addLocalEventListener(this, 10, 11, 12);
            long topVer = this.ctx.discovery().topologyVersion();
            if (topVer >= this.awaitVer) {
                this.onDone(topVer);
            }
        }

        @Override
        public boolean onDone(@Nullable Long res, @Nullable Throwable err) {
            if (super.onDone(res, err)) {
                this.ctx.event().removeLocalEventListener(this, 10, 11, 12);
                return true;
            }
            return false;
        }

        @Override
        public void onEvent(Event evt) {
            assert (evt.type() == 10 || evt.type() == 11 || evt.type() == 12);
            DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
            if (discoEvt.topologyVersion() >= this.awaitVer) {
                this.onDone(discoEvt.topologyVersion());
            }
        }
    }

    private class MetricsUpdater
    implements Runnable {
        private long prevGcTime = -1L;
        private long prevCpuTime = -1L;

        private MetricsUpdater() {
        }

        @Override
        public void run() {
            GridDiscoveryManager.this.gcCpuLoad = this.getGcCpuLoad();
            GridDiscoveryManager.this.cpuLoad = this.getCpuLoad();
        }

        private double getGcCpuLoad() {
            long gcTime = 0L;
            for (GarbageCollectorMXBean bean : gc) {
                long colTime = bean.getCollectionTime();
                if (colTime <= 0L) continue;
                gcTime += colTime;
            }
            gcTime /= (long)GridDiscoveryManager.this.metrics.getAvailableProcessors();
            double gc = 0.0;
            if (this.prevGcTime > 0L) {
                long gcTimeDiff = gcTime - this.prevGcTime;
                gc = (double)gcTimeDiff / 3000.0;
            }
            this.prevGcTime = gcTime;
            return gc;
        }

        private double getCpuLoad() {
            long cpuTime;
            try {
                cpuTime = (Long)U.property(os, "processCpuTime");
            }
            catch (IgniteException ignored) {
                return -1.0;
            }
            cpuTime /= (long)(1000000 * GridDiscoveryManager.this.metrics.getAvailableProcessors());
            double cpu = 0.0;
            if (this.prevCpuTime > 0L) {
                long cpuTimeDiff = cpuTime - this.prevCpuTime;
                cpu = Math.min(1.0, (double)cpuTimeDiff / 3000.0);
            }
            this.prevCpuTime = cpuTime;
            return cpu;
        }

        public String toString() {
            return S.toString(MetricsUpdater.class, this, super.toString());
        }
    }

    private class DiscoveryWorker
    extends GridWorker {
        private final BlockingQueue<GridTuple5<Integer, AffinityTopologyVersion, ClusterNode, Collection<ClusterNode>, DiscoveryCustomMessage>> evts;
        private boolean nodeSegFired;

        private DiscoveryWorker() {
            super(GridDiscoveryManager.this.ctx.gridName(), "disco-event-worker", GridDiscoveryManager.this.log);
            this.evts = new LinkedBlockingQueue<GridTuple5<Integer, AffinityTopologyVersion, ClusterNode, Collection<ClusterNode>, DiscoveryCustomMessage>>();
        }

        private void recordEvent(int type, long topVer, ClusterNode node, Collection<ClusterNode> topSnapshot) {
            assert (node != null);
            if (GridDiscoveryManager.this.ctx.event().isRecordable(type)) {
                DiscoveryEvent evt = new DiscoveryEvent();
                evt.node(GridDiscoveryManager.this.ctx.discovery().localNode());
                evt.eventNode(node);
                evt.type(type);
                evt.topologySnapshot(topVer, U.arrayList(topSnapshot, FILTER_DAEMON));
                if (type == 13) {
                    evt.message("Metrics were updated: " + node);
                } else if (type == 10) {
                    evt.message("Node joined: " + node);
                } else if (type == 11) {
                    evt.message("Node left: " + node);
                } else if (type == 12) {
                    evt.message("Node failed: " + node);
                } else if (type == 14) {
                    evt.message("Node segmented: " + node);
                } else if (type == 16) {
                    evt.message("Client node disconnected: " + node);
                } else if (type == 17) {
                    evt.message("Client node reconnected: " + node);
                } else assert (false);
                GridDiscoveryManager.this.ctx.event().record(evt);
            }
        }

        void addEvent(int type, AffinityTopologyVersion topVer, ClusterNode node, Collection<ClusterNode> topSnapshot, @Nullable DiscoveryCustomMessage data) {
            assert (node != null) : data;
            this.evts.add(new GridTuple5<Integer, AffinityTopologyVersion, ClusterNode, Collection<ClusterNode>, DiscoveryCustomMessage>(type, topVer, node, topSnapshot, data));
        }

        private String quietNode(ClusterNode node) {
            assert (node != null);
            return "nodeId8=" + node.id().toString().substring(0, 8) + ", " + "addrs=" + U.addressesAsString(node) + ", " + "order=" + node.order() + ", " + "CPUs=" + node.metrics().getTotalCpus();
        }

        @Override
        protected void body() throws InterruptedException {
            while (!this.isCancelled()) {
                try {
                    this.body0();
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Throwable t) {
                    U.error(this.log, "Unexpected exception in discovery worker thread (ignored).", t);
                    if (!(t instanceof Error)) continue;
                    throw (Error)t;
                }
            }
        }

        private void body0() throws InterruptedException {
            GridTuple5<Integer, AffinityTopologyVersion, ClusterNode, Collection<ClusterNode>, DiscoveryCustomMessage> evt = this.evts.take();
            int type = evt.get1();
            AffinityTopologyVersion topVer = evt.get2();
            ClusterNode node = evt.get3();
            boolean isDaemon = node.isDaemon();
            boolean segmented = false;
            switch (type) {
                case 10: {
                    assert (!GridDiscoveryManager.this.discoOrdered || topVer.topologyVersion() == node.order()) : "Invalid topology version [topVer=" + topVer + ", node=" + node + ']';
                    try {
                        GridDiscoveryManager.this.checkAttributes(F.asList(node));
                    }
                    catch (IgniteCheckedException e) {
                        U.warn(this.log, e.getMessage());
                    }
                    if (!isDaemon) {
                        if (!GridDiscoveryManager.this.isLocDaemon) {
                            if (this.log.isInfoEnabled()) {
                                this.log.info("Added new node to topology: " + node);
                            }
                            GridDiscoveryManager.this.ackTopology(topVer.topologyVersion(), true);
                            break;
                        }
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug("Added new node to topology: " + node);
                        break;
                    }
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Added new daemon node to topology: " + node);
                    break;
                }
                case 11: {
                    if (GridDiscoveryManager.this.hasRslvrs) {
                        GridDiscoveryManager.this.segChkWrk.scheduleSegmentCheck();
                    }
                    if (!isDaemon) {
                        if (!GridDiscoveryManager.this.isLocDaemon) {
                            if (this.log.isInfoEnabled()) {
                                this.log.info("Node left topology: " + node);
                            }
                            GridDiscoveryManager.this.ackTopology(topVer.topologyVersion(), true);
                            break;
                        }
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug("Node left topology: " + node);
                        break;
                    }
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Daemon node left topology: " + node);
                    break;
                }
                case 16: {
                    break;
                }
                case 17: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Client node reconnected to topology: " + node);
                    }
                    if (GridDiscoveryManager.this.isLocDaemon) break;
                    GridDiscoveryManager.this.ackTopology(topVer.topologyVersion(), true);
                    break;
                }
                case 12: {
                    if (GridDiscoveryManager.this.hasRslvrs) {
                        GridDiscoveryManager.this.segChkWrk.scheduleSegmentCheck();
                    }
                    if (!isDaemon) {
                        if (!GridDiscoveryManager.this.isLocDaemon) {
                            U.warn(this.log, "Node FAILED: " + node);
                            GridDiscoveryManager.this.ackTopology(topVer.topologyVersion(), true);
                            break;
                        }
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug("Node FAILED: " + node);
                        break;
                    }
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Daemon node FAILED: " + node);
                    break;
                }
                case 14: {
                    assert (F.eqNodes(GridDiscoveryManager.this.localNode(), node));
                    if (this.nodeSegFired) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Ignored node segmented event [type=EVT_NODE_SEGMENTED, node=" + node + ']');
                        }
                        return;
                    }
                    this.nodeSegFired = true;
                    GridDiscoveryManager.this.lastLoggedTop.set(0L);
                    segmented = true;
                    if (!GridDiscoveryManager.this.isLocDaemon) {
                        U.warn(this.log, "Local node SEGMENTED: " + node);
                        break;
                    }
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Local node SEGMENTED: " + node);
                    break;
                }
                case 18: {
                    if (GridDiscoveryManager.this.ctx.event().isRecordable(18)) {
                        DiscoveryCustomEvent customEvt = new DiscoveryCustomEvent();
                        customEvt.node(GridDiscoveryManager.this.ctx.discovery().localNode());
                        customEvt.eventNode(node);
                        customEvt.type(type);
                        customEvt.topologySnapshot(topVer.topologyVersion(), evt.get4());
                        customEvt.affinityTopologyVersion(topVer);
                        customEvt.customMessage(evt.get5());
                        GridDiscoveryManager.this.ctx.event().record(customEvt);
                    }
                    return;
                }
                case 13: {
                    break;
                }
                default: {
                    assert (false) : "Invalid discovery event: " + type;
                    break;
                }
            }
            this.recordEvent(type, topVer.topologyVersion(), node, evt.get4());
            if (segmented) {
                this.onSegmentation();
            }
        }

        private void onSegmentation() {
            SegmentationPolicy segPlc = GridDiscoveryManager.this.ctx.config().getSegmentationPolicy();
            try {
                ((DiscoverySpi)GridDiscoveryManager.this.getSpi()).disconnect();
            }
            catch (IgniteSpiException e) {
                U.error(this.log, "Failed to disconnect discovery SPI.", e);
            }
            switch (segPlc) {
                case RESTART_JVM: {
                    U.warn(this.log, "Restarting JVM according to configured segmentation policy.");
                    GridDiscoveryManager.this.restartJvm();
                    break;
                }
                case STOP: {
                    U.warn(this.log, "Stopping local node according to configured segmentation policy.");
                    GridDiscoveryManager.this.stopNode();
                    break;
                }
                default: {
                    assert (segPlc == SegmentationPolicy.NOOP) : "Unsupported segmentation policy value: " + (Object)((Object)segPlc);
                    break;
                }
            }
        }

        @Override
        public String toString() {
            return S.toString(DiscoveryWorker.class, this);
        }
    }

    private class SegmentCheckWorker
    extends GridWorker {
        private final BlockingQueue<Object> queue;

        private SegmentCheckWorker() {
            super(GridDiscoveryManager.this.ctx.gridName(), "disco-net-seg-chk-worker", GridDiscoveryManager.this.log);
            this.queue = new LinkedBlockingQueue<Object>();
            assert (GridDiscoveryManager.this.hasRslvrs);
            assert (GridDiscoveryManager.this.segChkFreq > 0L);
        }

        public void scheduleSegmentCheck() {
            this.queue.add(new Object());
        }

        @Override
        protected void body() throws InterruptedException {
            long lastChk = 0L;
            while (!this.isCancelled()) {
                Object req = this.queue.poll(2000L, TimeUnit.MILLISECONDS);
                long now = U.currentTimeMillis();
                if (req == null && (GridDiscoveryManager.this.segChkFreq == 0L || lastChk + GridDiscoveryManager.this.segChkFreq >= now)) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Skipping segment check as it has not been requested and it is not time to check.");
                    continue;
                }
                assert (req != null || lastChk + GridDiscoveryManager.this.segChkFreq < now);
                while (this.queue.poll() != null) {
                }
                if (!GridDiscoveryManager.this.lastSegChkRes.get()) continue;
                boolean segValid = GridDiscoveryManager.this.ctx.segmentation().isValidSegment();
                lastChk = now;
                if (!segValid) {
                    GridDiscoveryManager.this.discoWrk.addEvent(14, AffinityTopologyVersion.NONE, ((DiscoverySpi)GridDiscoveryManager.this.getSpi()).getLocalNode(), Collections.emptyList(), null);
                    GridDiscoveryManager.this.lastSegChkRes.set(false);
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Segment has been checked [requested=" + (req != null) + ", valid=" + segValid + ']');
            }
        }

        @Override
        public String toString() {
            return S.toString(SegmentCheckWorker.class, this);
        }
    }
}

