/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.eventstorage;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridEventStorageMessage
implements Message {
    private static final long serialVersionUID = 0L;
    @GridDirectTransient
    private Object resTopic;
    private byte[] resTopicBytes;
    private byte[] filter;
    @GridDirectTransient
    private Collection<Event> evts;
    private byte[] evtsBytes;
    @GridDirectTransient
    private Throwable ex;
    private byte[] exBytes;
    private IgniteUuid clsLdrId;
    private DeploymentMode depMode;
    private String filterClsName;
    private String userVer;
    @GridToStringInclude
    @GridDirectMap(keyType=UUID.class, valueType=IgniteUuid.class)
    private Map<UUID, IgniteUuid> ldrParties;

    public GridEventStorageMessage() {
    }

    GridEventStorageMessage(Object resTopic, byte[] filter, String filterClsName, IgniteUuid clsLdrId, DeploymentMode depMode, String userVer, Map<UUID, IgniteUuid> ldrParties) {
        this.resTopic = resTopic;
        this.filter = filter;
        this.filterClsName = filterClsName;
        this.depMode = depMode;
        this.clsLdrId = clsLdrId;
        this.userVer = userVer;
        this.ldrParties = ldrParties;
        this.evts = null;
        this.ex = null;
    }

    GridEventStorageMessage(Collection<Event> evts, Throwable ex) {
        this.evts = evts;
        this.ex = ex;
        this.resTopic = null;
        this.filter = null;
        this.filterClsName = null;
        this.depMode = null;
        this.clsLdrId = null;
        this.userVer = null;
    }

    Object responseTopic() {
        return this.resTopic;
    }

    void responseTopic(Object resTopic) {
        this.resTopic = resTopic;
    }

    byte[] responseTopicBytes() {
        return this.resTopicBytes;
    }

    void responseTopicBytes(byte[] resTopicBytes) {
        this.resTopicBytes = resTopicBytes;
    }

    byte[] filter() {
        return this.filter;
    }

    @Nullable
    Collection<Event> events() {
        return this.evts != null ? Collections.unmodifiableCollection(this.evts) : null;
    }

    void events(@Nullable Collection<Event> evts) {
        this.evts = evts;
    }

    byte[] eventsBytes() {
        return this.evtsBytes;
    }

    void eventsBytes(byte[] evtsBytes) {
        this.evtsBytes = evtsBytes;
    }

    IgniteUuid classLoaderId() {
        return this.clsLdrId;
    }

    DeploymentMode deploymentMode() {
        return this.depMode;
    }

    String filterClassName() {
        return this.filterClsName;
    }

    String userVersion() {
        return this.userVer;
    }

    @Nullable
    Map<UUID, IgniteUuid> loaderParticipants() {
        return this.ldrParties != null ? Collections.unmodifiableMap(this.ldrParties) : null;
    }

    void loaderParticipants(Map<UUID, IgniteUuid> ldrParties) {
        this.ldrParties = ldrParties;
    }

    Throwable exception() {
        return this.ex;
    }

    void exception(Throwable ex) {
        this.ex = ex;
    }

    byte[] exceptionBytes() {
        return this.exBytes;
    }

    void exceptionBytes(byte[] exBytes) {
        this.exBytes = exBytes;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeIgniteUuid("clsLdrId", this.clsLdrId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByte("depMode", this.depMode != null ? (byte)this.depMode.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeByteArray("evtsBytes", this.evtsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeByteArray("exBytes", this.exBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeByteArray("filter", this.filter)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeString("filterClsName", this.filterClsName)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeMap("ldrParties", this.ldrParties, MessageCollectionItemType.UUID, MessageCollectionItemType.IGNITE_UUID)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeByteArray("resTopicBytes", this.resTopicBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeString("userVer", this.userVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.clsLdrId = reader.readIgniteUuid("clsLdrId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                byte depModeOrd = reader.readByte("depMode");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.depMode = DeploymentMode.fromOrdinal(depModeOrd);
                reader.incrementState();
            }
            case 2: {
                this.evtsBytes = reader.readByteArray("evtsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.exBytes = reader.readByteArray("exBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.filter = reader.readByteArray("filter");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.filterClsName = reader.readString("filterClsName");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.ldrParties = reader.readMap("ldrParties", MessageCollectionItemType.UUID, MessageCollectionItemType.IGNITE_UUID, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.resTopicBytes = reader.readByteArray("resTopicBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.userVer = reader.readString("userVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridEventStorageMessage.class);
    }

    @Override
    public byte directType() {
        return 13;
    }

    @Override
    public byte fieldsCount() {
        return 9;
    }

    public String toString() {
        return S.toString(GridEventStorageMessage.class, this);
    }
}

