/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.failover;

import java.util.List;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskSession;
import org.apache.ignite.internal.GridTaskSessionImpl;
import org.apache.ignite.internal.managers.loadbalancer.GridLoadBalancerManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.failover.FailoverContext;
import org.jetbrains.annotations.Nullable;

public class GridFailoverContextImpl
implements FailoverContext {
    private final GridTaskSessionImpl taskSes;
    private final ComputeJobResult jobRes;
    @GridToStringExclude
    private final GridLoadBalancerManager loadMgr;
    private final int partId;
    private final Object affKey;
    private final String affCacheName;
    private final AffinityTopologyVersion topVer;

    public GridFailoverContextImpl(GridTaskSessionImpl taskSes, ComputeJobResult jobRes, GridLoadBalancerManager loadMgr, int partId, @Nullable Object affKey, @Nullable String affCacheName, @Nullable AffinityTopologyVersion topVer) {
        assert (taskSes != null);
        assert (jobRes != null);
        assert (loadMgr != null);
        this.taskSes = taskSes;
        this.jobRes = jobRes;
        this.loadMgr = loadMgr;
        this.partId = partId;
        this.affKey = affKey;
        this.affCacheName = affCacheName;
        this.topVer = topVer;
    }

    @Override
    public ComputeTaskSession getTaskSession() {
        return this.taskSes;
    }

    @Override
    public ComputeJobResult getJobResult() {
        return this.jobRes;
    }

    @Override
    public ClusterNode getBalancedNode(List<ClusterNode> top) {
        return this.loadMgr.getBalancedNode(this.taskSes, top, (ComputeJob)this.jobRes.getJob());
    }

    @Override
    @Nullable
    public Object affinityKey() {
        return this.affKey;
    }

    @Override
    @Nullable
    public String affinityCacheName() {
        return this.affCacheName;
    }

    @Override
    public int partition() {
        return this.partId;
    }

    @Nullable
    public AffinityTopologyVersion affinityTopologyVersion() {
        return this.topVer;
    }

    public String toString() {
        return S.toString(GridFailoverContextImpl.class, this);
    }
}

