/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.swapspace;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.events.SwapSpaceEvent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.SkipDaemon;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.GridSpiCloseableIteratorWrapper;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiCloseableIterator;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.swapspace.SwapContext;
import org.apache.ignite.spi.swapspace.SwapKey;
import org.apache.ignite.spi.swapspace.SwapSpaceSpi;
import org.apache.ignite.spi.swapspace.SwapSpaceSpiListener;
import org.jetbrains.annotations.Nullable;

@SkipDaemon
public class GridSwapSpaceManager
extends GridManagerAdapter<SwapSpaceSpi> {
    private Marshaller marsh;

    public GridSwapSpaceManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])new SwapSpaceSpi[]{ctx.config().getSwapSpaceSpi()});
    }

    @Override
    public void start() throws IgniteCheckedException {
        ((SwapSpaceSpi)this.getSpi()).setListener(new SwapSpaceSpiListener(){

            @Override
            public void onSwapEvent(int evtType, @Nullable String spaceName, @Nullable byte[] keyBytes, @Nullable byte[] valBytes) {
                if (GridSwapSpaceManager.this.ctx.event().isRecordable(evtType)) {
                    String msg = null;
                    switch (evtType) {
                        case 71: {
                            msg = "Swap space data read [space=" + spaceName + ']';
                            break;
                        }
                        case 72: {
                            msg = "Swap space data stored [space=" + spaceName + ']';
                            break;
                        }
                        case 73: {
                            msg = "Swap space data removed [space=" + spaceName + ']';
                            break;
                        }
                        case 74: {
                            msg = "Swap space cleared [space=" + spaceName + ']';
                            break;
                        }
                        case 75: {
                            msg = "Swap entry evicted [space=" + spaceName + ']';
                            break;
                        }
                        default: {
                            assert (false) : "Unknown event type: " + evtType;
                            break;
                        }
                    }
                    GridSwapSpaceManager.this.ctx.event().record(new SwapSpaceEvent(GridSwapSpaceManager.this.ctx.discovery().localNode(), msg, evtType, spaceName));
                }
                if (evtType == 75 && spaceName != null) {
                    assert (keyBytes != null);
                    assert (valBytes != null);
                    GridSwapSpaceManager.this.ctx.cache().onEvictFromSwap(spaceName, keyBytes, valBytes);
                }
            }
        });
        this.startSpi();
        this.marsh = this.ctx.config().getMarshaller();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        if (this.ctx.config().isDaemon()) {
            return;
        }
        ((SwapSpaceSpi)this.getSpi()).setListener(null);
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        if (this.ctx.config().isDaemon()) {
            return;
        }
        this.stopSpi();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    @Nullable
    public byte[] read(@Nullable String spaceName, SwapKey key, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        assert (key != null);
        try {
            return ((SwapSpaceSpi)this.getSpi()).read(spaceName, key, this.context(ldr));
        }
        catch (IgniteSpiException e) {
            throw new IgniteCheckedException("Failed to read from swap space [space=" + spaceName + ", key=" + key + ']', e);
        }
    }

    @Nullable
    public <T> T readValue(@Nullable String spaceName, SwapKey key, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        assert (key != null);
        return this.unmarshal(this.read(spaceName, key, ldr), ldr);
    }

    public void write(@Nullable String spaceName, SwapKey key, byte[] val, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        assert (key != null);
        assert (val != null);
        try {
            ((SwapSpaceSpi)this.getSpi()).store(spaceName, key, val, this.context(ldr));
        }
        catch (IgniteSpiException e) {
            throw new IgniteCheckedException("Failed to write to swap space [space=" + spaceName + ", key=" + key + ", valLen=" + val.length + ']', e);
        }
    }

    public <K, V> void writeAll(String spaceName, Map<SwapKey, byte[]> batch, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        ((SwapSpaceSpi)this.getSpi()).storeAll(spaceName, batch, this.context(ldr));
    }

    public void remove(@Nullable String spaceName, SwapKey key, @Nullable IgniteInClosure<byte[]> c, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        assert (key != null);
        try {
            ((SwapSpaceSpi)this.getSpi()).remove(spaceName, key, c, this.context(ldr));
        }
        catch (IgniteSpiException e) {
            throw new IgniteCheckedException("Failed to remove from swap space [space=" + spaceName + ", key=" + key + ']', e);
        }
    }

    public void removeAll(@Nullable String spaceName, Collection<SwapKey> keys, IgniteBiInClosure<SwapKey, byte[]> c, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        assert (keys != null);
        try {
            ((SwapSpaceSpi)this.getSpi()).removeAll(spaceName, keys, c, this.context(ldr));
        }
        catch (IgniteSpiException e) {
            throw new IgniteCheckedException("Failed to remove from swap space [space=" + spaceName + ", " + "keysCnt=" + keys.size() + ']', e);
        }
    }

    public long swapSize(@Nullable String spaceName) throws IgniteCheckedException {
        try {
            return ((SwapSpaceSpi)this.getSpi()).size(spaceName);
        }
        catch (IgniteSpiException e) {
            throw new IgniteCheckedException("Failed to get swap size for space: " + spaceName, e);
        }
    }

    public long swapKeys(@Nullable String spaceName) throws IgniteCheckedException {
        try {
            return ((SwapSpaceSpi)this.getSpi()).count(spaceName);
        }
        catch (IgniteSpiException e) {
            throw new IgniteCheckedException("Failed to get swap keys count for space: " + spaceName, e);
        }
    }

    public long swapKeys(@Nullable String spaceName, Set<Integer> parts) throws IgniteCheckedException {
        try {
            return ((SwapSpaceSpi)this.getSpi()).count(spaceName, parts);
        }
        catch (IgniteSpiException e) {
            throw new IgniteCheckedException("Failed to get swap keys count for space: " + spaceName, e);
        }
    }

    public void clear(@Nullable String spaceName) throws IgniteCheckedException {
        try {
            ((SwapSpaceSpi)this.getSpi()).clear(spaceName);
        }
        catch (IgniteSpiException e) {
            throw new IgniteCheckedException("Failed to clear swap space [space=" + spaceName + ']', e);
        }
    }

    @Nullable
    public GridCloseableIterator<Map.Entry<byte[], byte[]>> rawIterator(@Nullable String spaceName) throws IgniteCheckedException {
        try {
            IgniteSpiCloseableIterator<Map.Entry<byte[], byte[]>> it = ((SwapSpaceSpi)this.getSpi()).rawIterator(spaceName);
            return it == null ? null : new GridSpiCloseableIteratorWrapper<Map.Entry<byte[], byte[]>>(it);
        }
        catch (IgniteSpiException e) {
            throw new IgniteCheckedException("Failed to get iterator over swap space [space=" + spaceName + ']', e);
        }
    }

    @Nullable
    public GridCloseableIterator<Map.Entry<byte[], byte[]>> rawIterator(@Nullable String spaceName, int part) throws IgniteCheckedException {
        try {
            IgniteSpiCloseableIterator<Map.Entry<byte[], byte[]>> it = ((SwapSpaceSpi)this.getSpi()).rawIterator(spaceName, part);
            return (GridCloseableIterator)((Object)(it == null ? new GridEmptyCloseableIterator() : new GridSpiCloseableIteratorWrapper<Map.Entry<byte[], byte[]>>(it)));
        }
        catch (IgniteSpiException e) {
            throw new IgniteCheckedException("Failed to get iterator over swap space [space=" + spaceName + ']', e);
        }
    }

    @Nullable
    public <K> GridCloseableIterator<K> keysIterator(@Nullable String spaceName, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        try {
            IgniteSpiCloseableIterator it = ((SwapSpaceSpi)this.getSpi()).keyIterator(spaceName, this.context(ldr));
            return it == null ? null : new GridSpiCloseableIteratorWrapper(it);
        }
        catch (IgniteSpiException e) {
            throw new IgniteCheckedException("Failed to get iterator over swap space [space=" + spaceName + ']', e);
        }
    }

    private <T> T unmarshal(byte[] swapBytes, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        if (swapBytes == null) {
            return null;
        }
        return U.unmarshal(this.marsh, swapBytes, ldr != null ? ldr : U.gridClassLoader());
    }

    private SwapContext context(@Nullable ClassLoader clsLdr) {
        SwapContext ctx = new SwapContext();
        ctx.classLoader(clsLdr != null ? clsLdr : U.gridClassLoader());
        return ctx;
    }
}

