/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors;

import java.io.Serializable;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.GridProcessor;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.jetbrains.annotations.Nullable;

public abstract class GridProcessorAdapter
implements GridProcessor {
    @GridToStringExclude
    protected final GridKernalContext ctx;
    @GridToStringExclude
    protected final IgniteLogger log;

    protected GridProcessorAdapter(GridKernalContext ctx) {
        assert (ctx != null);
        this.ctx = ctx;
        this.log = ctx.log(this.getClass());
    }

    @Override
    public void onKernalStart() throws IgniteCheckedException {
    }

    @Override
    public void onKernalStop(boolean cancel) {
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
    }

    @Override
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) throws IgniteCheckedException {
        return null;
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return null;
    }

    @Override
    @Nullable
    public Serializable collectDiscoveryData(UUID nodeId) {
        return null;
    }

    @Override
    public void onDiscoveryDataReceived(UUID joiningNodeId, UUID rmtNodeId, Serializable data) {
    }

    @Override
    public void start() throws IgniteCheckedException {
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
    }

    protected final void assertParameter(boolean cond, String condDesc) throws IgniteCheckedException {
        if (!cond) {
            throw new IgniteCheckedException("Grid configuration parameter invalid: " + condDesc);
        }
    }

    @Override
    public void printMemoryStats() {
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node) {
        return null;
    }

    public String toString() {
        return S.toString(GridProcessorAdapter.class, this);
    }
}

