/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.affinity;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class AffinityTopologyVersion
implements Comparable<AffinityTopologyVersion>,
Externalizable,
Message {
    private static final long serialVersionUID = 0L;
    public static final AffinityTopologyVersion NONE = new AffinityTopologyVersion(-1L, 0);
    public static final AffinityTopologyVersion ZERO = new AffinityTopologyVersion(0L, 0);
    private long topVer;
    private int minorTopVer;

    public AffinityTopologyVersion() {
    }

    public AffinityTopologyVersion(long topVer) {
        this.topVer = topVer;
    }

    public AffinityTopologyVersion(long topVer, int minorTopVer) {
        this.topVer = topVer;
        this.minorTopVer = minorTopVer;
    }

    public long topologyVersion() {
        return this.topVer;
    }

    public int minorTopologyVersion() {
        return this.minorTopVer;
    }

    @Override
    public int compareTo(AffinityTopologyVersion o) {
        int cmp = Long.compare(this.topVer, o.topVer);
        if (cmp == 0) {
            return Integer.compare(this.minorTopVer, o.minorTopVer);
        }
        return cmp;
    }

    @Override
    public void onAckReceived() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AffinityTopologyVersion)) {
            return false;
        }
        AffinityTopologyVersion that = (AffinityTopologyVersion)o;
        return this.minorTopVer == that.minorTopVer && this.topVer == that.topVer;
    }

    public int hashCode() {
        return 31 * (int)this.topVer + this.minorTopVer;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.topVer);
        out.writeInt(this.minorTopVer);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.topVer = in.readLong();
        this.minorTopVer = in.readInt();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeInt("minorTopVer", this.minorTopVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.minorTopVer = reader.readInt("minorTopVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.topVer = reader.readLong("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(AffinityTopologyVersion.class);
    }

    @Override
    public byte directType() {
        return 111;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    public String toString() {
        return S.toString(AffinityTopologyVersion.class, this);
    }
}

