/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.affinity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.affinity.AffinityCentralizedFunction;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridNodeOrderComparator;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignment;
import org.apache.ignite.internal.processors.affinity.GridAffinityFunctionContextImpl;
import org.apache.ignite.internal.processors.affinity.HistoryAffinityAssignment;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class GridAffinityAssignmentCache {
    private final int MAX_HIST_SIZE = IgniteSystemProperties.getInteger("IGNITE_AFFINITY_HISTORY_SIZE", 500);
    private final String cacheName;
    private final Integer cacheId;
    private final int backups;
    private final AffinityFunction aff;
    private final IgnitePredicate<ClusterNode> nodeFilter;
    private final int partsCnt;
    private final ConcurrentNavigableMap<AffinityTopologyVersion, HistoryAffinityAssignment> affCache;
    private List<List<ClusterNode>> idealAssignment;
    private final AtomicReference<GridAffinityAssignment> head;
    private final ConcurrentMap<AffinityTopologyVersion, AffinityReadyFuture> readyFuts = new ConcurrentHashMap8<AffinityTopologyVersion, AffinityReadyFuture>();
    private final IgniteLogger log;
    private final GridKernalContext ctx;
    private final boolean locCache;
    private volatile IgniteCheckedException stopErr;
    private final AtomicInteger histSize = new AtomicInteger();
    private final AtomicInteger fullHistSize = new AtomicInteger();
    private final Object similarAffKey;

    public GridAffinityAssignmentCache(GridKernalContext ctx, String cacheName, AffinityFunction aff, IgnitePredicate<ClusterNode> nodeFilter, int backups, boolean locCache) {
        assert (ctx != null);
        assert (aff != null);
        assert (nodeFilter != null);
        this.ctx = ctx;
        this.aff = aff;
        this.nodeFilter = nodeFilter;
        this.cacheName = cacheName;
        this.backups = backups;
        this.locCache = locCache;
        this.cacheId = CU.cacheId(cacheName);
        this.log = ctx.log(GridAffinityAssignmentCache.class);
        this.partsCnt = aff.partitions();
        this.affCache = new ConcurrentSkipListMap<AffinityTopologyVersion, HistoryAffinityAssignment>();
        this.head = new AtomicReference<GridAffinityAssignment>(new GridAffinityAssignment(AffinityTopologyVersion.NONE));
        this.similarAffKey = ctx.affinity().similaryAffinityKey(aff, nodeFilter, backups, this.partsCnt);
        assert (this.similarAffKey != null);
    }

    public Object similarAffinityKey() {
        return this.similarAffKey;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public Integer cacheId() {
        return this.cacheId;
    }

    public void initialize(AffinityTopologyVersion topVer, List<List<ClusterNode>> affAssignment) {
        assert (topVer.compareTo(this.lastVersion()) >= 0) : "[topVer = " + topVer + ", last=" + this.lastVersion() + ']';
        assert (this.idealAssignment != null);
        GridAffinityAssignment assignment = new GridAffinityAssignment(topVer, affAssignment, this.idealAssignment);
        this.affCache.put(topVer, new HistoryAffinityAssignment(assignment));
        this.head.set(assignment);
        for (Map.Entry entry : this.readyFuts.entrySet()) {
            if (((AffinityTopologyVersion)entry.getKey()).compareTo(topVer) > 0) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Completing topology ready future (initialized affinity) [locNodeId=" + this.ctx.localNodeId() + ", futVer=" + entry.getKey() + ", topVer=" + topVer + ']');
            }
            ((AffinityReadyFuture)entry.getValue()).onDone(topVer);
        }
        this.onHistoryAdded(assignment);
    }

    public void idealAssignment(List<List<ClusterNode>> assignment) {
        this.idealAssignment = assignment;
    }

    @Nullable
    public List<List<ClusterNode>> idealAssignment() {
        return this.idealAssignment;
    }

    public boolean centralizedAffinityFunction() {
        return U.hasAnnotation(this.aff, AffinityCentralizedFunction.class);
    }

    public void cancelFutures(IgniteCheckedException err) {
        this.stopErr = err;
        for (AffinityReadyFuture fut : this.readyFuts.values()) {
            fut.onDone(err);
        }
    }

    public void onReconnected() {
        this.idealAssignment = null;
        this.affCache.clear();
        this.head.set(new GridAffinityAssignment(AffinityTopologyVersion.NONE));
        this.stopErr = null;
    }

    public List<List<ClusterNode>> calculate(AffinityTopologyVersion topVer, DiscoveryEvent discoEvt) {
        boolean affNode;
        List<ClusterNode> sorted;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Calculating affinity [topVer=" + topVer + ", locNodeId=" + this.ctx.localNodeId() + ", discoEvt=" + discoEvt + ']');
        }
        List<List<ClusterNode>> prevAssignment = this.idealAssignment;
        if (!this.locCache) {
            sorted = new ArrayList<ClusterNode>(this.ctx.discovery().cacheAffinityNodes(this.cacheName, topVer));
            Collections.sort(sorted, GridNodeOrderComparator.INSTANCE);
        } else {
            sorted = Collections.singletonList(this.ctx.discovery().localNode());
        }
        List<List<ClusterNode>> assignment = prevAssignment != null && discoEvt != null ? (!(affNode = CU.affinityNode(discoEvt.eventNode(), this.nodeFilter)) ? prevAssignment : this.aff.assignPartitions(new GridAffinityFunctionContextImpl(sorted, prevAssignment, discoEvt, topVer, this.backups))) : this.aff.assignPartitions(new GridAffinityFunctionContextImpl(sorted, prevAssignment, discoEvt, topVer, this.backups));
        assert (assignment != null);
        this.idealAssignment = assignment;
        if (this.locCache) {
            this.initialize(topVer, assignment);
        }
        return assignment;
    }

    public void clientEventTopologyChange(DiscoveryEvent evt, AffinityTopologyVersion topVer) {
        assert (topVer.compareTo(this.lastVersion()) >= 0) : "[topVer = " + topVer + ", last=" + this.lastVersion() + ']';
        GridAffinityAssignment aff = this.head.get();
        assert (evt.type() == 18 || aff.primaryPartitions(evt.eventNode().id()).isEmpty()) : evt;
        assert (evt.type() == 18 || aff.backupPartitions(evt.eventNode().id()).isEmpty()) : evt;
        GridAffinityAssignment assignmentCpy = new GridAffinityAssignment(topVer, aff);
        this.affCache.put(topVer, new HistoryAffinityAssignment(assignmentCpy));
        this.head.set(assignmentCpy);
        for (Map.Entry entry : this.readyFuts.entrySet()) {
            if (((AffinityTopologyVersion)entry.getKey()).compareTo(topVer) > 0) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Completing topology ready future (use previous affinity) [locNodeId=" + this.ctx.localNodeId() + ", futVer=" + entry.getKey() + ", topVer=" + topVer + ']');
            }
            ((AffinityReadyFuture)entry.getValue()).onDone(topVer);
        }
        this.onHistoryAdded(assignmentCpy);
    }

    public AffinityTopologyVersion lastVersion() {
        return this.head.get().topologyVersion();
    }

    public List<List<ClusterNode>> assignments(AffinityTopologyVersion topVer) {
        AffinityAssignment aff = this.cachedAffinity(topVer);
        return aff.assignment();
    }

    @Nullable
    public IgniteInternalFuture<AffinityTopologyVersion> readyFuture(AffinityTopologyVersion topVer) {
        GridAffinityAssignment aff = this.head.get();
        if (aff.topologyVersion().compareTo(topVer) >= 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Returning finished future for readyFuture [head=" + aff.topologyVersion() + ", topVer=" + topVer + ']');
            }
            return null;
        }
        GridFutureAdapter fut = F.addIfAbsent(this.readyFuts, topVer, new AffinityReadyFuture(topVer));
        aff = this.head.get();
        if (aff.topologyVersion().compareTo(topVer) >= 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Completing topology ready future right away [head=" + aff.topologyVersion() + ", topVer=" + topVer + ']');
            }
            fut.onDone(topVer);
        } else if (this.stopErr != null) {
            fut.onDone(this.stopErr);
        }
        return fut;
    }

    public int partitions() {
        return this.partsCnt;
    }

    public List<ClusterNode> nodes(int part, AffinityTopologyVersion topVer) {
        return this.cachedAffinity(topVer).get(part);
    }

    public Set<Integer> primaryPartitions(UUID nodeId, AffinityTopologyVersion topVer) {
        return this.cachedAffinity(topVer).primaryPartitions(nodeId);
    }

    public Set<Integer> backupPartitions(UUID nodeId, AffinityTopologyVersion topVer) {
        return this.cachedAffinity(topVer).backupPartitions(nodeId);
    }

    public void dumpDebugInfo() {
        if (!this.readyFuts.isEmpty()) {
            U.warn(this.log, "Pending affinity ready futures [cache=" + this.cacheName + ", lastVer=" + this.lastVersion() + "]:");
            for (AffinityReadyFuture fut : this.readyFuts.values()) {
                U.warn(this.log, ">>> " + fut);
            }
        }
    }

    public AffinityAssignment cachedAffinity(AffinityTopologyVersion topVer) {
        if (topVer.equals(AffinityTopologyVersion.NONE)) {
            topVer = this.lastVersion();
        } else {
            this.awaitTopologyVersion(topVer);
        }
        assert (topVer.topologyVersion() >= 0L) : topVer;
        AffinityAssignment cache = this.head.get();
        if (!cache.topologyVersion().equals(topVer) && (cache = (AffinityAssignment)this.affCache.get(topVer)) == null) {
            throw new IllegalStateException("Getting affinity for topology version earlier than affinity is calculated [locNode=" + this.ctx.discovery().localNode() + ", cache=" + this.cacheName + ", topVer=" + topVer + ", head=" + this.head.get().topologyVersion() + ", history=" + this.affCache.keySet() + ']');
        }
        assert (cache.topologyVersion().equals(topVer)) : "Invalid cached affinity: " + cache;
        return cache;
    }

    public boolean primaryChanged(int part, AffinityTopologyVersion startVer, AffinityTopologyVersion endVer) {
        AffinityAssignment aff = (AffinityAssignment)this.affCache.get(startVer);
        if (aff == null) {
            return false;
        }
        List<ClusterNode> nodes = aff.get(part);
        if (nodes.isEmpty()) {
            return true;
        }
        ClusterNode primary = nodes.get(0);
        for (AffinityAssignment assignment : this.affCache.tailMap((Object)startVer, false).values()) {
            List<ClusterNode> nodes0 = assignment.assignment().get(part);
            if (nodes0.isEmpty()) {
                return true;
            }
            if (!nodes0.get(0).equals(primary)) {
                return true;
            }
            if (!assignment.topologyVersion().equals(endVer)) continue;
            return false;
        }
        return true;
    }

    public void init(GridAffinityAssignmentCache aff) {
        assert (aff.lastVersion().compareTo(this.lastVersion()) >= 0);
        assert (aff.idealAssignment() != null);
        this.idealAssignment(aff.idealAssignment());
        this.initialize(aff.lastVersion(), aff.assignments(aff.lastVersion()));
    }

    private void awaitTopologyVersion(AffinityTopologyVersion topVer) {
        GridAffinityAssignment aff = this.head.get();
        if (aff.topologyVersion().compareTo(topVer) >= 0) {
            return;
        }
        try {
            IgniteInternalFuture<AffinityTopologyVersion> fut;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Will wait for topology version [locNodeId=" + this.ctx.localNodeId() + ", topVer=" + topVer + ']');
            }
            if ((fut = this.readyFuture(topVer)) != null) {
                fut.get();
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to wait for affinity ready future for topology version: " + topVer, e);
        }
    }

    private void onHistoryAdded(GridAffinityAssignment aff) {
        int fullSize = this.fullHistSize.incrementAndGet();
        int size = aff.clientEventChange() ? this.histSize.get() : this.histSize.incrementAndGet();
        int rmvCnt = size - this.MAX_HIST_SIZE;
        if (rmvCnt <= 0 && fullSize > this.MAX_HIST_SIZE * 2) {
            rmvCnt = this.MAX_HIST_SIZE;
        }
        if (rmvCnt > 0) {
            Iterator it = this.affCache.values().iterator();
            while (it.hasNext() && rmvCnt > 0) {
                AffinityAssignment aff0 = (AffinityAssignment)it.next();
                it.remove();
                --rmvCnt;
                if (!aff0.clientEventChange()) {
                    this.histSize.decrementAndGet();
                }
                this.fullHistSize.decrementAndGet();
            }
        }
    }

    private class AffinityReadyFuture
    extends GridFutureAdapter<AffinityTopologyVersion> {
        private static final long serialVersionUID = 0L;
        private AffinityTopologyVersion reqTopVer;

        private AffinityReadyFuture(AffinityTopologyVersion reqTopVer) {
            this.reqTopVer = reqTopVer;
        }

        @Override
        public boolean onDone(AffinityTopologyVersion res, @Nullable Throwable err) {
            assert (res != null || err != null);
            boolean done = super.onDone(res, err);
            if (done) {
                GridAffinityAssignmentCache.this.readyFuts.remove(this.reqTopVer, this);
            }
            return done;
        }

        @Override
        public String toString() {
            return S.toString(AffinityReadyFuture.class, this);
        }
    }
}

