/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsFullMessage;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class CacheAffinityChangeMessage
implements DiscoveryCustomMessage {
    private static final long serialVersionUID = 0L;
    private IgniteUuid id = IgniteUuid.randomUuid();
    private AffinityTopologyVersion topVer;
    private GridDhtPartitionExchangeId exchId;
    private Map<Integer, Map<Integer, List<UUID>>> assignmentChange;
    private Map<Integer, IgniteUuid> cacheDeploymentIds;
    private GridDhtPartitionsFullMessage partsMsg;
    private transient boolean exchangeNeeded;

    public CacheAffinityChangeMessage(AffinityTopologyVersion topVer, Map<Integer, Map<Integer, List<UUID>>> assignmentChange, Map<Integer, IgniteUuid> cacheDeploymentIds) {
        assert (!F.isEmpty(assignmentChange)) : assignmentChange;
        this.topVer = topVer;
        this.assignmentChange = assignmentChange;
        this.cacheDeploymentIds = cacheDeploymentIds;
    }

    public CacheAffinityChangeMessage(GridDhtPartitionExchangeId exchId, GridDhtPartitionsFullMessage partsMsg, Map<Integer, Map<Integer, List<UUID>>> assignmentChange) {
        this.exchId = exchId;
        this.partsMsg = partsMsg;
        this.assignmentChange = assignmentChange;
    }

    public Map<Integer, IgniteUuid> cacheDeploymentIds() {
        return this.cacheDeploymentIds;
    }

    public boolean exchangeNeeded() {
        return this.exchangeNeeded;
    }

    public void exchangeNeeded(boolean exchangeNeeded) {
        this.exchangeNeeded = exchangeNeeded;
    }

    public GridDhtPartitionsFullMessage partitionsMessage() {
        return this.partsMsg;
    }

    @Nullable
    public Map<Integer, Map<Integer, List<UUID>>> assignmentChange() {
        return this.assignmentChange;
    }

    @Nullable
    public GridDhtPartitionExchangeId exchangeId() {
        return this.exchId;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Override
    public IgniteUuid id() {
        return this.id;
    }

    @Override
    @Nullable
    public DiscoveryCustomMessage ackMessage() {
        return null;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    public String toString() {
        return S.toString(CacheAffinityChangeMessage.class, this);
    }
}

