/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignmentCache;
import org.apache.ignite.internal.processors.cache.CacheAffinityChangeMessage;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeRequest;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtAffinityAssignmentResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtAssignmentFetchFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteInClosureX;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class CacheAffinitySharedManager<K, V>
extends GridCacheSharedManagerAdapter<K, V> {
    public static final IgniteProductVersion LATE_AFF_ASSIGN_SINCE = IgniteProductVersion.fromString("1.6.0");
    private boolean lateAffAssign;
    private ConcurrentMap<Integer, CacheHolder> caches = new ConcurrentHashMap<Integer, CacheHolder>();
    private AffinityTopologyVersion affCalcVer;
    private AffinityTopologyVersion lastAffVer;
    private final Map<Integer, DynamicCacheDescriptor> registeredCaches = new HashMap<Integer, DynamicCacheDescriptor>();
    private WaitRebalanceInfo waitInfo;
    private final Object mux = new Object();
    private final ConcurrentMap<T2<Integer, AffinityTopologyVersion>, GridDhtAssignmentFetchFuture> pendingAssignmentFetchFuts = new ConcurrentHashMap8<T2<Integer, AffinityTopologyVersion>, GridDhtAssignmentFetchFuture>();
    private final GridLocalEventListener discoLsnr = new GridLocalEventListener(){

        @Override
        public void onEvent(Event evt) {
            DiscoveryEvent e = (DiscoveryEvent)evt;
            assert (e.type() == 11 || e.type() == 12);
            ClusterNode n = e.eventNode();
            for (GridDhtAssignmentFetchFuture fut : CacheAffinitySharedManager.this.pendingAssignmentFetchFuts.values()) {
                fut.onNodeLeft(n.id());
            }
        }
    };

    @Override
    protected void start0() throws IgniteCheckedException {
        super.start0();
        this.lateAffAssign = this.cctx.kernalContext().config().isLateAffinityAssignment();
        this.cctx.kernalContext().event().addLocalEventListener(this.discoLsnr, 11, 12);
    }

    void onDiscoveryEvent(int type, ClusterNode node, AffinityTopologyVersion topVer) {
        if (type == 10 && node.isLocal()) {
            this.registeredCaches.clear();
            this.affCalcVer = null;
            this.lastAffVer = null;
            for (DynamicCacheDescriptor desc : this.cctx.cache().cacheDescriptors()) {
                this.registeredCaches.put(desc.cacheId(), desc);
            }
        }
        if (!(CU.clientNode(node) || type != 12 && type != 10 && type != 11)) {
            assert (this.lastAffVer == null || topVer.compareTo(this.lastAffVer) > 0);
            this.lastAffVer = topVer;
        }
    }

    boolean onCustomEvent(CacheAffinityChangeMessage msg) {
        assert (this.lateAffAssign) : msg;
        if (msg.exchangeId() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Need process affinity change message [lastAffVer=" + this.lastAffVer + ", msgExchId=" + msg.exchangeId() + ", msgVer=" + msg.topologyVersion() + ']');
            }
            return false;
        }
        boolean exchangeNeeded = this.lastAffVer == null || this.lastAffVer.equals(msg.topologyVersion());
        msg.exchangeNeeded(exchangeNeeded);
        if (exchangeNeeded) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Need process affinity change message [lastAffVer=" + this.lastAffVer + ", msgExchId=" + msg.exchangeId() + ", msgVer=" + msg.topologyVersion() + ']');
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Ignore affinity change message [lastAffVer=" + this.lastAffVer + ", msgExchId=" + msg.exchangeId() + ", msgVer=" + msg.topologyVersion() + ']');
        }
        return exchangeNeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCacheStopped(AffinityTopologyVersion topVer) {
        CacheAffinityChangeMessage msg = null;
        Object object = this.mux;
        synchronized (object) {
            if (this.waitInfo == null || !this.waitInfo.topVer.equals(topVer)) {
                return;
            }
            if (this.waitInfo.waitCaches.isEmpty()) {
                msg = this.affinityChangeMessage(this.waitInfo);
                this.waitInfo = null;
            }
        }
        try {
            if (msg != null) {
                this.cctx.discovery().sendCustomEvent(msg);
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send affinity change message.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkRebalanceState(GridDhtPartitionTopology top, Integer checkCacheId) {
        if (!this.lateAffAssign) {
            return;
        }
        CacheAffinityChangeMessage msg = null;
        Object object = this.mux;
        synchronized (object) {
            if (this.waitInfo == null) {
                return;
            }
            assert (this.affCalcVer != null);
            assert (this.affCalcVer.equals(this.waitInfo.topVer)) : "Invalid affinity version [calcVer=" + this.affCalcVer + ", waitVer=" + WaitRebalanceInfo.access$100(this.waitInfo) + ']';
            Map partWait = (Map)this.waitInfo.waitCaches.get(checkCacheId);
            boolean rebalanced = true;
            if (partWait != null) {
                CacheHolder cache = (CacheHolder)this.caches.get(checkCacheId);
                if (cache != null) {
                    Iterator it = partWait.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry e = it.next();
                        Integer part = (Integer)e.getKey();
                        UUID waitNode = (UUID)e.getValue();
                        GridDhtPartitionState state = top.partitionState(waitNode, part);
                        if (state != GridDhtPartitionState.OWNING) {
                            rebalanced = false;
                            break;
                        }
                        it.remove();
                    }
                }
                if (rebalanced) {
                    this.waitInfo.waitCaches.remove(checkCacheId);
                    if (this.waitInfo.waitCaches.isEmpty()) {
                        msg = this.affinityChangeMessage(this.waitInfo);
                        this.waitInfo = null;
                    }
                }
            }
        }
        try {
            if (msg != null) {
                this.cctx.discovery().sendCustomEvent(msg);
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send affinity change message.", e);
        }
    }

    @Nullable
    private CacheAffinityChangeMessage affinityChangeMessage(WaitRebalanceInfo waitInfo) {
        if (waitInfo.assignments.isEmpty()) {
            return null;
        }
        HashMap<Integer, Map<Integer, List<UUID>>> assignmentsChange = U.newHashMap(waitInfo.assignments.size());
        for (Map.Entry e : waitInfo.assignments.entrySet()) {
            Integer cacheId = (Integer)e.getKey();
            Map assignment = (Map)e.getValue();
            HashMap assignment0 = U.newHashMap(assignment.size());
            for (Map.Entry e0 : assignment.entrySet()) {
                assignment0.put(e0.getKey(), CacheAffinitySharedManager.toIds0((List)e0.getValue()));
            }
            assignmentsChange.put(cacheId, assignment0);
        }
        return new CacheAffinityChangeMessage(waitInfo.topVer, assignmentsChange, waitInfo.deploymentIds);
    }

    public void onCacheCreated(GridCacheContext cctx) {
        final Integer cacheId = cctx.cacheId();
        if (!this.caches.containsKey(cctx.cacheId())) {
            cctx.io().addHandler(cacheId, GridDhtAffinityAssignmentResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new IgniteBiInClosure<UUID, GridDhtAffinityAssignmentResponse>(){

                @Override
                public void apply(UUID nodeId, GridDhtAffinityAssignmentResponse res) {
                    CacheAffinitySharedManager.this.processAffinityAssignmentResponse(cacheId, nodeId, res);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onCacheChangeRequest(final GridDhtPartitionsExchangeFuture fut, boolean crd, Collection<DynamicCacheChangeRequest> reqs) throws IgniteCheckedException {
        assert (!F.isEmpty(reqs)) : fut;
        for (DynamicCacheChangeRequest req : reqs) {
            Integer cacheId = CU.cacheId(req.cacheName());
            if (req.stop()) {
                DynamicCacheDescriptor dynamicCacheDescriptor = this.registeredCaches.remove(cacheId);
                assert (dynamicCacheDescriptor != null) : cacheId;
                continue;
            }
            if (!req.start() || req.clientStartOnly()) continue;
            DynamicCacheDescriptor dynamicCacheDescriptor = new DynamicCacheDescriptor(this.cctx.kernalContext(), req.startCacheConfiguration(), req.cacheType(), false, req.deploymentId());
            DynamicCacheDescriptor old = this.registeredCaches.put(cacheId, dynamicCacheDescriptor);
            assert (old == null) : old;
        }
        boolean clientOnly = true;
        this.forAllCaches(crd && this.lateAffAssign, new IgniteInClosureX<GridAffinityAssignmentCache>(){

            @Override
            public void applyx(GridAffinityAssignmentCache aff) throws IgniteCheckedException {
                if (fut.stopping(aff.cacheId())) {
                    return;
                }
                aff.clientEventTopologyChange(fut.discoveryEvent(), fut.topologyVersion());
            }
        });
        HashSet<Integer> stoppedCaches = null;
        for (DynamicCacheChangeRequest dynamicCacheChangeRequest : reqs) {
            CacheHolder cache;
            if (!dynamicCacheChangeRequest.clientStartOnly() && !dynamicCacheChangeRequest.close()) {
                clientOnly = false;
            }
            Integer cacheId = CU.cacheId(dynamicCacheChangeRequest.cacheName());
            if (dynamicCacheChangeRequest.start()) {
                this.cctx.cache().prepareCacheStart(dynamicCacheChangeRequest, fut.topologyVersion());
                if (fut.isCacheAdded(cacheId, fut.topologyVersion()) && this.cctx.discovery().cacheAffinityNodes(dynamicCacheChangeRequest.cacheName(), fut.topologyVersion()).isEmpty()) {
                    U.quietAndWarn(this.log, "No server nodes found for cache client: " + dynamicCacheChangeRequest.cacheName());
                }
                if (!crd || !this.lateAffAssign) {
                    boolean clientCacheStarted;
                    GridCacheContext cacheCtx = this.cctx.cacheContext(cacheId);
                    if (cacheCtx == null || cacheCtx.isLocal()) continue;
                    boolean bl = clientCacheStarted = dynamicCacheChangeRequest.clientStartOnly() && dynamicCacheChangeRequest.initiatingNodeId().equals(this.cctx.localNodeId());
                    if (clientCacheStarted) {
                        this.initAffinity(cacheCtx.affinity().affinityCache(), fut, this.lateAffAssign);
                        continue;
                    }
                    if (dynamicCacheChangeRequest.clientStartOnly()) continue;
                    assert (fut.topologyVersion().equals(cacheCtx.startTopologyVersion()));
                    GridAffinityAssignmentCache aff = cacheCtx.affinity().affinityCache();
                    assert (aff.lastVersion().equals(AffinityTopologyVersion.NONE)) : aff.lastVersion();
                    List<List<ClusterNode>> assignment = aff.calculate(fut.topologyVersion(), fut.discoveryEvent());
                    aff.initialize(fut.topologyVersion(), assignment);
                    continue;
                }
                this.initStartedCacheOnCoordinator(fut, cacheId);
                continue;
            }
            if (!dynamicCacheChangeRequest.stop() && !dynamicCacheChangeRequest.close()) continue;
            this.cctx.cache().blockGateway(dynamicCacheChangeRequest);
            if (!crd) continue;
            boolean rmvCache = false;
            if (dynamicCacheChangeRequest.close() && dynamicCacheChangeRequest.initiatingNodeId().equals(this.cctx.localNodeId())) {
                GridCacheContext cacheCtx = this.cctx.cacheContext(cacheId);
                rmvCache = cacheCtx != null && !cacheCtx.affinityNode();
            } else if (dynamicCacheChangeRequest.stop()) {
                rmvCache = true;
            }
            if (!rmvCache || (cache = (CacheHolder)this.caches.remove(cacheId)) == null) continue;
            if (!dynamicCacheChangeRequest.stop()) {
                assert (!cache.client());
                cache = CacheHolder2.create(this.cctx, this.cctx.cache().cacheDescriptor(cacheId), fut, cache.affinity());
                this.caches.put(cacheId, cache);
                continue;
            }
            if (stoppedCaches == null) {
                stoppedCaches = new HashSet<Integer>();
            }
            stoppedCaches.add(cache.cacheId());
            this.cctx.io().removeHandler(cacheId, GridDhtAffinityAssignmentResponse.class);
        }
        if (stoppedCaches != null) {
            boolean notify = false;
            Object object = this.mux;
            synchronized (object) {
                if (this.waitInfo != null) {
                    for (Integer cacheId : stoppedCaches) {
                        boolean rmv = this.waitInfo.waitCaches.remove(cacheId) != null;
                        if (!rmv) continue;
                        notify = true;
                        this.waitInfo.assignments.remove(cacheId);
                    }
                }
            }
            if (notify) {
                final AffinityTopologyVersion affinityTopologyVersion = this.affCalcVer;
                this.cctx.kernalContext().closure().runLocalSafe(new Runnable(){

                    @Override
                    public void run() {
                        CacheAffinitySharedManager.this.onCacheStopped(affinityTopologyVersion);
                    }
                });
            }
        }
        return clientOnly;
    }

    public void onExchangeChangeAffinityMessage(GridDhtPartitionsExchangeFuture exchFut, boolean crd, CacheAffinityChangeMessage msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Process exchange affinity change message [exchVer=" + exchFut.topologyVersion() + ", msg=" + msg + ']');
        }
        assert (exchFut.exchangeId().equals(msg.exchangeId())) : msg;
        final AffinityTopologyVersion topVer = exchFut.topologyVersion();
        final Map<Integer, Map<Integer, List<UUID>>> assignment = msg.assignmentChange();
        assert (assignment != null);
        final HashMap affCache = new HashMap();
        this.forAllCaches(crd, new IgniteInClosureX<GridAffinityAssignmentCache>(){

            @Override
            public void applyx(GridAffinityAssignmentCache aff) throws IgniteCheckedException {
                List<List<ClusterNode>> newAssignment;
                List<List<ClusterNode>> idealAssignment = aff.idealAssignment();
                assert (idealAssignment != null);
                Map cacheAssignment = (Map)assignment.get(aff.cacheId());
                if (cacheAssignment != null) {
                    newAssignment = new ArrayList<List<ClusterNode>>(idealAssignment);
                    for (Map.Entry e : cacheAssignment.entrySet()) {
                        newAssignment.set((Integer)e.getKey(), CacheAffinitySharedManager.this.toNodes(topVer, (List)e.getValue()));
                    }
                } else {
                    newAssignment = idealAssignment;
                }
                aff.initialize(topVer, CacheAffinitySharedManager.this.cachedAssignment(aff, newAssignment, affCache));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChangeAffinityMessage(final GridDhtPartitionsExchangeFuture exchFut, boolean crd, final CacheAffinityChangeMessage msg) throws IgniteCheckedException {
        assert (this.affCalcVer != null || this.cctx.kernalContext().clientNode());
        assert (msg.topologyVersion() != null && msg.exchangeId() == null) : msg;
        assert (this.affCalcVer == null || this.affCalcVer.equals(msg.topologyVersion()));
        final AffinityTopologyVersion topVer = exchFut.topologyVersion();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Process affinity change message [exchVer=" + exchFut.topologyVersion() + ", affCalcVer=" + this.affCalcVer + ", msgVer=" + msg.topologyVersion() + ']');
        }
        final Map<Integer, Map<Integer, List<UUID>>> affChange = msg.assignmentChange();
        assert (!F.isEmpty(affChange)) : msg;
        final Map<Integer, IgniteUuid> deploymentIds = msg.cacheDeploymentIds();
        final HashMap affCache = new HashMap();
        this.forAllCaches(crd, new IgniteInClosureX<GridAffinityAssignmentCache>(){

            @Override
            public void applyx(GridAffinityAssignmentCache aff) throws IgniteCheckedException {
                AffinityTopologyVersion affTopVer = aff.lastVersion();
                assert (affTopVer.topologyVersion() > 0L) : affTopVer;
                IgniteUuid deploymentId = ((DynamicCacheDescriptor)CacheAffinitySharedManager.this.registeredCaches.get(aff.cacheId())).deploymentId();
                if (!deploymentId.equals(deploymentIds.get(aff.cacheId()))) {
                    aff.clientEventTopologyChange(exchFut.discoveryEvent(), topVer);
                    return;
                }
                Map change = (Map)affChange.get(aff.cacheId());
                if (change != null) {
                    assert (!change.isEmpty()) : msg;
                    List<List<ClusterNode>> curAff = aff.assignments(affTopVer);
                    ArrayList<List<ClusterNode>> assignment = new ArrayList<List<ClusterNode>>(curAff);
                    for (Map.Entry e : change.entrySet()) {
                        Integer part = (Integer)e.getKey();
                        List nodes = CacheAffinitySharedManager.this.toNodes(topVer, (List)e.getValue());
                        assert (!nodes.equals(assignment.get(part))) : "Assignment did not change [cache=" + aff.cacheName() + ", part=" + part + ", cur=" + F.nodeIds((Collection)assignment.get(part)) + ", new=" + F.nodeIds(nodes) + ", exchVer=" + exchFut.topologyVersion() + ", msgVer=" + msg.topologyVersion() + ']';
                        assignment.set(part, nodes);
                    }
                    aff.initialize(topVer, CacheAffinitySharedManager.this.cachedAssignment(aff, assignment, affCache));
                } else {
                    aff.clientEventTopologyChange(exchFut.discoveryEvent(), topVer);
                }
            }
        });
        Object object = this.mux;
        synchronized (object) {
            if (this.affCalcVer == null) {
                this.affCalcVer = msg.topologyVersion();
            }
        }
    }

    public void onClientEvent(final GridDhtPartitionsExchangeFuture fut, boolean crd) throws IgniteCheckedException {
        boolean locJoin = fut.discoveryEvent().eventNode().isLocal();
        if (this.lateAffAssign) {
            if (!locJoin) {
                this.forAllCaches(crd, new IgniteInClosureX<GridAffinityAssignmentCache>(){

                    @Override
                    public void applyx(GridAffinityAssignmentCache aff) throws IgniteCheckedException {
                        AffinityTopologyVersion topVer = fut.topologyVersion();
                        aff.clientEventTopologyChange(fut.discoveryEvent(), topVer);
                    }
                });
            } else {
                this.fetchAffinityOnJoin(fut);
            }
        } else if (!locJoin) {
            this.forAllCaches(false, new IgniteInClosureX<GridAffinityAssignmentCache>(){

                @Override
                public void applyx(GridAffinityAssignmentCache aff) throws IgniteCheckedException {
                    AffinityTopologyVersion topVer = fut.topologyVersion();
                    aff.clientEventTopologyChange(fut.discoveryEvent(), topVer);
                }
            });
        } else {
            this.initCachesAffinity(fut);
        }
    }

    public void addDhtAssignmentFetchFuture(GridDhtAssignmentFetchFuture fut) {
        GridDhtAssignmentFetchFuture old = this.pendingAssignmentFetchFuts.putIfAbsent(fut.key(), fut);
        assert (old == null) : "More than one thread is trying to fetch partition assignments [fut=" + fut + ", allFuts=" + this.pendingAssignmentFetchFuts + ']';
    }

    public void removeDhtAssignmentFetchFuture(GridDhtAssignmentFetchFuture fut) {
        boolean rmv = this.pendingAssignmentFetchFuts.remove(fut.key(), fut);
        assert (rmv) : "Failed to remove assignment fetch future: " + fut.key();
    }

    private void processAffinityAssignmentResponse(Integer cacheId, UUID nodeId, GridDhtAffinityAssignmentResponse res) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing affinity assignment response [node=" + nodeId + ", res=" + res + ']');
        }
        for (GridDhtAssignmentFetchFuture fut : this.pendingAssignmentFetchFuts.values()) {
            if (!((Integer)fut.key().get1()).equals(cacheId)) continue;
            fut.onResponse(nodeId, res);
            break;
        }
    }

    private void forAllRegisteredCaches(IgniteInClosureX<DynamicCacheDescriptor> c) throws IgniteCheckedException {
        assert (this.lateAffAssign);
        for (DynamicCacheDescriptor cacheDesc : this.registeredCaches.values()) {
            if (cacheDesc.cacheConfiguration().getCacheMode() == CacheMode.LOCAL) continue;
            c.applyx(cacheDesc);
        }
    }

    private void forAllCaches(boolean crd, IgniteInClosureX<GridAffinityAssignmentCache> c) {
        if (crd) {
            for (CacheHolder cache : this.caches.values()) {
                c.apply(cache.affinity());
            }
        } else {
            for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
                if (cacheCtx.isLocal()) continue;
                c.apply(cacheCtx.affinity().affinityCache());
            }
        }
    }

    private void initStartedCacheOnCoordinator(GridDhtPartitionsExchangeFuture fut, Integer cacheId) throws IgniteCheckedException {
        CacheHolder cache = (CacheHolder)this.caches.get(cacheId);
        GridCacheContext cacheCtx = this.cctx.cacheContext(cacheId);
        if (cache == null) {
            DynamicCacheDescriptor desc = this.cctx.cache().cacheDescriptor(cacheId);
            assert (desc != null) : cacheId;
            if (desc.cacheConfiguration().getCacheMode() == CacheMode.LOCAL) {
                return;
            }
            cache = cacheCtx != null ? new CacheHolder1(cacheCtx, null) : CacheHolder2.create(this.cctx, desc, fut, null);
            CacheHolder old = this.caches.put(cacheId, cache);
            assert (old == null) : old;
            List<List<ClusterNode>> newAff = cache.affinity().calculate(fut.topologyVersion(), fut.discoveryEvent());
            cache.affinity().initialize(fut.topologyVersion(), newAff);
        } else if (cache.client() && cacheCtx != null) {
            assert (cache.affinity().idealAssignment() != null);
            cache = new CacheHolder1(cacheCtx, cache.affinity());
            this.caches.put(cacheId, cache);
        }
    }

    public void initStartedCaches(boolean crd, final GridDhtPartitionsExchangeFuture fut, @Nullable Collection<DynamicCacheDescriptor> descs) throws IgniteCheckedException {
        if (descs != null) {
            for (DynamicCacheDescriptor desc : descs) {
                if (this.registeredCaches.containsKey(desc.cacheId())) continue;
                this.registeredCaches.put(desc.cacheId(), desc);
            }
        }
        if (crd && this.lateAffAssign) {
            this.forAllRegisteredCaches(new IgniteInClosureX<DynamicCacheDescriptor>(){

                @Override
                public void applyx(DynamicCacheDescriptor desc) throws IgniteCheckedException {
                    CacheHolder cache = CacheAffinitySharedManager.this.cache(fut, desc);
                    if (cache.affinity().lastVersion().equals(AffinityTopologyVersion.NONE)) {
                        List<List<ClusterNode>> assignment = cache.affinity().calculate(fut.topologyVersion(), fut.discoveryEvent());
                        cache.affinity().initialize(fut.topologyVersion(), assignment);
                    }
                }
            });
        } else {
            this.forAllCaches(false, new IgniteInClosureX<GridAffinityAssignmentCache>(){

                @Override
                public void applyx(GridAffinityAssignmentCache aff) throws IgniteCheckedException {
                    if (aff.lastVersion().equals(AffinityTopologyVersion.NONE)) {
                        CacheAffinitySharedManager.this.initAffinity(aff, fut, false);
                    }
                }
            });
        }
    }

    private void initAffinity(GridAffinityAssignmentCache aff, GridDhtPartitionsExchangeFuture fut, boolean fetch) throws IgniteCheckedException {
        if (!fetch && this.canCalculateAffinity(aff, fut)) {
            List<List<ClusterNode>> assignment = aff.calculate(fut.topologyVersion(), fut.discoveryEvent());
            aff.initialize(fut.topologyVersion(), assignment);
        } else {
            GridDhtAssignmentFetchFuture fetchFut = new GridDhtAssignmentFetchFuture(this.cctx, aff.cacheName(), fut.topologyVersion());
            fetchFut.init();
            this.fetchAffinity(fut, aff, fetchFut);
        }
    }

    private boolean canCalculateAffinity(GridAffinityAssignmentCache aff, GridDhtPartitionsExchangeFuture fut) {
        if (!aff.centralizedAffinityFunction()) {
            return true;
        }
        Collection<ClusterNode> affNodes = this.cctx.discovery().cacheAffinityNodes(aff.cacheName(), fut.topologyVersion());
        DynamicCacheDescriptor cacheDesc = this.registeredCaches.get(aff.cacheId());
        assert (cacheDesc != null) : aff.cacheName();
        return fut.cacheStarted(aff.cacheId()) || !fut.exchangeId().nodeId().equals(this.cctx.localNodeId()) || this.cctx.localNodeId().equals(cacheDesc.receivedFrom()) || affNodes.size() == 1 && affNodes.contains(this.cctx.localNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServerJoin(final GridDhtPartitionsExchangeFuture fut, boolean crd) throws IgniteCheckedException {
        assert (!fut.discoveryEvent().eventNode().isClient());
        boolean locJoin = fut.discoveryEvent().eventNode().isLocal();
        WaitRebalanceInfo waitRebalanceInfo = null;
        if (this.lateAffAssign) {
            if (locJoin) {
                if (crd) {
                    this.forAllRegisteredCaches(new IgniteInClosureX<DynamicCacheDescriptor>(){

                        @Override
                        public void applyx(DynamicCacheDescriptor cacheDesc) throws IgniteCheckedException {
                            AffinityTopologyVersion topVer = fut.topologyVersion();
                            CacheHolder cache = CacheAffinitySharedManager.this.cache(fut, cacheDesc);
                            List<List<ClusterNode>> newAff = cache.affinity().calculate(topVer, fut.discoveryEvent());
                            cache.affinity().initialize(topVer, newAff);
                        }
                    });
                } else {
                    this.fetchAffinityOnJoin(fut);
                }
            } else {
                waitRebalanceInfo = this.initAffinityOnNodeJoin(fut, crd);
            }
        } else {
            this.initCachesAffinity(fut);
        }
        Object object = this.mux;
        synchronized (object) {
            this.affCalcVer = fut.topologyVersion();
            WaitRebalanceInfo info = this.waitInfo = waitRebalanceInfo != null && !waitRebalanceInfo.empty() ? waitRebalanceInfo : null;
            if (crd && this.lateAffAssign && this.log.isDebugEnabled()) {
                this.log.debug("Computed new affinity after node join [topVer=" + fut.topologyVersion() + ", waitCaches=" + (info != null ? this.cacheNames(info.waitCaches.keySet()) : null) + ']');
            }
        }
    }

    private String cacheNames(Collection<Integer> cacheIds) {
        StringBuilder names = new StringBuilder();
        for (Integer cacheId : cacheIds) {
            String name = this.registeredCaches.get(cacheId).cacheConfiguration().getName();
            if (names.length() != 0) {
                names.append(", ");
            }
            names.append(name);
        }
        return names.toString();
    }

    private void fetchAffinityOnJoin(GridDhtPartitionsExchangeFuture fut) throws IgniteCheckedException {
        AffinityTopologyVersion topVer = fut.topologyVersion();
        ArrayList<GridDhtAssignmentFetchFuture> fetchFuts = new ArrayList<GridDhtAssignmentFetchFuture>();
        for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
            if (cacheCtx.isLocal()) continue;
            DynamicCacheDescriptor cacheDesc = this.registeredCaches.get(cacheCtx.cacheId());
            if (this.cctx.localNodeId().equals(cacheDesc.receivedFrom())) {
                List<List<ClusterNode>> assignment = cacheCtx.affinity().affinityCache().calculate(fut.topologyVersion(), fut.discoveryEvent());
                cacheCtx.affinity().affinityCache().initialize(fut.topologyVersion(), assignment);
                continue;
            }
            GridDhtAssignmentFetchFuture fetchFut = new GridDhtAssignmentFetchFuture(this.cctx, cacheCtx.name(), topVer);
            fetchFut.init();
            fetchFuts.add(fetchFut);
        }
        for (int i = 0; i < fetchFuts.size(); ++i) {
            GridDhtAssignmentFetchFuture fetchFut = (GridDhtAssignmentFetchFuture)fetchFuts.get(i);
            Integer cacheId = (Integer)fetchFut.key().get1();
            this.fetchAffinity(fut, this.cctx.cacheContext(cacheId).affinity().affinityCache(), fetchFut);
        }
    }

    private void fetchAffinity(GridDhtPartitionsExchangeFuture fut, GridAffinityAssignmentCache affCache, GridDhtAssignmentFetchFuture fetchFut) throws IgniteCheckedException {
        assert (affCache != null);
        AffinityTopologyVersion topVer = fut.topologyVersion();
        GridDhtAffinityAssignmentResponse res = (GridDhtAffinityAssignmentResponse)fetchFut.get();
        if (res == null) {
            List<List<ClusterNode>> aff = affCache.calculate(topVer, fut.discoveryEvent());
            affCache.initialize(topVer, aff);
        } else {
            List<List<ClusterNode>> idealAff = res.idealAffinityAssignment(this.cctx.discovery());
            if (idealAff != null) {
                affCache.idealAssignment(idealAff);
            } else {
                assert (!affCache.centralizedAffinityFunction() || !this.lateAffAssign);
                affCache.calculate(topVer, fut.discoveryEvent());
            }
            List<List<ClusterNode>> aff = res.affinityAssignment(this.cctx.discovery());
            assert (aff != null) : res;
            affCache.initialize(topVer, aff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onServerLeft(GridDhtPartitionsExchangeFuture fut) throws IgniteCheckedException {
        boolean centralizedAff;
        ClusterNode leftNode = fut.discoveryEvent().eventNode();
        assert (!leftNode.isClient()) : leftNode;
        if (this.lateAffAssign) {
            for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
                if (cacheCtx.isLocal()) continue;
                cacheCtx.affinity().affinityCache().calculate(fut.topologyVersion(), fut.discoveryEvent());
            }
            centralizedAff = true;
        } else {
            this.initCachesAffinity(fut);
            centralizedAff = false;
        }
        Object object = this.mux;
        synchronized (object) {
            this.affCalcVer = fut.topologyVersion();
            this.waitInfo = null;
        }
        return centralizedAff;
    }

    private void initCachesAffinity(GridDhtPartitionsExchangeFuture fut) throws IgniteCheckedException {
        assert (!this.lateAffAssign);
        for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
            if (cacheCtx.isLocal()) continue;
            this.initAffinity(cacheCtx.affinity().affinityCache(), fut, false);
        }
    }

    private IgniteInternalFuture<?> initCoordinatorCaches(final GridDhtPartitionsExchangeFuture fut) throws IgniteCheckedException {
        final ArrayList futs = new ArrayList();
        this.forAllRegisteredCaches(new IgniteInClosureX<DynamicCacheDescriptor>(){

            @Override
            public void applyx(DynamicCacheDescriptor desc) throws IgniteCheckedException {
                CacheHolder cache = (CacheHolder)CacheAffinitySharedManager.this.caches.get(desc.cacheId());
                if (cache != null) {
                    if (cache.client()) {
                        cache.affinity().calculate(fut.topologyVersion(), fut.discoveryEvent());
                    }
                    return;
                }
                final Integer cacheId = desc.cacheId();
                GridCacheContext cacheCtx = CacheAffinitySharedManager.this.cctx.cacheContext(cacheId);
                if (cacheCtx == null) {
                    CacheAffinitySharedManager.this.cctx.io().addHandler(desc.cacheId(), GridDhtAffinityAssignmentResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new IgniteBiInClosure<UUID, GridDhtAffinityAssignmentResponse>(){

                        @Override
                        public void apply(UUID nodeId, GridDhtAffinityAssignmentResponse res) {
                            CacheAffinitySharedManager.this.processAffinityAssignmentResponse(cacheId, nodeId, res);
                        }
                    });
                    cache = CacheHolder2.create(CacheAffinitySharedManager.this.cctx, desc, fut, null);
                    final GridAffinityAssignmentCache aff = cache.affinity();
                    List<GridDhtPartitionsExchangeFuture> exchFuts = CacheAffinitySharedManager.this.cctx.exchange().exchangeFutures();
                    int idx = exchFuts.indexOf(fut);
                    assert (idx >= 0 && idx < exchFuts.size() - 1) : "Invalid exchange futures state [cur=" + idx + ", total=" + exchFuts.size() + ']';
                    final GridDhtPartitionsExchangeFuture prev = exchFuts.get(idx + 1);
                    if (CacheAffinitySharedManager.this.log.isDebugEnabled()) {
                        CacheAffinitySharedManager.this.log.debug("Need initialize affinity on coordinator [cache=" + desc.cacheConfiguration().getName() + "prevAff=" + prev.topologyVersion() + ']');
                    }
                    assert (prev.topologyVersion().compareTo(fut.topologyVersion()) < 0) : prev;
                    GridDhtAssignmentFetchFuture fetchFut = new GridDhtAssignmentFetchFuture(CacheAffinitySharedManager.this.cctx, aff.cacheName(), prev.topologyVersion());
                    fetchFut.init();
                    final GridFutureAdapter affFut = new GridFutureAdapter();
                    fetchFut.listen(new IgniteInClosureX<IgniteInternalFuture<GridDhtAffinityAssignmentResponse>>(){

                        @Override
                        public void applyx(IgniteInternalFuture<GridDhtAffinityAssignmentResponse> fetchFut) throws IgniteCheckedException {
                            CacheAffinitySharedManager.this.fetchAffinity(prev, aff, (GridDhtAssignmentFetchFuture)fetchFut);
                            aff.calculate(fut.topologyVersion(), fut.discoveryEvent());
                            affFut.onDone(fut.topologyVersion());
                        }
                    });
                    futs.add(affFut);
                } else {
                    cache = new CacheHolder1(cacheCtx, null);
                }
                CacheHolder old = CacheAffinitySharedManager.this.caches.put(cache.cacheId(), cache);
                assert (old == null) : old;
            }
        });
        if (!futs.isEmpty()) {
            GridCompoundFuture affFut = new GridCompoundFuture();
            for (IgniteInternalFuture f : futs) {
                affFut.add(f);
            }
            affFut.markInitialized();
            return affFut;
        }
        return null;
    }

    private CacheHolder cache(GridDhtPartitionsExchangeFuture fut, DynamicCacheDescriptor desc) throws IgniteCheckedException {
        assert (this.lateAffAssign);
        final Integer cacheId = desc.cacheId();
        CacheHolder cache = (CacheHolder)this.caches.get(cacheId);
        if (cache != null) {
            return cache;
        }
        GridCacheContext cacheCtx = this.cctx.cacheContext(desc.cacheId());
        if (cacheCtx == null) {
            this.cctx.io().addHandler(cacheId, GridDhtAffinityAssignmentResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new IgniteBiInClosure<UUID, GridDhtAffinityAssignmentResponse>(){

                @Override
                public void apply(UUID nodeId, GridDhtAffinityAssignmentResponse res) {
                    CacheAffinitySharedManager.this.processAffinityAssignmentResponse(cacheId, nodeId, res);
                }
            });
            cache = CacheHolder2.create(this.cctx, desc, fut, null);
        } else {
            cache = new CacheHolder1(cacheCtx, null);
        }
        CacheHolder old = this.caches.put(cache.cacheId(), cache);
        assert (old == null) : old;
        return cache;
    }

    @Nullable
    private WaitRebalanceInfo initAffinityOnNodeJoin(final GridDhtPartitionsExchangeFuture fut, boolean crd) throws IgniteCheckedException {
        AffinityTopologyVersion topVer = fut.topologyVersion();
        final HashMap<Object, List<List<ClusterNode>>> affCache = new HashMap<Object, List<List<ClusterNode>>>();
        if (!crd) {
            for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
                if (cacheCtx.isLocal()) continue;
                boolean latePrimary = cacheCtx.rebalanceEnabled();
                this.initAffinityOnNodeJoin(fut, cacheCtx.affinity().affinityCache(), null, latePrimary, affCache);
            }
            return null;
        }
        final WaitRebalanceInfo waitRebalanceInfo = new WaitRebalanceInfo(topVer);
        this.forAllRegisteredCaches(new IgniteInClosureX<DynamicCacheDescriptor>(){

            @Override
            public void applyx(DynamicCacheDescriptor cacheDesc) throws IgniteCheckedException {
                CacheHolder cache = CacheAffinitySharedManager.this.cache(fut, cacheDesc);
                boolean latePrimary = cache.rebalanceEnabled;
                CacheAffinitySharedManager.this.initAffinityOnNodeJoin(fut, cache.affinity(), waitRebalanceInfo, latePrimary, affCache);
            }
        });
        return waitRebalanceInfo;
    }

    private void initAffinityOnNodeJoin(GridDhtPartitionsExchangeFuture fut, GridAffinityAssignmentCache aff, WaitRebalanceInfo rebalanceInfo, boolean latePrimary, Map<Object, List<List<ClusterNode>>> affCache) throws IgniteCheckedException {
        assert (this.lateAffAssign);
        AffinityTopologyVersion topVer = fut.topologyVersion();
        AffinityTopologyVersion affTopVer = aff.lastVersion();
        assert (affTopVer.topologyVersion() > 0L) : "Affinity is not initialized [cache=" + aff.cacheName() + ", topVer=" + affTopVer + ", node=" + this.cctx.localNodeId() + ']';
        List<List<ClusterNode>> curAff = aff.assignments(affTopVer);
        assert (aff.idealAssignment() != null) : "Previous assignment is not available.";
        List<List<ClusterNode>> idealAssignment = aff.calculate(topVer, fut.discoveryEvent());
        List<List<ClusterNode>> newAssignment = null;
        if (latePrimary) {
            for (int p = 0; p < idealAssignment.size(); ++p) {
                ClusterNode newPrimary;
                List<ClusterNode> newNodes = idealAssignment.get(p);
                List<ClusterNode> curNodes = curAff.get(p);
                ClusterNode curPrimary = curNodes.size() > 0 ? curNodes.get(0) : null;
                ClusterNode clusterNode = newPrimary = newNodes.size() > 0 ? newNodes.get(0) : null;
                if (curPrimary == null || newPrimary == null || curPrimary.equals(newPrimary)) continue;
                assert (this.cctx.discovery().node(topVer, curPrimary.id()) != null) : curPrimary;
                List<ClusterNode> nodes0 = this.latePrimaryAssignment(aff, p, curPrimary, newNodes, rebalanceInfo);
                if (newAssignment == null) {
                    newAssignment = new ArrayList<List<ClusterNode>>(idealAssignment);
                }
                newAssignment.set(p, nodes0);
            }
        }
        if (newAssignment == null) {
            newAssignment = idealAssignment;
        }
        aff.initialize(fut.topologyVersion(), this.cachedAssignment(aff, newAssignment, affCache));
    }

    private List<List<ClusterNode>> cachedAssignment(GridAffinityAssignmentCache aff, List<List<ClusterNode>> assign, Map<Object, List<List<ClusterNode>>> affCache) {
        List<List<ClusterNode>> assign0 = affCache.get(aff.similarAffinityKey());
        if (assign0 != null && assign0.equals(assign)) {
            assign = assign0;
        } else {
            affCache.put(aff.similarAffinityKey(), assign);
        }
        return assign;
    }

    private List<ClusterNode> latePrimaryAssignment(GridAffinityAssignmentCache aff, int part, ClusterNode curPrimary, List<ClusterNode> newNodes, WaitRebalanceInfo rebalance) {
        assert (this.lateAffAssign);
        assert (curPrimary != null);
        assert (!F.isEmpty(newNodes));
        assert (!curPrimary.equals(newNodes.get(0)));
        ArrayList<ClusterNode> nodes0 = new ArrayList<ClusterNode>(newNodes.size() + 1);
        nodes0.add(curPrimary);
        for (int i = 0; i < newNodes.size(); ++i) {
            ClusterNode node = newNodes.get(i);
            if (node.equals(curPrimary)) continue;
            nodes0.add(node);
        }
        if (rebalance != null) {
            rebalance.add(aff.cacheId(), part, newNodes.get(0).id(), newNodes);
        }
        return nodes0;
    }

    public IgniteInternalFuture<Map<Integer, Map<Integer, List<UUID>>>> initAffinityOnNodeLeft(final GridDhtPartitionsExchangeFuture fut) throws IgniteCheckedException {
        assert (this.lateAffAssign);
        IgniteInternalFuture<?> initFut = this.initCoordinatorCaches(fut);
        if (initFut != null && !initFut.isDone()) {
            final GridFutureAdapter<Map<Integer, Map<Integer, List<UUID>>>> resFut = new GridFutureAdapter<Map<Integer, Map<Integer, List<UUID>>>>();
            initFut.listen(new IgniteInClosure<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> initFut) {
                    try {
                        resFut.onDone(CacheAffinitySharedManager.this.initAffinityOnNodeLeft0(fut));
                    }
                    catch (IgniteCheckedException e) {
                        resFut.onDone(e);
                    }
                }
            });
            return resFut;
        }
        return new GridFinishedFuture<Map<Integer, Map<Integer, List<UUID>>>>(this.initAffinityOnNodeLeft0(fut));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, Map<Integer, List<UUID>>> initAffinityOnNodeLeft0(final GridDhtPartitionsExchangeFuture fut) throws IgniteCheckedException {
        final AffinityTopologyVersion topVer = fut.topologyVersion();
        final WaitRebalanceInfo waitRebalanceInfo = new WaitRebalanceInfo(topVer);
        final Collection<ClusterNode> aliveNodes = this.cctx.discovery().nodes(topVer);
        final HashMap<Integer, Map<Integer, List<UUID>>> assignment = new HashMap<Integer, Map<Integer, List<UUID>>>();
        this.forAllRegisteredCaches(new IgniteInClosureX<DynamicCacheDescriptor>(){

            @Override
            public void applyx(DynamicCacheDescriptor cacheDesc) throws IgniteCheckedException {
                CacheHolder cache = CacheAffinitySharedManager.this.cache(fut, cacheDesc);
                if (!cache.rebalanceEnabled) {
                    return;
                }
                AffinityTopologyVersion affTopVer = cache.affinity().lastVersion();
                assert (affTopVer.topologyVersion() > 0L && !affTopVer.equals(topVer)) : "Invalid affinity version [last=" + affTopVer + ", futVer=" + topVer + ", cache=" + cache.name() + ']';
                List<List<ClusterNode>> curAssignment = cache.affinity().assignments(affTopVer);
                List<List<ClusterNode>> newAssignment = cache.affinity().idealAssignment();
                assert (newAssignment != null);
                GridDhtPartitionTopology top = cache.topology(fut);
                HashMap<Integer, List> cacheAssignment = null;
                for (int p = 0; p < newAssignment.size(); ++p) {
                    List newNodes0;
                    block11: {
                        GridDhtPartitionState state;
                        ClusterNode newPrimary;
                        List<ClusterNode> curNodes;
                        List<ClusterNode> newNodes;
                        block12: {
                            newNodes = newAssignment.get(p);
                            curNodes = curAssignment.get(p);
                            ClusterNode curPrimary = curNodes.size() > 0 ? curNodes.get(0) : null;
                            newPrimary = newNodes.size() > 0 ? newNodes.get(0) : null;
                            newNodes0 = null;
                            assert (newPrimary == null || aliveNodes.contains(newPrimary)) : "Invalid new primary [cache=" + cache.name() + ", node=" + newPrimary + ", topVer=" + topVer + ']';
                            if (curPrimary == null || newPrimary == null || curPrimary.equals(newPrimary)) break block11;
                            if (!aliveNodes.contains(curPrimary)) break block12;
                            state = top.partitionState(newPrimary.id(), p);
                            if (state == GridDhtPartitionState.OWNING) break block11;
                            newNodes0 = CacheAffinitySharedManager.this.latePrimaryAssignment(cache.affinity(), p, curPrimary, newNodes, waitRebalanceInfo);
                            break block11;
                        }
                        state = top.partitionState(newPrimary.id(), p);
                        if (state != GridDhtPartitionState.OWNING) {
                            for (int i = 1; i < curNodes.size(); ++i) {
                                ClusterNode curNode = curNodes.get(i);
                                if (top.partitionState(curNode.id(), p) != GridDhtPartitionState.OWNING) continue;
                                newNodes0 = CacheAffinitySharedManager.this.latePrimaryAssignment(cache.affinity(), p, curNode, newNodes, waitRebalanceInfo);
                                break;
                            }
                            if (newNodes0 == null) {
                                List<ClusterNode> owners = top.owners(p);
                                for (ClusterNode owner : owners) {
                                    if (!aliveNodes.contains(owner)) continue;
                                    newNodes0 = CacheAffinitySharedManager.this.latePrimaryAssignment(cache.affinity(), p, owner, newNodes, waitRebalanceInfo);
                                    break;
                                }
                            }
                        }
                    }
                    if (newNodes0 == null) continue;
                    if (cacheAssignment == null) {
                        cacheAssignment = new HashMap<Integer, List>();
                    }
                    cacheAssignment.put(p, CacheAffinitySharedManager.toIds0(newNodes0));
                }
                if (cacheAssignment != null) {
                    assignment.put(cache.cacheId(), cacheAssignment);
                }
            }
        });
        Object object = this.mux;
        synchronized (object) {
            assert (this.affCalcVer.equals(topVer));
            WaitRebalanceInfo info = this.waitInfo = !waitRebalanceInfo.empty() ? waitRebalanceInfo : null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Computed new affinity after node left [topVer=" + topVer + ", waitCaches=" + (info != null ? this.cacheNames(info.waitCaches.keySet()) : null) + ']');
            }
        }
        return assignment;
    }

    public void dumpDebugInfo() {
        if (!this.pendingAssignmentFetchFuts.isEmpty()) {
            U.warn(this.log, "Pending assignment fetch futures:");
            for (GridDhtAssignmentFetchFuture fut : this.pendingAssignmentFetchFuts.values()) {
                U.warn(this.log, ">>> " + fut);
            }
        }
    }

    private static List<UUID> toIds0(List<ClusterNode> nodes) {
        ArrayList<UUID> partIds = new ArrayList<UUID>(nodes.size());
        for (int i = 0; i < nodes.size(); ++i) {
            partIds.add(nodes.get(i).id());
        }
        return partIds;
    }

    private List<ClusterNode> toNodes(AffinityTopologyVersion topVer, List<UUID> ids) {
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(ids.size());
        for (int i = 0; i < ids.size(); ++i) {
            UUID id = ids.get(i);
            ClusterNode node = this.cctx.discovery().node(topVer, id);
            assert (node != null) : "Failed to get node [id=" + id + ", topVer=" + topVer + ", locNode=" + this.cctx.localNode() + ", allNodes=" + this.cctx.discovery().nodes(topVer) + ']';
            nodes.add(node);
        }
        return nodes;
    }

    class WaitRebalanceInfo {
        private final AffinityTopologyVersion topVer;
        private Map<Integer, Map<Integer, UUID>> waitCaches;
        private Map<Integer, Map<Integer, List<ClusterNode>>> assignments;
        private Map<Integer, IgniteUuid> deploymentIds;

        WaitRebalanceInfo(AffinityTopologyVersion topVer) {
            this.topVer = topVer;
        }

        boolean empty() {
            if (this.waitCaches != null) {
                assert (!this.waitCaches.isEmpty());
                assert (this.waitCaches.size() == this.assignments.size());
                return false;
            }
            return true;
        }

        void add(Integer cacheId, Integer part, UUID waitNode, List<ClusterNode> assignment) {
            Map<Integer, UUID> cacheWaitParts;
            assert (!F.isEmpty(assignment)) : assignment;
            if (this.waitCaches == null) {
                this.waitCaches = new HashMap<Integer, Map<Integer, UUID>>();
                this.assignments = new HashMap<Integer, Map<Integer, List<ClusterNode>>>();
                this.deploymentIds = new HashMap<Integer, IgniteUuid>();
            }
            if ((cacheWaitParts = this.waitCaches.get(cacheId)) == null) {
                cacheWaitParts = new HashMap<Integer, UUID>();
                this.waitCaches.put(cacheId, cacheWaitParts);
                this.deploymentIds.put(cacheId, ((DynamicCacheDescriptor)CacheAffinitySharedManager.this.registeredCaches.get(cacheId)).deploymentId());
            }
            cacheWaitParts.put(part, waitNode);
            Map<Integer, List<ClusterNode>> cacheAssignment = this.assignments.get(cacheId);
            if (cacheAssignment == null) {
                cacheAssignment = new HashMap<Integer, List<ClusterNode>>();
                this.assignments.put(cacheId, cacheAssignment);
            }
            cacheAssignment.put(part, assignment);
        }
    }

    private static class CacheHolder2
    extends CacheHolder {
        private final GridCacheSharedContext cctx;

        static CacheHolder2 create(GridCacheSharedContext cctx, DynamicCacheDescriptor cacheDesc, GridDhtPartitionsExchangeFuture fut, @Nullable GridAffinityAssignmentCache initAff) throws IgniteCheckedException {
            assert (cacheDesc != null);
            assert (!cctx.kernalContext().clientNode());
            CacheConfiguration ccfg = cacheDesc.cacheConfiguration();
            assert (ccfg != null) : cacheDesc;
            assert (ccfg.getCacheMode() != CacheMode.LOCAL) : ccfg.getName();
            assert (!cctx.discovery().cacheAffinityNodes(ccfg.getName(), fut.topologyVersion()).contains(cctx.localNode()));
            AffinityFunction affFunc = cctx.cache().clone(ccfg.getAffinity());
            cctx.kernalContext().resource().injectGeneric(affFunc);
            cctx.kernalContext().resource().injectCacheName(affFunc, ccfg.getName());
            U.startLifecycleAware(F.asList(affFunc));
            GridAffinityAssignmentCache aff = new GridAffinityAssignmentCache(cctx.kernalContext(), ccfg.getName(), affFunc, ccfg.getNodeFilter(), ccfg.getBackups(), ccfg.getCacheMode() == CacheMode.LOCAL);
            return new CacheHolder2(ccfg.getRebalanceMode() != CacheRebalanceMode.NONE, cctx, aff, initAff);
        }

        public CacheHolder2(boolean rebalanceEnabled, GridCacheSharedContext cctx, GridAffinityAssignmentCache aff, @Nullable GridAffinityAssignmentCache initAff) {
            super(rebalanceEnabled, aff, initAff);
            this.cctx = cctx;
        }

        @Override
        public boolean client() {
            return true;
        }

        @Override
        public GridDhtPartitionTopology topology(GridDhtPartitionsExchangeFuture fut) {
            return this.cctx.exchange().clientTopology(this.cacheId(), fut);
        }
    }

    private class CacheHolder1
    extends CacheHolder {
        private final GridCacheContext cctx;

        CacheHolder1(@Nullable GridCacheContext cctx, GridAffinityAssignmentCache initAff) {
            super(cctx.rebalanceEnabled(), cctx.affinity().affinityCache(), initAff);
            assert (!cctx.isLocal()) : cctx.name();
            this.cctx = cctx;
        }

        @Override
        public boolean client() {
            return false;
        }

        @Override
        public int partitions() {
            return this.cctx.affinity().partitions();
        }

        @Override
        public String name() {
            return this.cctx.name();
        }

        @Override
        public int cacheId() {
            return this.cctx.cacheId();
        }

        @Override
        public GridDhtPartitionTopology topology(GridDhtPartitionsExchangeFuture fut) {
            return this.cctx.topology();
        }
    }

    static abstract class CacheHolder {
        private final GridAffinityAssignmentCache aff;
        private final boolean rebalanceEnabled;

        CacheHolder(boolean rebalanceEnabled, GridAffinityAssignmentCache aff, @Nullable GridAffinityAssignmentCache initAff) {
            this.aff = aff;
            if (initAff != null) {
                aff.init(initAff);
            }
            this.rebalanceEnabled = rebalanceEnabled;
        }

        abstract boolean client();

        int cacheId() {
            return this.aff.cacheId();
        }

        int partitions() {
            return this.aff.partitions();
        }

        String name() {
            return this.aff.cacheName();
        }

        abstract GridDhtPartitionTopology topology(GridDhtPartitionsExchangeFuture var1);

        GridAffinityAssignmentCache affinity() {
            return this.aff;
        }
    }
}

