/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.GridCacheDefaultAffinityKeyMapper;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheDefaultBinaryAffinityKeyMapper
extends GridCacheDefaultAffinityKeyMapper {
    private static final long serialVersionUID = 0L;
    private CacheObjectBinaryProcessorImpl proc;

    @Override
    public Object affinityKey(Object key) {
        try {
            key = this.proc.toBinary(key);
        }
        catch (IgniteException e) {
            U.error(this.log, "Failed to marshal key to binary: " + key, e);
        }
        if (key instanceof BinaryObject) {
            return this.proc.affinityKey((BinaryObject)key);
        }
        return super.affinityKey(key);
    }

    @Override
    public void ignite(Ignite ignite) {
        super.ignite(ignite);
        if (ignite != null) {
            IgniteKernal kernal = (IgniteKernal)ignite;
            this.proc = (CacheObjectBinaryProcessorImpl)kernal.context().cacheObjects();
        }
    }
}

