/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheEntry;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;

public class CacheEntryImplEx<K, V>
extends CacheEntryImpl<K, V>
implements CacheEntry<K, V> {
    private static final long serialVersionUID = 0L;
    private GridCacheVersion ver;

    public CacheEntryImplEx() {
    }

    public CacheEntryImplEx(K key, V val, GridCacheVersion ver) {
        super(key, val);
        this.ver = ver;
    }

    @Override
    public GridCacheVersion version() {
        if (this.ver == IgniteTxEntry.GET_ENTRY_INVALID_VER_AFTER_GET) {
            throw new IgniteException("Impossible to get entry version after get() inside OPTIMISTIC REPEATABLE_READ transaction. Use only getEntry() or getEntries() inside OPTIMISTIC REPEATABLE_READ transaction to solve this problem.");
        }
        if (this.ver == IgniteTxEntry.GET_ENTRY_INVALID_VER_UPDATED) {
            throw new IgniteException("Impossible to get version for entry updated in transaction.");
        }
        return this.ver;
    }

    @Override
    public long updateTime() {
        return this.ver.globalTime();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.ver);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.ver = (GridCacheVersion)in.readObject();
    }

    @Override
    public String toString() {
        String res = "CacheEntry [key=" + this.getKey() + ", val=" + this.getValue();
        res = this.ver != null && this.ver != IgniteTxEntry.GET_ENTRY_INVALID_VER_AFTER_GET && this.ver != IgniteTxEntry.GET_ENTRY_INVALID_VER_UPDATED ? res + ", topVer=" + this.ver.topologyVersion() + ", nodeOrder=" + this.ver.nodeOrder() + ", order=" + this.ver.order() + ", updateTime=" + this.ver.globalTime() : res + ", ver=n/a";
        return res + ']';
    }
}

